/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Size;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.DefaultCodec;
import com.google.android.exoplayer2.transformer.DeviceMappedEncoderBitrateProvider;
import com.google.android.exoplayer2.transformer.EncoderSelector;
import com.google.android.exoplayer2.transformer.EncoderUtil;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.transformer.VideoEncoderSettings;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MediaFormatUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class DefaultEncoderFactory
implements Codec.EncoderFactory {
    private static final int DEFAULT_FRAME_RATE = 30;
    private static final int PRIORITY_BEST_EFFORT = 1;
    private static final String TAG = "DefaultEncoderFactory";
    private final Context context;
    private final EncoderSelector videoEncoderSelector;
    private final VideoEncoderSettings requestedVideoEncoderSettings;
    private final boolean enableFallback;

    @Deprecated
    public DefaultEncoderFactory(Context context) {
        this(context, EncoderSelector.DEFAULT, true);
    }

    @Deprecated
    public DefaultEncoderFactory(Context context, EncoderSelector videoEncoderSelector, boolean enableFallback) {
        this(context, videoEncoderSelector, VideoEncoderSettings.DEFAULT, enableFallback);
    }

    @Deprecated
    public DefaultEncoderFactory(Context context, EncoderSelector videoEncoderSelector, VideoEncoderSettings requestedVideoEncoderSettings, boolean enableFallback) {
        this.context = context;
        this.videoEncoderSelector = videoEncoderSelector;
        this.requestedVideoEncoderSettings = requestedVideoEncoderSettings;
        this.enableFallback = enableFallback;
    }

    @Override
    public Codec createForAudioEncoding(Format format, List<String> allowedMimeTypes) throws TransformationException {
        Assertions.checkArgument((!allowedMimeTypes.isEmpty() ? 1 : 0) != 0);
        Assertions.checkNotNull((Object)format.sampleMimeType);
        if (!allowedMimeTypes.contains(format.sampleMimeType)) {
            if (this.enableFallback) {
                format = format.buildUpon().setSampleMimeType(allowedMimeTypes.get(0)).build();
            } else {
                throw DefaultEncoderFactory.createTransformationException(format);
            }
        }
        MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (int)format.sampleRate, (int)format.channelCount);
        mediaFormat.setInteger("bitrate", format.bitrate);
        String mediaCodecName = EncoderUtil.findCodecForFormat(mediaFormat, false);
        if (mediaCodecName == null) {
            throw DefaultEncoderFactory.createTransformationException(format);
        }
        return new DefaultCodec(this.context, format, mediaFormat, mediaCodecName, false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Codec createForVideoEncoding(Format format, List<String> allowedMimeTypes) throws TransformationException {
        int bitrate;
        if (format.frameRate == -1.0f) {
            format = format.buildUpon().setFrameRate(30.0f).build();
        }
        Assertions.checkArgument((format.width != -1 ? 1 : 0) != 0);
        Assertions.checkArgument((format.height != -1 ? 1 : 0) != 0);
        Assertions.checkArgument((format.height <= format.width ? 1 : 0) != 0);
        Assertions.checkArgument((format.rotationDegrees == 0 ? 1 : 0) != 0);
        Assertions.checkNotNull((Object)format.sampleMimeType);
        Assertions.checkArgument((!allowedMimeTypes.isEmpty() ? 1 : 0) != 0);
        Assertions.checkStateNotNull((Object)this.videoEncoderSelector);
        VideoEncoderQueryResult encoderAndClosestFormatSupport = DefaultEncoderFactory.findEncoderWithClosestSupportedFormat(format, this.requestedVideoEncoderSettings, this.videoEncoderSelector, allowedMimeTypes, this.enableFallback);
        if (encoderAndClosestFormatSupport == null) {
            throw DefaultEncoderFactory.createTransformationException(format);
        }
        MediaCodecInfo encoderInfo = encoderAndClosestFormatSupport.encoder;
        Format encoderSupportedFormat = encoderAndClosestFormatSupport.supportedFormat;
        VideoEncoderSettings supportedVideoEncoderSettings = encoderAndClosestFormatSupport.supportedEncoderSettings;
        String mimeType = (String)Assertions.checkNotNull((Object)encoderSupportedFormat.sampleMimeType);
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)mimeType, (int)encoderSupportedFormat.width, (int)encoderSupportedFormat.height);
        mediaFormat.setInteger("frame-rate", Math.round(encoderSupportedFormat.frameRate));
        if (supportedVideoEncoderSettings.enableHighQualityTargeting) {
            bitrate = new DeviceMappedEncoderBitrateProvider().getBitrate(encoderInfo.getName(), encoderSupportedFormat.width, encoderSupportedFormat.height, encoderSupportedFormat.frameRate);
            encoderSupportedFormat = encoderSupportedFormat.buildUpon().setAverageBitrate(bitrate).build();
        } else if (encoderSupportedFormat.bitrate == -1) {
            bitrate = DefaultEncoderFactory.getSuggestedBitrate(encoderSupportedFormat.width, encoderSupportedFormat.height, encoderSupportedFormat.frameRate);
            encoderSupportedFormat = encoderSupportedFormat.buildUpon().setAverageBitrate(bitrate).build();
        }
        mediaFormat.setInteger("bitrate", encoderSupportedFormat.averageBitrate);
        mediaFormat.setInteger("bitrate-mode", supportedVideoEncoderSettings.bitrateMode);
        if (supportedVideoEncoderSettings.profile != -1 && supportedVideoEncoderSettings.level != -1 && Util.SDK_INT >= 23) {
            mediaFormat.setInteger("profile", supportedVideoEncoderSettings.profile);
            mediaFormat.setInteger("level", supportedVideoEncoderSettings.level);
        }
        if (mimeType.equals("video/avc")) {
            DefaultEncoderFactory.adjustMediaFormatForH264EncoderSettings(format.colorInfo, encoderInfo, mediaFormat);
        }
        MediaFormatUtil.maybeSetColorInfo((MediaFormat)mediaFormat, (ColorInfo)encoderSupportedFormat.colorInfo);
        if (Util.SDK_INT >= 31 && ColorInfo.isTransferHdr((ColorInfo)format.colorInfo)) {
            if (!EncoderUtil.getSupportedColorFormats(encoderInfo, mimeType).contains((Object)2130750114)) throw DefaultEncoderFactory.createTransformationException(format);
            mediaFormat.setInteger("color-format", 2130750114);
        } else {
            mediaFormat.setInteger("color-format", 2130708361);
        }
        if (Util.SDK_INT >= 25) {
            mediaFormat.setFloat("i-frame-interval", supportedVideoEncoderSettings.iFrameIntervalSeconds);
        } else {
            float iFrameIntervalSeconds = supportedVideoEncoderSettings.iFrameIntervalSeconds;
            mediaFormat.setInteger("i-frame-interval", iFrameIntervalSeconds > 0.0f && iFrameIntervalSeconds <= 1.0f ? 1 : (int)Math.floor(iFrameIntervalSeconds));
        }
        if (Util.SDK_INT < 23) return new DefaultCodec(this.context, encoderSupportedFormat, mediaFormat, encoderInfo.getName(), false, null);
        if (supportedVideoEncoderSettings.operatingRate == -1 && supportedVideoEncoderSettings.priority == -1) {
            DefaultEncoderFactory.adjustMediaFormatForEncoderPerformanceSettings(mediaFormat);
            return new DefaultCodec(this.context, encoderSupportedFormat, mediaFormat, encoderInfo.getName(), false, null);
        } else {
            if (supportedVideoEncoderSettings.operatingRate != -1) {
                mediaFormat.setInteger("operating-rate", supportedVideoEncoderSettings.operatingRate);
            }
            if (supportedVideoEncoderSettings.priority == -1) return new DefaultCodec(this.context, encoderSupportedFormat, mediaFormat, encoderInfo.getName(), false, null);
            mediaFormat.setInteger("priority", supportedVideoEncoderSettings.priority);
        }
        return new DefaultCodec(this.context, encoderSupportedFormat, mediaFormat, encoderInfo.getName(), false, null);
    }

    @Override
    public boolean videoNeedsEncoding() {
        return !this.requestedVideoEncoderSettings.equals(VideoEncoderSettings.DEFAULT);
    }

    @RequiresNonNull(value={"#1.sampleMimeType"})
    @Nullable
    private static VideoEncoderQueryResult findEncoderWithClosestSupportedFormat(Format requestedFormat, VideoEncoderSettings videoEncoderSettings, EncoderSelector encoderSelector, List<String> allowedMimeTypes, boolean enableFallback) {
        String requestedMimeType = requestedFormat.sampleMimeType;
        String mimeType = DefaultEncoderFactory.findFallbackMimeType(encoderSelector, requestedMimeType, allowedMimeTypes);
        if (mimeType == null || !enableFallback && !requestedMimeType.equals(mimeType)) {
            return null;
        }
        ImmutableList<MediaCodecInfo> filteredEncoderInfos = encoderSelector.selectEncoderInfos(mimeType);
        if (filteredEncoderInfos.isEmpty()) {
            return null;
        }
        if (!enableFallback) {
            return new VideoEncoderQueryResult((MediaCodecInfo)filteredEncoderInfos.get(0), requestedFormat, videoEncoderSettings);
        }
        if ((filteredEncoderInfos = DefaultEncoderFactory.filterEncodersByResolution(filteredEncoderInfos, mimeType, requestedFormat.width, requestedFormat.height)).isEmpty()) {
            return null;
        }
        Size finalResolution = (Size)Assertions.checkNotNull((Object)EncoderUtil.getSupportedResolution((MediaCodecInfo)filteredEncoderInfos.get(0), mimeType, requestedFormat.width, requestedFormat.height));
        int requestedBitrate = videoEncoderSettings.bitrate != -1 ? videoEncoderSettings.bitrate : DefaultEncoderFactory.getSuggestedBitrate(finalResolution.getWidth(), finalResolution.getHeight(), requestedFormat.frameRate);
        if ((filteredEncoderInfos = DefaultEncoderFactory.filterEncodersByBitrate(filteredEncoderInfos, mimeType, requestedBitrate)).isEmpty()) {
            return null;
        }
        if ((filteredEncoderInfos = DefaultEncoderFactory.filterEncodersByBitrateMode(filteredEncoderInfos, mimeType, videoEncoderSettings.bitrateMode)).isEmpty()) {
            return null;
        }
        MediaCodecInfo pickedEncoderInfo = (MediaCodecInfo)filteredEncoderInfos.get(0);
        int closestSupportedBitrate = (Integer)EncoderUtil.getSupportedBitrateRange(pickedEncoderInfo, mimeType).clamp((Comparable)Integer.valueOf(requestedBitrate));
        VideoEncoderSettings.Builder supportedEncodingSettingBuilder = videoEncoderSettings.buildUpon();
        Format.Builder encoderSupportedFormatBuilder = requestedFormat.buildUpon().setSampleMimeType(mimeType).setWidth(finalResolution.getWidth()).setHeight(finalResolution.getHeight());
        if (!videoEncoderSettings.enableHighQualityTargeting) {
            supportedEncodingSettingBuilder.setBitrate(closestSupportedBitrate);
            encoderSupportedFormatBuilder.setAverageBitrate(closestSupportedBitrate);
        }
        if (videoEncoderSettings.profile == -1 || videoEncoderSettings.level == -1 || videoEncoderSettings.level > EncoderUtil.findHighestSupportedEncodingLevel(pickedEncoderInfo, mimeType, videoEncoderSettings.profile)) {
            supportedEncodingSettingBuilder.setEncodingProfileLevel(-1, -1);
        }
        return new VideoEncoderQueryResult(pickedEncoderInfo, encoderSupportedFormatBuilder.build(), supportedEncodingSettingBuilder.build());
    }

    private static ImmutableList<MediaCodecInfo> filterEncodersByResolution(List<MediaCodecInfo> encoders, String mimeType, int requestedWidth, int requestedHeight) {
        return DefaultEncoderFactory.filterEncoders(encoders, encoderInfo -> {
            Size closestSupportedResolution = EncoderUtil.getSupportedResolution(encoderInfo, mimeType, requestedWidth, requestedHeight);
            if (closestSupportedResolution == null) {
                return Integer.MAX_VALUE;
            }
            return Math.abs(requestedWidth * requestedHeight - closestSupportedResolution.getWidth() * closestSupportedResolution.getHeight());
        }, "resolution");
    }

    private static ImmutableList<MediaCodecInfo> filterEncodersByBitrate(List<MediaCodecInfo> encoders, String mimeType, int requestedBitrate) {
        return DefaultEncoderFactory.filterEncoders(encoders, encoderInfo -> {
            int achievableBitrate = (Integer)EncoderUtil.getSupportedBitrateRange(encoderInfo, mimeType).clamp((Comparable)Integer.valueOf(requestedBitrate));
            return Math.abs(achievableBitrate - requestedBitrate);
        }, "bitrate");
    }

    private static ImmutableList<MediaCodecInfo> filterEncodersByBitrateMode(List<MediaCodecInfo> encoders, String mimeType, int requestedBitrateMode) {
        return DefaultEncoderFactory.filterEncoders(encoders, encoderInfo -> EncoderUtil.isBitrateModeSupported(encoderInfo, mimeType, requestedBitrateMode) ? 0 : Integer.MAX_VALUE, "bitrate mode");
    }

    private static void adjustMediaFormatForEncoderPerformanceSettings(MediaFormat mediaFormat) {
        if (Util.SDK_INT < 25) {
            return;
        }
        mediaFormat.setInteger("priority", 1);
        if (Util.SDK_INT == 26) {
            mediaFormat.setInteger("operating-rate", 30);
        } else {
            mediaFormat.setInteger("operating-rate", Integer.MAX_VALUE);
        }
    }

    private static void adjustMediaFormatForH264EncoderSettings(@Nullable ColorInfo colorInfo, MediaCodecInfo encoderInfo, MediaFormat mediaFormat) {
        String mimeType = "video/avc";
        if (Util.SDK_INT >= 29) {
            int supportedEncodingLevel;
            int colorTransfer;
            ImmutableList<Integer> codecProfiles;
            int expectedEncodingProfile = 8;
            if (colorInfo != null && !(codecProfiles = EncoderUtil.getCodecProfilesForHdrFormat(mimeType, colorTransfer = colorInfo.colorTransfer)).isEmpty()) {
                expectedEncodingProfile = (Integer)codecProfiles.get(0);
            }
            if ((supportedEncodingLevel = EncoderUtil.findHighestSupportedEncodingLevel(encoderInfo, mimeType, expectedEncodingProfile)) != -1) {
                mediaFormat.setInteger("profile", expectedEncodingProfile);
                mediaFormat.setInteger("level", supportedEncodingLevel);
                mediaFormat.setInteger("max-bframes", 1);
            }
        } else if (Util.SDK_INT >= 26) {
            int expectedEncodingProfile = 8;
            int supportedEncodingLevel = EncoderUtil.findHighestSupportedEncodingLevel(encoderInfo, mimeType, expectedEncodingProfile);
            if (supportedEncodingLevel != -1) {
                mediaFormat.setInteger("profile", expectedEncodingProfile);
                mediaFormat.setInteger("level", supportedEncodingLevel);
                mediaFormat.setInteger("latency", 1);
            }
        } else if (Util.SDK_INT >= 24) {
            int expectedEncodingProfile = 1;
            int supportedLevel = EncoderUtil.findHighestSupportedEncodingLevel(encoderInfo, mimeType, expectedEncodingProfile);
            Assertions.checkState((supportedLevel != -1 ? 1 : 0) != 0);
            mediaFormat.setInteger("profile", expectedEncodingProfile);
            mediaFormat.setInteger("level", supportedLevel);
        }
    }

    private static ImmutableList<MediaCodecInfo> filterEncoders(List<MediaCodecInfo> encoders, EncoderFallbackCost cost, String filterName) {
        ArrayList<MediaCodecInfo> filteredEncoders = new ArrayList<MediaCodecInfo>(encoders.size());
        int minGap = Integer.MAX_VALUE;
        for (int i = 0; i < encoders.size(); ++i) {
            MediaCodecInfo encoderInfo = encoders.get(i);
            int gap = cost.getParameterSupportGap(encoderInfo);
            if (gap == Integer.MAX_VALUE) continue;
            if (gap < minGap) {
                minGap = gap;
                filteredEncoders.clear();
                filteredEncoders.add(encoderInfo);
                continue;
            }
            if (gap != minGap) continue;
            filteredEncoders.add(encoderInfo);
        }
        ArrayList<MediaCodecInfo> removedEncoders = new ArrayList<MediaCodecInfo>(encoders);
        removedEncoders.removeAll(filteredEncoders);
        StringBuilder stringBuilder = new StringBuilder("Encoders removed for ").append(filterName).append(":\n");
        for (int i = 0; i < removedEncoders.size(); ++i) {
            MediaCodecInfo encoderInfo = (MediaCodecInfo)removedEncoders.get(i);
            stringBuilder.append(Util.formatInvariant((String)"  %s\n", (Object[])new Object[]{encoderInfo.getName()}));
        }
        Log.d((String)TAG, (String)stringBuilder.toString());
        return ImmutableList.copyOf(filteredEncoders);
    }

    @Nullable
    private static String findFallbackMimeType(EncoderSelector encoderSelector, String requestedMimeType, List<String> allowedMimeTypes) {
        if (DefaultEncoderFactory.mimeTypeIsSupported(encoderSelector, requestedMimeType, allowedMimeTypes)) {
            return requestedMimeType;
        }
        if (DefaultEncoderFactory.mimeTypeIsSupported(encoderSelector, "video/hevc", allowedMimeTypes)) {
            return "video/hevc";
        }
        if (DefaultEncoderFactory.mimeTypeIsSupported(encoderSelector, "video/avc", allowedMimeTypes)) {
            return "video/avc";
        }
        for (int i = 0; i < allowedMimeTypes.size(); ++i) {
            String allowedMimeType = allowedMimeTypes.get(i);
            if (!DefaultEncoderFactory.mimeTypeIsSupported(encoderSelector, allowedMimeType, allowedMimeTypes)) continue;
            return allowedMimeType;
        }
        return null;
    }

    private static boolean mimeTypeIsSupported(EncoderSelector encoderSelector, String mimeType, List<String> allowedMimeTypes) {
        return !encoderSelector.selectEncoderInfos(mimeType).isEmpty() && allowedMimeTypes.contains(mimeType);
    }

    private static int getSuggestedBitrate(int width, int height, float frameRate) {
        return (int)((double)((float)(width * height) * frameRate) * 0.07 * 2.0);
    }

    @RequiresNonNull(value={"#1.sampleMimeType"})
    private static TransformationException createTransformationException(Format format) {
        return TransformationException.createForCodec((Throwable)new IllegalArgumentException("The requested encoding format is not supported."), MimeTypes.isVideo((String)format.sampleMimeType), false, format, null, 4003);
    }

    private static interface EncoderFallbackCost {
        public int getParameterSupportGap(MediaCodecInfo var1);
    }

    private static final class VideoEncoderQueryResult {
        public final MediaCodecInfo encoder;
        public final Format supportedFormat;
        public final VideoEncoderSettings supportedEncoderSettings;

        public VideoEncoderQueryResult(MediaCodecInfo encoder, Format supportedFormat, VideoEncoderSettings supportedEncoderSettings) {
            this.encoder = encoder;
            this.supportedFormat = supportedFormat;
            this.supportedEncoderSettings = supportedEncoderSettings;
        }
    }

    public static final class Builder {
        private final Context context;
        @Nullable
        private EncoderSelector encoderSelector;
        @Nullable
        private VideoEncoderSettings requestedVideoEncoderSettings;
        private boolean enableFallback;

        public Builder(Context context) {
            this.context = context;
            this.enableFallback = true;
        }

        @CanIgnoreReturnValue
        public Builder setVideoEncoderSelector(EncoderSelector encoderSelector) {
            this.encoderSelector = encoderSelector;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRequestedVideoEncoderSettings(VideoEncoderSettings requestedVideoEncoderSettings) {
            this.requestedVideoEncoderSettings = requestedVideoEncoderSettings;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setEnableFallback(boolean enableFallback) {
            this.enableFallback = enableFallback;
            return this;
        }

        public DefaultEncoderFactory build() {
            if (this.encoderSelector == null) {
                this.encoderSelector = EncoderSelector.DEFAULT;
            }
            if (this.requestedVideoEncoderSettings == null) {
                this.requestedVideoEncoderSettings = VideoEncoderSettings.DEFAULT;
            }
            return new DefaultEncoderFactory(this.context, this.encoderSelector, this.requestedVideoEncoderSettings, this.enableFallback);
        }
    }
}

