/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.os.ParcelFileDescriptor;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.transformer.Transformer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

final class MuxerWrapper {
    private static final long MAX_TRACK_WRITE_AHEAD_US = Util.msToUs((long)500L);
    @Nullable
    private final String outputPath;
    @Nullable
    private final ParcelFileDescriptor outputParcelFileDescriptor;
    private final Muxer.Factory muxerFactory;
    private final Transformer.AsyncErrorListener asyncErrorListener;
    private final SparseIntArray trackTypeToIndex;
    private final SparseIntArray trackTypeToSampleCount;
    private final SparseLongArray trackTypeToTimeUs;
    private final SparseLongArray trackTypeToBytesWritten;
    private final ScheduledExecutorService abortScheduledExecutorService;
    private int trackCount;
    private int trackFormatCount;
    private boolean isReady;
    private int previousTrackType;
    private long minTrackTimeUs;
    private @MonotonicNonNull ScheduledFuture<?> abortScheduledFuture;
    private boolean isAborted;
    private @MonotonicNonNull Muxer muxer;

    public MuxerWrapper(@Nullable String outputPath, @Nullable ParcelFileDescriptor outputParcelFileDescriptor, Muxer.Factory muxerFactory, Transformer.AsyncErrorListener asyncErrorListener) {
        if (outputPath == null && outputParcelFileDescriptor == null) {
            throw new NullPointerException("Both output path and ParcelFileDescriptor are null");
        }
        this.outputPath = outputPath;
        this.outputParcelFileDescriptor = outputParcelFileDescriptor;
        this.muxerFactory = muxerFactory;
        this.asyncErrorListener = asyncErrorListener;
        this.trackTypeToIndex = new SparseIntArray();
        this.trackTypeToSampleCount = new SparseIntArray();
        this.trackTypeToTimeUs = new SparseLongArray();
        this.trackTypeToBytesWritten = new SparseLongArray();
        this.previousTrackType = -2;
        this.abortScheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void registerTrack() {
        Assertions.checkState((this.trackFormatCount == 0 ? 1 : 0) != 0, (Object)"Tracks cannot be registered after track formats have been added.");
        ++this.trackCount;
    }

    public boolean supportsSampleMimeType(@Nullable String mimeType) {
        int trackType = MimeTypes.getTrackType((String)mimeType);
        return this.getSupportedSampleMimeTypes(trackType).contains((Object)mimeType);
    }

    public ImmutableList<String> getSupportedSampleMimeTypes(int trackType) {
        return this.muxerFactory.getSupportedSampleMimeTypes(trackType);
    }

    public void addTrackFormat(Format format) throws Muxer.MuxerException {
        Assertions.checkState((this.trackCount > 0 ? 1 : 0) != 0, (Object)"All tracks should be registered before the formats are added.");
        Assertions.checkState((this.trackFormatCount < this.trackCount ? 1 : 0) != 0, (Object)"All track formats have already been added.");
        String sampleMimeType = format.sampleMimeType;
        boolean isAudio = MimeTypes.isAudio((String)sampleMimeType);
        boolean isVideo = MimeTypes.isVideo((String)sampleMimeType);
        Assertions.checkState((isAudio || isVideo ? 1 : 0) != 0, (Object)("Unsupported track format: " + sampleMimeType));
        int trackType = MimeTypes.getTrackType((String)sampleMimeType);
        Assertions.checkState((this.trackTypeToIndex.get(trackType, -1) == -1 ? 1 : 0) != 0, (Object)("There is already a track of type " + trackType));
        this.ensureMuxerInitialized();
        int trackIndex = this.muxer.addTrack(format);
        this.trackTypeToIndex.put(trackType, trackIndex);
        this.trackTypeToSampleCount.put(trackType, 0);
        this.trackTypeToTimeUs.put(trackType, 0L);
        this.trackTypeToBytesWritten.put(trackType, 0L);
        ++this.trackFormatCount;
        if (this.trackFormatCount == this.trackCount) {
            this.isReady = true;
            this.resetAbortTimer();
        }
    }

    public boolean writeSample(int trackType, ByteBuffer data, boolean isKeyFrame, long presentationTimeUs) throws Muxer.MuxerException {
        int trackIndex = this.trackTypeToIndex.get(trackType, -1);
        Assertions.checkState((trackIndex != -1 ? 1 : 0) != 0, (Object)("Could not write sample because there is no track of type " + trackType));
        if (!this.canWriteSampleOfType(trackType)) {
            return false;
        }
        this.trackTypeToSampleCount.put(trackType, this.trackTypeToSampleCount.get(trackType) + 1);
        this.trackTypeToBytesWritten.put(trackType, this.trackTypeToBytesWritten.get(trackType) + (long)data.remaining());
        if (this.trackTypeToTimeUs.get(trackType) < presentationTimeUs) {
            this.trackTypeToTimeUs.put(trackType, presentationTimeUs);
        }
        Assertions.checkNotNull((Object)this.muxer);
        this.resetAbortTimer();
        this.muxer.writeSampleData(trackIndex, data, isKeyFrame, presentationTimeUs);
        this.previousTrackType = trackType;
        return true;
    }

    public void endTrack(int trackType) {
        this.trackTypeToIndex.delete(trackType);
        if (this.trackTypeToIndex.size() == 0) {
            this.abortScheduledExecutorService.shutdownNow();
        }
    }

    public void release(boolean forCancellation) throws Muxer.MuxerException {
        this.isReady = false;
        this.abortScheduledExecutorService.shutdownNow();
        if (this.muxer != null) {
            this.muxer.release(forCancellation);
        }
    }

    public int getTrackCount() {
        return this.trackCount;
    }

    public int getTrackAverageBitrate(int trackType) {
        long trackDurationUs = this.trackTypeToTimeUs.get(trackType, -1L);
        long trackBytes = this.trackTypeToBytesWritten.get(trackType, -1L);
        if (trackDurationUs <= 0L || trackBytes <= 0L) {
            return -2147483647;
        }
        return (int)Util.scaleLargeTimestamp((long)trackBytes, (long)8000000L, (long)trackDurationUs);
    }

    public int getTrackSampleCount(int trackType) {
        return this.trackTypeToSampleCount.get(trackType, 0);
    }

    public long getDurationMs() {
        return Util.usToMs((long)Util.maxValue((SparseLongArray)this.trackTypeToTimeUs));
    }

    private boolean canWriteSampleOfType(int trackType) {
        long trackTimeUs = this.trackTypeToTimeUs.get(trackType, -9223372036854775807L);
        Assertions.checkState((trackTimeUs != -9223372036854775807L ? 1 : 0) != 0);
        if (!this.isReady) {
            return false;
        }
        if (this.trackTypeToIndex.size() == 1) {
            return true;
        }
        if (trackType != this.previousTrackType) {
            this.minTrackTimeUs = Util.minValue((SparseLongArray)this.trackTypeToTimeUs);
        }
        return trackTimeUs - this.minTrackTimeUs <= MAX_TRACK_WRITE_AHEAD_US;
    }

    @RequiresNonNull(value={"muxer"})
    private void resetAbortTimer() {
        long maxDelayBetweenSamplesMs = this.muxer.getMaxDelayBetweenSamplesMs();
        if (maxDelayBetweenSamplesMs == -9223372036854775807L) {
            return;
        }
        if (this.abortScheduledFuture != null) {
            this.abortScheduledFuture.cancel(false);
        }
        this.abortScheduledFuture = this.abortScheduledExecutorService.schedule(() -> {
            if (this.isAborted) {
                return;
            }
            this.isAborted = true;
            this.asyncErrorListener.onTransformationException(TransformationException.createForMuxer(new IllegalStateException("No output sample written in the last " + maxDelayBetweenSamplesMs + " milliseconds. Aborting transformation."), 6001));
        }, maxDelayBetweenSamplesMs, TimeUnit.MILLISECONDS);
    }

    @EnsuresNonNull(value={"muxer"})
    private void ensureMuxerInitialized() throws Muxer.MuxerException {
        if (this.muxer == null) {
            if (this.outputPath != null) {
                this.muxer = this.muxerFactory.create(this.outputPath);
            } else {
                Assertions.checkNotNull((Object)this.outputParcelFileDescriptor);
                this.muxer = this.muxerFactory.create(this.outputParcelFileDescriptor);
            }
        }
    }
}

