/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.transformer.Transformer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ListenerSet;
import com.google.android.exoplayer2.util.Util;

final class FallbackListener {
    private final MediaItem mediaItem;
    private final TransformationRequest originalTransformationRequest;
    private final ListenerSet<Transformer.Listener> transformerListeners;
    private TransformationRequest fallbackTransformationRequest;
    private int trackCount;

    public FallbackListener(MediaItem mediaItem, ListenerSet<Transformer.Listener> transformerListeners, TransformationRequest originalTransformationRequest) {
        this.mediaItem = mediaItem;
        this.transformerListeners = transformerListeners;
        this.originalTransformationRequest = originalTransformationRequest;
        this.fallbackTransformationRequest = originalTransformationRequest;
    }

    public void registerTrack() {
        ++this.trackCount;
    }

    public void onTransformationRequestFinalized(TransformationRequest transformationRequest) {
        Assertions.checkState((this.trackCount-- > 0 ? 1 : 0) != 0);
        TransformationRequest.Builder fallbackRequestBuilder = this.fallbackTransformationRequest.buildUpon();
        if (!Util.areEqual((Object)transformationRequest.audioMimeType, (Object)this.originalTransformationRequest.audioMimeType)) {
            fallbackRequestBuilder.setAudioMimeType(transformationRequest.audioMimeType);
        }
        if (!Util.areEqual((Object)transformationRequest.videoMimeType, (Object)this.originalTransformationRequest.videoMimeType)) {
            fallbackRequestBuilder.setVideoMimeType(transformationRequest.videoMimeType);
        }
        if (transformationRequest.outputHeight != this.originalTransformationRequest.outputHeight) {
            fallbackRequestBuilder.setResolution(transformationRequest.outputHeight);
        }
        if (transformationRequest.enableHdrEditing != this.originalTransformationRequest.enableHdrEditing) {
            fallbackRequestBuilder.experimental_setEnableHdrEditing(transformationRequest.enableHdrEditing);
        }
        if (transformationRequest.enableRequestSdrToneMapping != this.originalTransformationRequest.enableRequestSdrToneMapping) {
            fallbackRequestBuilder.setEnableRequestSdrToneMapping(transformationRequest.enableRequestSdrToneMapping);
        }
        this.fallbackTransformationRequest = fallbackRequestBuilder.build();
        if (this.trackCount == 0 && !this.originalTransformationRequest.equals(this.fallbackTransformationRequest)) {
            this.transformerListeners.queueEvent(-1, listener -> listener.onFallbackApplied(this.mediaItem, this.originalTransformationRequest, this.fallbackTransformationRequest));
            this.transformerListeners.flushEvents();
        }
    }
}

