/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.Tracks;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionParameters;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.ProgressHolder;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.transformer.Transformer;
import com.google.android.exoplayer2.transformer.TransformerAudioRenderer;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.transformer.TransformerVideoRenderer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.DebugViewProvider;
import com.google.android.exoplayer2.util.Effect;
import com.google.android.exoplayer2.util.FrameProcessor;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class ExoPlayerAssetLoader {
    private final Context context;
    private final TransformationRequest transformationRequest;
    private final ImmutableList<Effect> videoEffects;
    private final boolean removeAudio;
    private final boolean removeVideo;
    private final MediaSource.Factory mediaSourceFactory;
    private final Codec.DecoderFactory decoderFactory;
    private final Codec.EncoderFactory encoderFactory;
    private final FrameProcessor.Factory frameProcessorFactory;
    private final Looper looper;
    private final DebugViewProvider debugViewProvider;
    private final Clock clock;
    private @MonotonicNonNull MuxerWrapper muxerWrapper;
    @Nullable
    private ExoPlayer player;
    private int progressState;

    public ExoPlayerAssetLoader(Context context, TransformationRequest transformationRequest, ImmutableList<Effect> videoEffects, boolean removeAudio, boolean removeVideo, MediaSource.Factory mediaSourceFactory, Codec.DecoderFactory decoderFactory, Codec.EncoderFactory encoderFactory, FrameProcessor.Factory frameProcessorFactory, Looper looper, DebugViewProvider debugViewProvider, Clock clock) {
        this.context = context;
        this.transformationRequest = transformationRequest;
        this.videoEffects = videoEffects;
        this.removeAudio = removeAudio;
        this.removeVideo = removeVideo;
        this.mediaSourceFactory = mediaSourceFactory;
        this.decoderFactory = decoderFactory;
        this.encoderFactory = encoderFactory;
        this.frameProcessorFactory = frameProcessorFactory;
        this.looper = looper;
        this.debugViewProvider = debugViewProvider;
        this.clock = clock;
        this.progressState = 4;
    }

    public void start(MediaItem mediaItem, MuxerWrapper muxerWrapper, Listener listener, FallbackListener fallbackListener, Transformer.AsyncErrorListener asyncErrorListener) {
        this.muxerWrapper = muxerWrapper;
        DefaultTrackSelector trackSelector = new DefaultTrackSelector(this.context);
        trackSelector.setParameters((TrackSelectionParameters)new DefaultTrackSelector.Parameters.Builder(this.context).setForceHighestSupportedBitrate(true).build());
        DefaultLoadControl loadControl = new DefaultLoadControl.Builder().setBufferDurationsMs(50000, 50000, 250, 500).build();
        ExoPlayer.Builder playerBuilder = new ExoPlayer.Builder(this.context, (RenderersFactory)new RenderersFactoryImpl(this.context, muxerWrapper, this.removeAudio, this.removeVideo, this.transformationRequest, mediaItem.clippingConfiguration.startsAtKeyFrame, this.videoEffects, this.frameProcessorFactory, this.encoderFactory, this.decoderFactory, fallbackListener, asyncErrorListener, this.debugViewProvider)).setMediaSourceFactory(this.mediaSourceFactory).setTrackSelector((TrackSelector)trackSelector).setLoadControl((LoadControl)loadControl).setLooper(this.looper);
        if (this.clock != Clock.DEFAULT) {
            ExoPlayer.Builder builder = playerBuilder.setClock(this.clock);
        }
        this.player = playerBuilder.build();
        this.player.setMediaItem(mediaItem);
        this.player.addListener((Player.Listener)new PlayerListener(listener));
        this.player.prepare();
        this.progressState = 0;
    }

    public int getProgress(ProgressHolder progressHolder) {
        if (this.progressState == 1) {
            Player player = (Player)Assertions.checkNotNull((Object)this.player);
            long durationMs = player.getDuration();
            long positionMs = player.getCurrentPosition();
            progressHolder.progress = Math.min((int)(positionMs * 100L / durationMs), 99);
        }
        return this.progressState;
    }

    public void release() {
        this.progressState = 4;
        if (this.player != null) {
            this.player.release();
            this.player = null;
        }
    }

    private final class PlayerListener
    implements Player.Listener {
        private final Listener listener;

        public PlayerListener(Listener listener) {
            this.listener = listener;
        }

        public void onPlaybackStateChanged(int state) {
            if (state == 4) {
                this.listener.onEnded();
            }
        }

        public void onTimelineChanged(Timeline timeline, int reason) {
            if (ExoPlayerAssetLoader.this.progressState != 0) {
                return;
            }
            Timeline.Window window = new Timeline.Window();
            timeline.getWindow(0, window);
            if (!window.isPlaceholder) {
                long durationUs = window.durationUs;
                ExoPlayerAssetLoader.this.progressState = durationUs <= 0L || durationUs == -9223372036854775807L ? 2 : 1;
                ((ExoPlayer)Assertions.checkNotNull((Object)ExoPlayerAssetLoader.this.player)).play();
            }
        }

        public void onTracksChanged(Tracks tracks) {
            if (((MuxerWrapper)Assertions.checkNotNull((Object)ExoPlayerAssetLoader.this.muxerWrapper)).getTrackCount() == 0) {
                this.listener.onError(new IllegalStateException("The output does not contain any tracks."));
            }
        }

        public void onPlayerError(PlaybackException error) {
            this.listener.onError((Exception)error);
        }
    }

    private static final class RenderersFactoryImpl
    implements RenderersFactory {
        private final Context context;
        private final MuxerWrapper muxerWrapper;
        private final TransformerMediaClock mediaClock;
        private final boolean removeAudio;
        private final boolean removeVideo;
        private final TransformationRequest transformationRequest;
        private final boolean clippingStartsAtKeyFrame;
        private final ImmutableList<Effect> videoEffects;
        private final FrameProcessor.Factory frameProcessorFactory;
        private final Codec.EncoderFactory encoderFactory;
        private final Codec.DecoderFactory decoderFactory;
        private final FallbackListener fallbackListener;
        private final Transformer.AsyncErrorListener asyncErrorListener;
        private final DebugViewProvider debugViewProvider;

        public RenderersFactoryImpl(Context context, MuxerWrapper muxerWrapper, boolean removeAudio, boolean removeVideo, TransformationRequest transformationRequest, boolean clippingStartsAtKeyFrame, ImmutableList<Effect> videoEffects, FrameProcessor.Factory frameProcessorFactory, Codec.EncoderFactory encoderFactory, Codec.DecoderFactory decoderFactory, FallbackListener fallbackListener, Transformer.AsyncErrorListener asyncErrorListener, DebugViewProvider debugViewProvider) {
            this.context = context;
            this.muxerWrapper = muxerWrapper;
            this.removeAudio = removeAudio;
            this.removeVideo = removeVideo;
            this.transformationRequest = transformationRequest;
            this.clippingStartsAtKeyFrame = clippingStartsAtKeyFrame;
            this.videoEffects = videoEffects;
            this.frameProcessorFactory = frameProcessorFactory;
            this.encoderFactory = encoderFactory;
            this.decoderFactory = decoderFactory;
            this.fallbackListener = fallbackListener;
            this.asyncErrorListener = asyncErrorListener;
            this.debugViewProvider = debugViewProvider;
            this.mediaClock = new TransformerMediaClock();
        }

        public Renderer[] createRenderers(Handler eventHandler, VideoRendererEventListener videoRendererEventListener, AudioRendererEventListener audioRendererEventListener, TextOutput textRendererOutput, MetadataOutput metadataRendererOutput) {
            int rendererCount = this.removeAudio || this.removeVideo ? 1 : 2;
            Renderer[] renderers = new Renderer[rendererCount];
            int index = 0;
            if (!this.removeAudio) {
                renderers[index] = new TransformerAudioRenderer(this.muxerWrapper, this.mediaClock, this.transformationRequest, this.encoderFactory, this.decoderFactory, this.asyncErrorListener, this.fallbackListener);
                ++index;
            }
            if (!this.removeVideo) {
                renderers[index] = new TransformerVideoRenderer(this.context, this.muxerWrapper, this.mediaClock, this.transformationRequest, this.clippingStartsAtKeyFrame, this.videoEffects, this.frameProcessorFactory, this.encoderFactory, this.decoderFactory, this.asyncErrorListener, this.fallbackListener, this.debugViewProvider);
                ++index;
            }
            return renderers;
        }
    }

    public static interface Listener {
        public void onEnded();

        public void onError(Exception var1);
    }
}

