/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.FrameProcessorChain;
import com.google.android.exoplayer2.transformer.GlEffect;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.PassthroughSamplePipeline;
import com.google.android.exoplayer2.transformer.SefSlowMotionFlattener;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.transformer.Transformer;
import com.google.android.exoplayer2.transformer.TransformerBaseRenderer;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.transformer.VideoTranscodingSamplePipeline;
import com.google.android.exoplayer2.util.Assertions;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

final class TransformerVideoRenderer
extends TransformerBaseRenderer {
    private static final String TAG = "TVideoRenderer";
    private final Context context;
    private final boolean clippingStartsAtKeyFrame;
    private final ImmutableList<GlEffect> effects;
    private final Codec.EncoderFactory encoderFactory;
    private final Codec.DecoderFactory decoderFactory;
    private final FrameProcessorChain.Listener frameProcessorChainListener;
    private final Transformer.DebugViewProvider debugViewProvider;
    private final DecoderInputBuffer decoderInputBuffer;
    private @MonotonicNonNull SefSlowMotionFlattener sefSlowMotionFlattener;

    public TransformerVideoRenderer(Context context, MuxerWrapper muxerWrapper, TransformerMediaClock mediaClock, TransformationRequest transformationRequest, boolean clippingStartsAtKeyFrame, ImmutableList<GlEffect> effects, Codec.EncoderFactory encoderFactory, Codec.DecoderFactory decoderFactory, FallbackListener fallbackListener, FrameProcessorChain.Listener frameProcessorChainListener, Transformer.DebugViewProvider debugViewProvider) {
        super(2, muxerWrapper, mediaClock, transformationRequest, fallbackListener);
        this.context = context;
        this.clippingStartsAtKeyFrame = clippingStartsAtKeyFrame;
        this.effects = effects;
        this.encoderFactory = encoderFactory;
        this.decoderFactory = decoderFactory;
        this.frameProcessorChainListener = frameProcessorChainListener;
        this.debugViewProvider = debugViewProvider;
        this.decoderInputBuffer = new DecoderInputBuffer(0);
    }

    public String getName() {
        return TAG;
    }

    @Override
    protected boolean ensureConfigured() throws TransformationException {
        if (this.samplePipeline != null) {
            return true;
        }
        FormatHolder formatHolder = this.getFormatHolder();
        int result = this.readSource(formatHolder, this.decoderInputBuffer, 2);
        if (result != -5) {
            return false;
        }
        Format inputFormat = (Format)Assertions.checkNotNull((Object)formatHolder.format);
        this.samplePipeline = this.shouldPassthrough(inputFormat) ? new PassthroughSamplePipeline(inputFormat, this.transformationRequest, this.fallbackListener) : new VideoTranscodingSamplePipeline(this.context, inputFormat, this.streamOffsetUs, this.transformationRequest, this.effects, this.decoderFactory, this.encoderFactory, (List<String>)this.muxerWrapper.getSupportedSampleMimeTypes(this.getTrackType()), this.fallbackListener, this.frameProcessorChainListener, this.debugViewProvider);
        if (this.transformationRequest.flattenForSlowMotion) {
            this.sefSlowMotionFlattener = new SefSlowMotionFlattener(inputFormat);
        }
        return true;
    }

    private boolean shouldPassthrough(Format inputFormat) {
        if (this.streamStartPositionUs - this.streamOffsetUs != 0L && !this.clippingStartsAtKeyFrame) {
            return false;
        }
        if (this.encoderFactory.videoNeedsEncoding()) {
            return false;
        }
        if (this.transformationRequest.enableRequestSdrToneMapping) {
            return false;
        }
        if (this.transformationRequest.enableHdrEditing) {
            return false;
        }
        if (this.transformationRequest.videoMimeType != null && !this.transformationRequest.videoMimeType.equals(inputFormat.sampleMimeType)) {
            return false;
        }
        if (this.transformationRequest.videoMimeType == null && !this.muxerWrapper.supportsSampleMimeType(inputFormat.sampleMimeType)) {
            return false;
        }
        if (inputFormat.pixelWidthHeightRatio != 1.0f) {
            return false;
        }
        if (this.transformationRequest.rotationDegrees != 0.0f) {
            return false;
        }
        if (this.transformationRequest.scaleX != 1.0f) {
            return false;
        }
        if (this.transformationRequest.scaleY != 1.0f) {
            return false;
        }
        if (this.transformationRequest.outputHeight != -1 && this.transformationRequest.outputHeight != inputFormat.height) {
            return false;
        }
        return this.effects.isEmpty();
    }

    @Override
    @RequiresNonNull(value={"samplePipeline", "#1.data"})
    protected void maybeQueueSampleToPipeline(DecoderInputBuffer inputBuffer) throws TransformationException {
        if (this.sefSlowMotionFlattener == null) {
            this.samplePipeline.queueInputBuffer();
            return;
        }
        ByteBuffer data = inputBuffer.data;
        long presentationTimeUs = inputBuffer.timeUs - this.streamOffsetUs;
        boolean shouldDropSample = this.sefSlowMotionFlattener.dropOrTransformSample(data, presentationTimeUs);
        inputBuffer.timeUs = this.streamOffsetUs + this.sefSlowMotionFlattener.getSamplePresentationTimeUs();
        if (shouldDropSample) {
            data.clear();
        } else {
            this.samplePipeline.queueInputBuffer();
        }
    }
}

