/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.view.SurfaceView;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.Tracks;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionParameters;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.FrameProcessingException;
import com.google.android.exoplayer2.transformer.FrameProcessorChain;
import com.google.android.exoplayer2.transformer.FrameworkMuxer;
import com.google.android.exoplayer2.transformer.GlEffect;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.ProgressHolder;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.transformer.TransformationResult;
import com.google.android.exoplayer2.transformer.TransformerAudioRenderer;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.transformer.TransformerVideoRenderer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.ListenerSet;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class Transformer {
    public static final int PROGRESS_STATE_WAITING_FOR_AVAILABILITY = 0;
    public static final int PROGRESS_STATE_AVAILABLE = 1;
    public static final int PROGRESS_STATE_UNAVAILABLE = 2;
    public static final int PROGRESS_STATE_NO_TRANSFORMATION = 4;
    private final Context context;
    private final MediaSource.Factory mediaSourceFactory;
    private final Muxer.Factory muxerFactory;
    private final boolean removeAudio;
    private final boolean removeVideo;
    private final String containerMimeType;
    private final TransformationRequest transformationRequest;
    private final ImmutableList<GlEffect> videoFrameEffects;
    private final Looper looper;
    private final Clock clock;
    private final DebugViewProvider debugViewProvider;
    private final ListenerSet<Listener> listeners;
    @VisibleForTesting
    final Codec.DecoderFactory decoderFactory;
    @VisibleForTesting
    final Codec.EncoderFactory encoderFactory;
    @Nullable
    private MuxerWrapper muxerWrapper;
    @Nullable
    private ExoPlayer player;
    private int progressState;
    private boolean isCancelling;

    private Transformer(Context context, MediaSource.Factory mediaSourceFactory, Muxer.Factory muxerFactory, boolean removeAudio, boolean removeVideo, String containerMimeType, TransformationRequest transformationRequest, ImmutableList<GlEffect> videoFrameEffects, ListenerSet<Listener> listeners, Looper looper, Clock clock, Codec.EncoderFactory encoderFactory, Codec.DecoderFactory decoderFactory, DebugViewProvider debugViewProvider) {
        Assertions.checkState((!removeAudio || !removeVideo ? 1 : 0) != 0, (Object)"Audio and video cannot both be removed.");
        this.context = context;
        this.mediaSourceFactory = mediaSourceFactory;
        this.muxerFactory = muxerFactory;
        this.removeAudio = removeAudio;
        this.removeVideo = removeVideo;
        this.containerMimeType = containerMimeType;
        this.transformationRequest = transformationRequest;
        this.videoFrameEffects = videoFrameEffects;
        this.listeners = listeners;
        this.looper = looper;
        this.clock = clock;
        this.encoderFactory = encoderFactory;
        this.decoderFactory = decoderFactory;
        this.debugViewProvider = debugViewProvider;
        this.progressState = 4;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    @Deprecated
    public void setListener(Listener listener) {
        this.verifyApplicationThread();
        this.listeners.clear();
        this.listeners.add((Object)listener);
    }

    public void addListener(Listener listener) {
        this.verifyApplicationThread();
        this.listeners.add((Object)listener);
    }

    public void removeListener(Listener listener) {
        this.verifyApplicationThread();
        this.listeners.remove((Object)listener);
    }

    public void removeAllListeners() {
        this.verifyApplicationThread();
        this.listeners.clear();
    }

    public void startTransformation(MediaItem mediaItem, String path) throws IOException {
        if (!mediaItem.clippingConfiguration.equals((Object)MediaItem.ClippingConfiguration.UNSET) && this.transformationRequest.flattenForSlowMotion) {
            throw new UnsupportedEncodingException("Clipping is not supported when slow motion flattening is requested");
        }
        this.startTransformation(mediaItem, this.muxerFactory.create(path, this.containerMimeType));
    }

    @RequiresApi(value=26)
    public void startTransformation(MediaItem mediaItem, ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        this.startTransformation(mediaItem, this.muxerFactory.create(parcelFileDescriptor, this.containerMimeType));
    }

    private void startTransformation(MediaItem mediaItem, Muxer muxer) {
        MuxerWrapper muxerWrapper;
        this.verifyApplicationThread();
        if (this.player != null) {
            throw new IllegalStateException("There is already a transformation in progress.");
        }
        this.muxerWrapper = muxerWrapper = new MuxerWrapper(muxer, this.muxerFactory, this.containerMimeType);
        DefaultTrackSelector trackSelector = new DefaultTrackSelector(this.context);
        trackSelector.setParameters((TrackSelectionParameters)new DefaultTrackSelector.ParametersBuilder(this.context).setForceHighestSupportedBitrate(true).build());
        DefaultLoadControl loadControl = new DefaultLoadControl.Builder().setBufferDurationsMs(50000, 50000, 250, 500).build();
        TransformerPlayerListener playerListener = new TransformerPlayerListener(mediaItem, muxerWrapper, this.looper);
        ExoPlayer.Builder playerBuilder = new ExoPlayer.Builder(this.context, (RenderersFactory)new TransformerRenderersFactory(this.context, muxerWrapper, this.removeAudio, this.removeVideo, this.transformationRequest, mediaItem.clippingConfiguration.startsAtKeyFrame, this.videoFrameEffects, this.encoderFactory, this.decoderFactory, new FallbackListener(mediaItem, this.listeners, this.transformationRequest), playerListener, this.debugViewProvider)).setMediaSourceFactory(this.mediaSourceFactory).setTrackSelector((TrackSelector)trackSelector).setLoadControl((LoadControl)loadControl).setLooper(this.looper);
        if (this.clock != Clock.DEFAULT) {
            ExoPlayer.Builder builder = playerBuilder.setClock(this.clock);
        }
        this.player = playerBuilder.build();
        this.player.setMediaItem(mediaItem);
        this.player.addListener((Player.Listener)playerListener);
        this.player.prepare();
        this.progressState = 0;
    }

    public Looper getApplicationLooper() {
        return this.looper;
    }

    public int getProgress(ProgressHolder progressHolder) {
        this.verifyApplicationThread();
        if (this.progressState == 1) {
            Player player = (Player)Assertions.checkNotNull((Object)this.player);
            long durationMs = player.getDuration();
            long positionMs = player.getCurrentPosition();
            progressHolder.progress = Math.min((int)(positionMs * 100L / durationMs), 99);
        }
        return this.progressState;
    }

    public void cancel() {
        this.isCancelling = true;
        try {
            this.releaseResources(true);
        }
        catch (TransformationException impossible) {
            throw new IllegalStateException(impossible);
        }
        this.isCancelling = false;
    }

    private void releaseResources(boolean forCancellation) throws TransformationException {
        this.verifyApplicationThread();
        this.progressState = 4;
        if (this.player != null) {
            this.player.release();
            this.player = null;
        }
        if (this.muxerWrapper != null) {
            try {
                this.muxerWrapper.release(forCancellation);
            }
            catch (Muxer.MuxerException e) {
                throw TransformationException.createForMuxer(e, 6001);
            }
            this.muxerWrapper = null;
        }
    }

    private void verifyApplicationThread() {
        if (Looper.myLooper() != this.looper) {
            throw new IllegalStateException("Transformer is accessed on the wrong thread.");
        }
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.transformer");
    }

    private final class TransformerPlayerListener
    implements Player.Listener,
    FrameProcessorChain.Listener {
        private final MediaItem mediaItem;
        private final MuxerWrapper muxerWrapper;
        private final Handler handler;

        public TransformerPlayerListener(MediaItem mediaItem, MuxerWrapper muxerWrapper, Looper looper) {
            this.mediaItem = mediaItem;
            this.muxerWrapper = muxerWrapper;
            this.handler = new Handler(looper);
        }

        public void onPlaybackStateChanged(int state) {
            if (state == 4) {
                this.handleTransformationEnded(null);
            }
        }

        public void onTimelineChanged(Timeline timeline, int reason) {
            if (Transformer.this.progressState != 0) {
                return;
            }
            Timeline.Window window = new Timeline.Window();
            timeline.getWindow(0, window);
            if (!window.isPlaceholder) {
                long durationUs = window.durationUs;
                Transformer.this.progressState = durationUs <= 0L || durationUs == -9223372036854775807L ? 2 : 1;
                ((ExoPlayer)Assertions.checkNotNull((Object)Transformer.this.player)).play();
            }
        }

        public void onTracksChanged(Tracks tracks) {
            if (this.muxerWrapper.getTrackCount() == 0) {
                this.handleTransformationEnded(TransformationException.createForUnexpected(new IllegalStateException("The output does not contain any tracks.")));
            }
        }

        public void onPlayerError(PlaybackException error) {
            TransformationException transformationException;
            Throwable cause = error.getCause();
            TransformationException transformationException2 = transformationException = cause instanceof TransformationException ? (TransformationException)cause : TransformationException.createForPlaybackException(error);
            if (Transformer.this.isCancelling) {
                Transformer.this.listeners.queueEvent(-1, listener -> listener.onTransformationError(this.mediaItem, transformationException));
                Transformer.this.listeners.flushEvents();
            } else {
                this.handleTransformationEnded(transformationException);
            }
        }

        private void handleTransformationEnded(@Nullable TransformationException exception) {
            TransformationException resourceReleaseException = null;
            try {
                Transformer.this.releaseResources(false);
            }
            catch (TransformationException e) {
                resourceReleaseException = e;
            }
            catch (RuntimeException e) {
                resourceReleaseException = TransformationException.createForUnexpected(e);
            }
            if (exception == null) {
                exception = resourceReleaseException;
            }
            if (exception != null) {
                TransformationException finalException = exception;
                Transformer.this.listeners.queueEvent(-1, listener -> listener.onTransformationError(this.mediaItem, finalException));
            } else {
                TransformationResult result = new TransformationResult.Builder().setDurationMs(this.muxerWrapper.getDurationMs()).setAverageAudioBitrate(this.muxerWrapper.getTrackAverageBitrate(1)).setAverageVideoBitrate(this.muxerWrapper.getTrackAverageBitrate(2)).setVideoFrameCount(this.muxerWrapper.getTrackSampleCount(2)).build();
                Transformer.this.listeners.queueEvent(-1, listener -> listener.onTransformationCompleted(this.mediaItem, result));
            }
            Transformer.this.listeners.flushEvents();
        }

        @Override
        public void onFrameProcessingError(FrameProcessingException exception) {
            this.handler.post(() -> this.handleTransformationEnded(TransformationException.createForFrameProcessorChain(exception, 5002)));
        }
    }

    private static final class TransformerRenderersFactory
    implements RenderersFactory {
        private final Context context;
        private final MuxerWrapper muxerWrapper;
        private final TransformerMediaClock mediaClock;
        private final boolean removeAudio;
        private final boolean removeVideo;
        private final TransformationRequest transformationRequest;
        private final boolean clippingStartsAtKeyFrame;
        private final ImmutableList<GlEffect> videoFrameEffects;
        private final Codec.EncoderFactory encoderFactory;
        private final Codec.DecoderFactory decoderFactory;
        private final FallbackListener fallbackListener;
        private final FrameProcessorChain.Listener frameProcessorChainListener;
        private final DebugViewProvider debugViewProvider;

        public TransformerRenderersFactory(Context context, MuxerWrapper muxerWrapper, boolean removeAudio, boolean removeVideo, TransformationRequest transformationRequest, boolean clippingStartsAtKeyFrame, ImmutableList<GlEffect> videoFrameEffects, Codec.EncoderFactory encoderFactory, Codec.DecoderFactory decoderFactory, FallbackListener fallbackListener, FrameProcessorChain.Listener frameProcessorChainListener, DebugViewProvider debugViewProvider) {
            this.context = context;
            this.muxerWrapper = muxerWrapper;
            this.removeAudio = removeAudio;
            this.removeVideo = removeVideo;
            this.transformationRequest = transformationRequest;
            this.clippingStartsAtKeyFrame = clippingStartsAtKeyFrame;
            this.videoFrameEffects = videoFrameEffects;
            this.encoderFactory = encoderFactory;
            this.decoderFactory = decoderFactory;
            this.fallbackListener = fallbackListener;
            this.frameProcessorChainListener = frameProcessorChainListener;
            this.debugViewProvider = debugViewProvider;
            this.mediaClock = new TransformerMediaClock();
        }

        public Renderer[] createRenderers(Handler eventHandler, VideoRendererEventListener videoRendererEventListener, AudioRendererEventListener audioRendererEventListener, TextOutput textRendererOutput, MetadataOutput metadataRendererOutput) {
            int rendererCount = this.removeAudio || this.removeVideo ? 1 : 2;
            Renderer[] renderers = new Renderer[rendererCount];
            int index = 0;
            if (!this.removeAudio) {
                renderers[index] = new TransformerAudioRenderer(this.muxerWrapper, this.mediaClock, this.transformationRequest, this.encoderFactory, this.decoderFactory, this.fallbackListener);
                ++index;
            }
            if (!this.removeVideo) {
                renderers[index] = new TransformerVideoRenderer(this.context, this.muxerWrapper, this.mediaClock, this.transformationRequest, this.clippingStartsAtKeyFrame, this.videoFrameEffects, this.encoderFactory, this.decoderFactory, this.fallbackListener, this.frameProcessorChainListener, this.debugViewProvider);
                ++index;
            }
            return renderers;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface ProgressState {
    }

    public static interface DebugViewProvider {
        public static final DebugViewProvider NONE = (width, height) -> null;

        @Nullable
        public SurfaceView getDebugPreviewSurfaceView(int var1, int var2);
    }

    public static interface Listener {
        @Deprecated
        default public void onTransformationCompleted(MediaItem inputMediaItem) {
        }

        default public void onTransformationCompleted(MediaItem inputMediaItem, TransformationResult transformationResult) {
            this.onTransformationCompleted(inputMediaItem);
        }

        @Deprecated
        default public void onTransformationError(MediaItem inputMediaItem, Exception exception) {
            this.onTransformationError(inputMediaItem, (TransformationException)exception);
        }

        default public void onTransformationError(MediaItem inputMediaItem, TransformationException exception) {
        }

        default public void onFallbackApplied(MediaItem inputMediaItem, TransformationRequest originalTransformationRequest, TransformationRequest fallbackTransformationRequest) {
        }
    }

    public static final class Builder {
        private @MonotonicNonNull Context context;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @MonotonicNonNull MediaSource.Factory mediaSourceFactory;
        private Muxer.Factory muxerFactory;
        private boolean removeAudio;
        private boolean removeVideo;
        private String containerMimeType;
        private TransformationRequest transformationRequest;
        private ImmutableList<GlEffect> videoFrameEffects;
        private ListenerSet<Listener> listeners;
        private DebugViewProvider debugViewProvider;
        private Looper looper;
        private Clock clock;
        private Codec.EncoderFactory encoderFactory;
        private Codec.DecoderFactory decoderFactory;

        @Deprecated
        public Builder() {
            this.muxerFactory = new FrameworkMuxer.Factory();
            this.looper = Util.getCurrentOrMainLooper();
            this.clock = Clock.DEFAULT;
            this.listeners = new ListenerSet(this.looper, this.clock, (listener, flags) -> {});
            this.encoderFactory = Codec.EncoderFactory.DEFAULT;
            this.decoderFactory = Codec.DecoderFactory.DEFAULT;
            this.debugViewProvider = DebugViewProvider.NONE;
            this.containerMimeType = "video/mp4";
            this.transformationRequest = new TransformationRequest.Builder().build();
            this.videoFrameEffects = ImmutableList.of();
        }

        public Builder(Context context) {
            this.context = context.getApplicationContext();
            this.muxerFactory = new FrameworkMuxer.Factory();
            this.looper = Util.getCurrentOrMainLooper();
            this.clock = Clock.DEFAULT;
            this.listeners = new ListenerSet(this.looper, this.clock, (listener, flags) -> {});
            this.encoderFactory = Codec.EncoderFactory.DEFAULT;
            this.decoderFactory = Codec.DecoderFactory.DEFAULT;
            this.debugViewProvider = DebugViewProvider.NONE;
            this.containerMimeType = "video/mp4";
            this.transformationRequest = new TransformationRequest.Builder().build();
            this.videoFrameEffects = ImmutableList.of();
        }

        private Builder(Transformer transformer) {
            this.context = transformer.context;
            this.mediaSourceFactory = transformer.mediaSourceFactory;
            this.muxerFactory = transformer.muxerFactory;
            this.removeAudio = transformer.removeAudio;
            this.removeVideo = transformer.removeVideo;
            this.containerMimeType = transformer.containerMimeType;
            this.transformationRequest = transformer.transformationRequest;
            this.videoFrameEffects = transformer.videoFrameEffects;
            this.listeners = transformer.listeners;
            this.looper = transformer.looper;
            this.encoderFactory = transformer.encoderFactory;
            this.decoderFactory = transformer.decoderFactory;
            this.debugViewProvider = transformer.debugViewProvider;
            this.clock = transformer.clock;
        }

        @Deprecated
        public Builder setContext(Context context) {
            this.context = context.getApplicationContext();
            return this;
        }

        public Builder setTransformationRequest(TransformationRequest transformationRequest) {
            this.transformationRequest = transformationRequest;
            return this;
        }

        public Builder setVideoFrameEffects(List<GlEffect> effects) {
            this.videoFrameEffects = ImmutableList.copyOf(effects);
            return this;
        }

        public Builder setMediaSourceFactory(MediaSource.Factory mediaSourceFactory) {
            this.mediaSourceFactory = mediaSourceFactory;
            return this;
        }

        public Builder setRemoveAudio(boolean removeAudio) {
            this.removeAudio = removeAudio;
            return this;
        }

        public Builder setRemoveVideo(boolean removeVideo) {
            this.removeVideo = removeVideo;
            return this;
        }

        @Deprecated
        public Builder setFlattenForSlowMotion(boolean flattenForSlowMotion) {
            this.transformationRequest = this.transformationRequest.buildUpon().setFlattenForSlowMotion(flattenForSlowMotion).build();
            return this;
        }

        @Deprecated
        public Builder setOutputMimeType(String outputMimeType) {
            this.containerMimeType = outputMimeType;
            return this;
        }

        @Deprecated
        public Builder setListener(Listener listener) {
            this.listeners.clear();
            this.listeners.add((Object)listener);
            return this;
        }

        public Builder addListener(Listener listener) {
            this.listeners.add((Object)listener);
            return this;
        }

        public Builder removeListener(Listener listener) {
            this.listeners.remove((Object)listener);
            return this;
        }

        public Builder removeAllListeners() {
            this.listeners.clear();
            return this;
        }

        public Builder setLooper(Looper looper) {
            this.looper = looper;
            this.listeners = this.listeners.copy(looper, (listener, flags) -> {});
            return this;
        }

        public Builder setEncoderFactory(Codec.EncoderFactory encoderFactory) {
            this.encoderFactory = encoderFactory;
            return this;
        }

        public Builder setDecoderFactory(Codec.DecoderFactory decoderFactory) {
            this.decoderFactory = decoderFactory;
            return this;
        }

        public Builder setDebugViewProvider(DebugViewProvider debugViewProvider) {
            this.debugViewProvider = debugViewProvider;
            return this;
        }

        @VisibleForTesting
        Builder setClock(Clock clock) {
            this.clock = clock;
            this.listeners = this.listeners.copy(this.looper, clock, (listener, flags) -> {});
            return this;
        }

        @VisibleForTesting
        Builder setMuxerFactory(Muxer.Factory muxerFactory) {
            this.muxerFactory = muxerFactory;
            return this;
        }

        public Transformer build() {
            Assertions.checkNotNull((Object)this.context);
            if (this.mediaSourceFactory == null) {
                DefaultExtractorsFactory defaultExtractorsFactory = new DefaultExtractorsFactory();
                if (this.transformationRequest.flattenForSlowMotion) {
                    defaultExtractorsFactory.setMp4ExtractorFlags(4);
                }
                this.mediaSourceFactory = new DefaultMediaSourceFactory(this.context, (ExtractorsFactory)defaultExtractorsFactory);
            }
            Assertions.checkState((boolean)this.muxerFactory.supportsOutputMimeType(this.containerMimeType), (Object)("Unsupported container MIME type: " + this.containerMimeType));
            if (this.transformationRequest.audioMimeType != null) {
                this.checkSampleMimeType(this.transformationRequest.audioMimeType);
            }
            if (this.transformationRequest.videoMimeType != null) {
                this.checkSampleMimeType(this.transformationRequest.videoMimeType);
            }
            return new Transformer(this.context, this.mediaSourceFactory, this.muxerFactory, this.removeAudio, this.removeVideo, this.containerMimeType, this.transformationRequest, this.videoFrameEffects, this.listeners, this.looper, this.clock, this.encoderFactory, this.decoderFactory, this.debugViewProvider);
        }

        private void checkSampleMimeType(String sampleMimeType) {
            Assertions.checkState((boolean)this.muxerFactory.supportsSampleMimeType(sampleMimeType, this.containerMimeType), (Object)("Unsupported sample MIME type " + sampleMimeType + " for container MIME type " + this.containerMimeType));
        }
    }
}

