/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;

public final class TransformationRequest {
    public final boolean flattenForSlowMotion;
    public final float scaleX;
    public final float scaleY;
    public final float rotationDegrees;
    public final int outputHeight;
    @Nullable
    public final String audioMimeType;
    @Nullable
    public final String videoMimeType;
    public final boolean enableRequestSdrToneMapping;
    public final boolean enableHdrEditing;

    private TransformationRequest(boolean flattenForSlowMotion, float scaleX, float scaleY, float rotationDegrees, int outputHeight, @Nullable String audioMimeType, @Nullable String videoMimeType, boolean enableRequestSdrToneMapping, boolean enableHdrEditing) {
        Assertions.checkArgument((!enableHdrEditing || !enableRequestSdrToneMapping ? 1 : 0) != 0);
        this.flattenForSlowMotion = flattenForSlowMotion;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.rotationDegrees = rotationDegrees;
        this.outputHeight = outputHeight;
        this.audioMimeType = audioMimeType;
        this.videoMimeType = videoMimeType;
        this.enableRequestSdrToneMapping = enableRequestSdrToneMapping;
        this.enableHdrEditing = enableHdrEditing;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransformationRequest)) {
            return false;
        }
        TransformationRequest that = (TransformationRequest)o;
        return this.flattenForSlowMotion == that.flattenForSlowMotion && this.scaleX == that.scaleX && this.scaleY == that.scaleY && this.rotationDegrees == that.rotationDegrees && this.outputHeight == that.outputHeight && Util.areEqual((Object)this.audioMimeType, (Object)that.audioMimeType) && Util.areEqual((Object)this.videoMimeType, (Object)that.videoMimeType) && this.enableRequestSdrToneMapping == that.enableRequestSdrToneMapping && this.enableHdrEditing == that.enableHdrEditing;
    }

    public int hashCode() {
        int result = this.flattenForSlowMotion ? 1 : 0;
        result = 31 * result + Float.floatToIntBits(this.scaleX);
        result = 31 * result + Float.floatToIntBits(this.scaleY);
        result = 31 * result + Float.floatToIntBits(this.rotationDegrees);
        result = 31 * result + this.outputHeight;
        result = 31 * result + (this.audioMimeType != null ? this.audioMimeType.hashCode() : 0);
        result = 31 * result + (this.videoMimeType != null ? this.videoMimeType.hashCode() : 0);
        result = 31 * result + (this.enableRequestSdrToneMapping ? 1 : 0);
        result = 31 * result + (this.enableHdrEditing ? 1 : 0);
        return result;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public static final class Builder {
        private boolean flattenForSlowMotion;
        private float scaleX;
        private float scaleY;
        private float rotationDegrees;
        private int outputHeight;
        @Nullable
        private String audioMimeType;
        @Nullable
        private String videoMimeType;
        private boolean enableRequestSdrToneMapping;
        private boolean enableHdrEditing;

        public Builder() {
            this.scaleX = 1.0f;
            this.scaleY = 1.0f;
            this.outputHeight = -1;
        }

        private Builder(TransformationRequest transformationRequest) {
            this.flattenForSlowMotion = transformationRequest.flattenForSlowMotion;
            this.scaleX = transformationRequest.scaleX;
            this.scaleY = transformationRequest.scaleY;
            this.rotationDegrees = transformationRequest.rotationDegrees;
            this.outputHeight = transformationRequest.outputHeight;
            this.audioMimeType = transformationRequest.audioMimeType;
            this.videoMimeType = transformationRequest.videoMimeType;
            this.enableRequestSdrToneMapping = transformationRequest.enableRequestSdrToneMapping;
            this.enableHdrEditing = transformationRequest.enableHdrEditing;
        }

        public Builder setFlattenForSlowMotion(boolean flattenForSlowMotion) {
            this.flattenForSlowMotion = flattenForSlowMotion;
            return this;
        }

        public Builder setScale(float scaleX, float scaleY) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            return this;
        }

        public Builder setRotationDegrees(float rotationDegrees) {
            this.rotationDegrees = rotationDegrees;
            return this;
        }

        public Builder setResolution(int outputHeight) {
            this.outputHeight = outputHeight;
            return this;
        }

        public Builder setVideoMimeType(@Nullable String videoMimeType) {
            Assertions.checkArgument((videoMimeType == null || MimeTypes.isVideo((String)videoMimeType) ? 1 : 0) != 0, (Object)("Not a video MIME type: " + videoMimeType));
            this.videoMimeType = videoMimeType;
            return this;
        }

        public Builder setAudioMimeType(@Nullable String audioMimeType) {
            Assertions.checkArgument((audioMimeType == null || MimeTypes.isAudio((String)audioMimeType) ? 1 : 0) != 0, (Object)("Not an audio MIME type: " + audioMimeType));
            this.audioMimeType = audioMimeType;
            return this;
        }

        public Builder setEnableRequestSdrToneMapping(boolean enableRequestSdrToneMapping) {
            this.enableRequestSdrToneMapping = enableRequestSdrToneMapping;
            return this;
        }

        public Builder experimental_setEnableHdrEditing(boolean enableHdrEditing) {
            this.enableHdrEditing = enableHdrEditing;
            return this;
        }

        public TransformationRequest build() {
            return new TransformationRequest(this.flattenForSlowMotion, this.scaleX, this.scaleY, this.rotationDegrees, this.outputHeight, this.audioMimeType, this.videoMimeType, this.enableRequestSdrToneMapping, this.enableHdrEditing);
        }
    }
}

