/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.BaseAudioProcessor;
import com.google.android.exoplayer2.audio.SonicAudioProcessor;
import com.google.android.exoplayer2.transformer.SpeedProvider;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;

final class SpeedChangingAudioProcessor
extends BaseAudioProcessor {
    private final SpeedProvider speedProvider;
    private final SonicAudioProcessor sonicAudioProcessor;
    private float currentSpeed;
    private long bytesRead;
    private boolean endOfStreamQueuedToSonic;

    public SpeedChangingAudioProcessor(SpeedProvider speedProvider) {
        this.speedProvider = speedProvider;
        this.sonicAudioProcessor = new SonicAudioProcessor();
        this.currentSpeed = 1.0f;
    }

    public AudioProcessor.AudioFormat onConfigure(AudioProcessor.AudioFormat inputAudioFormat) throws AudioProcessor.UnhandledAudioFormatException {
        return this.sonicAudioProcessor.configure(inputAudioFormat);
    }

    public void queueInput(ByteBuffer inputBuffer) {
        int bytesToNextSpeedChange;
        long timeUs = Util.scaleLargeTimestamp((long)this.bytesRead, (long)1000000L, (long)((long)this.inputAudioFormat.sampleRate * (long)this.inputAudioFormat.bytesPerFrame));
        float newSpeed = this.speedProvider.getSpeed(timeUs);
        if (newSpeed != this.currentSpeed) {
            this.currentSpeed = newSpeed;
            if (this.isUsingSonic()) {
                this.sonicAudioProcessor.setSpeed(newSpeed);
                this.sonicAudioProcessor.setPitch(newSpeed);
            }
            this.flush();
        }
        int inputBufferLimit = inputBuffer.limit();
        long nextSpeedChangeTimeUs = this.speedProvider.getNextSpeedChangeTimeUs(timeUs);
        if (nextSpeedChangeTimeUs != -9223372036854775807L) {
            bytesToNextSpeedChange = (int)Util.scaleLargeTimestamp((long)(nextSpeedChangeTimeUs - timeUs), (long)((long)this.inputAudioFormat.sampleRate * (long)this.inputAudioFormat.bytesPerFrame), (long)1000000L);
            int bytesToNextFrame = this.inputAudioFormat.bytesPerFrame - bytesToNextSpeedChange % this.inputAudioFormat.bytesPerFrame;
            if (bytesToNextFrame != this.inputAudioFormat.bytesPerFrame) {
                bytesToNextSpeedChange += bytesToNextFrame;
            }
            inputBuffer.limit(Math.min(inputBufferLimit, inputBuffer.position() + bytesToNextSpeedChange));
        } else {
            bytesToNextSpeedChange = -1;
        }
        long startPosition = inputBuffer.position();
        if (this.isUsingSonic()) {
            this.sonicAudioProcessor.queueInput(inputBuffer);
            if (bytesToNextSpeedChange != -1 && (long)inputBuffer.position() - startPosition == (long)bytesToNextSpeedChange) {
                this.sonicAudioProcessor.queueEndOfStream();
                this.endOfStreamQueuedToSonic = true;
            }
        } else {
            ByteBuffer buffer = this.replaceOutputBuffer(inputBuffer.remaining());
            buffer.put(inputBuffer);
            buffer.flip();
        }
        this.bytesRead += (long)inputBuffer.position() - startPosition;
        inputBuffer.limit(inputBufferLimit);
    }

    protected void onQueueEndOfStream() {
        if (!this.endOfStreamQueuedToSonic) {
            this.sonicAudioProcessor.queueEndOfStream();
            this.endOfStreamQueuedToSonic = true;
        }
    }

    public ByteBuffer getOutput() {
        return this.isUsingSonic() ? this.sonicAudioProcessor.getOutput() : super.getOutput();
    }

    public boolean isEnded() {
        return super.isEnded() && this.sonicAudioProcessor.isEnded();
    }

    protected void onFlush() {
        this.sonicAudioProcessor.flush();
        this.endOfStreamQueuedToSonic = false;
    }

    protected void onReset() {
        this.currentSpeed = 1.0f;
        this.bytesRead = 0L;
        this.sonicAudioProcessor.reset();
        this.endOfStreamQueuedToSonic = false;
    }

    private boolean isUsingSonic() {
        return this.currentSpeed != 1.0f;
    }
}

