/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.graphics.Matrix;
import android.util.Size;
import com.google.android.exoplayer2.transformer.MatrixTransformation;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.GlUtil;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class ScaleToFitTransformation
implements MatrixTransformation {
    private final Matrix transformationMatrix = new Matrix();
    private @MonotonicNonNull Matrix adjustedTransformationMatrix;

    private ScaleToFitTransformation(float scaleX, float scaleY, float rotationDegrees) {
        this.transformationMatrix.postScale(scaleX, scaleY);
        this.transformationMatrix.postRotate(rotationDegrees);
    }

    @Override
    public Size configure(int inputWidth, int inputHeight) {
        Assertions.checkArgument((inputWidth > 0 ? 1 : 0) != 0, (Object)"inputWidth must be positive");
        Assertions.checkArgument((inputHeight > 0 ? 1 : 0) != 0, (Object)"inputHeight must be positive");
        this.adjustedTransformationMatrix = new Matrix(this.transformationMatrix);
        if (this.transformationMatrix.isIdentity()) {
            return new Size(inputWidth, inputHeight);
        }
        float inputAspectRatio = (float)inputWidth / (float)inputHeight;
        this.adjustedTransformationMatrix.preScale(inputAspectRatio, 1.0f);
        this.adjustedTransformationMatrix.postScale(1.0f / inputAspectRatio, 1.0f);
        float[][] transformOnNdcPoints = new float[][]{{-1.0f, -1.0f, 0.0f, 1.0f}, {-1.0f, 1.0f, 0.0f, 1.0f}, {1.0f, -1.0f, 0.0f, 1.0f}, {1.0f, 1.0f, 0.0f, 1.0f}};
        float minX = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float minY = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        for (float[] transformOnNdcPoint : transformOnNdcPoints) {
            this.adjustedTransformationMatrix.mapPoints(transformOnNdcPoint);
            minX = Math.min(minX, transformOnNdcPoint[0]);
            maxX = Math.max(maxX, transformOnNdcPoint[0]);
            minY = Math.min(minY, transformOnNdcPoint[1]);
            maxY = Math.max(maxY, transformOnNdcPoint[1]);
        }
        float scaleX = (maxX - minX) / 2.0f;
        float scaleY = (maxY - minY) / 2.0f;
        this.adjustedTransformationMatrix.postScale(1.0f / scaleX, 1.0f / scaleY);
        return new Size(Math.round((float)inputWidth * scaleX), Math.round((float)inputHeight * scaleY));
    }

    @Override
    public Matrix getMatrix(long presentationTimeUs) {
        return (Matrix)Assertions.checkStateNotNull((Object)this.adjustedTransformationMatrix, (Object)"configure must be called first");
    }

    static {
        GlUtil.glAssertionsEnabled = true;
    }

    public static final class Builder {
        private float scaleX = 1.0f;
        private float scaleY = 1.0f;
        private float rotationDegrees = 0.0f;

        public Builder setScale(float scaleX, float scaleY) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            return this;
        }

        public Builder setRotationDegrees(float rotationDegrees) {
            this.rotationDegrees = rotationDegrees;
            return this;
        }

        public ScaleToFitTransformation build() {
            return new ScaleToFitTransformation(this.scaleX, this.scaleY, this.rotationDegrees);
        }
    }
}

