/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.graphics.Matrix;
import android.media.MediaCodec;
import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.FrameEditor;
import com.google.android.exoplayer2.transformer.SamplePipeline;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.transformer.Transformer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.dataflow.qual.Pure;

final class VideoTranscodingSamplePipeline
implements SamplePipeline {
    private final int outputRotationDegrees;
    private final DecoderInputBuffer decoderInputBuffer = new DecoderInputBuffer(0);
    private final Codec decoder;
    private final Codec encoder;
    private final DecoderInputBuffer encoderOutputBuffer = new DecoderInputBuffer(0);
    private @MonotonicNonNull FrameEditor frameEditor;
    private boolean waitingForFrameEditorInput;

    public VideoTranscodingSamplePipeline(Context context, Format inputFormat, TransformationRequest transformationRequest, Codec.DecoderFactory decoderFactory, Codec.EncoderFactory encoderFactory, List<String> allowedOutputMimeTypes, FallbackListener fallbackListener, Transformer.DebugViewProvider debugViewProvider) throws TransformationException {
        boolean swapEncodingDimensions;
        float inputFormatAspectRatio = (float)inputFormat.width / (float)inputFormat.height;
        int outputWidth = inputFormat.width;
        int outputHeight = inputFormat.height;
        if (transformationRequest.outputHeight != -1 && transformationRequest.outputHeight != inputFormat.height) {
            outputWidth = Math.round(inputFormatAspectRatio * (float)transformationRequest.outputHeight);
            outputHeight = transformationRequest.outputHeight;
        }
        boolean bl = swapEncodingDimensions = inputFormat.height > inputFormat.width;
        if (swapEncodingDimensions) {
            this.outputRotationDegrees = (inputFormat.rotationDegrees + 90) % 360;
            int temp = outputWidth;
            outputWidth = outputHeight;
            outputHeight = temp;
        } else {
            this.outputRotationDegrees = inputFormat.rotationDegrees;
        }
        float displayAspectRatio = inputFormat.rotationDegrees % 180 == 0 ? inputFormatAspectRatio : 1.0f / inputFormatAspectRatio;
        Matrix transformationMatrix = new Matrix(transformationRequest.transformationMatrix);
        transformationMatrix.preScale(displayAspectRatio, 1.0f);
        transformationMatrix.postScale(1.0f / displayAspectRatio, 1.0f);
        transformationMatrix.postRotate((float)this.outputRotationDegrees);
        Format requestedOutputFormat = new Format.Builder().setWidth(outputWidth).setHeight(outputHeight).setRotationDegrees(0).setSampleMimeType(transformationRequest.videoMimeType != null ? transformationRequest.videoMimeType : inputFormat.sampleMimeType).build();
        this.encoder = encoderFactory.createForVideoEncoding(requestedOutputFormat, allowedOutputMimeTypes);
        Format actualOutputFormat = this.encoder.getConfigurationFormat();
        fallbackListener.onTransformationRequestFinalized(VideoTranscodingSamplePipeline.createFallbackTransformationRequest(transformationRequest, !swapEncodingDimensions, requestedOutputFormat, actualOutputFormat));
        if (transformationRequest.enableHdrEditing || inputFormat.height != actualOutputFormat.height || inputFormat.width != actualOutputFormat.width || !transformationMatrix.isIdentity()) {
            this.frameEditor = FrameEditor.create(context, actualOutputFormat.width, actualOutputFormat.height, inputFormat.pixelWidthHeightRatio, transformationMatrix, (Surface)Assertions.checkNotNull((Object)this.encoder.getInputSurface()), transformationRequest.enableHdrEditing, debugViewProvider);
        }
        this.decoder = decoderFactory.createForVideoDecoding(inputFormat, this.frameEditor == null ? (Surface)Assertions.checkNotNull((Object)this.encoder.getInputSurface()) : this.frameEditor.getInputSurface());
    }

    @Override
    @Nullable
    public DecoderInputBuffer dequeueInputBuffer() throws TransformationException {
        return this.decoder.maybeDequeueInputBuffer(this.decoderInputBuffer) ? this.decoderInputBuffer : null;
    }

    @Override
    public void queueInputBuffer() throws TransformationException {
        this.decoder.queueInputBuffer(this.decoderInputBuffer);
    }

    @Override
    public boolean processData() throws TransformationException {
        if (this.hasProcessedAllInputData()) {
            return false;
        }
        if (Util.SDK_INT >= 29) {
            return this.processDataV29();
        }
        return this.processDataDefault();
    }

    @RequiresApi(value=29)
    private boolean processDataV29() throws TransformationException {
        if (this.frameEditor != null) {
            while (this.frameEditor.canProcessData()) {
                this.frameEditor.processData();
            }
        }
        while (this.decoder.getOutputBufferInfo() != null) {
            if (this.frameEditor != null) {
                this.frameEditor.registerInputFrame();
            }
            this.decoder.releaseOutputBuffer(true);
        }
        if (this.decoder.isEnded()) {
            this.signalEndOfInputStream();
        }
        return this.frameEditor != null && this.frameEditor.canProcessData();
    }

    private boolean processDataDefault() throws TransformationException {
        boolean decoderHasOutputBuffer;
        if (this.frameEditor != null) {
            if (this.frameEditor.canProcessData()) {
                this.waitingForFrameEditorInput = false;
                this.frameEditor.processData();
                return true;
            }
            if (this.waitingForFrameEditorInput) {
                return false;
            }
        }
        boolean bl = decoderHasOutputBuffer = this.decoder.getOutputBufferInfo() != null;
        if (decoderHasOutputBuffer) {
            if (this.frameEditor != null) {
                this.frameEditor.registerInputFrame();
                this.waitingForFrameEditorInput = true;
            }
            this.decoder.releaseOutputBuffer(true);
        }
        if (this.decoder.isEnded()) {
            this.signalEndOfInputStream();
            return false;
        }
        return decoderHasOutputBuffer && !this.waitingForFrameEditorInput;
    }

    @Override
    @Nullable
    public Format getOutputFormat() throws TransformationException {
        Format format = this.encoder.getOutputFormat();
        return format == null ? null : format.buildUpon().setRotationDegrees(this.outputRotationDegrees).build();
    }

    @Override
    @Nullable
    public DecoderInputBuffer getOutputBuffer() throws TransformationException {
        this.encoderOutputBuffer.data = this.encoder.getOutputBuffer();
        if (this.encoderOutputBuffer.data == null) {
            return null;
        }
        MediaCodec.BufferInfo bufferInfo = (MediaCodec.BufferInfo)Assertions.checkNotNull((Object)this.encoder.getOutputBufferInfo());
        this.encoderOutputBuffer.timeUs = bufferInfo.presentationTimeUs;
        this.encoderOutputBuffer.setFlags(bufferInfo.flags);
        return this.encoderOutputBuffer;
    }

    @Override
    public void releaseOutputBuffer() throws TransformationException {
        this.encoder.releaseOutputBuffer();
    }

    @Override
    public boolean isEnded() {
        return this.encoder.isEnded();
    }

    @Override
    public void release() {
        if (this.frameEditor != null) {
            this.frameEditor.release();
        }
        this.decoder.release();
        this.encoder.release();
    }

    @Pure
    private static TransformationRequest createFallbackTransformationRequest(TransformationRequest transformationRequest, boolean resolutionIsHeight, Format requestedFormat, Format actualFormat) {
        if (Util.areEqual((Object)requestedFormat.sampleMimeType, (Object)actualFormat.sampleMimeType) && (!resolutionIsHeight && requestedFormat.width == actualFormat.width || resolutionIsHeight && requestedFormat.height == actualFormat.height)) {
            return transformationRequest;
        }
        return transformationRequest.buildUpon().setVideoMimeType(actualFormat.sampleMimeType).setResolution(resolutionIsHeight ? requestedFormat.height : requestedFormat.width).build();
    }

    private boolean hasProcessedAllInputData() {
        return this.decoder.isEnded() && (this.frameEditor == null || this.frameEditor.isEnded());
    }

    private void signalEndOfInputStream() throws TransformationException {
        if (this.frameEditor != null) {
            this.frameEditor.signalEndOfInputStream();
        }
        if (this.frameEditor == null || this.frameEditor.isEnded()) {
            this.encoder.signalEndOfInputStream();
        }
    }
}

