/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.graphics.Matrix;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableSet;

public final class TransformationRequest {
    public final Matrix transformationMatrix;
    public final boolean flattenForSlowMotion;
    public final int outputHeight;
    @Nullable
    public final String audioMimeType;
    @Nullable
    public final String videoMimeType;
    public final boolean enableHdrEditing;

    private TransformationRequest(Matrix transformationMatrix, boolean flattenForSlowMotion, int outputHeight, @Nullable String audioMimeType, @Nullable String videoMimeType, boolean enableHdrEditing) {
        this.transformationMatrix = transformationMatrix;
        this.flattenForSlowMotion = flattenForSlowMotion;
        this.outputHeight = outputHeight;
        this.audioMimeType = audioMimeType;
        this.videoMimeType = videoMimeType;
        this.enableHdrEditing = enableHdrEditing;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransformationRequest)) {
            return false;
        }
        TransformationRequest that = (TransformationRequest)o;
        return this.transformationMatrix.equals((Object)that.transformationMatrix) && this.flattenForSlowMotion == that.flattenForSlowMotion && this.outputHeight == that.outputHeight && Util.areEqual((Object)this.audioMimeType, (Object)that.audioMimeType) && Util.areEqual((Object)this.videoMimeType, (Object)that.videoMimeType) && this.enableHdrEditing == that.enableHdrEditing;
    }

    public int hashCode() {
        int result = this.transformationMatrix.hashCode();
        result = 31 * result + (this.flattenForSlowMotion ? 1 : 0);
        result = 31 * result + this.outputHeight;
        result = 31 * result + (this.audioMimeType != null ? this.audioMimeType.hashCode() : 0);
        result = 31 * result + (this.videoMimeType != null ? this.videoMimeType.hashCode() : 0);
        result = 31 * result + (this.enableHdrEditing ? 1 : 0);
        return result;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public static final class Builder {
        private static final ImmutableSet<Integer> SUPPORTED_OUTPUT_HEIGHTS = ImmutableSet.of((Object)144, (Object)240, (Object)360, (Object)480, (Object)720, (Object)1080, (Object[])new Integer[]{1440, 2160});
        private Matrix transformationMatrix;
        private boolean flattenForSlowMotion;
        private int outputHeight;
        @Nullable
        private String audioMimeType;
        @Nullable
        private String videoMimeType;
        private boolean enableHdrEditing;

        public Builder() {
            this.transformationMatrix = new Matrix();
            this.outputHeight = -1;
        }

        private Builder(TransformationRequest transformationRequest) {
            this.transformationMatrix = new Matrix(transformationRequest.transformationMatrix);
            this.flattenForSlowMotion = transformationRequest.flattenForSlowMotion;
            this.outputHeight = transformationRequest.outputHeight;
            this.audioMimeType = transformationRequest.audioMimeType;
            this.videoMimeType = transformationRequest.videoMimeType;
            this.enableHdrEditing = transformationRequest.enableHdrEditing;
        }

        public Builder setTransformationMatrix(Matrix transformationMatrix) {
            this.transformationMatrix = new Matrix(transformationMatrix);
            return this;
        }

        public Builder setFlattenForSlowMotion(boolean flattenForSlowMotion) {
            this.flattenForSlowMotion = flattenForSlowMotion;
            return this;
        }

        public Builder setResolution(int outputHeight) {
            Assertions.checkArgument((outputHeight == -1 || SUPPORTED_OUTPUT_HEIGHTS.contains((Object)outputHeight) ? 1 : 0) != 0, (Object)new StringBuilder(37).append("Unsupported outputHeight: ").append(outputHeight).toString());
            this.outputHeight = outputHeight;
            return this;
        }

        public Builder setVideoMimeType(@Nullable String videoMimeType) {
            String string = String.valueOf(videoMimeType);
            Assertions.checkArgument((videoMimeType == null || MimeTypes.isVideo((String)videoMimeType) ? 1 : 0) != 0, (Object)(string.length() != 0 ? "Not a video MIME type: ".concat(string) : new String("Not a video MIME type: ")));
            this.videoMimeType = videoMimeType;
            return this;
        }

        public Builder setAudioMimeType(@Nullable String audioMimeType) {
            String string = String.valueOf(audioMimeType);
            Assertions.checkArgument((audioMimeType == null || MimeTypes.isAudio((String)audioMimeType) ? 1 : 0) != 0, (Object)(string.length() != 0 ? "Not an audio MIME type: ".concat(string) : new String("Not an audio MIME type: ")));
            this.audioMimeType = audioMimeType;
            return this;
        }

        public Builder experimental_setEnableHdrEditing(boolean enableHdrEditing) {
            this.enableHdrEditing = enableHdrEditing;
            return this;
        }

        public TransformationRequest build() {
            return new TransformationRequest(this.transformationMatrix, this.flattenForSlowMotion, this.outputHeight, this.audioMimeType, this.videoMimeType, this.enableHdrEditing);
        }
    }
}

