/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.view.Surface;
import android.view.SurfaceView;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.transformer.Transformer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.GlUtil;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

final class FrameEditor {
    private static final String VERTEX_SHADER_TRANSFORMATION_PATH = "shaders/vertex_shader_transformation.glsl";
    private static final String FRAGMENT_SHADER_COPY_EXTERNAL_PATH = "shaders/fragment_shader_copy_external.glsl";
    private static final String VERTEX_SHADER_TRANSFORMATION_ES3_PATH = "shaders/vertex_shader_transformation_es3.glsl";
    private static final String FRAGMENT_SHADER_COPY_EXTERNAL_YUV_ES3_PATH = "shaders/fragment_shader_copy_external_yuv_es3.glsl";
    private static final float[] MATRIX_YUV_TO_BT2020_COLOR_TRANSFORM;
    private final float[] textureTransformMatrix;
    private final EGLDisplay eglDisplay;
    private final EGLContext eglContext;
    private final EGLSurface eglSurface;
    private final int textureId;
    private final AtomicInteger pendingInputFrameCount;
    private final AtomicInteger availableInputFrameCount;
    private final SurfaceTexture inputSurfaceTexture;
    private final Surface inputSurface;
    private final GlUtil.Program glProgram;
    private final int outputWidth;
    private final int outputHeight;
    @Nullable
    private final EGLSurface debugPreviewEglSurface;
    private final int debugPreviewWidth;
    private final int debugPreviewHeight;
    private boolean inputStreamEnded;

    public static FrameEditor create(Context context, int outputWidth, int outputHeight, float pixelWidthHeightRatio, android.graphics.Matrix transformationMatrix, Surface outputSurface, boolean enableExperimentalHdrEditing, Transformer.DebugViewProvider debugViewProvider) throws TransformationException {
        int debugPreviewHeight;
        int debugPreviewWidth;
        GlUtil.Program glProgram;
        int textureId;
        EGLSurface eglSurface;
        EGLContext eglContext;
        EGLDisplay eglDisplay;
        if (pixelWidthHeightRatio != 1.0f) {
            throw TransformationException.createForFrameEditor(new UnsupportedOperationException(new StringBuilder(133).append("Transformer's frame editor currently does not support frame edits on non-square pixels. The pixelWidthHeightRatio is: ").append(pixelWidthHeightRatio).toString()), 5001);
        }
        SurfaceView debugSurfaceView = debugViewProvider.getDebugPreviewSurfaceView(outputWidth, outputHeight);
        EGLSurface debugPreviewEglSurface = null;
        try {
            eglDisplay = GlUtil.createEglDisplay();
            if (enableExperimentalHdrEditing) {
                eglContext = GlUtil.createEglContextEs3Rgba1010102((EGLDisplay)eglDisplay);
                eglSurface = GlUtil.getEglSurfaceBt2020Pq((EGLDisplay)eglDisplay, (Object)outputSurface);
                if (debugSurfaceView != null) {
                    debugPreviewEglSurface = GlUtil.getEglSurfaceBt2020Pq((EGLDisplay)eglDisplay, (Object)Assertions.checkNotNull((Object)debugSurfaceView.getHolder()));
                }
            } else {
                eglContext = GlUtil.createEglContext((EGLDisplay)eglDisplay);
                eglSurface = GlUtil.getEglSurface((EGLDisplay)eglDisplay, (Object)outputSurface);
                if (debugSurfaceView != null) {
                    debugPreviewEglSurface = GlUtil.getEglSurface((EGLDisplay)eglDisplay, (Object)Assertions.checkNotNull((Object)debugSurfaceView.getHolder()));
                }
            }
            GlUtil.focusSurface((EGLDisplay)eglDisplay, (EGLContext)eglContext, (EGLSurface)eglSurface, (int)outputWidth, (int)outputHeight);
            textureId = GlUtil.createExternalTexture();
            glProgram = FrameEditor.configureGlProgram(context, transformationMatrix, textureId, enableExperimentalHdrEditing);
        }
        catch (GlUtil.GlException | IOException e) {
            throw TransformationException.createForFrameEditor(e, 5001);
        }
        if (debugSurfaceView != null) {
            debugPreviewWidth = debugSurfaceView.getWidth();
            debugPreviewHeight = debugSurfaceView.getHeight();
        } else {
            debugPreviewWidth = -1;
            debugPreviewHeight = -1;
        }
        return new FrameEditor(eglDisplay, eglContext, eglSurface, textureId, glProgram, outputWidth, outputHeight, debugPreviewEglSurface, debugPreviewWidth, debugPreviewHeight);
    }

    private static GlUtil.Program configureGlProgram(Context context, android.graphics.Matrix transformationMatrix, int textureId, boolean enableExperimentalHdrEditing) throws IOException {
        String vertexShaderFilePath = enableExperimentalHdrEditing ? VERTEX_SHADER_TRANSFORMATION_ES3_PATH : VERTEX_SHADER_TRANSFORMATION_PATH;
        String fragmentShaderFilePath = enableExperimentalHdrEditing ? FRAGMENT_SHADER_COPY_EXTERNAL_YUV_ES3_PATH : FRAGMENT_SHADER_COPY_EXTERNAL_PATH;
        GlUtil.Program glProgram = new GlUtil.Program(context, vertexShaderFilePath, fragmentShaderFilePath);
        glProgram.setBufferAttribute("aFramePosition", GlUtil.getNormalizedCoordinateBounds(), 4);
        glProgram.setBufferAttribute("aTexCoords", GlUtil.getTextureCoordinateBounds(), 4);
        glProgram.setSamplerTexIdUniform("uTexSampler", textureId, 0);
        if (enableExperimentalHdrEditing) {
            glProgram.setFloatsUniform("uColorTransform", MATRIX_YUV_TO_BT2020_COLOR_TRANSFORM);
        }
        float[] transformationMatrixArray = FrameEditor.getGlMatrixArray(transformationMatrix);
        glProgram.setFloatsUniform("uTransformationMatrix", transformationMatrixArray);
        return glProgram;
    }

    private static float[] getGlMatrixArray(android.graphics.Matrix matrix) {
        float[] matrix3x3Array = new float[9];
        matrix.getValues(matrix3x3Array);
        float[] matrix4x4Array = FrameEditor.getMatrix4x4Array(matrix3x3Array);
        float[] transposedMatrix4x4Array = new float[16];
        Matrix.transposeM((float[])transposedMatrix4x4Array, (int)0, (float[])matrix4x4Array, (int)0);
        return transposedMatrix4x4Array;
    }

    private static float[] getMatrix4x4Array(float[] matrix3x3Array) {
        float[] matrix4x4Array = new float[16];
        matrix4x4Array[10] = 1.0f;
        for (int inputRow = 0; inputRow < 3; ++inputRow) {
            for (int inputColumn = 0; inputColumn < 3; ++inputColumn) {
                int outputRow = inputRow == 2 ? 3 : inputRow;
                int outputColumn = inputColumn == 2 ? 3 : inputColumn;
                matrix4x4Array[outputRow * 4 + outputColumn] = matrix3x3Array[inputRow * 3 + inputColumn];
            }
        }
        return matrix4x4Array;
    }

    private FrameEditor(EGLDisplay eglDisplay, EGLContext eglContext, EGLSurface eglSurface, int textureId, GlUtil.Program glProgram, int outputWidth, int outputHeight, @Nullable EGLSurface debugPreviewEglSurface, int debugPreviewWidth, int debugPreviewHeight) {
        this.eglDisplay = eglDisplay;
        this.eglContext = eglContext;
        this.eglSurface = eglSurface;
        this.textureId = textureId;
        this.glProgram = glProgram;
        this.pendingInputFrameCount = new AtomicInteger();
        this.availableInputFrameCount = new AtomicInteger();
        this.outputWidth = outputWidth;
        this.outputHeight = outputHeight;
        this.debugPreviewEglSurface = debugPreviewEglSurface;
        this.debugPreviewWidth = debugPreviewWidth;
        this.debugPreviewHeight = debugPreviewHeight;
        this.textureTransformMatrix = new float[16];
        this.inputSurfaceTexture = new SurfaceTexture(textureId);
        this.inputSurfaceTexture.setOnFrameAvailableListener(surfaceTexture -> {
            Assertions.checkState((this.pendingInputFrameCount.getAndDecrement() > 0 ? 1 : 0) != 0);
            this.availableInputFrameCount.incrementAndGet();
        });
        this.inputSurface = new Surface(this.inputSurfaceTexture);
    }

    public Surface getInputSurface() {
        return this.inputSurface;
    }

    public void registerInputFrame() {
        Assertions.checkState((!this.inputStreamEnded ? 1 : 0) != 0);
        this.pendingInputFrameCount.incrementAndGet();
    }

    public boolean canProcessData() {
        return this.availableInputFrameCount.get() > 0;
    }

    public void processData() throws TransformationException {
        Assertions.checkState((boolean)this.canProcessData());
        try {
            this.inputSurfaceTexture.updateTexImage();
            this.inputSurfaceTexture.getTransformMatrix(this.textureTransformMatrix);
            this.glProgram.setFloatsUniform("uTexTransform", this.textureTransformMatrix);
            this.glProgram.bindAttributesAndUniforms();
            this.focusAndDrawQuad(this.eglSurface, this.outputWidth, this.outputHeight);
            long presentationTimeNs = this.inputSurfaceTexture.getTimestamp();
            EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (long)presentationTimeNs);
            EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
            if (this.debugPreviewEglSurface != null) {
                this.focusAndDrawQuad(this.debugPreviewEglSurface, this.debugPreviewWidth, this.debugPreviewHeight);
                EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.debugPreviewEglSurface);
            }
        }
        catch (GlUtil.GlException e) {
            throw TransformationException.createForFrameEditor(e, 5002);
        }
        this.availableInputFrameCount.decrementAndGet();
    }

    public void release() {
        this.glProgram.delete();
        GlUtil.deleteTexture((int)this.textureId);
        GlUtil.destroyEglContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
        this.inputSurfaceTexture.release();
        this.inputSurface.release();
    }

    private void focusAndDrawQuad(EGLSurface eglSurface, int width, int height) {
        GlUtil.focusSurface((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext, (EGLSurface)eglSurface, (int)width, (int)height);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }

    public boolean isEnded() {
        return this.inputStreamEnded && this.pendingInputFrameCount.get() == 0 && this.availableInputFrameCount.get() == 0;
    }

    public void signalEndOfInputStream() {
        this.inputStreamEnded = true;
    }

    static {
        GlUtil.glAssertionsEnabled = true;
        MATRIX_YUV_TO_BT2020_COLOR_TRANSFORM = new float[]{1.168f, 1.168f, 1.168f, 0.0f, -0.188f, 2.148f, 1.683f, -0.652f, 0.0f};
    }
}

