/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public final class EncoderUtil {
    private static final List<MediaCodecInfo> encoders = new ArrayList<MediaCodecInfo>();

    public static ImmutableList<MediaCodecInfo> getSupportedEncoders(String mimeType) {
        EncoderUtil.maybePopulateEncoderInfos();
        ImmutableList.Builder availableEncoders = new ImmutableList.Builder();
        for (int i = 0; i < encoders.size(); ++i) {
            String[] supportedMimeTypes;
            MediaCodecInfo encoderInfo = encoders.get(i);
            for (String supportedMimeType : supportedMimeTypes = encoderInfo.getSupportedTypes()) {
                if (!Ascii.equalsIgnoreCase((CharSequence)supportedMimeType, (CharSequence)mimeType)) continue;
                availableEncoders.add((Object)encoderInfo);
            }
        }
        return availableEncoders.build();
    }

    @Nullable
    public static Pair<Integer, Integer> getClosestSupportedResolution(MediaCodecInfo encoderInfo, String mimeType, int width, int height) {
        int adjustedWidth;
        MediaCodecInfo.VideoCapabilities videoEncoderCapabilities = encoderInfo.getCapabilitiesForType(mimeType).getVideoCapabilities();
        if (videoEncoderCapabilities.isSizeSupported(width, height)) {
            return Pair.create((Object)width, (Object)height);
        }
        int adjustedHeight = (Integer)videoEncoderCapabilities.getSupportedHeights().clamp((Comparable)Integer.valueOf(height));
        if (adjustedHeight != height) {
            width = (int)Math.round((double)width * (double)adjustedHeight / (double)height);
            height = adjustedHeight;
        }
        if ((adjustedWidth = ((Integer)videoEncoderCapabilities.getSupportedWidths().clamp((Comparable)Integer.valueOf(width))).intValue()) != width) {
            height = (int)Math.round((double)height * (double)adjustedWidth / (double)width);
            width = adjustedWidth;
        }
        return videoEncoderCapabilities.isSizeSupported(width = EncoderUtil.alignResolution(width, videoEncoderCapabilities.getWidthAlignment()), height = EncoderUtil.alignResolution(height, videoEncoderCapabilities.getHeightAlignment())) ? Pair.create((Object)width, (Object)height) : null;
    }

    public static boolean isProfileLevelSupported(MediaCodecInfo encoderInfo, String mimeType, int profile, int level) {
        MediaCodecInfo.CodecProfileLevel[] profileLevels;
        for (MediaCodecInfo.CodecProfileLevel profileLevel : profileLevels = encoderInfo.getCapabilitiesForType((String)mimeType).profileLevels) {
            if (profileLevel.profile != profile || profileLevel.level != level) continue;
            return true;
        }
        return false;
    }

    public static int getClosestSupportedBitrate(MediaCodecInfo encoderInfo, String mimeType, int bitrate) {
        return (Integer)encoderInfo.getCapabilitiesForType(mimeType).getVideoCapabilities().getBitrateRange().clamp((Comparable)Integer.valueOf(bitrate));
    }

    private static int alignResolution(int size, int alignment) {
        return alignment * Math.round((float)size / (float)alignment);
    }

    private static synchronized void maybePopulateEncoderInfos() {
        if (encoders.isEmpty()) {
            MediaCodecInfo[] allCodecInfos;
            MediaCodecList mediaCodecList = new MediaCodecList(1);
            for (MediaCodecInfo mediaCodecInfo : allCodecInfos = mediaCodecList.getCodecInfos()) {
                if (!mediaCodecInfo.isEncoder()) continue;
                encoders.add(mediaCodecInfo);
            }
        }
    }

    private EncoderUtil() {
    }
}

