/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Pair;
import android.view.Surface;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.mediacodec.MediaCodecUtil;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.EncoderUtil;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MediaFormatUtil;
import com.google.android.exoplayer2.util.TraceUtil;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.List;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

final class DefaultCodecFactory
implements Codec.DecoderFactory,
Codec.EncoderFactory {
    private static final String DEFAULT_FALLBACK_MIME_TYPE = "video/avc";
    private static final int DEFAULT_COLOR_FORMAT = 2130708361;
    private static final int DEFAULT_FRAME_RATE = 60;
    private static final int DEFAULT_I_FRAME_INTERVAL_SECS = 1;

    DefaultCodecFactory() {
    }

    @Override
    public Codec createForAudioDecoding(Format format) throws TransformationException {
        MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (int)format.sampleRate, (int)format.channelCount);
        MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"max-input-size", (int)format.maxInputSize);
        MediaFormatUtil.setCsdBuffers((MediaFormat)mediaFormat, (List)format.initializationData);
        return DefaultCodecFactory.createCodec(format, mediaFormat, false, true, null);
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    public Codec createForVideoDecoding(Format format, Surface outputSurface) throws TransformationException {
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (int)format.width, (int)format.height);
        MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"rotation-degrees", (int)format.rotationDegrees);
        MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"max-input-size", (int)format.maxInputSize);
        MediaFormatUtil.setCsdBuffers((MediaFormat)mediaFormat, (List)format.initializationData);
        if (Util.SDK_INT >= 29) {
            mediaFormat.setInteger("allow-frame-drop", 0);
        }
        return DefaultCodecFactory.createCodec(format, mediaFormat, true, true, outputSurface);
    }

    @Override
    public Codec createForAudioEncoding(Format format, List<String> allowedMimeTypes) throws TransformationException {
        Assertions.checkArgument((!allowedMimeTypes.isEmpty() ? 1 : 0) != 0);
        if (!allowedMimeTypes.contains(format.sampleMimeType)) {
            format = format.buildUpon().setSampleMimeType(allowedMimeTypes.get(0)).build();
        }
        MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (int)format.sampleRate, (int)format.channelCount);
        mediaFormat.setInteger("bitrate", format.bitrate);
        return DefaultCodecFactory.createCodec(format, mediaFormat, false, false, null);
    }

    @Override
    public Codec createForVideoEncoding(Format format, List<String> allowedMimeTypes) throws TransformationException {
        Assertions.checkArgument((format.width != -1 ? 1 : 0) != 0);
        Assertions.checkArgument((format.height != -1 ? 1 : 0) != 0);
        Assertions.checkArgument((format.height <= format.width ? 1 : 0) != 0);
        Assertions.checkArgument((format.rotationDegrees == 0 ? 1 : 0) != 0);
        Assertions.checkNotNull((Object)format.sampleMimeType);
        Assertions.checkArgument((!allowedMimeTypes.isEmpty() ? 1 : 0) != 0);
        format = DefaultCodecFactory.getVideoEncoderSupportedFormat(format, allowedMimeTypes);
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (int)format.width, (int)format.height);
        mediaFormat.setFloat("frame-rate", format.frameRate);
        mediaFormat.setInteger("bitrate", format.averageBitrate);
        Pair codecProfileAndLevel = MediaCodecUtil.getCodecProfileAndLevel((Format)format);
        if (codecProfileAndLevel != null) {
            mediaFormat.setInteger("profile", ((Integer)codecProfileAndLevel.first).intValue());
            if (Util.SDK_INT >= 23) {
                mediaFormat.setInteger("level", ((Integer)codecProfileAndLevel.second).intValue());
            }
        }
        mediaFormat.setInteger("color-format", 2130708361);
        mediaFormat.setInteger("i-frame-interval", 1);
        return DefaultCodecFactory.createCodec(format, mediaFormat, true, false, null);
    }

    @RequiresNonNull(value={"#1.sampleMimeType"})
    private static Codec createCodec(Format format, MediaFormat mediaFormat, boolean isVideo, boolean isDecoder, @Nullable Surface outputSurface) throws TransformationException {
        MediaCodec mediaCodec = null;
        Surface inputSurface = null;
        try {
            mediaCodec = isDecoder ? MediaCodec.createDecoderByType((String)format.sampleMimeType) : MediaCodec.createEncoderByType((String)format.sampleMimeType);
            DefaultCodecFactory.configureCodec(mediaCodec, mediaFormat, isDecoder, outputSurface);
            if (isVideo && !isDecoder) {
                inputSurface = mediaCodec.createInputSurface();
            }
            DefaultCodecFactory.startCodec(mediaCodec);
        }
        catch (Exception e) {
            if (inputSurface != null) {
                inputSurface.release();
            }
            String mediaCodecName = null;
            if (mediaCodec != null) {
                mediaCodecName = mediaCodec.getName();
                mediaCodec.release();
            }
            throw DefaultCodecFactory.createTransformationException(e, format, isVideo, isDecoder, mediaCodecName);
        }
        return new Codec(mediaCodec, format, inputSurface);
    }

    private static void configureCodec(MediaCodec codec, MediaFormat mediaFormat, boolean isDecoder, @Nullable Surface outputSurface) {
        TraceUtil.beginSection((String)"configureCodec");
        codec.configure(mediaFormat, outputSurface, null, isDecoder ? 0 : 1);
        TraceUtil.endSection();
    }

    private static void startCodec(MediaCodec codec) {
        TraceUtil.beginSection((String)"startCodec");
        codec.start();
        TraceUtil.endSection();
    }

    @RequiresNonNull(value={"#1.sampleMimeType"})
    private static Format getVideoEncoderSupportedFormat(Format requestedFormat, List<String> allowedMimeTypes) throws TransformationException {
        String mimeType = requestedFormat.sampleMimeType;
        Format.Builder formatBuilder = requestedFormat.buildUpon();
        if (!allowedMimeTypes.contains(mimeType) || EncoderUtil.getSupportedEncoders(mimeType).isEmpty()) {
            String string = mimeType = allowedMimeTypes.contains(DEFAULT_FALLBACK_MIME_TYPE) ? DEFAULT_FALLBACK_MIME_TYPE : allowedMimeTypes.get(0);
            if (EncoderUtil.getSupportedEncoders(mimeType).isEmpty()) {
                String string2 = String.valueOf(requestedFormat.sampleMimeType);
                throw DefaultCodecFactory.createTransformationException(new IllegalArgumentException(string2.length() != 0 ? "No encoder is found for requested MIME type ".concat(string2) : new String("No encoder is found for requested MIME type ")), requestedFormat, true, false, null);
            }
        }
        formatBuilder.setSampleMimeType(mimeType);
        MediaCodecInfo encoderInfo = (MediaCodecInfo)EncoderUtil.getSupportedEncoders(mimeType).get(0);
        int width = requestedFormat.width;
        int height = requestedFormat.height;
        Pair<Integer, Integer> encoderSupportedResolution = EncoderUtil.getClosestSupportedResolution(encoderInfo, mimeType, width, height);
        if (encoderSupportedResolution == null) {
            int n = width;
            int n2 = height;
            throw DefaultCodecFactory.createTransformationException(new IllegalArgumentException(new StringBuilder(72).append("Cannot find fallback resolution for resolution ").append(n).append(" x ").append(n2).toString()), requestedFormat, true, false, null);
        }
        width = (Integer)encoderSupportedResolution.first;
        height = (Integer)encoderSupportedResolution.second;
        formatBuilder.setWidth(width).setHeight(height);
        float frameRate = requestedFormat.frameRate != -1.0f ? requestedFormat.frameRate : 60.0f;
        int bitrate = EncoderUtil.getClosestSupportedBitrate(encoderInfo, mimeType, requestedFormat.averageBitrate != -1 ? requestedFormat.averageBitrate : DefaultCodecFactory.getSuggestedBitrate(width, height, frameRate));
        formatBuilder.setFrameRate(frameRate).setAverageBitrate(bitrate);
        Pair profileLevel = MediaCodecUtil.getCodecProfileAndLevel((Format)requestedFormat);
        if (profileLevel == null || !requestedFormat.sampleMimeType.equals(mimeType) || !EncoderUtil.isProfileLevelSupported(encoderInfo, mimeType, (Integer)profileLevel.first, (Integer)profileLevel.second)) {
            formatBuilder.setCodecs(null);
        }
        return formatBuilder.build();
    }

    private static int getSuggestedBitrate(int width, int height, float frameRate) {
        return (int)((double)((float)(width * height) * frameRate) * 0.1);
    }

    private static TransformationException createTransformationException(Exception cause, Format format, boolean isVideo, boolean isDecoder, @Nullable String mediaCodecName) {
        String componentName;
        String string = String.valueOf(isVideo ? "Video" : "Audio");
        String string2 = String.valueOf(isDecoder ? "Decoder" : "Encoder");
        String string3 = componentName = string2.length() != 0 ? string.concat(string2) : new String(string);
        if (cause instanceof IOException || cause instanceof MediaCodec.CodecException) {
            return TransformationException.createForCodec(cause, componentName, format, mediaCodecName, isDecoder ? 3001 : 4001);
        }
        if (cause instanceof IllegalArgumentException) {
            return TransformationException.createForCodec(cause, componentName, format, mediaCodecName, isDecoder ? 3003 : 4003);
        }
        return TransformationException.createForUnexpected(cause);
    }
}

