/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.DefaultCodecFactory;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class Codec {
    private static final int MEDIA_CODEC_PCM_ENCODING = 2;
    private final MediaCodec.BufferInfo outputBufferInfo;
    private final MediaCodec mediaCodec;
    private final Format configurationFormat;
    @Nullable
    private final Surface inputSurface;
    private @MonotonicNonNull Format outputFormat;
    @Nullable
    private ByteBuffer outputBuffer;
    private int inputBufferIndex;
    private int outputBufferIndex;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;

    public Codec(MediaCodec mediaCodec, Format configurationFormat, @Nullable Surface inputSurface) {
        this.mediaCodec = mediaCodec;
        this.configurationFormat = configurationFormat;
        this.inputSurface = inputSurface;
        this.outputBufferInfo = new MediaCodec.BufferInfo();
        this.inputBufferIndex = -1;
        this.outputBufferIndex = -1;
    }

    public Format getConfigurationFormat() {
        return this.configurationFormat;
    }

    @Nullable
    public Surface getInputSurface() {
        return this.inputSurface;
    }

    @EnsuresNonNullIf(expression={"#1.data"}, result=true)
    public boolean maybeDequeueInputBuffer(DecoderInputBuffer inputBuffer) throws TransformationException {
        if (this.inputStreamEnded) {
            return false;
        }
        if (this.inputBufferIndex < 0) {
            try {
                this.inputBufferIndex = this.mediaCodec.dequeueInputBuffer(0L);
            }
            catch (RuntimeException e) {
                throw this.createTransformationException(e);
            }
            if (this.inputBufferIndex < 0) {
                return false;
            }
            try {
                inputBuffer.data = this.mediaCodec.getInputBuffer(this.inputBufferIndex);
            }
            catch (RuntimeException e) {
                throw this.createTransformationException(e);
            }
            inputBuffer.clear();
        }
        Assertions.checkNotNull((Object)inputBuffer.data);
        return true;
    }

    public void queueInputBuffer(DecoderInputBuffer inputBuffer) throws TransformationException {
        Assertions.checkState((!this.inputStreamEnded ? 1 : 0) != 0, (Object)"Input buffer can not be queued after the input stream has ended.");
        int offset = 0;
        int size = 0;
        if (inputBuffer.data != null && inputBuffer.data.hasRemaining()) {
            offset = inputBuffer.data.position();
            size = inputBuffer.data.remaining();
        }
        int flags = 0;
        if (inputBuffer.isEndOfStream()) {
            this.inputStreamEnded = true;
            flags = 4;
        }
        try {
            this.mediaCodec.queueInputBuffer(this.inputBufferIndex, offset, size, inputBuffer.timeUs, flags);
        }
        catch (RuntimeException e) {
            throw this.createTransformationException(e);
        }
        this.inputBufferIndex = -1;
        inputBuffer.data = null;
    }

    public void signalEndOfInputStream() throws TransformationException {
        Assertions.checkState((this.mediaCodec.getCodecInfo().isEncoder() && this.inputSurface != null ? 1 : 0) != 0);
        try {
            this.mediaCodec.signalEndOfInputStream();
        }
        catch (RuntimeException e) {
            throw this.createTransformationException(e);
        }
    }

    @Nullable
    public Format getOutputFormat() throws TransformationException {
        this.maybeDequeueOutputBuffer(false);
        return this.outputFormat;
    }

    @Nullable
    public ByteBuffer getOutputBuffer() throws TransformationException {
        return this.maybeDequeueOutputBuffer(true) ? this.outputBuffer : null;
    }

    @Nullable
    public MediaCodec.BufferInfo getOutputBufferInfo() throws TransformationException {
        return this.maybeDequeueOutputBuffer(false) ? this.outputBufferInfo : null;
    }

    public void releaseOutputBuffer() throws TransformationException {
        this.releaseOutputBuffer(false);
    }

    public void releaseOutputBuffer(boolean render) throws TransformationException {
        this.outputBuffer = null;
        try {
            if (render) {
                this.mediaCodec.releaseOutputBuffer(this.outputBufferIndex, ((MediaCodec.BufferInfo)Assertions.checkStateNotNull((Object)this.outputBufferInfo)).presentationTimeUs * 1000L);
            } else {
                this.mediaCodec.releaseOutputBuffer(this.outputBufferIndex, false);
            }
        }
        catch (RuntimeException e) {
            throw this.createTransformationException(e);
        }
        this.outputBufferIndex = -1;
    }

    public boolean isEnded() {
        return this.outputStreamEnded && this.outputBufferIndex == -1;
    }

    public void release() {
        this.outputBuffer = null;
        if (this.inputSurface != null) {
            this.inputSurface.release();
        }
        this.mediaCodec.release();
    }

    private boolean maybeDequeueOutputBuffer(boolean setOutputBuffer) throws TransformationException {
        if (this.outputBufferIndex >= 0) {
            return true;
        }
        if (this.outputStreamEnded) {
            return false;
        }
        try {
            this.outputBufferIndex = this.mediaCodec.dequeueOutputBuffer(this.outputBufferInfo, 0L);
        }
        catch (RuntimeException e) {
            throw this.createTransformationException(e);
        }
        if (this.outputBufferIndex < 0) {
            if (this.outputBufferIndex == -2) {
                this.outputFormat = Codec.getFormat(this.mediaCodec.getOutputFormat());
            }
            return false;
        }
        if ((this.outputBufferInfo.flags & 4) != 0) {
            this.outputStreamEnded = true;
            if (this.outputBufferInfo.size == 0) {
                this.releaseOutputBuffer();
                return false;
            }
        }
        if ((this.outputBufferInfo.flags & 2) != 0) {
            this.releaseOutputBuffer();
            return false;
        }
        if (setOutputBuffer) {
            try {
                this.outputBuffer = (ByteBuffer)Assertions.checkNotNull((Object)this.mediaCodec.getOutputBuffer(this.outputBufferIndex));
            }
            catch (RuntimeException e) {
                throw this.createTransformationException(e);
            }
            this.outputBuffer.position(this.outputBufferInfo.offset);
            this.outputBuffer.limit(this.outputBufferInfo.offset + this.outputBufferInfo.size);
        }
        return true;
    }

    private TransformationException createTransformationException(Exception cause) {
        boolean isEncoder = this.mediaCodec.getCodecInfo().isEncoder();
        boolean isVideo = MimeTypes.isVideo((String)this.configurationFormat.sampleMimeType);
        String string = String.valueOf(isVideo ? "Video" : "Audio");
        String string2 = String.valueOf(isEncoder ? "Encoder" : "Decoder");
        String componentName = string2.length() != 0 ? string.concat(string2) : new String(string);
        return TransformationException.createForCodec(cause, componentName, this.configurationFormat, this.mediaCodec.getName(), isEncoder ? 4002 : 3002);
    }

    private static Format getFormat(MediaFormat mediaFormat) {
        ImmutableList.Builder csdBuffers = new ImmutableList.Builder();
        int csdIndex = 0;
        while (true) {
            int n = csdIndex++;
            ByteBuffer csdByteBuffer = mediaFormat.getByteBuffer(new StringBuilder(15).append("csd-").append(n).toString());
            if (csdByteBuffer == null) break;
            byte[] csdBufferData = new byte[csdByteBuffer.remaining()];
            csdByteBuffer.get(csdBufferData);
            csdBuffers.add((Object)csdBufferData);
        }
        String mimeType = mediaFormat.getString("mime");
        Format.Builder formatBuilder = new Format.Builder().setSampleMimeType(mediaFormat.getString("mime")).setInitializationData((List)csdBuffers.build());
        if (MimeTypes.isVideo((String)mimeType)) {
            formatBuilder.setWidth(mediaFormat.getInteger("width")).setHeight(mediaFormat.getInteger("height"));
        } else if (MimeTypes.isAudio((String)mimeType)) {
            formatBuilder.setChannelCount(mediaFormat.getInteger("channel-count")).setSampleRate(mediaFormat.getInteger("sample-rate")).setPcmEncoding(2);
        }
        return formatBuilder.build();
    }

    public static interface EncoderFactory {
        public static final EncoderFactory DEFAULT = new DefaultCodecFactory();

        public Codec createForAudioEncoding(Format var1, List<String> var2) throws TransformationException;

        public Codec createForVideoEncoding(Format var1, List<String> var2) throws TransformationException;
    }

    public static interface DecoderFactory {
        public static final DecoderFactory DEFAULT = new DefaultCodecFactory();

        public Codec createForAudioDecoding(Format var1) throws TransformationException;

        public Codec createForVideoDecoding(Format var1, Surface var2) throws TransformationException;
    }
}

