/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.media.MediaCodec;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.SonicAudioProcessor;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.SamplePipeline;
import com.google.android.exoplayer2.transformer.SegmentSpeedProvider;
import com.google.android.exoplayer2.transformer.SpeedProvider;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.util.List;
import org.checkerframework.dataflow.qual.Pure;

final class AudioTranscodingSamplePipeline
implements SamplePipeline {
    private static final int DEFAULT_ENCODER_BITRATE = 131072;
    private final Codec decoder;
    private final DecoderInputBuffer decoderInputBuffer = new DecoderInputBuffer(0);
    private final SonicAudioProcessor sonicAudioProcessor;
    private final SpeedProvider speedProvider;
    private final boolean flattenForSlowMotion;
    private final Codec encoder;
    private final AudioProcessor.AudioFormat encoderInputAudioFormat;
    private final DecoderInputBuffer encoderInputBuffer = new DecoderInputBuffer(0);
    private final DecoderInputBuffer encoderOutputBuffer = new DecoderInputBuffer(0);
    private long nextEncoderInputBufferTimeUs;
    private long encoderBufferDurationRemainder;
    private ByteBuffer sonicOutputBuffer;
    private boolean drainingSonicForSpeedChange;
    private float currentSpeed;

    public AudioTranscodingSamplePipeline(Format inputFormat, TransformationRequest transformationRequest, Codec.DecoderFactory decoderFactory, Codec.EncoderFactory encoderFactory, List<String> allowedOutputMimeTypes, FallbackListener fallbackListener) throws TransformationException {
        this.decoder = decoderFactory.createForAudioDecoding(inputFormat);
        this.flattenForSlowMotion = transformationRequest.flattenForSlowMotion;
        this.sonicAudioProcessor = new SonicAudioProcessor();
        this.sonicOutputBuffer = AudioProcessor.EMPTY_BUFFER;
        this.speedProvider = new SegmentSpeedProvider(inputFormat);
        this.currentSpeed = this.speedProvider.getSpeed(0L);
        AudioProcessor.AudioFormat encoderInputAudioFormat = new AudioProcessor.AudioFormat(inputFormat.sampleRate, inputFormat.channelCount, 2);
        if (this.flattenForSlowMotion) {
            try {
                encoderInputAudioFormat = this.sonicAudioProcessor.configure(encoderInputAudioFormat);
            }
            catch (AudioProcessor.UnhandledAudioFormatException impossible) {
                throw new IllegalStateException(impossible);
            }
            this.sonicAudioProcessor.setSpeed(this.currentSpeed);
            this.sonicAudioProcessor.setPitch(this.currentSpeed);
            this.sonicAudioProcessor.flush();
        }
        this.encoderInputAudioFormat = encoderInputAudioFormat;
        Format requestedOutputFormat = new Format.Builder().setSampleMimeType(transformationRequest.audioMimeType == null ? inputFormat.sampleMimeType : transformationRequest.audioMimeType).setSampleRate(encoderInputAudioFormat.sampleRate).setChannelCount(encoderInputAudioFormat.channelCount).setAverageBitrate(131072).build();
        this.encoder = encoderFactory.createForAudioEncoding(requestedOutputFormat, allowedOutputMimeTypes);
        fallbackListener.onTransformationRequestFinalized(AudioTranscodingSamplePipeline.createFallbackTransformationRequest(transformationRequest, requestedOutputFormat, this.encoder.getConfigurationFormat()));
    }

    @Override
    @Nullable
    public DecoderInputBuffer dequeueInputBuffer() throws TransformationException {
        return this.decoder.maybeDequeueInputBuffer(this.decoderInputBuffer) ? this.decoderInputBuffer : null;
    }

    @Override
    public void queueInputBuffer() throws TransformationException {
        this.decoder.queueInputBuffer(this.decoderInputBuffer);
    }

    @Override
    public boolean processData() throws TransformationException {
        if (this.sonicAudioProcessor.isActive()) {
            return this.feedEncoderFromSonic() || this.feedSonicFromDecoder();
        }
        return this.feedEncoderFromDecoder();
    }

    @Override
    @Nullable
    public Format getOutputFormat() throws TransformationException {
        return this.encoder.getOutputFormat();
    }

    @Override
    @Nullable
    public DecoderInputBuffer getOutputBuffer() throws TransformationException {
        this.encoderOutputBuffer.data = this.encoder.getOutputBuffer();
        if (this.encoderOutputBuffer.data == null) {
            return null;
        }
        this.encoderOutputBuffer.timeUs = ((MediaCodec.BufferInfo)Assertions.checkNotNull((Object)this.encoder.getOutputBufferInfo())).presentationTimeUs;
        this.encoderOutputBuffer.setFlags(1);
        return this.encoderOutputBuffer;
    }

    @Override
    public void releaseOutputBuffer() throws TransformationException {
        this.encoder.releaseOutputBuffer();
    }

    @Override
    public boolean isEnded() {
        return this.encoder.isEnded();
    }

    @Override
    public void release() {
        this.sonicAudioProcessor.reset();
        this.decoder.release();
        this.encoder.release();
    }

    private boolean feedEncoderFromDecoder() throws TransformationException {
        if (!this.encoder.maybeDequeueInputBuffer(this.encoderInputBuffer)) {
            return false;
        }
        if (this.decoder.isEnded()) {
            this.queueEndOfStreamToEncoder();
            return false;
        }
        ByteBuffer decoderOutputBuffer = this.decoder.getOutputBuffer();
        if (decoderOutputBuffer == null) {
            return false;
        }
        if (this.isSpeedChanging((MediaCodec.BufferInfo)Assertions.checkNotNull((Object)this.decoder.getOutputBufferInfo()))) {
            this.flushSonicAndSetSpeed(this.currentSpeed);
            return false;
        }
        this.feedEncoder(decoderOutputBuffer);
        if (!decoderOutputBuffer.hasRemaining()) {
            this.decoder.releaseOutputBuffer();
        }
        return true;
    }

    private boolean feedEncoderFromSonic() throws TransformationException {
        if (!this.encoder.maybeDequeueInputBuffer(this.encoderInputBuffer)) {
            return false;
        }
        if (!this.sonicOutputBuffer.hasRemaining()) {
            this.sonicOutputBuffer = this.sonicAudioProcessor.getOutput();
            if (!this.sonicOutputBuffer.hasRemaining()) {
                if (this.decoder.isEnded() && this.sonicAudioProcessor.isEnded()) {
                    this.queueEndOfStreamToEncoder();
                }
                return false;
            }
        }
        this.feedEncoder(this.sonicOutputBuffer);
        return true;
    }

    private boolean feedSonicFromDecoder() throws TransformationException {
        if (this.drainingSonicForSpeedChange) {
            if (this.sonicAudioProcessor.isEnded() && !this.sonicOutputBuffer.hasRemaining()) {
                this.flushSonicAndSetSpeed(this.currentSpeed);
                this.drainingSonicForSpeedChange = false;
            }
            return false;
        }
        if (this.sonicOutputBuffer.hasRemaining()) {
            return false;
        }
        if (this.decoder.isEnded()) {
            this.sonicAudioProcessor.queueEndOfStream();
            return false;
        }
        Assertions.checkState((!this.sonicAudioProcessor.isEnded() ? 1 : 0) != 0);
        ByteBuffer decoderOutputBuffer = this.decoder.getOutputBuffer();
        if (decoderOutputBuffer == null) {
            return false;
        }
        if (this.isSpeedChanging((MediaCodec.BufferInfo)Assertions.checkNotNull((Object)this.decoder.getOutputBufferInfo()))) {
            this.sonicAudioProcessor.queueEndOfStream();
            this.drainingSonicForSpeedChange = true;
            return false;
        }
        this.sonicAudioProcessor.queueInput(decoderOutputBuffer);
        if (!decoderOutputBuffer.hasRemaining()) {
            this.decoder.releaseOutputBuffer();
        }
        return true;
    }

    private void feedEncoder(ByteBuffer inputBuffer) throws TransformationException {
        ByteBuffer encoderInputBufferData = (ByteBuffer)Assertions.checkNotNull((Object)this.encoderInputBuffer.data);
        int bufferLimit = inputBuffer.limit();
        inputBuffer.limit(Math.min(bufferLimit, inputBuffer.position() + encoderInputBufferData.capacity()));
        encoderInputBufferData.put(inputBuffer);
        this.encoderInputBuffer.timeUs = this.nextEncoderInputBufferTimeUs;
        this.computeNextEncoderInputBufferTimeUs(encoderInputBufferData.position(), this.encoderInputAudioFormat.bytesPerFrame, this.encoderInputAudioFormat.sampleRate);
        this.encoderInputBuffer.setFlags(0);
        this.encoderInputBuffer.flip();
        inputBuffer.limit(bufferLimit);
        this.encoder.queueInputBuffer(this.encoderInputBuffer);
    }

    private void queueEndOfStreamToEncoder() throws TransformationException {
        Assertions.checkState((((ByteBuffer)Assertions.checkNotNull((Object)this.encoderInputBuffer.data)).position() == 0 ? 1 : 0) != 0);
        this.encoderInputBuffer.timeUs = this.nextEncoderInputBufferTimeUs;
        this.encoderInputBuffer.addFlag(4);
        this.encoderInputBuffer.flip();
        this.encoder.queueInputBuffer(this.encoderInputBuffer);
    }

    private boolean isSpeedChanging(MediaCodec.BufferInfo bufferInfo) {
        if (!this.flattenForSlowMotion) {
            return false;
        }
        float newSpeed = this.speedProvider.getSpeed(bufferInfo.presentationTimeUs);
        boolean speedChanging = newSpeed != this.currentSpeed;
        this.currentSpeed = newSpeed;
        return speedChanging;
    }

    private void flushSonicAndSetSpeed(float speed) {
        this.sonicAudioProcessor.setSpeed(speed);
        this.sonicAudioProcessor.setPitch(speed);
        this.sonicAudioProcessor.flush();
    }

    private void computeNextEncoderInputBufferTimeUs(long bytesWritten, int bytesPerFrame, int sampleRate) {
        long numerator = bytesWritten * 1000000L + this.encoderBufferDurationRemainder;
        long denominator = (long)bytesPerFrame * (long)sampleRate;
        long bufferDurationUs = numerator / denominator;
        this.encoderBufferDurationRemainder = numerator - bufferDurationUs * denominator;
        if (this.encoderBufferDurationRemainder > 0L) {
            ++bufferDurationUs;
            this.encoderBufferDurationRemainder -= denominator;
        }
        this.nextEncoderInputBufferTimeUs += bufferDurationUs;
    }

    @Pure
    private static TransformationRequest createFallbackTransformationRequest(TransformationRequest transformationRequest, Format requestedFormat, Format actualFormat) {
        if (Util.areEqual((Object)requestedFormat.sampleMimeType, (Object)actualFormat.sampleMimeType)) {
            return transformationRequest;
        }
        return transformationRequest.buildUpon().setAudioMimeType(actualFormat.sampleMimeType).build();
    }
}

