/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.BaseRenderer;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.Transformation;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.util.MediaClock;
import com.google.android.exoplayer2.util.MimeTypes;

@RequiresApi(value=18)
abstract class TransformerBaseRenderer
extends BaseRenderer {
    protected final MuxerWrapper muxerWrapper;
    protected final TransformerMediaClock mediaClock;
    protected final Transformation transformation;
    protected boolean isRendererStarted;
    protected long streamOffsetUs;

    public TransformerBaseRenderer(int trackType, MuxerWrapper muxerWrapper, TransformerMediaClock mediaClock, Transformation transformation) {
        super(trackType);
        this.muxerWrapper = muxerWrapper;
        this.mediaClock = mediaClock;
        this.transformation = transformation;
    }

    protected void onStreamChanged(Format[] formats, long startPositionUs, long offsetUs) {
        this.streamOffsetUs = offsetUs;
    }

    public final int supportsFormat(Format format) {
        String sampleMimeType = format.sampleMimeType;
        if (MimeTypes.getTrackType((String)sampleMimeType) != this.getTrackType()) {
            return RendererCapabilities.create((int)0);
        }
        if (MimeTypes.isAudio((String)sampleMimeType) && this.muxerWrapper.supportsSampleMimeType(this.transformation.audioMimeType == null ? sampleMimeType : this.transformation.audioMimeType) || MimeTypes.isVideo((String)sampleMimeType) && this.muxerWrapper.supportsSampleMimeType(this.transformation.videoMimeType == null ? sampleMimeType : this.transformation.videoMimeType)) {
            return RendererCapabilities.create((int)4);
        }
        return RendererCapabilities.create((int)1);
    }

    public final boolean isReady() {
        return this.isSourceReady();
    }

    public final MediaClock getMediaClock() {
        return this.mediaClock;
    }

    protected final void onEnabled(boolean joining, boolean mayRenderStartOfStream) {
        this.muxerWrapper.registerTrack();
        this.mediaClock.updateTimeForTrackType(this.getTrackType(), 0L);
    }

    protected void onStarted() throws ExoPlaybackException {
        this.isRendererStarted = true;
    }

    protected final void onStopped() {
        this.isRendererStarted = false;
    }
}

