/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.media.MediaCodec;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.SonicAudioProcessor;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.MediaCodecAdapterWrapper;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.SegmentSpeedProvider;
import com.google.android.exoplayer2.transformer.SpeedProvider;
import com.google.android.exoplayer2.transformer.Transformation;
import com.google.android.exoplayer2.transformer.TransformerBaseRenderer;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@RequiresApi(value=18)
final class TransformerAudioRenderer
extends TransformerBaseRenderer {
    private static final String TAG = "TransformerAudioRenderer";
    private static final int DEFAULT_ENCODER_BITRATE = 131072;
    private static final float SPEED_UNSET = -1.0f;
    private final DecoderInputBuffer decoderInputBuffer = new DecoderInputBuffer(0);
    private final DecoderInputBuffer encoderInputBuffer = new DecoderInputBuffer(0);
    private final SonicAudioProcessor sonicAudioProcessor = new SonicAudioProcessor();
    @Nullable
    private MediaCodecAdapterWrapper decoder;
    @Nullable
    private MediaCodecAdapterWrapper encoder;
    @Nullable
    private SpeedProvider speedProvider;
    private @MonotonicNonNull Format decoderInputFormat;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @MonotonicNonNull AudioProcessor.AudioFormat encoderInputAudioFormat;
    private ByteBuffer sonicOutputBuffer = AudioProcessor.EMPTY_BUFFER;
    private long nextEncoderInputBufferTimeUs = 0L;
    private float currentSpeed = -1.0f;
    private boolean muxerWrapperTrackEnded;
    private boolean hasEncoderOutputFormat;
    private boolean drainingSonicForSpeedChange;

    public TransformerAudioRenderer(MuxerWrapper muxerWrapper, TransformerMediaClock mediaClock, Transformation transformation) {
        super(1, muxerWrapper, mediaClock, transformation);
    }

    public String getName() {
        return TAG;
    }

    public boolean isEnded() {
        return this.muxerWrapperTrackEnded;
    }

    protected void onReset() {
        this.decoderInputBuffer.clear();
        this.decoderInputBuffer.data = null;
        this.encoderInputBuffer.clear();
        this.encoderInputBuffer.data = null;
        this.sonicAudioProcessor.reset();
        if (this.decoder != null) {
            this.decoder.release();
            this.decoder = null;
        }
        if (this.encoder != null) {
            this.encoder.release();
            this.encoder = null;
        }
        this.speedProvider = null;
        this.sonicOutputBuffer = AudioProcessor.EMPTY_BUFFER;
        this.nextEncoderInputBufferTimeUs = 0L;
        this.currentSpeed = -1.0f;
        this.muxerWrapperTrackEnded = false;
        this.hasEncoderOutputFormat = false;
        this.drainingSonicForSpeedChange = false;
    }

    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        if (!this.isRendererStarted || this.isEnded()) {
            return;
        }
        if (this.ensureDecoderConfigured()) {
            MediaCodecAdapterWrapper decoder = this.decoder;
            if (this.ensureEncoderAndAudioProcessingConfigured()) {
                MediaCodecAdapterWrapper encoder = this.encoder;
                while (this.feedMuxerFromEncoder(encoder)) {
                }
                if (this.sonicAudioProcessor.isActive()) {
                    while (this.feedEncoderFromSonic(decoder, encoder)) {
                    }
                    while (this.feedSonicFromDecoder(decoder)) {
                    }
                } else {
                    while (this.feedEncoderFromDecoder(decoder, encoder)) {
                    }
                }
            }
            while (this.feedDecoderFromInput(decoder)) {
            }
        }
    }

    private boolean feedMuxerFromEncoder(MediaCodecAdapterWrapper encoder) {
        if (!this.hasEncoderOutputFormat) {
            Format encoderOutputFormat = encoder.getOutputFormat();
            if (encoderOutputFormat == null) {
                return false;
            }
            this.hasEncoderOutputFormat = true;
            this.muxerWrapper.addTrackFormat(encoderOutputFormat);
        }
        if (encoder.isEnded()) {
            this.muxerWrapper.endTrack(this.getTrackType());
            this.muxerWrapperTrackEnded = true;
            return false;
        }
        ByteBuffer encoderOutputBuffer = encoder.getOutputBuffer();
        if (encoderOutputBuffer == null) {
            return false;
        }
        MediaCodec.BufferInfo encoderOutputBufferInfo = (MediaCodec.BufferInfo)Assertions.checkNotNull((Object)encoder.getOutputBufferInfo());
        if (!this.muxerWrapper.writeSample(this.getTrackType(), encoderOutputBuffer, true, encoderOutputBufferInfo.presentationTimeUs)) {
            return false;
        }
        encoder.releaseOutputBuffer();
        return true;
    }

    @RequiresNonNull(value={"encoderInputAudioFormat"})
    private boolean feedEncoderFromDecoder(MediaCodecAdapterWrapper decoder, MediaCodecAdapterWrapper encoder) {
        if (!encoder.maybeDequeueInputBuffer(this.encoderInputBuffer)) {
            return false;
        }
        if (decoder.isEnded()) {
            this.queueEndOfStreamToEncoder(encoder);
            return false;
        }
        ByteBuffer decoderOutputBuffer = decoder.getOutputBuffer();
        if (decoderOutputBuffer == null) {
            return false;
        }
        if (this.isSpeedChanging((MediaCodec.BufferInfo)Assertions.checkNotNull((Object)decoder.getOutputBufferInfo()))) {
            this.flushSonicAndSetSpeed(this.currentSpeed);
            return false;
        }
        this.feedEncoder(encoder, decoderOutputBuffer);
        if (!decoderOutputBuffer.hasRemaining()) {
            decoder.releaseOutputBuffer();
        }
        return true;
    }

    @RequiresNonNull(value={"encoderInputAudioFormat"})
    private boolean feedEncoderFromSonic(MediaCodecAdapterWrapper decoder, MediaCodecAdapterWrapper encoder) {
        if (!encoder.maybeDequeueInputBuffer(this.encoderInputBuffer)) {
            return false;
        }
        if (!this.sonicOutputBuffer.hasRemaining()) {
            this.sonicOutputBuffer = this.sonicAudioProcessor.getOutput();
            if (!this.sonicOutputBuffer.hasRemaining()) {
                if (decoder.isEnded() && this.sonicAudioProcessor.isEnded()) {
                    this.queueEndOfStreamToEncoder(encoder);
                }
                return false;
            }
        }
        this.feedEncoder(encoder, this.sonicOutputBuffer);
        return true;
    }

    private boolean feedSonicFromDecoder(MediaCodecAdapterWrapper decoder) {
        if (this.drainingSonicForSpeedChange) {
            if (this.sonicAudioProcessor.isEnded() && !this.sonicOutputBuffer.hasRemaining()) {
                this.flushSonicAndSetSpeed(this.currentSpeed);
                this.drainingSonicForSpeedChange = false;
            }
            return false;
        }
        if (this.sonicOutputBuffer.hasRemaining()) {
            return false;
        }
        if (decoder.isEnded()) {
            this.sonicAudioProcessor.queueEndOfStream();
            return false;
        }
        Assertions.checkState((!this.sonicAudioProcessor.isEnded() ? 1 : 0) != 0);
        ByteBuffer decoderOutputBuffer = decoder.getOutputBuffer();
        if (decoderOutputBuffer == null) {
            return false;
        }
        if (this.isSpeedChanging((MediaCodec.BufferInfo)Assertions.checkNotNull((Object)decoder.getOutputBufferInfo()))) {
            this.sonicAudioProcessor.queueEndOfStream();
            this.drainingSonicForSpeedChange = true;
            return false;
        }
        this.sonicAudioProcessor.queueInput(decoderOutputBuffer);
        if (!decoderOutputBuffer.hasRemaining()) {
            decoder.releaseOutputBuffer();
        }
        return true;
    }

    private boolean feedDecoderFromInput(MediaCodecAdapterWrapper decoder) {
        if (!decoder.maybeDequeueInputBuffer(this.decoderInputBuffer)) {
            return false;
        }
        this.decoderInputBuffer.clear();
        int result = this.readSource(this.getFormatHolder(), this.decoderInputBuffer, 0);
        switch (result) {
            case -4: {
                this.mediaClock.updateTimeForTrackType(this.getTrackType(), this.decoderInputBuffer.timeUs);
                this.decoderInputBuffer.timeUs -= this.streamOffsetUs;
                this.decoderInputBuffer.flip();
                decoder.queueInputBuffer(this.decoderInputBuffer);
                return !this.decoderInputBuffer.isEndOfStream();
            }
            case -5: {
                throw new IllegalStateException("Format changes are not supported.");
            }
        }
        return false;
    }

    @RequiresNonNull(value={"encoderInputAudioFormat"})
    private void feedEncoder(MediaCodecAdapterWrapper encoder, ByteBuffer inputBuffer) {
        ByteBuffer encoderInputBufferData = (ByteBuffer)Assertions.checkNotNull((Object)this.encoderInputBuffer.data);
        int bufferLimit = inputBuffer.limit();
        inputBuffer.limit(Math.min(bufferLimit, inputBuffer.position() + encoderInputBufferData.capacity()));
        encoderInputBufferData.put(inputBuffer);
        this.encoderInputBuffer.timeUs = this.nextEncoderInputBufferTimeUs;
        this.nextEncoderInputBufferTimeUs += TransformerAudioRenderer.getBufferDurationUs(encoderInputBufferData.position(), this.encoderInputAudioFormat.bytesPerFrame, this.encoderInputAudioFormat.sampleRate);
        this.encoderInputBuffer.setFlags(0);
        this.encoderInputBuffer.flip();
        inputBuffer.limit(bufferLimit);
        encoder.queueInputBuffer(this.encoderInputBuffer);
    }

    private void queueEndOfStreamToEncoder(MediaCodecAdapterWrapper encoder) {
        Assertions.checkState((((ByteBuffer)Assertions.checkNotNull((Object)this.encoderInputBuffer.data)).position() == 0 ? 1 : 0) != 0);
        this.encoderInputBuffer.timeUs = this.nextEncoderInputBufferTimeUs;
        this.encoderInputBuffer.addFlag(4);
        this.encoderInputBuffer.flip();
        encoder.queueInputBuffer(this.encoderInputBuffer);
    }

    @RequiresNonNull(value={"decoder", "decoderInputFormat"})
    @EnsuresNonNullIf(expression={"encoder", "encoderInputAudioFormat"}, result=true)
    private boolean ensureEncoderAndAudioProcessingConfigured() throws ExoPlaybackException {
        if (this.encoder != null && this.encoderInputAudioFormat != null) {
            return true;
        }
        MediaCodecAdapterWrapper decoder = this.decoder;
        Format decoderOutputFormat = decoder.getOutputFormat();
        if (decoderOutputFormat == null) {
            return false;
        }
        AudioProcessor.AudioFormat outputAudioFormat = new AudioProcessor.AudioFormat(decoderOutputFormat.sampleRate, decoderOutputFormat.channelCount, decoderOutputFormat.pcmEncoding);
        if (this.transformation.flattenForSlowMotion) {
            try {
                outputAudioFormat = this.sonicAudioProcessor.configure(outputAudioFormat);
                this.flushSonicAndSetSpeed(this.currentSpeed);
            }
            catch (AudioProcessor.UnhandledAudioFormatException e) {
                throw this.createRendererException(e, 1000);
            }
        }
        String audioMimeType = this.transformation.audioMimeType == null ? this.decoderInputFormat.sampleMimeType : this.transformation.audioMimeType;
        try {
            this.encoder = MediaCodecAdapterWrapper.createForAudioEncoding(new Format.Builder().setSampleMimeType(audioMimeType).setSampleRate(outputAudioFormat.sampleRate).setChannelCount(outputAudioFormat.channelCount).setAverageBitrate(131072).build());
        }
        catch (IOException e) {
            throw this.createRendererException(e, 1000);
        }
        this.encoderInputAudioFormat = outputAudioFormat;
        return true;
    }

    @EnsuresNonNullIf(expression={"decoderInputFormat", "decoder"}, result=true)
    private boolean ensureDecoderConfigured() throws ExoPlaybackException {
        MediaCodecAdapterWrapper decoder;
        if (this.decoder != null && this.decoderInputFormat != null) {
            return true;
        }
        FormatHolder formatHolder = this.getFormatHolder();
        int result = this.readSource(formatHolder, this.decoderInputBuffer, 2);
        if (result != -5) {
            return false;
        }
        this.decoderInputFormat = (Format)Assertions.checkNotNull((Object)formatHolder.format);
        try {
            decoder = MediaCodecAdapterWrapper.createForAudioDecoding(this.decoderInputFormat);
        }
        catch (IOException e) {
            throw this.createRendererException(e, 1000);
        }
        this.speedProvider = new SegmentSpeedProvider(this.decoderInputFormat);
        this.currentSpeed = this.speedProvider.getSpeed(0L);
        this.decoder = decoder;
        return true;
    }

    private boolean isSpeedChanging(MediaCodec.BufferInfo bufferInfo) {
        if (!this.transformation.flattenForSlowMotion) {
            return false;
        }
        float newSpeed = ((SpeedProvider)Assertions.checkNotNull((Object)this.speedProvider)).getSpeed(bufferInfo.presentationTimeUs);
        boolean speedChanging = newSpeed != this.currentSpeed;
        this.currentSpeed = newSpeed;
        return speedChanging;
    }

    private void flushSonicAndSetSpeed(float speed) {
        this.sonicAudioProcessor.setSpeed(speed);
        this.sonicAudioProcessor.setPitch(speed);
        this.sonicAudioProcessor.flush();
    }

    private ExoPlaybackException createRendererException(Throwable cause, int errorCode) {
        return ExoPlaybackException.createForRenderer((Throwable)cause, (String)TAG, (int)this.getIndex(), (Format)this.decoderInputFormat, (int)4, (boolean)false, (int)errorCode);
    }

    private static long getBufferDurationUs(long bytesWritten, int bytesPerFrame, int sampleRate) {
        long framesWritten = bytesWritten / (long)bytesPerFrame;
        return framesWritten * 1000000L / (long)sampleRate;
    }
}

