/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.mediacodec.MediaCodecAdapter;
import com.google.android.exoplayer2.mediacodec.MediaCodecInfo;
import com.google.android.exoplayer2.mediacodec.SynchronousMediaCodecAdapter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MediaFormatUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@RequiresApi(value=18)
final class MediaCodecAdapterWrapper {
    private static final int MEDIA_CODEC_PCM_ENCODING = 2;
    private final MediaCodec.BufferInfo outputBufferInfo;
    private final MediaCodecAdapter codec;
    private @MonotonicNonNull Format outputFormat;
    @Nullable
    private ByteBuffer outputBuffer;
    private int inputBufferIndex;
    private int outputBufferIndex;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;

    private static MediaCodecInfo createPlaceholderMediaCodecInfo() {
        return MediaCodecInfo.newInstance((String)"name-placeholder", (String)"mime-type-placeholder", (String)"mime-type-placeholder", null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
    }

    public static MediaCodecAdapterWrapper createForAudioDecoding(Format format) throws IOException {
        MediaCodecAdapter adapter = null;
        try {
            MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (int)format.sampleRate, (int)format.channelCount);
            MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"max-input-size", (int)format.maxInputSize);
            MediaFormatUtil.setCsdBuffers((MediaFormat)mediaFormat, (List)format.initializationData);
            adapter = new Factory().createAdapter(MediaCodecAdapter.Configuration.createForAudioDecoding((MediaCodecInfo)MediaCodecAdapterWrapper.createPlaceholderMediaCodecInfo(), (MediaFormat)mediaFormat, (Format)format, null));
            return new MediaCodecAdapterWrapper(adapter);
        }
        catch (Exception e) {
            if (adapter != null) {
                adapter.release();
            }
            throw e;
        }
    }

    public static MediaCodecAdapterWrapper createForVideoDecoding(Format format, Surface surface) throws IOException {
        MediaCodecAdapter adapter = null;
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (int)format.width, (int)format.height);
            MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"max-input-size", (int)format.maxInputSize);
            MediaFormatUtil.setCsdBuffers((MediaFormat)mediaFormat, (List)format.initializationData);
            adapter = new Factory().createAdapter(MediaCodecAdapter.Configuration.createForVideoDecoding((MediaCodecInfo)MediaCodecAdapterWrapper.createPlaceholderMediaCodecInfo(), (MediaFormat)mediaFormat, (Format)format, (Surface)surface, null));
            return new MediaCodecAdapterWrapper(adapter);
        }
        catch (Exception e) {
            if (adapter != null) {
                adapter.release();
            }
            throw e;
        }
    }

    public static MediaCodecAdapterWrapper createForAudioEncoding(Format format) throws IOException {
        Object encoder = null;
        MediaCodecAdapter adapter = null;
        try {
            MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (int)format.sampleRate, (int)format.channelCount);
            mediaFormat.setInteger("bitrate", format.bitrate);
            adapter = new Factory().createAdapter(MediaCodecAdapter.Configuration.createForAudioEncoding((MediaCodecInfo)MediaCodecAdapterWrapper.createPlaceholderMediaCodecInfo(), (MediaFormat)mediaFormat, (Format)format));
            return new MediaCodecAdapterWrapper(adapter);
        }
        catch (Exception e) {
            if (adapter != null) {
                adapter.release();
            } else if (encoder != null) {
                encoder.release();
            }
            throw e;
        }
    }

    public static MediaCodecAdapterWrapper createForVideoEncoding(Format format, Map<String, Integer> additionalEncoderConfig) throws IOException {
        Assertions.checkArgument((format.width != -1 ? 1 : 0) != 0);
        Assertions.checkArgument((format.height != -1 ? 1 : 0) != 0);
        MediaCodecAdapter adapter = null;
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (int)format.width, (int)format.height);
            mediaFormat.setInteger("color-format", 2130708361);
            mediaFormat.setInteger("frame-rate", 30);
            mediaFormat.setInteger("i-frame-interval", 1);
            mediaFormat.setInteger("bitrate", 413000);
            for (Map.Entry<String, Integer> encoderSetting : additionalEncoderConfig.entrySet()) {
                mediaFormat.setInteger(encoderSetting.getKey(), encoderSetting.getValue().intValue());
            }
            adapter = new Factory().createAdapter(MediaCodecAdapter.Configuration.createForVideoEncoding((MediaCodecInfo)MediaCodecAdapterWrapper.createPlaceholderMediaCodecInfo(), (MediaFormat)mediaFormat, (Format)format));
            return new MediaCodecAdapterWrapper(adapter);
        }
        catch (Exception e) {
            if (adapter != null) {
                adapter.release();
            }
            throw e;
        }
    }

    private MediaCodecAdapterWrapper(MediaCodecAdapter codec) {
        this.codec = codec;
        this.outputBufferInfo = new MediaCodec.BufferInfo();
        this.inputBufferIndex = -1;
        this.outputBufferIndex = -1;
    }

    @Nullable
    public Surface getInputSurface() {
        return this.codec.getInputSurface();
    }

    @EnsuresNonNullIf(expression={"#1.data"}, result=true)
    public boolean maybeDequeueInputBuffer(DecoderInputBuffer inputBuffer) {
        if (this.inputStreamEnded) {
            return false;
        }
        if (this.inputBufferIndex < 0) {
            this.inputBufferIndex = this.codec.dequeueInputBufferIndex();
            if (this.inputBufferIndex < 0) {
                return false;
            }
            inputBuffer.data = this.codec.getInputBuffer(this.inputBufferIndex);
            inputBuffer.clear();
        }
        Assertions.checkNotNull((Object)inputBuffer.data);
        return true;
    }

    public void queueInputBuffer(DecoderInputBuffer inputBuffer) {
        Assertions.checkState((!this.inputStreamEnded ? 1 : 0) != 0, (Object)"Input buffer can not be queued after the input stream has ended.");
        int offset = 0;
        int size = 0;
        if (inputBuffer.data != null && inputBuffer.data.hasRemaining()) {
            offset = inputBuffer.data.position();
            size = inputBuffer.data.remaining();
        }
        int flags = 0;
        if (inputBuffer.isEndOfStream()) {
            this.inputStreamEnded = true;
            flags = 4;
        }
        this.codec.queueInputBuffer(this.inputBufferIndex, offset, size, inputBuffer.timeUs, flags);
        this.inputBufferIndex = -1;
        inputBuffer.data = null;
    }

    @RequiresApi(value=18)
    public void signalEndOfInputStream() {
        this.codec.signalEndOfInputStream();
    }

    @Nullable
    public Format getOutputFormat() {
        this.maybeDequeueOutputBuffer();
        return this.outputFormat;
    }

    @Nullable
    public ByteBuffer getOutputBuffer() {
        return this.maybeDequeueAndSetOutputBuffer() ? this.outputBuffer : null;
    }

    @Nullable
    public MediaCodec.BufferInfo getOutputBufferInfo() {
        return this.maybeDequeueOutputBuffer() ? this.outputBufferInfo : null;
    }

    public void releaseOutputBuffer() {
        this.releaseOutputBuffer(false);
    }

    public void releaseOutputBuffer(boolean render) {
        this.outputBuffer = null;
        this.codec.releaseOutputBuffer(this.outputBufferIndex, render);
        this.outputBufferIndex = -1;
    }

    public boolean isEnded() {
        return this.outputStreamEnded && this.outputBufferIndex == -1;
    }

    public void release() {
        this.outputBuffer = null;
        this.codec.release();
    }

    private boolean maybeDequeueAndSetOutputBuffer() {
        if (!this.maybeDequeueOutputBuffer()) {
            return false;
        }
        this.outputBuffer = (ByteBuffer)Assertions.checkNotNull((Object)this.codec.getOutputBuffer(this.outputBufferIndex));
        this.outputBuffer.position(this.outputBufferInfo.offset);
        this.outputBuffer.limit(this.outputBufferInfo.offset + this.outputBufferInfo.size);
        return true;
    }

    private boolean maybeDequeueOutputBuffer() {
        if (this.outputBufferIndex >= 0) {
            return true;
        }
        if (this.outputStreamEnded) {
            return false;
        }
        this.outputBufferIndex = this.codec.dequeueOutputBufferIndex(this.outputBufferInfo);
        if (this.outputBufferIndex < 0) {
            if (this.outputBufferIndex == -2) {
                this.outputFormat = MediaCodecAdapterWrapper.getFormat(this.codec.getOutputFormat());
            }
            return false;
        }
        if ((this.outputBufferInfo.flags & 4) != 0) {
            this.outputStreamEnded = true;
            if (this.outputBufferInfo.size == 0) {
                this.releaseOutputBuffer();
                return false;
            }
        }
        if ((this.outputBufferInfo.flags & 2) != 0) {
            this.releaseOutputBuffer();
            return false;
        }
        return true;
    }

    private static Format getFormat(MediaFormat mediaFormat) {
        ImmutableList.Builder csdBuffers = new ImmutableList.Builder();
        int csdIndex = 0;
        while (true) {
            int n = csdIndex++;
            ByteBuffer csdByteBuffer = mediaFormat.getByteBuffer(new StringBuilder(15).append("csd-").append(n).toString());
            if (csdByteBuffer == null) break;
            byte[] csdBufferData = new byte[csdByteBuffer.remaining()];
            csdByteBuffer.get(csdBufferData);
            csdBuffers.add((Object)csdBufferData);
        }
        String mimeType = mediaFormat.getString("mime");
        Format.Builder formatBuilder = new Format.Builder().setSampleMimeType(mediaFormat.getString("mime")).setInitializationData((List)csdBuffers.build());
        if (MimeTypes.isVideo((String)mimeType)) {
            formatBuilder.setWidth(mediaFormat.getInteger("width")).setHeight(mediaFormat.getInteger("height"));
        } else if (MimeTypes.isAudio((String)mimeType)) {
            formatBuilder.setChannelCount(mediaFormat.getInteger("channel-count")).setSampleRate(mediaFormat.getInteger("sample-rate")).setPcmEncoding(2);
        }
        return formatBuilder.build();
    }

    private static class Factory
    extends SynchronousMediaCodecAdapter.Factory {
        private Factory() {
        }

        protected MediaCodec createCodec(MediaCodecAdapter.Configuration configuration) throws IOException {
            String sampleMimeType = (String)Assertions.checkNotNull((Object)configuration.mediaFormat.getString("mime"));
            boolean isDecoder = (configuration.flags & 1) == 0;
            return isDecoder ? MediaCodec.createDecoderByType((String)((String)Assertions.checkNotNull((Object)sampleMimeType))) : MediaCodec.createEncoderByType((String)((String)Assertions.checkNotNull((Object)sampleMimeType)));
        }
    }
}

