/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.SampleTransformer;
import com.google.android.exoplayer2.transformer.SefSlowMotionVideoSampleTransformer;
import com.google.android.exoplayer2.transformer.Transformation;
import com.google.android.exoplayer2.transformer.TransformerBaseRenderer;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.util.Assertions;
import java.nio.ByteBuffer;

@RequiresApi(value=18)
final class TransformerVideoRenderer
extends TransformerBaseRenderer {
    private static final String TAG = "TransformerVideoRenderer";
    private final DecoderInputBuffer buffer = new DecoderInputBuffer(2);
    @Nullable
    private SampleTransformer sampleTransformer;
    private boolean formatRead;
    private boolean isBufferPending;
    private boolean isInputStreamEnded;

    public TransformerVideoRenderer(MuxerWrapper muxerWrapper, TransformerMediaClock mediaClock, Transformation transformation) {
        super(2, muxerWrapper, mediaClock, transformation);
    }

    public String getName() {
        return TAG;
    }

    public void render(long positionUs, long elapsedRealtimeUs) {
        if (!this.isRendererStarted || this.isEnded()) {
            return;
        }
        if (!this.formatRead) {
            FormatHolder formatHolder = this.getFormatHolder();
            int result = this.readSource(formatHolder, this.buffer, true);
            if (result != -5) {
                return;
            }
            Format format = (Format)Assertions.checkNotNull((Object)formatHolder.format);
            this.formatRead = true;
            if (this.transformation.flattenForSlowMotion) {
                this.sampleTransformer = new SefSlowMotionVideoSampleTransformer(format);
            }
            this.muxerWrapper.addTrackFormat(format);
        }
        do {
            if (!this.isBufferPending && !this.readAndTransformBuffer()) {
                return;
            }
            boolean bl = this.isBufferPending = !this.muxerWrapper.writeSample(this.getTrackType(), this.buffer.data, this.buffer.isKeyFrame(), this.buffer.timeUs);
        } while (!this.isBufferPending);
    }

    public boolean isEnded() {
        return this.isInputStreamEnded;
    }

    private boolean readAndTransformBuffer() {
        this.buffer.clear();
        int result = this.readSource(this.getFormatHolder(), this.buffer, false);
        if (result == -5) {
            throw new IllegalStateException("Format changes are not supported.");
        }
        if (result == -3) {
            return false;
        }
        if (this.buffer.isEndOfStream()) {
            this.isInputStreamEnded = true;
            this.muxerWrapper.endTrack(this.getTrackType());
            return false;
        }
        this.mediaClock.updateTimeForTrackType(this.getTrackType(), this.buffer.timeUs);
        ByteBuffer data = (ByteBuffer)Assertions.checkNotNull((Object)this.buffer.data);
        data.flip();
        if (this.sampleTransformer != null) {
            this.sampleTransformer.transformSample(this.buffer);
        }
        return true;
    }
}

