/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.media.MediaCodec;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.SonicAudioProcessor;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.MediaCodecAdapterWrapper;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.SegmentSpeedProvider;
import com.google.android.exoplayer2.transformer.SpeedProvider;
import com.google.android.exoplayer2.transformer.Transformation;
import com.google.android.exoplayer2.transformer.TransformerBaseRenderer;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(value=18)
final class TransformerAudioRenderer
extends TransformerBaseRenderer {
    private static final String TAG = "TransformerAudioRenderer";
    private static final int DEFAULT_ENCODER_BITRATE = 131072;
    private static final float SPEED_UNSET = -1.0f;
    private final DecoderInputBuffer decoderInputBuffer = new DecoderInputBuffer(0);
    private final DecoderInputBuffer encoderInputBuffer = new DecoderInputBuffer(0);
    private final SonicAudioProcessor sonicAudioProcessor = new SonicAudioProcessor();
    @Nullable
    private MediaCodecAdapterWrapper decoder;
    @Nullable
    private MediaCodecAdapterWrapper encoder;
    @Nullable
    private SpeedProvider speedProvider;
    @Nullable
    private Format inputFormat;
    @Nullable
    private AudioProcessor.AudioFormat encoderInputAudioFormat;
    private ByteBuffer sonicOutputBuffer = AudioProcessor.EMPTY_BUFFER;
    private long nextEncoderInputBufferTimeUs = 0L;
    private float currentSpeed = -1.0f;
    private boolean muxerWrapperTrackEnded;
    private boolean hasEncoderOutputFormat;
    private boolean drainingSonicForSpeedChange;

    public TransformerAudioRenderer(MuxerWrapper muxerWrapper, TransformerMediaClock mediaClock, Transformation transformation) {
        super(1, muxerWrapper, mediaClock, transformation);
    }

    public String getName() {
        return TAG;
    }

    public boolean isEnded() {
        return this.muxerWrapperTrackEnded;
    }

    protected void onReset() {
        this.decoderInputBuffer.clear();
        this.decoderInputBuffer.data = null;
        this.encoderInputBuffer.clear();
        this.encoderInputBuffer.data = null;
        this.sonicAudioProcessor.reset();
        if (this.decoder != null) {
            this.decoder.release();
            this.decoder = null;
        }
        if (this.encoder != null) {
            this.encoder.release();
            this.encoder = null;
        }
        this.speedProvider = null;
        this.inputFormat = null;
        this.encoderInputAudioFormat = null;
        this.sonicOutputBuffer = AudioProcessor.EMPTY_BUFFER;
        this.nextEncoderInputBufferTimeUs = 0L;
        this.currentSpeed = -1.0f;
        this.muxerWrapperTrackEnded = false;
        this.hasEncoderOutputFormat = false;
        this.drainingSonicForSpeedChange = false;
    }

    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        if (!this.isRendererStarted || this.isEnded()) {
            return;
        }
        if (this.ensureDecoderConfigured()) {
            if (this.ensureEncoderAndAudioProcessingConfigured()) {
                while (this.drainEncoderToFeedMuxer()) {
                }
                if (this.sonicAudioProcessor.isActive()) {
                    while (this.drainSonicToFeedEncoder()) {
                    }
                    while (this.drainDecoderToFeedSonic()) {
                    }
                } else {
                    while (this.drainDecoderToFeedEncoder()) {
                    }
                }
            }
            while (this.feedDecoderInputFromSource()) {
            }
        }
    }

    private boolean drainEncoderToFeedMuxer() {
        MediaCodecAdapterWrapper encoder = (MediaCodecAdapterWrapper)Assertions.checkNotNull((Object)this.encoder);
        if (!this.hasEncoderOutputFormat) {
            Format encoderOutputFormat = encoder.getOutputFormat();
            if (encoderOutputFormat == null) {
                return false;
            }
            this.hasEncoderOutputFormat = true;
            this.muxerWrapper.addTrackFormat(encoderOutputFormat);
        }
        if (encoder.isEnded()) {
            this.muxerWrapper.endTrack(this.getTrackType());
            this.muxerWrapperTrackEnded = true;
            return false;
        }
        ByteBuffer encoderOutputBuffer = encoder.getOutputBuffer();
        if (encoderOutputBuffer == null) {
            return false;
        }
        MediaCodec.BufferInfo encoderOutputBufferInfo = (MediaCodec.BufferInfo)Assertions.checkNotNull((Object)encoder.getOutputBufferInfo());
        if (!this.muxerWrapper.writeSample(this.getTrackType(), encoderOutputBuffer, true, encoderOutputBufferInfo.presentationTimeUs)) {
            return false;
        }
        encoder.releaseOutputBuffer();
        return true;
    }

    private boolean drainDecoderToFeedEncoder() {
        MediaCodecAdapterWrapper decoder = (MediaCodecAdapterWrapper)Assertions.checkNotNull((Object)this.decoder);
        MediaCodecAdapterWrapper encoder = (MediaCodecAdapterWrapper)Assertions.checkNotNull((Object)this.encoder);
        if (!encoder.maybeDequeueInputBuffer(this.encoderInputBuffer)) {
            return false;
        }
        if (decoder.isEnded()) {
            this.queueEndOfStreamToEncoder();
            return false;
        }
        ByteBuffer decoderOutputBuffer = decoder.getOutputBuffer();
        if (decoderOutputBuffer == null) {
            return false;
        }
        if (this.isSpeedChanging((MediaCodec.BufferInfo)Assertions.checkNotNull((Object)decoder.getOutputBufferInfo()))) {
            this.flushSonicAndSetSpeed(this.currentSpeed);
            return false;
        }
        this.feedEncoder(decoderOutputBuffer);
        if (!decoderOutputBuffer.hasRemaining()) {
            decoder.releaseOutputBuffer();
        }
        return true;
    }

    private boolean drainSonicToFeedEncoder() {
        MediaCodecAdapterWrapper encoder = (MediaCodecAdapterWrapper)Assertions.checkNotNull((Object)this.encoder);
        if (!encoder.maybeDequeueInputBuffer(this.encoderInputBuffer)) {
            return false;
        }
        if (!this.sonicOutputBuffer.hasRemaining()) {
            this.sonicOutputBuffer = this.sonicAudioProcessor.getOutput();
            if (!this.sonicOutputBuffer.hasRemaining()) {
                if (((MediaCodecAdapterWrapper)Assertions.checkNotNull((Object)this.decoder)).isEnded() && this.sonicAudioProcessor.isEnded()) {
                    this.queueEndOfStreamToEncoder();
                }
                return false;
            }
        }
        this.feedEncoder(this.sonicOutputBuffer);
        return true;
    }

    private boolean drainDecoderToFeedSonic() {
        MediaCodecAdapterWrapper decoder = (MediaCodecAdapterWrapper)Assertions.checkNotNull((Object)this.decoder);
        if (this.drainingSonicForSpeedChange) {
            if (this.sonicAudioProcessor.isEnded() && !this.sonicOutputBuffer.hasRemaining()) {
                this.flushSonicAndSetSpeed(this.currentSpeed);
                this.drainingSonicForSpeedChange = false;
            }
            return false;
        }
        if (this.sonicOutputBuffer.hasRemaining()) {
            return false;
        }
        if (decoder.isEnded()) {
            this.sonicAudioProcessor.queueEndOfStream();
            return false;
        }
        Assertions.checkState((!this.sonicAudioProcessor.isEnded() ? 1 : 0) != 0);
        ByteBuffer decoderOutputBuffer = decoder.getOutputBuffer();
        if (decoderOutputBuffer == null) {
            return false;
        }
        if (this.isSpeedChanging((MediaCodec.BufferInfo)Assertions.checkNotNull((Object)decoder.getOutputBufferInfo()))) {
            this.sonicAudioProcessor.queueEndOfStream();
            this.drainingSonicForSpeedChange = true;
            return false;
        }
        this.sonicAudioProcessor.queueInput(decoderOutputBuffer);
        if (!decoderOutputBuffer.hasRemaining()) {
            decoder.releaseOutputBuffer();
        }
        return true;
    }

    private boolean feedDecoderInputFromSource() {
        MediaCodecAdapterWrapper decoder = (MediaCodecAdapterWrapper)Assertions.checkNotNull((Object)this.decoder);
        if (!decoder.maybeDequeueInputBuffer(this.decoderInputBuffer)) {
            return false;
        }
        this.decoderInputBuffer.clear();
        int result = this.readSource(this.getFormatHolder(), this.decoderInputBuffer, false);
        switch (result) {
            case -4: {
                this.mediaClock.updateTimeForTrackType(this.getTrackType(), this.decoderInputBuffer.timeUs);
                this.decoderInputBuffer.flip();
                decoder.queueInputBuffer(this.decoderInputBuffer);
                return !this.decoderInputBuffer.isEndOfStream();
            }
            case -5: {
                throw new IllegalStateException("Format changes are not supported.");
            }
        }
        return false;
    }

    private void feedEncoder(ByteBuffer inputBuffer) {
        AudioProcessor.AudioFormat encoderInputAudioFormat = (AudioProcessor.AudioFormat)Assertions.checkNotNull((Object)this.encoderInputAudioFormat);
        MediaCodecAdapterWrapper encoder = (MediaCodecAdapterWrapper)Assertions.checkNotNull((Object)this.encoder);
        ByteBuffer encoderInputBufferData = (ByteBuffer)Assertions.checkNotNull((Object)this.encoderInputBuffer.data);
        int bufferLimit = inputBuffer.limit();
        inputBuffer.limit(Math.min(bufferLimit, inputBuffer.position() + encoderInputBufferData.capacity()));
        encoderInputBufferData.put(inputBuffer);
        this.encoderInputBuffer.timeUs = this.nextEncoderInputBufferTimeUs;
        this.nextEncoderInputBufferTimeUs += TransformerAudioRenderer.getBufferDurationUs(encoderInputBufferData.position(), encoderInputAudioFormat.bytesPerFrame, encoderInputAudioFormat.sampleRate);
        this.encoderInputBuffer.setFlags(0);
        this.encoderInputBuffer.flip();
        inputBuffer.limit(bufferLimit);
        encoder.queueInputBuffer(this.encoderInputBuffer);
    }

    private void queueEndOfStreamToEncoder() {
        MediaCodecAdapterWrapper encoder = (MediaCodecAdapterWrapper)Assertions.checkNotNull((Object)this.encoder);
        Assertions.checkState((((ByteBuffer)Assertions.checkNotNull((Object)this.encoderInputBuffer.data)).position() == 0 ? 1 : 0) != 0);
        this.encoderInputBuffer.addFlag(4);
        this.encoderInputBuffer.flip();
        encoder.queueInputBuffer(this.encoderInputBuffer);
    }

    private boolean ensureEncoderAndAudioProcessingConfigured() throws ExoPlaybackException {
        if (this.encoder != null) {
            return true;
        }
        MediaCodecAdapterWrapper decoder = (MediaCodecAdapterWrapper)Assertions.checkNotNull((Object)this.decoder);
        Format decoderOutputFormat = decoder.getOutputFormat();
        if (decoderOutputFormat == null) {
            return false;
        }
        AudioProcessor.AudioFormat outputAudioFormat = new AudioProcessor.AudioFormat(decoderOutputFormat.sampleRate, decoderOutputFormat.channelCount, decoderOutputFormat.pcmEncoding);
        if (this.transformation.flattenForSlowMotion) {
            try {
                outputAudioFormat = this.sonicAudioProcessor.configure(outputAudioFormat);
                this.flushSonicAndSetSpeed(this.currentSpeed);
            }
            catch (AudioProcessor.UnhandledAudioFormatException e) {
                throw this.createRendererException(e);
            }
        }
        try {
            this.encoder = MediaCodecAdapterWrapper.createForAudioEncoding(new Format.Builder().setSampleMimeType(((Format)Assertions.checkNotNull((Object)this.inputFormat)).sampleMimeType).setSampleRate(outputAudioFormat.sampleRate).setChannelCount(outputAudioFormat.channelCount).setAverageBitrate(131072).build());
        }
        catch (IOException e) {
            throw this.createRendererException(e);
        }
        this.encoderInputAudioFormat = outputAudioFormat;
        return true;
    }

    private boolean ensureDecoderConfigured() throws ExoPlaybackException {
        if (this.decoder != null) {
            return true;
        }
        FormatHolder formatHolder = this.getFormatHolder();
        int result = this.readSource(formatHolder, this.decoderInputBuffer, true);
        if (result != -5) {
            return false;
        }
        this.inputFormat = (Format)Assertions.checkNotNull((Object)formatHolder.format);
        try {
            this.decoder = MediaCodecAdapterWrapper.createForAudioDecoding(this.inputFormat);
        }
        catch (IOException e) {
            throw this.createRendererException(e);
        }
        this.speedProvider = new SegmentSpeedProvider(this.inputFormat);
        this.currentSpeed = this.speedProvider.getSpeed(0L);
        return true;
    }

    private boolean isSpeedChanging(MediaCodec.BufferInfo bufferInfo) {
        if (!this.transformation.flattenForSlowMotion) {
            return false;
        }
        float newSpeed = ((SpeedProvider)Assertions.checkNotNull((Object)this.speedProvider)).getSpeed(bufferInfo.presentationTimeUs);
        boolean speedChanging = newSpeed != this.currentSpeed;
        this.currentSpeed = newSpeed;
        return speedChanging;
    }

    private void flushSonicAndSetSpeed(float speed) {
        this.sonicAudioProcessor.setSpeed(speed);
        this.sonicAudioProcessor.setPitch(speed);
        this.sonicAudioProcessor.flush();
    }

    private ExoPlaybackException createRendererException(Throwable cause) {
        return ExoPlaybackException.createForRenderer((Throwable)cause, (String)TAG, (int)this.getIndex(), (Format)this.inputFormat, (int)4);
    }

    private static long getBufferDurationUs(long bytesWritten, int bytesPerFrame, int sampleRate) {
        long framesWritten = bytesWritten / (long)bytesPerFrame;
        return framesWritten * 1000000L / (long)sampleRate;
    }
}

