/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.smoothstreaming.manifest;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.mp4.TrackEncryptionBox;
import com.google.android.exoplayer2.offline.FilterableManifest;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.UriUtil;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class SsManifest
implements FilterableManifest<SsManifest> {
    public static final int UNSET_LOOKAHEAD = -1;
    public final int majorVersion;
    public final int minorVersion;
    public final int lookAheadCount;
    public final boolean isLive;
    @Nullable
    public final ProtectionElement protectionElement;
    public final StreamElement[] streamElements;
    public final long durationUs;
    public final long dvrWindowLengthUs;

    public SsManifest(int majorVersion, int minorVersion, long timescale, long duration, long dvrWindowLength, int lookAheadCount, boolean isLive, @Nullable ProtectionElement protectionElement, StreamElement[] streamElements) {
        this(majorVersion, minorVersion, duration == 0L ? -9223372036854775807L : Util.scaleLargeTimestamp((long)duration, (long)1000000L, (long)timescale), dvrWindowLength == 0L ? -9223372036854775807L : Util.scaleLargeTimestamp((long)dvrWindowLength, (long)1000000L, (long)timescale), lookAheadCount, isLive, protectionElement, streamElements);
    }

    private SsManifest(int majorVersion, int minorVersion, long durationUs, long dvrWindowLengthUs, int lookAheadCount, boolean isLive, @Nullable ProtectionElement protectionElement, StreamElement[] streamElements) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.durationUs = durationUs;
        this.dvrWindowLengthUs = dvrWindowLengthUs;
        this.lookAheadCount = lookAheadCount;
        this.isLive = isLive;
        this.protectionElement = protectionElement;
        this.streamElements = streamElements;
    }

    public final SsManifest copy(List<StreamKey> streamKeys) {
        ArrayList<StreamKey> sortedKeys = new ArrayList<StreamKey>(streamKeys);
        Collections.sort(sortedKeys);
        StreamElement currentStreamElement = null;
        ArrayList<StreamElement> copiedStreamElements = new ArrayList<StreamElement>();
        ArrayList<Format> copiedFormats = new ArrayList<Format>();
        for (int i = 0; i < sortedKeys.size(); ++i) {
            StreamKey key = sortedKeys.get(i);
            StreamElement streamElement = this.streamElements[key.groupIndex];
            if (streamElement != currentStreamElement && currentStreamElement != null) {
                copiedStreamElements.add(currentStreamElement.copy(copiedFormats.toArray(new Format[0])));
                copiedFormats.clear();
            }
            currentStreamElement = streamElement;
            copiedFormats.add(streamElement.formats[key.streamIndex]);
        }
        if (currentStreamElement != null) {
            copiedStreamElements.add(currentStreamElement.copy(copiedFormats.toArray(new Format[0])));
        }
        StreamElement[] copiedStreamElementsArray = copiedStreamElements.toArray(new StreamElement[0]);
        return new SsManifest(this.majorVersion, this.minorVersion, this.durationUs, this.dvrWindowLengthUs, this.lookAheadCount, this.isLive, this.protectionElement, copiedStreamElementsArray);
    }

    public static class StreamElement {
        private static final String URL_PLACEHOLDER_START_TIME_1 = "{start time}";
        private static final String URL_PLACEHOLDER_START_TIME_2 = "{start_time}";
        private static final String URL_PLACEHOLDER_BITRATE_1 = "{bitrate}";
        private static final String URL_PLACEHOLDER_BITRATE_2 = "{Bitrate}";
        public final int type;
        public final String subType;
        public final long timescale;
        public final String name;
        public final int maxWidth;
        public final int maxHeight;
        public final int displayWidth;
        public final int displayHeight;
        @Nullable
        public final String language;
        public final Format[] formats;
        public final int chunkCount;
        private final String baseUri;
        private final String chunkTemplate;
        private final List<Long> chunkStartTimes;
        private final long[] chunkStartTimesUs;
        private final long lastChunkDurationUs;

        public StreamElement(String baseUri, String chunkTemplate, int type, String subType, long timescale, String name, int maxWidth, int maxHeight, int displayWidth, int displayHeight, @Nullable String language, Format[] formats, List<Long> chunkStartTimes, long lastChunkDuration) {
            this(baseUri, chunkTemplate, type, subType, timescale, name, maxWidth, maxHeight, displayWidth, displayHeight, language, formats, chunkStartTimes, Util.scaleLargeTimestamps(chunkStartTimes, (long)1000000L, (long)timescale), Util.scaleLargeTimestamp((long)lastChunkDuration, (long)1000000L, (long)timescale));
        }

        private StreamElement(String baseUri, String chunkTemplate, int type, String subType, long timescale, String name, int maxWidth, int maxHeight, int displayWidth, int displayHeight, @Nullable String language, Format[] formats, List<Long> chunkStartTimes, long[] chunkStartTimesUs, long lastChunkDurationUs) {
            this.baseUri = baseUri;
            this.chunkTemplate = chunkTemplate;
            this.type = type;
            this.subType = subType;
            this.timescale = timescale;
            this.name = name;
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
            this.displayWidth = displayWidth;
            this.displayHeight = displayHeight;
            this.language = language;
            this.formats = formats;
            this.chunkStartTimes = chunkStartTimes;
            this.chunkStartTimesUs = chunkStartTimesUs;
            this.lastChunkDurationUs = lastChunkDurationUs;
            this.chunkCount = chunkStartTimes.size();
        }

        public StreamElement copy(Format[] formats) {
            return new StreamElement(this.baseUri, this.chunkTemplate, this.type, this.subType, this.timescale, this.name, this.maxWidth, this.maxHeight, this.displayWidth, this.displayHeight, this.language, formats, this.chunkStartTimes, this.chunkStartTimesUs, this.lastChunkDurationUs);
        }

        public int getChunkIndex(long timeUs) {
            return Util.binarySearchFloor((long[])this.chunkStartTimesUs, (long)timeUs, (boolean)true, (boolean)true);
        }

        public long getStartTimeUs(int chunkIndex) {
            return this.chunkStartTimesUs[chunkIndex];
        }

        public long getChunkDurationUs(int chunkIndex) {
            return chunkIndex == this.chunkCount - 1 ? this.lastChunkDurationUs : this.chunkStartTimesUs[chunkIndex + 1] - this.chunkStartTimesUs[chunkIndex];
        }

        public Uri buildRequestUri(int track, int chunkIndex) {
            Assertions.checkState((this.formats != null ? 1 : 0) != 0);
            Assertions.checkState((this.chunkStartTimes != null ? 1 : 0) != 0);
            Assertions.checkState((chunkIndex < this.chunkStartTimes.size() ? 1 : 0) != 0);
            String bitrateString = Integer.toString(this.formats[track].bitrate);
            String startTimeString = this.chunkStartTimes.get(chunkIndex).toString();
            String chunkUrl = this.chunkTemplate.replace(URL_PLACEHOLDER_BITRATE_1, bitrateString).replace(URL_PLACEHOLDER_BITRATE_2, bitrateString).replace(URL_PLACEHOLDER_START_TIME_1, startTimeString).replace(URL_PLACEHOLDER_START_TIME_2, startTimeString);
            return UriUtil.resolveToUri((String)this.baseUri, (String)chunkUrl);
        }
    }

    public static class ProtectionElement {
        public final UUID uuid;
        public final byte[] data;
        public final TrackEncryptionBox[] trackEncryptionBoxes;

        public ProtectionElement(UUID uuid, byte[] data, TrackEncryptionBox[] trackEncryptionBoxes) {
            this.uuid = uuid;
            this.data = data;
            this.trackEncryptionBoxes = trackEncryptionBoxes;
        }
    }
}

