/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp.reader;

import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.rtsp.RtpPacket;
import com.google.android.exoplayer2.source.rtsp.RtpPayloadFormat;
import com.google.android.exoplayer2.source.rtsp.reader.RtpPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class RtpVp9Reader
implements RtpPayloadReader {
    private static final String TAG = "RtpVp9Reader";
    private static final long MEDIA_CLOCK_FREQUENCY = 90000L;
    private static final int SCALABILITY_STRUCTURE_SIZE = 4;
    private final RtpPayloadFormat payloadFormat;
    private @MonotonicNonNull TrackOutput trackOutput;
    private long firstReceivedTimestamp;
    private long startTimeOffsetUs;
    private int previousSequenceNumber;
    private int fragmentedSampleSizeBytes;
    private int width;
    private int height;
    private boolean gotFirstPacketOfVP9Frame;
    private boolean reportedOutputFormat;

    public RtpVp9Reader(RtpPayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
        this.firstReceivedTimestamp = -9223372036854775807L;
        this.startTimeOffsetUs = 0L;
        this.previousSequenceNumber = -1;
        this.width = -1;
        this.height = -1;
        this.gotFirstPacketOfVP9Frame = false;
        this.reportedOutputFormat = false;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, int trackId) {
        this.trackOutput = extractorOutput.track(trackId, 2);
        this.trackOutput.format(this.payloadFormat.format);
    }

    @Override
    public void onReceivingFirstPacket(long timestamp, int sequenceNumber) {
    }

    @Override
    public void consume(ParsableByteArray data, long timestamp, int sequenceNumber, boolean rtpMarker) {
        Assertions.checkStateNotNull((Object)this.trackOutput);
        if (this.validateVp9Descriptor(data, sequenceNumber)) {
            int bufferFlags = 0;
            if (this.fragmentedSampleSizeBytes == 0 && this.gotFirstPacketOfVP9Frame && (data.peekUnsignedByte() & 4) == 0) {
                bufferFlags = 1;
            }
            if (!this.reportedOutputFormat && this.width != -1 && this.height != -1) {
                if (this.width != this.payloadFormat.format.width || this.height != this.payloadFormat.format.height) {
                    this.trackOutput.format(this.payloadFormat.format.buildUpon().setWidth(this.width).setHeight(this.height).build());
                }
                this.reportedOutputFormat = true;
            }
            int currentFragmentSizeBytes = data.bytesLeft();
            this.trackOutput.sampleData(data, currentFragmentSizeBytes);
            this.fragmentedSampleSizeBytes += currentFragmentSizeBytes;
            if (rtpMarker) {
                if (this.firstReceivedTimestamp == -9223372036854775807L) {
                    this.firstReceivedTimestamp = timestamp;
                }
                long timeUs = RtpVp9Reader.toSampleUs(this.startTimeOffsetUs, timestamp, this.firstReceivedTimestamp);
                this.trackOutput.sampleMetadata(timeUs, bufferFlags, this.fragmentedSampleSizeBytes, 0, null);
                this.fragmentedSampleSizeBytes = 0;
                this.gotFirstPacketOfVP9Frame = false;
            }
            this.previousSequenceNumber = sequenceNumber;
        }
    }

    @Override
    public void seek(long nextRtpTimestamp, long timeUs) {
        this.firstReceivedTimestamp = nextRtpTimestamp;
        this.fragmentedSampleSizeBytes = 0;
        this.startTimeOffsetUs = timeUs;
    }

    private boolean validateVp9Descriptor(ParsableByteArray payload, int packetSequenceNumber) {
        int optionalHeader;
        int header = payload.readUnsignedByte();
        if (!this.gotFirstPacketOfVP9Frame) {
            if ((header & 8) == 0) {
                Log.w((String)TAG, (String)"First payload octet of the RTP packet is not the beginning of a new VP9 partition, Dropping current packet.");
                return false;
            }
            this.gotFirstPacketOfVP9Frame = true;
        } else {
            int expectedSequenceNumber = RtpPacket.getNextSequenceNumber(this.previousSequenceNumber);
            if (packetSequenceNumber != expectedSequenceNumber) {
                Log.w((String)TAG, (String)Util.formatInvariant((String)"Received RTP packet with unexpected sequence number. Expected: %d; received: %d. Dropping packet.", (Object[])new Object[]{expectedSequenceNumber, packetSequenceNumber}));
                return false;
            }
        }
        if ((header & 0x80) != 0 && ((optionalHeader = payload.readUnsignedByte()) & 0x80) != 0 && payload.bytesLeft() < 1) {
            return false;
        }
        Assertions.checkArgument(((header & 0x10) == 0 ? 1 : 0) != 0, (Object)"VP9 flexible mode is not supported.");
        if ((header & 0x20) != 0) {
            payload.skipBytes(1);
            if (payload.bytesLeft() < 1) {
                return false;
            }
            if ((header & 0x10) == 0) {
                payload.skipBytes(1);
            }
        }
        if ((header & 2) != 0) {
            int scalabilityStructure = payload.readUnsignedByte();
            int spatialLayersCount = scalabilityStructure >> 5 & 7;
            if ((scalabilityStructure & 0x10) != 0) {
                int scalabilityStructureCount = spatialLayersCount + 1;
                if (payload.bytesLeft() < scalabilityStructureCount * 4) {
                    return false;
                }
                for (int index = 0; index < scalabilityStructureCount; ++index) {
                    this.width = payload.readUnsignedShort();
                    this.height = payload.readUnsignedShort();
                }
            }
            if ((scalabilityStructure & 8) != 0) {
                int numOfPicInPictureGroup = payload.readUnsignedByte();
                if (payload.bytesLeft() < numOfPicInPictureGroup) {
                    return false;
                }
                for (int picIndex = 0; picIndex < numOfPicInPictureGroup; ++picIndex) {
                    int picture = payload.readUnsignedShort();
                    int referenceIndices = (picture & 0xC) >> 2;
                    if (payload.bytesLeft() < referenceIndices) {
                        return false;
                    }
                    payload.skipBytes(referenceIndices);
                }
            }
        }
        return true;
    }

    private static long toSampleUs(long startTimeOffsetUs, long rtpTimestamp, long firstReceivedRtpTimestamp) {
        return startTimeOffsetUs + Util.scaleLargeTimestamp((long)(rtpTimestamp - firstReceivedRtpTimestamp), (long)1000000L, (long)90000L);
    }
}

