/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp.reader;

import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.rtsp.RtpPacket;
import com.google.android.exoplayer2.source.rtsp.RtpPayloadFormat;
import com.google.android.exoplayer2.source.rtsp.reader.RtpPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class RtpVp8Reader
implements RtpPayloadReader {
    private static final String TAG = "RtpVP8Reader";
    private static final long MEDIA_CLOCK_FREQUENCY = 90000L;
    private final RtpPayloadFormat payloadFormat;
    private @MonotonicNonNull TrackOutput trackOutput;
    private long firstReceivedTimestamp;
    private int previousSequenceNumber;
    private int fragmentedSampleSizeBytes;
    private long startTimeOffsetUs;
    private boolean gotFirstPacketOfVp8Frame;
    private boolean isKeyFrame;
    private boolean isOutputFormatSet;

    public RtpVp8Reader(RtpPayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
        this.firstReceivedTimestamp = -9223372036854775807L;
        this.previousSequenceNumber = -1;
        this.fragmentedSampleSizeBytes = -1;
        this.startTimeOffsetUs = 0L;
        this.gotFirstPacketOfVp8Frame = false;
        this.isKeyFrame = false;
        this.isOutputFormatSet = false;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, int trackId) {
        this.trackOutput = extractorOutput.track(trackId, 2);
        this.trackOutput.format(this.payloadFormat.format);
    }

    @Override
    public void onReceivingFirstPacket(long timestamp, int sequenceNumber) {
    }

    @Override
    public void consume(ParsableByteArray data, long timestamp, int sequenceNumber, boolean rtpMarker) {
        Assertions.checkStateNotNull((Object)this.trackOutput);
        boolean isValidVP8Descriptor = this.validateVp8Descriptor(data, sequenceNumber);
        if (isValidVP8Descriptor) {
            if (this.fragmentedSampleSizeBytes == -1 && this.gotFirstPacketOfVp8Frame) {
                boolean bl = this.isKeyFrame = (data.peekUnsignedByte() & 1) == 0;
            }
            if (!this.isOutputFormatSet) {
                int currPosition = data.getPosition();
                data.setPosition(currPosition + 6);
                int width = data.readLittleEndianUnsignedShort() & 0x3FFF;
                int height = data.readLittleEndianUnsignedShort() & 0x3FFF;
                data.setPosition(currPosition);
                if (width != this.payloadFormat.format.width || height != this.payloadFormat.format.height) {
                    this.trackOutput.format(this.payloadFormat.format.buildUpon().setWidth(width).setHeight(height).build());
                }
                this.isOutputFormatSet = true;
            }
            int fragmentSize = data.bytesLeft();
            this.trackOutput.sampleData(data, fragmentSize);
            this.fragmentedSampleSizeBytes += fragmentSize;
            if (rtpMarker) {
                if (this.firstReceivedTimestamp == -9223372036854775807L) {
                    this.firstReceivedTimestamp = timestamp;
                }
                long timeUs = RtpVp8Reader.toSampleUs(this.startTimeOffsetUs, timestamp, this.firstReceivedTimestamp);
                this.trackOutput.sampleMetadata(timeUs, this.isKeyFrame ? 1 : 0, this.fragmentedSampleSizeBytes, 0, null);
                this.fragmentedSampleSizeBytes = -1;
                this.gotFirstPacketOfVp8Frame = false;
            }
            this.previousSequenceNumber = sequenceNumber;
        }
    }

    @Override
    public void seek(long nextRtpTimestamp, long timeUs) {
        this.firstReceivedTimestamp = nextRtpTimestamp;
        this.fragmentedSampleSizeBytes = -1;
        this.startTimeOffsetUs = timeUs;
    }

    private boolean validateVp8Descriptor(ParsableByteArray payload, int packetSequenceNumber) {
        int header = payload.readUnsignedByte();
        if (!this.gotFirstPacketOfVp8Frame) {
            if ((header & 0x10) != 1 || (header & 7) != 0) {
                Log.w((String)TAG, (String)"RTP packet is not the start of a new VP8 partition, skipping.");
                return false;
            }
            this.gotFirstPacketOfVp8Frame = true;
        } else {
            int expectedSequenceNumber = RtpPacket.getNextSequenceNumber(this.previousSequenceNumber);
            if (packetSequenceNumber != expectedSequenceNumber) {
                Log.w((String)TAG, (String)Util.formatInvariant((String)"Received RTP packet with unexpected sequence number. Expected: %d; received: %d. Dropping packet.", (Object[])new Object[]{expectedSequenceNumber, packetSequenceNumber}));
                return false;
            }
        }
        if ((header & 0x80) != 0) {
            int iHeader;
            int xHeader = payload.readUnsignedByte();
            if ((xHeader & 0x80) != 0 && ((iHeader = payload.readUnsignedByte()) & 0x80) != 0) {
                payload.skipBytes(1);
            }
            if ((xHeader & 0x40) != 0) {
                payload.skipBytes(1);
            }
            if ((xHeader & 0x20) != 0 || (xHeader & 0x10) != 0) {
                payload.skipBytes(1);
            }
        }
        return true;
    }

    private static long toSampleUs(long startTimeOffsetUs, long rtpTimestamp, long firstReceivedRtpTimestamp) {
        return startTimeOffsetUs + Util.scaleLargeTimestamp((long)(rtpTimestamp - firstReceivedRtpTimestamp), (long)1000000L, (long)90000L);
    }
}

