/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp.reader;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.audio.OpusUtil;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.rtsp.RtpPacket;
import com.google.android.exoplayer2.source.rtsp.RtpPayloadFormat;
import com.google.android.exoplayer2.source.rtsp.reader.RtpPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class RtpOpusReader
implements RtpPayloadReader {
    private static final String TAG = "RtpOpusReader";
    private static final long MEDIA_CLOCK_FREQUENCY = 48000L;
    private final RtpPayloadFormat payloadFormat;
    private @MonotonicNonNull TrackOutput trackOutput;
    private long firstReceivedTimestamp;
    private long startTimeOffsetUs;
    private int previousSequenceNumber;
    private boolean foundOpusIDHeader;
    private boolean foundOpusCommentHeader;

    public RtpOpusReader(RtpPayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
        this.firstReceivedTimestamp = -1L;
        this.previousSequenceNumber = -1;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, int trackId) {
        this.trackOutput = extractorOutput.track(trackId, 1);
        this.trackOutput.format(this.payloadFormat.format);
    }

    @Override
    public void onReceivingFirstPacket(long timestamp, int sequenceNumber) {
        this.firstReceivedTimestamp = timestamp;
    }

    @Override
    public void consume(ParsableByteArray data, long timestamp, int sequenceNumber, boolean rtpMarker) {
        Assertions.checkStateNotNull((Object)this.trackOutput);
        if (!this.foundOpusIDHeader) {
            RtpOpusReader.validateOpusIdHeader(data);
            List initializationData = OpusUtil.buildInitializationData((byte[])data.getData());
            Format.Builder formatBuilder = this.payloadFormat.format.buildUpon();
            formatBuilder.setInitializationData(initializationData);
            this.trackOutput.format(formatBuilder.build());
            this.foundOpusIDHeader = true;
        } else if (!this.foundOpusCommentHeader) {
            int sampleSize = data.limit();
            Assertions.checkArgument((sampleSize >= 8 ? 1 : 0) != 0, (Object)"Comment Header has insufficient data");
            String header = data.readString(8);
            Assertions.checkArgument((boolean)header.equals("OpusTags"), (Object)"Comment Header should follow ID Header");
            this.foundOpusCommentHeader = true;
        } else {
            int expectedSequenceNumber = RtpPacket.getNextSequenceNumber(this.previousSequenceNumber);
            if (sequenceNumber != expectedSequenceNumber) {
                Log.w((String)TAG, (String)Util.formatInvariant((String)"Received RTP packet with unexpected sequence number. Expected: %d; received: %d.", (Object[])new Object[]{expectedSequenceNumber, sequenceNumber}));
            }
            int size = data.bytesLeft();
            this.trackOutput.sampleData(data, size);
            long timeUs = RtpOpusReader.toSampleTimeUs(this.startTimeOffsetUs, timestamp, this.firstReceivedTimestamp);
            this.trackOutput.sampleMetadata(timeUs, 1, size, 0, null);
        }
        this.previousSequenceNumber = sequenceNumber;
    }

    @Override
    public void seek(long nextRtpTimestamp, long timeUs) {
        this.firstReceivedTimestamp = nextRtpTimestamp;
        this.startTimeOffsetUs = timeUs;
    }

    private static void validateOpusIdHeader(ParsableByteArray data) {
        int currPosition = data.getPosition();
        int sampleSize = data.limit();
        Assertions.checkArgument((sampleSize > 18 ? 1 : 0) != 0, (Object)"ID Header has insufficient data");
        String header = data.readString(8);
        Assertions.checkArgument((boolean)header.equals("OpusHead"), (Object)"ID Header missing");
        Assertions.checkArgument((data.readUnsignedByte() == 1 ? 1 : 0) != 0, (Object)"version number must always be 1");
        data.setPosition(currPosition);
    }

    private static long toSampleTimeUs(long startTimeOffsetUs, long rtpTimestamp, long firstReceivedRtpTimestamp) {
        return startTimeOffsetUs + Util.scaleLargeTimestamp((long)(rtpTimestamp - firstReceivedRtpTimestamp), (long)1000000L, (long)48000L);
    }
}

