/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp.reader;

import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.rtsp.RtpPayloadFormat;
import com.google.android.exoplayer2.source.rtsp.reader.RtpPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

final class RtpH265Reader
implements RtpPayloadReader {
    private static final String TAG = "RtpH265Reader";
    private static final long MEDIA_CLOCK_FREQUENCY = 90000L;
    private static final int FU_PAYLOAD_OFFSET = 3;
    private static final int RTP_PACKET_TYPE_AP = 48;
    private static final int RTP_PACKET_TYPE_FU = 49;
    private static final int NAL_IDR_W_RADL = 19;
    private static final int NAL_IDR_N_LP = 20;
    private final ParsableByteArray fuScratchBuffer = new ParsableByteArray();
    private final ParsableByteArray nalStartCodeArray = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
    private final RtpPayloadFormat payloadFormat;
    private @MonotonicNonNull TrackOutput trackOutput;
    private int bufferFlags;
    private long firstReceivedTimestamp;
    private int previousSequenceNumber;
    private int fragmentedSampleSizeBytes;
    private long startTimeOffsetUs;

    public RtpH265Reader(RtpPayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
        this.firstReceivedTimestamp = -9223372036854775807L;
        this.previousSequenceNumber = -1;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, int trackId) {
        this.trackOutput = extractorOutput.track(trackId, 2);
        this.trackOutput.format(this.payloadFormat.format);
    }

    @Override
    public void onReceivingFirstPacket(long timestamp, int sequenceNumber) {
    }

    @Override
    public void consume(ParsableByteArray data, long timestamp, int sequenceNumber, boolean rtpMarker) throws ParserException {
        if (data.getData().length == 0) {
            throw ParserException.createForMalformedManifest((String)"Empty RTP data packet.", null);
        }
        int payloadType = data.getData()[0] >> 1 & 0x3F;
        Assertions.checkStateNotNull((Object)this.trackOutput);
        if (payloadType >= 0 && payloadType < 48) {
            this.processSingleNalUnitPacket(data);
        } else {
            if (payloadType == 48) {
                throw new UnsupportedOperationException("need to implement processAggregationPacket");
            }
            if (payloadType == 49) {
                this.processFragmentationUnitPacket(data, sequenceNumber);
            } else {
                throw ParserException.createForMalformedManifest((String)String.format("RTP H265 payload type [%d] not supported.", payloadType), null);
            }
        }
        if (rtpMarker) {
            if (this.firstReceivedTimestamp == -9223372036854775807L) {
                this.firstReceivedTimestamp = timestamp;
            }
            long timeUs = RtpH265Reader.toSampleUs(this.startTimeOffsetUs, timestamp, this.firstReceivedTimestamp);
            this.trackOutput.sampleMetadata(timeUs, this.bufferFlags, this.fragmentedSampleSizeBytes, 0, null);
            this.fragmentedSampleSizeBytes = 0;
        }
        this.previousSequenceNumber = sequenceNumber;
    }

    @Override
    public void seek(long nextRtpTimestamp, long timeUs) {
        this.firstReceivedTimestamp = nextRtpTimestamp;
        this.fragmentedSampleSizeBytes = 0;
        this.startTimeOffsetUs = timeUs;
    }

    @RequiresNonNull(value={"trackOutput"})
    private void processSingleNalUnitPacket(ParsableByteArray data) {
        int numBytesInData = data.bytesLeft();
        this.fragmentedSampleSizeBytes += this.writeStartCode();
        this.trackOutput.sampleData(data, numBytesInData);
        this.fragmentedSampleSizeBytes += numBytesInData;
        int nalHeaderType = data.getData()[0] >> 1 & 0x3F;
        this.bufferFlags = RtpH265Reader.getBufferFlagsFromNalType(nalHeaderType);
    }

    @RequiresNonNull(value={"trackOutput"})
    private void processFragmentationUnitPacket(ParsableByteArray data, int packetSequenceNumber) throws ParserException {
        boolean isLastFuPacket;
        if (data.getData().length < 3) {
            throw ParserException.createForMalformedManifest((String)"Malformed FU header.", null);
        }
        int tid = data.getData()[1] & 7;
        byte fuHeader = data.getData()[2];
        int nalUnitType = fuHeader & 0x3F;
        boolean isFirstFuPacket = (fuHeader & 0x80) > 0;
        boolean bl = isLastFuPacket = (fuHeader & 0x40) > 0;
        if (isFirstFuPacket) {
            this.fragmentedSampleSizeBytes += this.writeStartCode();
            data.getData()[1] = (byte)(nalUnitType << 1 & 0x7F);
            data.getData()[2] = (byte)tid;
            this.fuScratchBuffer.reset(data.getData());
            this.fuScratchBuffer.setPosition(1);
        } else {
            int expectedSequenceNumber = (this.previousSequenceNumber + 1) % 65535;
            if (packetSequenceNumber != expectedSequenceNumber) {
                Log.w((String)TAG, (String)Util.formatInvariant((String)"Received RTP packet with unexpected sequence number. Expected: %d; received: %d. Dropping packet.", (Object[])new Object[]{expectedSequenceNumber, packetSequenceNumber}));
                return;
            }
            this.fuScratchBuffer.reset(data.getData());
            this.fuScratchBuffer.setPosition(3);
        }
        int fragmentSize = this.fuScratchBuffer.bytesLeft();
        this.trackOutput.sampleData(this.fuScratchBuffer, fragmentSize);
        this.fragmentedSampleSizeBytes += fragmentSize;
        if (isLastFuPacket) {
            this.bufferFlags = RtpH265Reader.getBufferFlagsFromNalType(nalUnitType);
        }
    }

    private int writeStartCode() {
        this.nalStartCodeArray.setPosition(0);
        int bytesWritten = this.nalStartCodeArray.bytesLeft();
        ((TrackOutput)Assertions.checkNotNull((Object)this.trackOutput)).sampleData(this.nalStartCodeArray, bytesWritten);
        return bytesWritten;
    }

    private static long toSampleUs(long startTimeOffsetUs, long rtpTimestamp, long firstReceivedRtpTimestamp) {
        return startTimeOffsetUs + Util.scaleLargeTimestamp((long)(rtpTimestamp - firstReceivedRtpTimestamp), (long)1000000L, (long)90000L);
    }

    private static int getBufferFlagsFromNalType(int nalType) {
        return nalType == 19 || nalType == 20 ? 1 : 0;
    }
}

