/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp.reader;

import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.rtsp.RtpPacket;
import com.google.android.exoplayer2.source.rtsp.RtpPayloadFormat;
import com.google.android.exoplayer2.source.rtsp.reader.RtpPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class RtpH263Reader
implements RtpPayloadReader {
    private static final String TAG = "RtpH263Reader";
    private static final long MEDIA_CLOCK_FREQUENCY = 90000L;
    private static final int I_VOP = 0;
    private static final int PICTURE_START_CODE = 128;
    private final RtpPayloadFormat payloadFormat;
    private @MonotonicNonNull TrackOutput trackOutput;
    private long firstReceivedTimestamp;
    private int fragmentedSampleSizeBytes;
    private int previousSequenceNumber;
    private int width;
    private int height;
    private boolean isKeyFrame;
    private boolean isOutputFormatSet;
    private long startTimeOffsetUs;

    public RtpH263Reader(RtpPayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
        this.firstReceivedTimestamp = -9223372036854775807L;
        this.previousSequenceNumber = -1;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, int trackId) {
        this.trackOutput = extractorOutput.track(trackId, 2);
        this.trackOutput.format(this.payloadFormat.format);
    }

    @Override
    public void onReceivingFirstPacket(long timestamp, int sequenceNumber) {
    }

    @Override
    public void consume(ParsableByteArray data, long timestamp, int sequenceNumber, boolean rtpMarker) {
        boolean pBitIsSet;
        Assertions.checkStateNotNull((Object)this.trackOutput);
        int currentPosition = data.getPosition();
        int header = data.readUnsignedShort();
        boolean bl = pBitIsSet = (header & 0x400) > 0;
        if ((header & 0x200) != 0 || (header & 0x1F8) != 0 || (header & 7) != 0) {
            Log.w((String)TAG, (String)"Dropping packet: video reduncancy coding is not supported, packet header VRC, or PLEN or PEBIT is non-zero");
            return;
        }
        if (pBitIsSet) {
            int payloadStartCode = data.peekUnsignedByte() & 0xFC;
            if (payloadStartCode < 128) {
                Log.w((String)TAG, (String)"Picture start Code (PSC) missing, dropping packet.");
                return;
            }
            data.getData()[currentPosition] = 0;
            data.getData()[currentPosition + 1] = 0;
            data.setPosition(currentPosition);
        } else {
            int expectedSequenceNumber = RtpPacket.getNextSequenceNumber(this.previousSequenceNumber);
            if (sequenceNumber != expectedSequenceNumber) {
                Log.w((String)TAG, (String)Util.formatInvariant((String)"Received RTP packet with unexpected sequence number. Expected: %d; received: %d. Dropping packet.", (Object[])new Object[]{expectedSequenceNumber, sequenceNumber}));
                return;
            }
        }
        if (this.fragmentedSampleSizeBytes == 0) {
            this.parseVopHeader(data, this.isOutputFormatSet);
            if (!this.isOutputFormatSet && this.isKeyFrame) {
                if (this.width != this.payloadFormat.format.width || this.height != this.payloadFormat.format.height) {
                    this.trackOutput.format(this.payloadFormat.format.buildUpon().setWidth(this.width).setHeight(this.height).build());
                }
                this.isOutputFormatSet = true;
            }
        }
        int fragmentSize = data.bytesLeft();
        this.trackOutput.sampleData(data, fragmentSize);
        this.fragmentedSampleSizeBytes += fragmentSize;
        if (rtpMarker) {
            if (this.firstReceivedTimestamp == -9223372036854775807L) {
                this.firstReceivedTimestamp = timestamp;
            }
            long timeUs = RtpH263Reader.toSampleUs(this.startTimeOffsetUs, timestamp, this.firstReceivedTimestamp);
            this.trackOutput.sampleMetadata(timeUs, this.isKeyFrame ? 1 : 0, this.fragmentedSampleSizeBytes, 0, null);
            this.fragmentedSampleSizeBytes = 0;
            this.isKeyFrame = false;
        }
        this.previousSequenceNumber = sequenceNumber;
    }

    @Override
    public void seek(long nextRtpTimestamp, long timeUs) {
        this.firstReceivedTimestamp = nextRtpTimestamp;
        this.fragmentedSampleSizeBytes = 0;
        this.startTimeOffsetUs = timeUs;
    }

    private void parseVopHeader(ParsableByteArray data, boolean gotResolution) {
        int currentPosition = data.getPosition();
        long shortVideoHeader = data.readUnsignedInt();
        if ((shortVideoHeader >> 10 & 0x3FL) == 32L) {
            int header = data.peekUnsignedByte();
            int vopType = header >> 1 & 1;
            if (!gotResolution && vopType == 0) {
                int sourceFormat = header >> 2 & 7;
                if (sourceFormat == 1) {
                    this.width = 128;
                    this.height = 96;
                } else {
                    this.width = 176 << sourceFormat - 2;
                    this.height = 144 << sourceFormat - 2;
                }
            }
            data.setPosition(currentPosition);
            this.isKeyFrame = vopType == 0;
            return;
        }
        data.setPosition(currentPosition);
        this.isKeyFrame = false;
    }

    private static long toSampleUs(long startTimeOffsetUs, long rtpTimestamp, long firstReceivedRtpTimestamp) {
        return startTimeOffsetUs + Util.scaleLargeTimestamp((long)(rtpTimestamp - firstReceivedRtpTimestamp), (long)1000000L, (long)90000L);
    }
}

