/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp.reader;

import com.google.android.exoplayer2.audio.Ac3Util;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.rtsp.RtpPayloadFormat;
import com.google.android.exoplayer2.source.rtsp.reader.RtpPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class RtpAc3Reader
implements RtpPayloadReader {
    private static final int AC3_FRAME_TYPE_COMPLETE_FRAME = 0;
    private static final int AC3_FRAME_TYPE_INITIAL_FRAGMENT_A = 1;
    private static final int AC3_FRAME_TYPE_INITIAL_FRAGMENT_B = 2;
    private static final int AC3_FRAME_TYPE_NON_INITIAL_FRAGMENT = 3;
    private static final int AC3_PAYLOAD_HEADER_SIZE = 2;
    private final RtpPayloadFormat payloadFormat;
    private final ParsableBitArray scratchBitBuffer;
    private @MonotonicNonNull TrackOutput trackOutput;
    private int numBytesPendingMetadataOutput;
    private long firstReceivedTimestamp;
    private long sampleTimeUsOfFramePendingMetadataOutput;
    private long startTimeOffsetUs;

    public RtpAc3Reader(RtpPayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
        this.scratchBitBuffer = new ParsableBitArray();
        this.firstReceivedTimestamp = -9223372036854775807L;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, int trackId) {
        this.trackOutput = extractorOutput.track(trackId, 1);
        this.trackOutput.format(this.payloadFormat.format);
    }

    @Override
    public void onReceivingFirstPacket(long timestamp, int sequenceNumber) {
        Assertions.checkState((this.firstReceivedTimestamp == -9223372036854775807L ? 1 : 0) != 0);
        this.firstReceivedTimestamp = timestamp;
    }

    @Override
    public void consume(ParsableByteArray data, long timestamp, int sequenceNumber, boolean rtpMarker) {
        int frameType = data.readUnsignedByte() & 3;
        int numOfFrames = data.readUnsignedByte() & 0xFF;
        long sampleTimeUs = RtpAc3Reader.toSampleTimeUs(this.startTimeOffsetUs, timestamp, this.firstReceivedTimestamp, this.payloadFormat.clockRate);
        switch (frameType) {
            case 0: {
                this.maybeOutputSampleMetadata();
                if (numOfFrames == 1) {
                    this.processSingleFramePacket(data, sampleTimeUs);
                    break;
                }
                this.processMultiFramePacket(data, numOfFrames, sampleTimeUs);
                break;
            }
            case 1: 
            case 2: {
                this.maybeOutputSampleMetadata();
            }
            case 3: {
                this.processFragmentedPacket(data, rtpMarker, frameType, sampleTimeUs);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(frameType));
            }
        }
    }

    @Override
    public void seek(long nextRtpTimestamp, long timeUs) {
        this.firstReceivedTimestamp = nextRtpTimestamp;
        this.startTimeOffsetUs = timeUs;
    }

    private void processSingleFramePacket(ParsableByteArray data, long sampleTimeUs) {
        int frameSize = data.bytesLeft();
        ((TrackOutput)Assertions.checkNotNull((Object)this.trackOutput)).sampleData(data, frameSize);
        ((TrackOutput)Util.castNonNull((Object)this.trackOutput)).sampleMetadata(sampleTimeUs, 1, frameSize, 0, null);
    }

    private void processMultiFramePacket(ParsableByteArray data, int numOfFrames, long sampleTimeUs) {
        this.scratchBitBuffer.reset(data.getData());
        this.scratchBitBuffer.skipBytes(2);
        for (int i = 0; i < numOfFrames; ++i) {
            Ac3Util.SyncFrameInfo frameInfo = Ac3Util.parseAc3SyncframeInfo((ParsableBitArray)this.scratchBitBuffer);
            ((TrackOutput)Assertions.checkNotNull((Object)this.trackOutput)).sampleData(data, frameInfo.frameSize);
            ((TrackOutput)Util.castNonNull((Object)this.trackOutput)).sampleMetadata(sampleTimeUs, 1, frameInfo.frameSize, 0, null);
            sampleTimeUs += (long)(frameInfo.sampleCount / frameInfo.sampleRate) * 1000000L;
            this.scratchBitBuffer.skipBytes(frameInfo.frameSize);
        }
    }

    private void processFragmentedPacket(ParsableByteArray data, boolean isFrameBoundary, int frameType, long sampleTimeUs) {
        int bytesToWrite = data.bytesLeft();
        ((TrackOutput)Assertions.checkNotNull((Object)this.trackOutput)).sampleData(data, bytesToWrite);
        this.numBytesPendingMetadataOutput += bytesToWrite;
        this.sampleTimeUsOfFramePendingMetadataOutput = sampleTimeUs;
        if (isFrameBoundary && frameType == 3) {
            this.outputSampleMetadataForFragmentedPackets();
        }
    }

    private void maybeOutputSampleMetadata() {
        if (this.numBytesPendingMetadataOutput > 0) {
            this.outputSampleMetadataForFragmentedPackets();
        }
    }

    private void outputSampleMetadataForFragmentedPackets() {
        ((TrackOutput)Util.castNonNull((Object)this.trackOutput)).sampleMetadata(this.sampleTimeUsOfFramePendingMetadataOutput, 1, this.numBytesPendingMetadataOutput, 0, null);
        this.numBytesPendingMetadataOutput = 0;
    }

    private static long toSampleTimeUs(long startTimeOffsetUs, long rtpTimestamp, long firstReceivedRtpTimestamp, int sampleRate) {
        return startTimeOffsetUs + Util.scaleLargeTimestamp((long)(rtpTimestamp - firstReceivedRtpTimestamp), (long)1000000L, (long)sampleRate);
    }
}

