/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp.reader;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.source.rtsp.RtpPayloadFormat;
import com.google.android.exoplayer2.source.rtsp.reader.RtpAacReader;
import com.google.android.exoplayer2.source.rtsp.reader.RtpAc3Reader;
import com.google.android.exoplayer2.source.rtsp.reader.RtpAmrReader;
import com.google.android.exoplayer2.source.rtsp.reader.RtpH263Reader;
import com.google.android.exoplayer2.source.rtsp.reader.RtpH264Reader;
import com.google.android.exoplayer2.source.rtsp.reader.RtpH265Reader;
import com.google.android.exoplayer2.source.rtsp.reader.RtpMpeg4Reader;
import com.google.android.exoplayer2.source.rtsp.reader.RtpOpusReader;
import com.google.android.exoplayer2.source.rtsp.reader.RtpPayloadReader;
import com.google.android.exoplayer2.source.rtsp.reader.RtpPcmReader;
import com.google.android.exoplayer2.source.rtsp.reader.RtpVp8Reader;
import com.google.android.exoplayer2.source.rtsp.reader.RtpVp9Reader;
import com.google.android.exoplayer2.util.Assertions;

public final class DefaultRtpPayloadReaderFactory
implements RtpPayloadReader.Factory {
    @Override
    @Nullable
    public RtpPayloadReader createPayloadReader(RtpPayloadFormat payloadFormat) {
        switch ((String)Assertions.checkNotNull((Object)payloadFormat.format.sampleMimeType)) {
            case "audio/ac3": {
                return new RtpAc3Reader(payloadFormat);
            }
            case "audio/mp4a-latm": {
                return new RtpAacReader(payloadFormat);
            }
            case "audio/3gpp": 
            case "audio/amr-wb": {
                return new RtpAmrReader(payloadFormat);
            }
            case "audio/opus": {
                return new RtpOpusReader(payloadFormat);
            }
            case "audio/raw": 
            case "audio/g711-alaw": 
            case "audio/g711-mlaw": {
                return new RtpPcmReader(payloadFormat);
            }
            case "video/3gpp": {
                return new RtpH263Reader(payloadFormat);
            }
            case "video/avc": {
                return new RtpH264Reader(payloadFormat);
            }
            case "video/hevc": {
                return new RtpH265Reader(payloadFormat);
            }
            case "video/mp4v-es": {
                return new RtpMpeg4Reader(payloadFormat);
            }
            case "video/x-vnd.on2.vp8": {
                return new RtpVp8Reader(payloadFormat);
            }
            case "video/x-vnd.on2.vp9": {
                return new RtpVp9Reader(payloadFormat);
            }
        }
        return null;
    }
}

