/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.source.rtsp.RtpDataChannel;
import com.google.android.exoplayer2.source.rtsp.RtspMessageChannel;
import com.google.android.exoplayer2.upstream.BaseDataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

final class TransferRtpDataChannel
extends BaseDataSource
implements RtpDataChannel,
RtspMessageChannel.InterleavedBinaryDataListener {
    private static final String DEFAULT_TCP_TRANSPORT_FORMAT = "RTP/AVP/TCP;unicast;interleaved=%d-%d";
    private final LinkedBlockingQueue<byte[]> packetQueue;
    private final long pollTimeoutMs;
    private byte[] unreadData;
    private int channelNumber;

    public TransferRtpDataChannel(long pollTimeoutMs) {
        super(true);
        this.pollTimeoutMs = pollTimeoutMs;
        this.packetQueue = new LinkedBlockingQueue();
        this.unreadData = new byte[0];
        this.channelNumber = -1;
    }

    @Override
    public String getTransport() {
        Assertions.checkState((this.channelNumber != -1 ? 1 : 0) != 0);
        return Util.formatInvariant((String)DEFAULT_TCP_TRANSPORT_FORMAT, (Object[])new Object[]{this.channelNumber, this.channelNumber + 1});
    }

    @Override
    public int getLocalPort() {
        return this.channelNumber;
    }

    @Override
    public RtspMessageChannel.InterleavedBinaryDataListener getInterleavedBinaryDataListener() {
        return this;
    }

    public long open(DataSpec dataSpec) {
        this.channelNumber = dataSpec.uri.getPort();
        return -1L;
    }

    public void close() {
    }

    @Nullable
    public Uri getUri() {
        return null;
    }

    public int read(byte[] buffer, int offset, int length) {
        byte[] data;
        if (length == 0) {
            return 0;
        }
        int bytesRead = 0;
        int bytesToRead = Math.min(length, this.unreadData.length);
        System.arraycopy(this.unreadData, 0, buffer, offset, bytesToRead);
        this.unreadData = Arrays.copyOfRange(this.unreadData, bytesToRead, this.unreadData.length);
        if ((bytesRead += bytesToRead) == length) {
            return bytesRead;
        }
        try {
            data = this.packetQueue.poll(this.pollTimeoutMs, TimeUnit.MILLISECONDS);
            if (data == null) {
                return -1;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1;
        }
        bytesToRead = Math.min(length - bytesRead, data.length);
        System.arraycopy(data, 0, buffer, offset + bytesRead, bytesToRead);
        if (bytesToRead < data.length) {
            this.unreadData = Arrays.copyOfRange(data, bytesToRead, data.length);
        }
        return bytesRead + bytesToRead;
    }

    @Override
    public void onInterleavedBinaryDataReceived(byte[] data) {
        this.packetQueue.add(data);
    }
}

