/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp;

import android.net.Uri;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.source.rtsp.MediaDescription;
import com.google.android.exoplayer2.source.rtsp.RtspMessageUtil;
import com.google.android.exoplayer2.source.rtsp.SessionDescription;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SessionDescriptionParser {
    private static final Pattern SDP_LINE_PATTERN = Pattern.compile("([a-z])=\\s?(.+)");
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("([\\x21\\x23-\\x27\\x2a\\x2b\\x2d\\x2e\\x30-\\x39\\x41-\\x5a\\x5e-\\x7e]+)(?::(.*))?");
    private static final Pattern MEDIA_DESCRIPTION_PATTERN = Pattern.compile("(\\S+)\\s(\\S+)\\s(\\S+)\\s(\\S+)");
    private static final String VERSION_TYPE = "v";
    private static final String ORIGIN_TYPE = "o";
    private static final String SESSION_TYPE = "s";
    private static final String INFORMATION_TYPE = "i";
    private static final String URI_TYPE = "u";
    private static final String EMAIL_TYPE = "e";
    private static final String PHONE_NUMBER_TYPE = "p";
    private static final String CONNECTION_TYPE = "c";
    private static final String BANDWIDTH_TYPE = "b";
    private static final String TIMING_TYPE = "t";
    private static final String KEY_TYPE = "k";
    private static final String ATTRIBUTE_TYPE = "a";
    private static final String MEDIA_TYPE = "m";
    private static final String REPEAT_TYPE = "r";
    private static final String ZONE_TYPE = "z";

    public static SessionDescription parse(String sdpString) throws ParserException {
        SessionDescription.Builder sessionDescriptionBuilder = new SessionDescription.Builder();
        MediaDescription.Builder mediaDescriptionBuilder = null;
        block34: for (String line : RtspMessageUtil.splitRtspMessageBody(sdpString)) {
            if ("".equals(line)) continue;
            Matcher matcher = SDP_LINE_PATTERN.matcher(line);
            if (!matcher.matches()) {
                throw ParserException.createForMalformedManifest((String)("Malformed SDP line: " + line), null);
            }
            String sdpType = (String)Assertions.checkNotNull((Object)matcher.group(1));
            String sdpValue = (String)Assertions.checkNotNull((Object)matcher.group(2));
            switch (sdpType) {
                case "v": {
                    if ("0".equals(sdpValue)) continue block34;
                    throw ParserException.createForMalformedManifest((String)String.format("SDP version %s is not supported.", sdpValue), null);
                }
                case "o": {
                    sessionDescriptionBuilder.setOrigin(sdpValue);
                    continue block34;
                }
                case "s": {
                    sessionDescriptionBuilder.setSessionName(sdpValue);
                    continue block34;
                }
                case "i": {
                    if (mediaDescriptionBuilder == null) {
                        sessionDescriptionBuilder.setSessionInfo(sdpValue);
                        continue block34;
                    }
                    mediaDescriptionBuilder.setMediaTitle(sdpValue);
                    continue block34;
                }
                case "u": {
                    sessionDescriptionBuilder.setUri(Uri.parse((String)sdpValue));
                    continue block34;
                }
                case "e": {
                    sessionDescriptionBuilder.setEmailAddress(sdpValue);
                    continue block34;
                }
                case "p": {
                    sessionDescriptionBuilder.setPhoneNumber(sdpValue);
                    continue block34;
                }
                case "c": {
                    if (mediaDescriptionBuilder == null) {
                        sessionDescriptionBuilder.setConnection(sdpValue);
                        continue block34;
                    }
                    mediaDescriptionBuilder.setConnection(sdpValue);
                    continue block34;
                }
                case "b": {
                    String[] bandwidthComponents = Util.split((String)sdpValue, (String)":\\s?");
                    Assertions.checkArgument((bandwidthComponents.length == 2 ? 1 : 0) != 0);
                    int bitrateKbps = Integer.parseInt(bandwidthComponents[1]);
                    if (mediaDescriptionBuilder == null) {
                        sessionDescriptionBuilder.setBitrate(bitrateKbps * 1000);
                        continue block34;
                    }
                    mediaDescriptionBuilder.setBitrate(bitrateKbps * 1000);
                    continue block34;
                }
                case "t": {
                    sessionDescriptionBuilder.setTiming(sdpValue);
                    continue block34;
                }
                case "k": {
                    if (mediaDescriptionBuilder == null) {
                        sessionDescriptionBuilder.setKey(sdpValue);
                        continue block34;
                    }
                    mediaDescriptionBuilder.setKey(sdpValue);
                    continue block34;
                }
                case "a": {
                    matcher = ATTRIBUTE_PATTERN.matcher(sdpValue);
                    if (!matcher.matches()) {
                        throw ParserException.createForMalformedManifest((String)("Malformed Attribute line: " + line), null);
                    }
                    String attributeName = (String)Assertions.checkNotNull((Object)matcher.group(1));
                    String attributeValue = Strings.nullToEmpty((String)matcher.group(2));
                    if (mediaDescriptionBuilder == null) {
                        sessionDescriptionBuilder.addAttribute(attributeName, attributeValue);
                        continue block34;
                    }
                    mediaDescriptionBuilder.addAttribute(attributeName, attributeValue);
                    continue block34;
                }
                case "m": {
                    if (mediaDescriptionBuilder != null) {
                        SessionDescriptionParser.addMediaDescriptionToSession(sessionDescriptionBuilder, mediaDescriptionBuilder);
                    }
                    mediaDescriptionBuilder = SessionDescriptionParser.parseMediaDescriptionLine(sdpValue);
                    continue block34;
                }
            }
        }
        if (mediaDescriptionBuilder != null) {
            SessionDescriptionParser.addMediaDescriptionToSession(sessionDescriptionBuilder, mediaDescriptionBuilder);
        }
        try {
            return sessionDescriptionBuilder.build();
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw ParserException.createForMalformedManifest(null, (Throwable)e);
        }
    }

    private static void addMediaDescriptionToSession(SessionDescription.Builder sessionDescriptionBuilder, MediaDescription.Builder mediaDescriptionBuilder) throws ParserException {
        try {
            sessionDescriptionBuilder.addMediaDescription(mediaDescriptionBuilder.build());
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw ParserException.createForMalformedManifest(null, (Throwable)e);
        }
    }

    private static MediaDescription.Builder parseMediaDescriptionLine(String line) throws ParserException {
        Matcher matcher = MEDIA_DESCRIPTION_PATTERN.matcher(line);
        if (!matcher.matches()) {
            throw ParserException.createForMalformedManifest((String)("Malformed SDP media description line: " + line), null);
        }
        String mediaType = (String)Assertions.checkNotNull((Object)matcher.group(1));
        String portString = (String)Assertions.checkNotNull((Object)matcher.group(2));
        String transportProtocol = (String)Assertions.checkNotNull((Object)matcher.group(3));
        String payloadTypeString = (String)Assertions.checkNotNull((Object)matcher.group(4));
        try {
            return new MediaDescription.Builder(mediaType, Integer.parseInt(portString), transportProtocol, Integer.parseInt(payloadTypeString));
        }
        catch (NumberFormatException e) {
            throw ParserException.createForMalformedManifest((String)("Malformed SDP media description line: " + line), (Throwable)e);
        }
    }

    private SessionDescriptionParser() {
    }
}

