/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp;

import android.net.Uri;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.SampleQueue;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.rtsp.RtpDataChannel;
import com.google.android.exoplayer2.source.rtsp.RtpDataLoadable;
import com.google.android.exoplayer2.source.rtsp.RtspClient;
import com.google.android.exoplayer2.source.rtsp.RtspMediaSource;
import com.google.android.exoplayer2.source.rtsp.RtspMediaTrack;
import com.google.android.exoplayer2.source.rtsp.RtspMessageChannel;
import com.google.android.exoplayer2.source.rtsp.RtspSessionTiming;
import com.google.android.exoplayer2.source.rtsp.RtspTrackTiming;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.net.BindException;
import java.util.ArrayList;
import java.util.List;
import javax.net.SocketFactory;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class RtspMediaPeriod
implements MediaPeriod {
    private static final int PORT_BINDING_MAX_RETRY_COUNT = 3;
    private final Allocator allocator;
    private final Handler handler;
    private final InternalListener internalListener;
    private final RtspClient rtspClient;
    private final List<RtspLoaderWrapper> rtspLoaderWrappers;
    private final List<RtpLoadInfo> selectedLoadInfos;
    private final Listener listener;
    private final RtpDataChannel.Factory rtpDataChannelFactory;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @MonotonicNonNull MediaPeriod.Callback callback;
    private @MonotonicNonNull ImmutableList<TrackGroup> trackGroups;
    @Nullable
    private IOException preparationError;
    @Nullable
    private RtspMediaSource.RtspPlaybackException playbackException;
    private long requestedSeekPositionUs;
    private long pendingSeekPositionUs;
    private long pendingSeekPositionUsForTcpRetry;
    private boolean loadingFinished;
    private boolean notifyDiscontinuity;
    private boolean released;
    private boolean prepared;
    private boolean trackSelected;
    private int portBindingRetryCount;
    private boolean isUsingRtpTcp;

    public RtspMediaPeriod(Allocator allocator, RtpDataChannel.Factory rtpDataChannelFactory, Uri uri, Listener listener, String userAgent, SocketFactory socketFactory, boolean debugLoggingEnabled) {
        this.allocator = allocator;
        this.rtpDataChannelFactory = rtpDataChannelFactory;
        this.listener = listener;
        this.handler = Util.createHandlerForCurrentLooper();
        this.internalListener = new InternalListener();
        this.rtspClient = new RtspClient(this.internalListener, this.internalListener, userAgent, uri, socketFactory, debugLoggingEnabled);
        this.rtspLoaderWrappers = new ArrayList<RtspLoaderWrapper>();
        this.selectedLoadInfos = new ArrayList<RtpLoadInfo>();
        this.pendingSeekPositionUs = -9223372036854775807L;
        this.requestedSeekPositionUs = -9223372036854775807L;
        this.pendingSeekPositionUsForTcpRetry = -9223372036854775807L;
    }

    public void release() {
        for (int i = 0; i < this.rtspLoaderWrappers.size(); ++i) {
            this.rtspLoaderWrappers.get(i).release();
        }
        Util.closeQuietly((Closeable)this.rtspClient);
        this.released = true;
    }

    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        try {
            this.rtspClient.start();
        }
        catch (IOException e) {
            this.preparationError = e;
            Util.closeQuietly((Closeable)this.rtspClient);
        }
    }

    public void maybeThrowPrepareError() throws IOException {
        if (this.preparationError != null) {
            throw this.preparationError;
        }
    }

    public TrackGroupArray getTrackGroups() {
        Assertions.checkState((boolean)this.prepared);
        return new TrackGroupArray((TrackGroup[])((ImmutableList)Assertions.checkNotNull(this.trackGroups)).toArray((Object[])new TrackGroup[0]));
    }

    public ImmutableList<StreamKey> getStreamKeys(List<ExoTrackSelection> trackSelections) {
        return ImmutableList.of();
    }

    public long selectTracks(@NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        int i;
        for (i = 0; i < selections.length; ++i) {
            if (streams[i] == null || selections[i] != null && mayRetainStreamFlags[i]) continue;
            streams[i] = null;
        }
        this.selectedLoadInfos.clear();
        for (i = 0; i < selections.length; ++i) {
            ExoTrackSelection selection = selections[i];
            if (selection == null) continue;
            TrackGroup trackGroup = selection.getTrackGroup();
            int trackGroupIndex = ((ImmutableList)Assertions.checkNotNull(this.trackGroups)).indexOf((Object)trackGroup);
            this.selectedLoadInfos.add(((RtspLoaderWrapper)Assertions.checkNotNull((Object)this.rtspLoaderWrappers.get((int)trackGroupIndex))).loadInfo);
            if (!this.trackGroups.contains((Object)trackGroup) || streams[i] != null) continue;
            streams[i] = new SampleStreamImpl(trackGroupIndex);
            streamResetFlags[i] = true;
        }
        for (i = 0; i < this.rtspLoaderWrappers.size(); ++i) {
            RtspLoaderWrapper loadControl = this.rtspLoaderWrappers.get(i);
            if (this.selectedLoadInfos.contains(loadControl.loadInfo)) continue;
            loadControl.cancelLoad();
        }
        this.trackSelected = true;
        this.maybeSetupTracks();
        return positionUs;
    }

    public void discardBuffer(long positionUs, boolean toKeyframe) {
        if (this.isSeekPending()) {
            return;
        }
        for (int i = 0; i < this.rtspLoaderWrappers.size(); ++i) {
            RtspLoaderWrapper loaderWrapper = this.rtspLoaderWrappers.get(i);
            if (loaderWrapper.canceled) continue;
            loaderWrapper.sampleQueue.discardTo(positionUs, toKeyframe, true);
        }
    }

    public long readDiscontinuity() {
        if (this.notifyDiscontinuity) {
            this.notifyDiscontinuity = false;
            return 0L;
        }
        return -9223372036854775807L;
    }

    public long seekToUs(long positionUs) {
        if (this.getBufferedPositionUs() == 0L && !this.isUsingRtpTcp) {
            this.pendingSeekPositionUsForTcpRetry = positionUs;
            return positionUs;
        }
        this.discardBuffer(positionUs, false);
        this.requestedSeekPositionUs = positionUs;
        if (this.isSeekPending()) {
            switch (this.rtspClient.getState()) {
                case 1: {
                    return positionUs;
                }
                case 2: {
                    this.pendingSeekPositionUs = positionUs;
                    this.rtspClient.seekToUs(this.pendingSeekPositionUs);
                    return positionUs;
                }
            }
            throw new IllegalStateException();
        }
        if (this.seekInsideBufferUs(positionUs)) {
            return positionUs;
        }
        this.pendingSeekPositionUs = positionUs;
        this.rtspClient.seekToUs(positionUs);
        for (int i = 0; i < this.rtspLoaderWrappers.size(); ++i) {
            this.rtspLoaderWrappers.get(i).seekTo(positionUs);
        }
        return positionUs;
    }

    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        return positionUs;
    }

    public long getBufferedPositionUs() {
        if (this.loadingFinished || this.rtspLoaderWrappers.isEmpty()) {
            return Long.MIN_VALUE;
        }
        if (this.requestedSeekPositionUs != -9223372036854775807L) {
            return this.requestedSeekPositionUs;
        }
        boolean allLoaderWrappersAreCanceled = true;
        long bufferedPositionUs = Long.MAX_VALUE;
        for (int i = 0; i < this.rtspLoaderWrappers.size(); ++i) {
            RtspLoaderWrapper loaderWrapper = this.rtspLoaderWrappers.get(i);
            if (loaderWrapper.canceled) continue;
            bufferedPositionUs = Math.min(bufferedPositionUs, loaderWrapper.getBufferedPositionUs());
            allLoaderWrappersAreCanceled = false;
        }
        return allLoaderWrappersAreCanceled || bufferedPositionUs == Long.MIN_VALUE ? 0L : bufferedPositionUs;
    }

    public long getNextLoadPositionUs() {
        return this.getBufferedPositionUs();
    }

    public boolean continueLoading(long positionUs) {
        return this.isLoading();
    }

    public boolean isLoading() {
        return !this.loadingFinished;
    }

    public void reevaluateBuffer(long positionUs) {
    }

    boolean isReady(int trackGroupIndex) {
        return !this.suppressRead() && this.rtspLoaderWrappers.get(trackGroupIndex).isSampleQueueReady();
    }

    int readData(int sampleQueueIndex, FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags) {
        if (this.suppressRead()) {
            return -3;
        }
        return this.rtspLoaderWrappers.get(sampleQueueIndex).read(formatHolder, buffer, readFlags);
    }

    int skipData(int sampleQueueIndex, long positionUs) {
        if (this.suppressRead()) {
            return -3;
        }
        return this.rtspLoaderWrappers.get(sampleQueueIndex).skipData(positionUs);
    }

    private boolean suppressRead() {
        return this.notifyDiscontinuity;
    }

    @Nullable
    private RtpDataLoadable getLoadableByTrackUri(Uri trackUri) {
        for (int i = 0; i < this.rtspLoaderWrappers.size(); ++i) {
            RtpLoadInfo loadInfo;
            if (this.rtspLoaderWrappers.get(i).canceled || !(loadInfo = this.rtspLoaderWrappers.get((int)i).loadInfo).getTrackUri().equals((Object)trackUri)) continue;
            return loadInfo.loadable;
        }
        return null;
    }

    private boolean isSeekPending() {
        return this.pendingSeekPositionUs != -9223372036854775807L;
    }

    private void maybeFinishPrepare() {
        if (this.released || this.prepared) {
            return;
        }
        for (int i = 0; i < this.rtspLoaderWrappers.size(); ++i) {
            if (this.rtspLoaderWrappers.get(i).sampleQueue.getUpstreamFormat() != null) continue;
            return;
        }
        this.prepared = true;
        this.trackGroups = RtspMediaPeriod.buildTrackGroups((ImmutableList<RtspLoaderWrapper>)ImmutableList.copyOf(this.rtspLoaderWrappers));
        ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onPrepared((MediaPeriod)this);
    }

    private boolean seekInsideBufferUs(long positionUs) {
        for (int i = 0; i < this.rtspLoaderWrappers.size(); ++i) {
            SampleQueue sampleQueue = this.rtspLoaderWrappers.get(i).sampleQueue;
            if (sampleQueue.seekTo(positionUs, false)) continue;
            return false;
        }
        return true;
    }

    private void maybeSetupTracks() {
        boolean transportReady = true;
        for (int i = 0; i < this.selectedLoadInfos.size(); ++i) {
            transportReady &= this.selectedLoadInfos.get(i).isTransportReady();
        }
        if (transportReady && this.trackSelected) {
            this.rtspClient.setupSelectedTracks(this.selectedLoadInfos);
        }
    }

    private void updateLoadingFinished() {
        this.loadingFinished = true;
        for (int i = 0; i < this.rtspLoaderWrappers.size(); ++i) {
            this.loadingFinished &= this.rtspLoaderWrappers.get(i).canceled;
        }
    }

    private static ImmutableList<TrackGroup> buildTrackGroups(ImmutableList<RtspLoaderWrapper> rtspLoaderWrappers) {
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        for (int i = 0; i < rtspLoaderWrappers.size(); ++i) {
            SampleQueue sampleQueue = ((RtspLoaderWrapper)rtspLoaderWrappers.get(i)).sampleQueue;
            listBuilder.add((Object)new TrackGroup(Integer.toString(i), new Format[]{(Format)Assertions.checkNotNull((Object)sampleQueue.getUpstreamFormat())}));
        }
        return listBuilder.build();
    }

    private void retryWithRtpTcp() {
        this.rtspClient.retryWithRtpTcp();
        RtpDataChannel.Factory fallbackRtpDataChannelFactory = this.rtpDataChannelFactory.createFallbackDataChannelFactory();
        if (fallbackRtpDataChannelFactory == null) {
            this.playbackException = new RtspMediaSource.RtspPlaybackException("No fallback data channel factory for TCP retry");
            return;
        }
        ArrayList<RtspLoaderWrapper> newLoaderWrappers = new ArrayList<RtspLoaderWrapper>(this.rtspLoaderWrappers.size());
        ArrayList<RtpLoadInfo> newSelectedLoadInfos = new ArrayList<RtpLoadInfo>(this.selectedLoadInfos.size());
        for (int i = 0; i < this.rtspLoaderWrappers.size(); ++i) {
            RtspLoaderWrapper loaderWrapper = this.rtspLoaderWrappers.get(i);
            if (!loaderWrapper.canceled) {
                RtspLoaderWrapper newLoaderWrapper = new RtspLoaderWrapper(loaderWrapper.loadInfo.mediaTrack, i, fallbackRtpDataChannelFactory);
                newLoaderWrappers.add(newLoaderWrapper);
                newLoaderWrapper.startLoading();
                if (!this.selectedLoadInfos.contains(loaderWrapper.loadInfo)) continue;
                newSelectedLoadInfos.add(newLoaderWrapper.loadInfo);
                continue;
            }
            newLoaderWrappers.add(loaderWrapper);
        }
        ImmutableList oldRtspLoaderWrappers = ImmutableList.copyOf(this.rtspLoaderWrappers);
        this.rtspLoaderWrappers.clear();
        this.rtspLoaderWrappers.addAll(newLoaderWrappers);
        this.selectedLoadInfos.clear();
        this.selectedLoadInfos.addAll(newSelectedLoadInfos);
        for (int i = 0; i < oldRtspLoaderWrappers.size(); ++i) {
            ((RtspLoaderWrapper)oldRtspLoaderWrappers.get(i)).cancelLoad();
        }
    }

    final class RtpLoadInfo {
        public final RtspMediaTrack mediaTrack;
        private final RtpDataLoadable loadable;
        @Nullable
        private String transport;

        public RtpLoadInfo(RtspMediaTrack mediaTrack, int trackId, RtpDataChannel.Factory rtpDataChannelFactory) {
            this.mediaTrack = mediaTrack;
            RtpDataLoadable.EventListener transportEventListener = (transport, rtpDataChannel) -> {
                this.transport = transport;
                RtspMessageChannel.InterleavedBinaryDataListener interleavedBinaryDataListener = rtpDataChannel.getInterleavedBinaryDataListener();
                if (interleavedBinaryDataListener != null) {
                    RtspMediaPeriod.this.rtspClient.registerInterleavedDataChannel(rtpDataChannel.getLocalPort(), interleavedBinaryDataListener);
                    RtspMediaPeriod.this.isUsingRtpTcp = true;
                }
                RtspMediaPeriod.this.maybeSetupTracks();
            };
            this.loadable = new RtpDataLoadable(trackId, mediaTrack, transportEventListener, RtspMediaPeriod.this.internalListener, rtpDataChannelFactory);
        }

        public boolean isTransportReady() {
            return this.transport != null;
        }

        public String getTransport() {
            Assertions.checkStateNotNull((Object)this.transport);
            return this.transport;
        }

        public Uri getTrackUri() {
            return this.loadable.rtspMediaTrack.uri;
        }
    }

    private final class RtspLoaderWrapper {
        public final RtpLoadInfo loadInfo;
        private final Loader loader;
        private final SampleQueue sampleQueue;
        private boolean canceled;
        private boolean released;

        public RtspLoaderWrapper(RtspMediaTrack mediaTrack, int trackId, RtpDataChannel.Factory rtpDataChannelFactory) {
            this.loadInfo = new RtpLoadInfo(mediaTrack, trackId, rtpDataChannelFactory);
            this.loader = new Loader("ExoPlayer:RtspMediaPeriod:RtspLoaderWrapper " + trackId);
            this.sampleQueue = SampleQueue.createWithoutDrm((Allocator)RtspMediaPeriod.this.allocator);
            this.sampleQueue.setUpstreamFormatChangeListener((SampleQueue.UpstreamFormatChangedListener)RtspMediaPeriod.this.internalListener);
        }

        public long getBufferedPositionUs() {
            return this.sampleQueue.getLargestQueuedTimestampUs();
        }

        public void startLoading() {
            this.loader.startLoading((Loader.Loadable)this.loadInfo.loadable, (Loader.Callback)RtspMediaPeriod.this.internalListener, 0);
        }

        public boolean isSampleQueueReady() {
            return this.sampleQueue.isReady(this.canceled);
        }

        public int read(FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags) {
            return this.sampleQueue.read(formatHolder, buffer, readFlags, this.canceled);
        }

        public int skipData(long positionUs) {
            int skipCount = this.sampleQueue.getSkipCount(positionUs, this.canceled);
            this.sampleQueue.skip(skipCount);
            return skipCount;
        }

        public void cancelLoad() {
            if (!this.canceled) {
                this.loadInfo.loadable.cancelLoad();
                this.canceled = true;
                RtspMediaPeriod.this.updateLoadingFinished();
            }
        }

        public void seekTo(long positionUs) {
            if (!this.canceled) {
                this.loadInfo.loadable.resetForSeek();
                this.sampleQueue.reset();
                this.sampleQueue.setStartTimeUs(positionUs);
            }
        }

        public void release() {
            if (this.released) {
                return;
            }
            this.loader.release();
            this.sampleQueue.release();
            this.released = true;
        }
    }

    private final class SampleStreamImpl
    implements SampleStream {
        private final int track;

        public SampleStreamImpl(int track) {
            this.track = track;
        }

        public boolean isReady() {
            return RtspMediaPeriod.this.isReady(this.track);
        }

        public void maybeThrowError() throws RtspMediaSource.RtspPlaybackException {
            if (RtspMediaPeriod.this.playbackException != null) {
                throw RtspMediaPeriod.this.playbackException;
            }
        }

        public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags) {
            return RtspMediaPeriod.this.readData(this.track, formatHolder, buffer, readFlags);
        }

        public int skipData(long positionUs) {
            return RtspMediaPeriod.this.skipData(this.track, positionUs);
        }
    }

    private final class InternalListener
    implements ExtractorOutput,
    Loader.Callback<RtpDataLoadable>,
    SampleQueue.UpstreamFormatChangedListener,
    RtspClient.SessionInfoListener,
    RtspClient.PlaybackEventListener {
        private InternalListener() {
        }

        public TrackOutput track(int id, int type) {
            return ((RtspLoaderWrapper)Assertions.checkNotNull((Object)((RtspLoaderWrapper)RtspMediaPeriod.this.rtspLoaderWrappers.get(id)))).sampleQueue;
        }

        public void endTracks() {
            RtspMediaPeriod.this.handler.post(() -> RtspMediaPeriod.this.maybeFinishPrepare());
        }

        public void seekMap(SeekMap seekMap) {
        }

        public void onLoadCompleted(RtpDataLoadable loadable, long elapsedRealtimeMs, long loadDurationMs) {
            if (RtspMediaPeriod.this.getBufferedPositionUs() == 0L) {
                if (!RtspMediaPeriod.this.isUsingRtpTcp) {
                    RtspMediaPeriod.this.retryWithRtpTcp();
                    RtspMediaPeriod.this.isUsingRtpTcp = true;
                }
                return;
            }
            for (int i = 0; i < RtspMediaPeriod.this.rtspLoaderWrappers.size(); ++i) {
                RtspLoaderWrapper loaderWrapper = (RtspLoaderWrapper)RtspMediaPeriod.this.rtspLoaderWrappers.get(i);
                if (loaderWrapper.loadInfo.loadable != loadable) continue;
                loaderWrapper.cancelLoad();
                break;
            }
        }

        public void onLoadCanceled(RtpDataLoadable loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        }

        public Loader.LoadErrorAction onLoadError(RtpDataLoadable loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
            if (!RtspMediaPeriod.this.prepared) {
                RtspMediaPeriod.this.preparationError = error;
            } else if (error.getCause() instanceof BindException) {
                if (RtspMediaPeriod.this.portBindingRetryCount++ < 3) {
                    return Loader.RETRY;
                }
            } else {
                RtspMediaPeriod.this.playbackException = new RtspMediaSource.RtspPlaybackException(loadable.rtspMediaTrack.uri.toString(), error);
            }
            return Loader.DONT_RETRY;
        }

        public void onUpstreamFormatChanged(Format format) {
            RtspMediaPeriod.this.handler.post(() -> RtspMediaPeriod.this.maybeFinishPrepare());
        }

        @Override
        public void onRtspSetupCompleted() {
            RtspMediaPeriod.this.rtspClient.startPlayback(0L);
        }

        @Override
        public void onPlaybackStarted(long startPositionUs, ImmutableList<RtspTrackTiming> trackTimingList) {
            int i;
            ArrayList<String> trackUrisWithTiming = new ArrayList<String>(trackTimingList.size());
            for (i = 0; i < trackTimingList.size(); ++i) {
                trackUrisWithTiming.add((String)Assertions.checkNotNull((Object)((RtspTrackTiming)trackTimingList.get((int)i)).uri.getPath()));
            }
            for (i = 0; i < RtspMediaPeriod.this.selectedLoadInfos.size(); ++i) {
                RtpLoadInfo loadInfo = (RtpLoadInfo)RtspMediaPeriod.this.selectedLoadInfos.get(i);
                if (trackUrisWithTiming.contains(loadInfo.getTrackUri().getPath())) continue;
                RtspMediaPeriod.this.listener.onSeekingUnsupported();
                if (!RtspMediaPeriod.this.isSeekPending()) continue;
                RtspMediaPeriod.this.notifyDiscontinuity = true;
                RtspMediaPeriod.this.pendingSeekPositionUs = -9223372036854775807L;
                RtspMediaPeriod.this.requestedSeekPositionUs = -9223372036854775807L;
                RtspMediaPeriod.this.pendingSeekPositionUsForTcpRetry = -9223372036854775807L;
            }
            for (i = 0; i < trackTimingList.size(); ++i) {
                RtspTrackTiming trackTiming = (RtspTrackTiming)trackTimingList.get(i);
                RtpDataLoadable dataLoadable = RtspMediaPeriod.this.getLoadableByTrackUri(trackTiming.uri);
                if (dataLoadable == null) continue;
                dataLoadable.setTimestamp(trackTiming.rtpTimestamp);
                dataLoadable.setSequenceNumber(trackTiming.sequenceNumber);
                if (!RtspMediaPeriod.this.isSeekPending() || RtspMediaPeriod.this.pendingSeekPositionUs != RtspMediaPeriod.this.requestedSeekPositionUs) continue;
                dataLoadable.seekToUs(startPositionUs, trackTiming.rtpTimestamp);
            }
            if (RtspMediaPeriod.this.isSeekPending()) {
                if (RtspMediaPeriod.this.pendingSeekPositionUs == RtspMediaPeriod.this.requestedSeekPositionUs) {
                    RtspMediaPeriod.this.pendingSeekPositionUs = -9223372036854775807L;
                    RtspMediaPeriod.this.requestedSeekPositionUs = -9223372036854775807L;
                } else {
                    RtspMediaPeriod.this.pendingSeekPositionUs = -9223372036854775807L;
                    RtspMediaPeriod.this.seekToUs(RtspMediaPeriod.this.requestedSeekPositionUs);
                }
            } else if (RtspMediaPeriod.this.pendingSeekPositionUsForTcpRetry != -9223372036854775807L) {
                RtspMediaPeriod.this.seekToUs(RtspMediaPeriod.this.pendingSeekPositionUsForTcpRetry);
                RtspMediaPeriod.this.pendingSeekPositionUsForTcpRetry = -9223372036854775807L;
            }
        }

        @Override
        public void onPlaybackError(RtspMediaSource.RtspPlaybackException error) {
            RtspMediaPeriod.this.playbackException = error;
        }

        @Override
        public void onSessionTimelineUpdated(RtspSessionTiming timing, ImmutableList<RtspMediaTrack> tracks) {
            for (int i = 0; i < tracks.size(); ++i) {
                RtspMediaTrack rtspMediaTrack = (RtspMediaTrack)tracks.get(i);
                RtspLoaderWrapper loaderWrapper = new RtspLoaderWrapper(rtspMediaTrack, i, RtspMediaPeriod.this.rtpDataChannelFactory);
                RtspMediaPeriod.this.rtspLoaderWrappers.add(loaderWrapper);
                loaderWrapper.startLoading();
            }
            RtspMediaPeriod.this.listener.onSourceInfoRefreshed(timing);
        }

        @Override
        public void onSessionTimelineRequestFailed(String message, @Nullable Throwable cause) {
            RtspMediaPeriod.this.preparationError = cause == null ? new IOException(message) : new IOException(message, cause);
        }
    }

    static interface Listener {
        public void onSourceInfoRefreshed(RtspSessionTiming var1);

        default public void onSeekingUnsupported() {
        }
    }
}

