/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp;

import android.net.Uri;
import android.util.Base64;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.source.rtsp.RtspMessageUtil;
import com.google.android.exoplayer2.util.Util;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class RtspAuthenticationInfo {
    public static final int BASIC = 1;
    public static final int DIGEST = 2;
    private static final String BASIC_AUTHORIZATION_HEADER_FORMAT = "Basic %s";
    private static final String DIGEST_AUTHORIZATION_HEADER_FORMAT = "Digest username=\"%s\", realm=\"%s\", nonce=\"%s\", uri=\"%s\", response=\"%s\"";
    private static final String DIGEST_AUTHORIZATION_HEADER_FORMAT_WITH_OPAQUE = "Digest username=\"%s\", realm=\"%s\", nonce=\"%s\", uri=\"%s\", response=\"%s\", opaque=\"%s\"";
    private static final String ALGORITHM = "MD5";
    public final int authenticationMechanism;
    public final String realm;
    public final String nonce;
    public final String opaque;

    public RtspAuthenticationInfo(int authenticationMechanism, String realm, String nonce, String opaque) {
        this.authenticationMechanism = authenticationMechanism;
        this.realm = realm;
        this.nonce = nonce;
        this.opaque = opaque;
    }

    public String getAuthorizationHeaderValue(RtspMessageUtil.RtspAuthUserInfo authUserInfo, Uri uri, int requestMethod) throws ParserException {
        switch (this.authenticationMechanism) {
            case 1: {
                return this.getBasicAuthorizationHeaderValue(authUserInfo);
            }
            case 2: {
                return this.getDigestAuthorizationHeaderValue(authUserInfo, uri, requestMethod);
            }
        }
        throw ParserException.createForManifestWithUnsupportedFeature(null, (Throwable)new UnsupportedOperationException());
    }

    private String getBasicAuthorizationHeaderValue(RtspMessageUtil.RtspAuthUserInfo authUserInfo) {
        return Util.formatInvariant((String)BASIC_AUTHORIZATION_HEADER_FORMAT, (Object[])new Object[]{Base64.encodeToString((byte[])RtspMessageUtil.getStringBytes(authUserInfo.username + ":" + authUserInfo.password), (int)0)});
    }

    private String getDigestAuthorizationHeaderValue(RtspMessageUtil.RtspAuthUserInfo authUserInfo, Uri uri, int requestMethod) throws ParserException {
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            String methodName = RtspMessageUtil.toMethodString(requestMethod);
            String hashA1 = Util.toHexString((byte[])md.digest(RtspMessageUtil.getStringBytes(authUserInfo.username + ":" + this.realm + ":" + authUserInfo.password)));
            String hashA2 = Util.toHexString((byte[])md.digest(RtspMessageUtil.getStringBytes(methodName + ":" + uri)));
            String response = Util.toHexString((byte[])md.digest(RtspMessageUtil.getStringBytes(hashA1 + ":" + this.nonce + ":" + hashA2)));
            if (this.opaque.isEmpty()) {
                return Util.formatInvariant((String)DIGEST_AUTHORIZATION_HEADER_FORMAT, (Object[])new Object[]{authUserInfo.username, this.realm, this.nonce, uri, response});
            }
            return Util.formatInvariant((String)DIGEST_AUTHORIZATION_HEADER_FORMAT_WITH_OPAQUE, (Object[])new Object[]{authUserInfo.username, this.realm, this.nonce, uri, response, this.opaque});
        }
        catch (NoSuchAlgorithmException e) {
            throw ParserException.createForManifestWithUnsupportedFeature(null, (Throwable)e);
        }
    }
}

