/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.rtsp.MediaDescription;
import com.google.android.exoplayer2.util.Assertions;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class RtpPayloadFormat {
    private static final String RTP_MEDIA_AC3 = "AC3";
    private static final String RTP_MEDIA_AMR = "AMR";
    private static final String RTP_MEDIA_AMR_WB = "AMR-WB";
    private static final String RTP_MEDIA_MPEG4_GENERIC = "MPEG4-GENERIC";
    private static final String RTP_MEDIA_MPEG4_VIDEO = "MP4V-ES";
    private static final String RTP_MEDIA_H263_1998 = "H263-1998";
    private static final String RTP_MEDIA_H263_2000 = "H263-2000";
    private static final String RTP_MEDIA_H264 = "H264";
    private static final String RTP_MEDIA_H265 = "H265";
    private static final String RTP_MEDIA_OPUS = "OPUS";
    private static final String RTP_MEDIA_PCM_L8 = "L8";
    private static final String RTP_MEDIA_PCM_L16 = "L16";
    private static final String RTP_MEDIA_PCMA = "PCMA";
    private static final String RTP_MEDIA_PCMU = "PCMU";
    private static final String RTP_MEDIA_VP8 = "VP8";
    private static final String RTP_MEDIA_VP9 = "VP9";
    public final int rtpPayloadType;
    public final int clockRate;
    public final Format format;
    public final ImmutableMap<String, String> fmtpParameters;

    public static boolean isFormatSupported(MediaDescription mediaDescription) {
        switch (Ascii.toUpperCase((String)mediaDescription.rtpMapAttribute.mediaEncoding)) {
            case "AC3": 
            case "AMR": 
            case "AMR-WB": 
            case "H263-1998": 
            case "H263-2000": 
            case "H264": 
            case "H265": 
            case "MP4V-ES": 
            case "MPEG4-GENERIC": 
            case "OPUS": 
            case "L8": 
            case "L16": 
            case "PCMA": 
            case "PCMU": 
            case "VP8": 
            case "VP9": {
                return true;
            }
        }
        return false;
    }

    public static String getMimeTypeFromRtpMediaType(String mediaType) {
        switch (Ascii.toUpperCase((String)mediaType)) {
            case "AC3": {
                return "audio/ac3";
            }
            case "AMR": {
                return "audio/3gpp";
            }
            case "AMR-WB": {
                return "audio/amr-wb";
            }
            case "MPEG4-GENERIC": {
                return "audio/mp4a-latm";
            }
            case "OPUS": {
                return "audio/opus";
            }
            case "L8": 
            case "L16": {
                return "audio/raw";
            }
            case "PCMA": {
                return "audio/g711-alaw";
            }
            case "PCMU": {
                return "audio/g711-mlaw";
            }
            case "H263-1998": 
            case "H263-2000": {
                return "video/3gpp";
            }
            case "H264": {
                return "video/avc";
            }
            case "H265": {
                return "video/hevc";
            }
            case "MP4V-ES": {
                return "video/mp4v-es";
            }
            case "VP8": {
                return "video/x-vnd.on2.vp8";
            }
            case "VP9": {
                return "video/x-vnd.on2.vp9";
            }
        }
        throw new IllegalArgumentException(mediaType);
    }

    public static int getRawPcmEncodingType(String mediaEncoding) {
        Assertions.checkArgument((mediaEncoding.equals(RTP_MEDIA_PCM_L8) || mediaEncoding.equals(RTP_MEDIA_PCM_L16) ? 1 : 0) != 0);
        return mediaEncoding.equals(RTP_MEDIA_PCM_L8) ? 3 : 0x10000000;
    }

    public RtpPayloadFormat(Format format, int rtpPayloadType, int clockRate, Map<String, String> fmtpParameters) {
        this.rtpPayloadType = rtpPayloadType;
        this.clockRate = clockRate;
        this.format = format;
        this.fmtpParameters = ImmutableMap.copyOf(fmtpParameters);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RtpPayloadFormat that = (RtpPayloadFormat)o;
        return this.rtpPayloadType == that.rtpPayloadType && this.clockRate == that.clockRate && this.format.equals((Object)that.format) && this.fmtpParameters.equals(that.fmtpParameters);
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this.rtpPayloadType;
        result = 31 * result + this.clockRate;
        result = 31 * result + this.format.hashCode();
        result = 31 * result + this.fmtpParameters.hashCode();
        return result;
    }
}

