/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp;

import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.source.rtsp.RtpPacket;
import java.util.TreeSet;

final class RtpPacketReorderingQueue {
    @VisibleForTesting
    static final int MAX_SEQUENCE_LEAP_ALLOWED = 1000;
    private static final int QUEUE_SIZE_THRESHOLD_FOR_RESET = 5000;
    @GuardedBy(value="this")
    private final TreeSet<RtpPacketContainer> packetQueue = new TreeSet((packetContainer1, packetContainer2) -> RtpPacketReorderingQueue.calculateSequenceNumberShift(packetContainer1.packet.sequenceNumber, packetContainer2.packet.sequenceNumber));
    @GuardedBy(value="this")
    private int lastReceivedSequenceNumber;
    @GuardedBy(value="this")
    private int lastDequeuedSequenceNumber;
    @GuardedBy(value="this")
    private boolean started;

    public RtpPacketReorderingQueue() {
        this.reset();
    }

    public synchronized void reset() {
        this.packetQueue.clear();
        this.started = false;
        this.lastDequeuedSequenceNumber = -1;
        this.lastReceivedSequenceNumber = -1;
    }

    public synchronized boolean offer(RtpPacket packet, long receivedTimestampMs) {
        if (this.packetQueue.size() >= 5000) {
            throw new IllegalStateException("Queue size limit of 5000 reached.");
        }
        int packetSequenceNumber = packet.sequenceNumber;
        if (!this.started) {
            this.reset();
            this.lastDequeuedSequenceNumber = RtpPacket.getPreviousSequenceNumber(packetSequenceNumber);
            this.started = true;
            this.addToQueue(new RtpPacketContainer(packet, receivedTimestampMs));
            return true;
        }
        int expectedSequenceNumber = RtpPacket.getNextSequenceNumber(this.lastReceivedSequenceNumber);
        int sequenceNumberShift = RtpPacketReorderingQueue.calculateSequenceNumberShift(packetSequenceNumber, expectedSequenceNumber);
        if (Math.abs(sequenceNumberShift) < 1000) {
            if (RtpPacketReorderingQueue.calculateSequenceNumberShift(packetSequenceNumber, this.lastDequeuedSequenceNumber) > 0) {
                this.addToQueue(new RtpPacketContainer(packet, receivedTimestampMs));
                return true;
            }
        } else {
            this.lastDequeuedSequenceNumber = RtpPacket.getPreviousSequenceNumber(packetSequenceNumber);
            this.packetQueue.clear();
            this.addToQueue(new RtpPacketContainer(packet, receivedTimestampMs));
            return true;
        }
        return false;
    }

    @Nullable
    public synchronized RtpPacket poll(long cutoffTimestampMs) {
        if (this.packetQueue.isEmpty()) {
            return null;
        }
        RtpPacketContainer packetContainer = this.packetQueue.first();
        int packetSequenceNumber = packetContainer.packet.sequenceNumber;
        if (packetSequenceNumber == RtpPacket.getNextSequenceNumber(this.lastDequeuedSequenceNumber) || cutoffTimestampMs >= packetContainer.receivedTimestampMs) {
            this.packetQueue.pollFirst();
            this.lastDequeuedSequenceNumber = packetSequenceNumber;
            return packetContainer.packet;
        }
        return null;
    }

    private synchronized void addToQueue(RtpPacketContainer packet) {
        this.lastReceivedSequenceNumber = packet.packet.sequenceNumber;
        this.packetQueue.add(packet);
    }

    private static int calculateSequenceNumberShift(int sequenceNumber, int previousSequenceNumber) {
        int shift;
        int sequenceShift = sequenceNumber - previousSequenceNumber;
        if (Math.abs(sequenceShift) > 1000 && (shift = Math.min(sequenceNumber, previousSequenceNumber) - Math.max(sequenceNumber, previousSequenceNumber) + 65535) < 1000) {
            return sequenceNumber < previousSequenceNumber ? shift : -shift;
        }
        return sequenceShift;
    }

    private static final class RtpPacketContainer {
        public final RtpPacket packet;
        public final long receivedTimestampMs;

        public RtpPacketContainer(RtpPacket packet, long receivedTimestampMs) {
            this.packet = packet;
            this.receivedTimestampMs = receivedTimestampMs;
        }
    }
}

