/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.common.math.IntMath;
import java.nio.ByteBuffer;

public final class RtpPacket {
    public static final int RTP_VERSION = 2;
    public static final int MAX_SIZE = 65507;
    public static final int MIN_HEADER_SIZE = 12;
    public static final int MIN_SEQUENCE_NUMBER = 0;
    public static final int MAX_SEQUENCE_NUMBER = 65535;
    public static final int CSRC_SIZE = 4;
    private static final byte[] EMPTY = new byte[0];
    public final byte version = (byte)2;
    public final boolean padding;
    public final boolean extension;
    public final byte csrcCount;
    public final boolean marker;
    public final byte payloadType;
    public final int sequenceNumber;
    public final long timestamp;
    public final int ssrc;
    public final byte[] csrc;
    public final byte[] payloadData;

    public static int getNextSequenceNumber(int sequenceNumber) {
        return IntMath.mod((int)(sequenceNumber + 1), (int)65536);
    }

    public static int getPreviousSequenceNumber(int sequenceNumber) {
        return IntMath.mod((int)(sequenceNumber - 1), (int)65536);
    }

    @Nullable
    public static RtpPacket parse(ParsableByteArray packetBuffer) {
        byte[] csrc;
        if (packetBuffer.bytesLeft() < 12) {
            return null;
        }
        int firstByte = packetBuffer.readUnsignedByte();
        byte version = (byte)(firstByte >> 6);
        boolean padding = (firstByte >> 5 & 1) == 1;
        int csrcCount = firstByte & 0xF;
        if (version != 2) {
            return null;
        }
        int secondByte = packetBuffer.readUnsignedByte();
        boolean marker = (secondByte >> 7 & 1) == 1;
        byte payloadType = (byte)(secondByte & 0x7F);
        int sequenceNumber = packetBuffer.readUnsignedShort();
        long timestamp = packetBuffer.readUnsignedInt();
        int ssrc = packetBuffer.readInt();
        if (csrcCount > 0) {
            csrc = new byte[csrcCount * 4];
            for (int i = 0; i < csrcCount; ++i) {
                packetBuffer.readBytes(csrc, i * 4, 4);
            }
        } else {
            csrc = EMPTY;
        }
        byte[] payloadData = new byte[packetBuffer.bytesLeft()];
        packetBuffer.readBytes(payloadData, 0, packetBuffer.bytesLeft());
        Builder builder = new Builder();
        return builder.setPadding(padding).setMarker(marker).setPayloadType(payloadType).setSequenceNumber(sequenceNumber).setTimestamp(timestamp).setSsrc(ssrc).setCsrc(csrc).setPayloadData(payloadData).build();
    }

    @Nullable
    public static RtpPacket parse(byte[] buffer, int length) {
        return RtpPacket.parse(new ParsableByteArray(buffer, length));
    }

    private RtpPacket(Builder builder) {
        this.padding = builder.padding;
        this.extension = false;
        this.marker = builder.marker;
        this.payloadType = builder.payloadType;
        this.sequenceNumber = builder.sequenceNumber;
        this.timestamp = builder.timestamp;
        this.ssrc = builder.ssrc;
        this.csrc = builder.csrc;
        this.csrcCount = (byte)(this.csrc.length / 4);
        this.payloadData = builder.payloadData;
    }

    public int writeToBuffer(byte[] target, int offset, int length) {
        int packetLength = 12 + 4 * this.csrcCount + this.payloadData.length;
        if (length < packetLength || target.length - offset < packetLength) {
            return -1;
        }
        ByteBuffer buffer = ByteBuffer.wrap(target, offset, length);
        byte firstByte = (byte)(0x80 | (this.padding ? 1 : 0) << 5 | (this.extension ? 1 : 0) << 4 | this.csrcCount & 0xF);
        byte secondByte = (byte)((this.marker ? 1 : 0) << 7 | this.payloadType & 0x7F);
        buffer.put(firstByte).put(secondByte).putShort((short)this.sequenceNumber).putInt((int)this.timestamp).putInt(this.ssrc).put(this.csrc).put(this.payloadData);
        return packetLength;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RtpPacket rtpPacket = (RtpPacket)o;
        return this.payloadType == rtpPacket.payloadType && this.sequenceNumber == rtpPacket.sequenceNumber && this.marker == rtpPacket.marker && this.timestamp == rtpPacket.timestamp && this.ssrc == rtpPacket.ssrc;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.payloadType;
        result = 31 * result + this.sequenceNumber;
        result = 31 * result + (this.marker ? 1 : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.ssrc;
        return result;
    }

    public String toString() {
        return Util.formatInvariant((String)"RtpPacket(payloadType=%d, seq=%d, timestamp=%d, ssrc=%x, marker=%b)", (Object[])new Object[]{this.payloadType, this.sequenceNumber, this.timestamp, this.ssrc, this.marker});
    }

    static /* synthetic */ byte[] access$000() {
        return EMPTY;
    }

    public static final class Builder {
        private boolean padding;
        private boolean marker;
        private byte payloadType;
        private int sequenceNumber;
        private long timestamp;
        private int ssrc;
        private byte[] csrc = RtpPacket.access$000();
        private byte[] payloadData = RtpPacket.access$000();

        public Builder setPadding(boolean padding) {
            this.padding = padding;
            return this;
        }

        public Builder setMarker(boolean marker) {
            this.marker = marker;
            return this;
        }

        public Builder setPayloadType(byte payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        public Builder setSequenceNumber(int sequenceNumber) {
            Assertions.checkArgument((sequenceNumber >= 0 && sequenceNumber <= 65535 ? 1 : 0) != 0);
            this.sequenceNumber = sequenceNumber & 0xFFFF;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setSsrc(int ssrc) {
            this.ssrc = ssrc;
            return this;
        }

        public Builder setCsrc(byte[] csrc) {
            Assertions.checkNotNull((Object)csrc);
            this.csrc = csrc;
            return this;
        }

        public Builder setPayloadData(byte[] payloadData) {
            Assertions.checkNotNull((Object)payloadData);
            this.payloadData = payloadData;
            return this;
        }

        public RtpPacket build() {
            return new RtpPacket(this);
        }
    }
}

