/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ts.Ac3Reader;
import com.google.android.exoplayer2.extractor.ts.Ac4Reader;
import com.google.android.exoplayer2.extractor.ts.AdtsReader;
import com.google.android.exoplayer2.extractor.ts.DtsReader;
import com.google.android.exoplayer2.extractor.ts.DvbSubtitleReader;
import com.google.android.exoplayer2.extractor.ts.H262Reader;
import com.google.android.exoplayer2.extractor.ts.H263Reader;
import com.google.android.exoplayer2.extractor.ts.H264Reader;
import com.google.android.exoplayer2.extractor.ts.H265Reader;
import com.google.android.exoplayer2.extractor.ts.Id3Reader;
import com.google.android.exoplayer2.extractor.ts.LatmReader;
import com.google.android.exoplayer2.extractor.ts.MpegAudioReader;
import com.google.android.exoplayer2.extractor.ts.PassthroughSectionPayloadReader;
import com.google.android.exoplayer2.extractor.ts.PesReader;
import com.google.android.exoplayer2.extractor.ts.SectionReader;
import com.google.android.exoplayer2.extractor.ts.SeiReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.extractor.ts.UserDataReader;
import com.google.android.exoplayer2.util.CodecSpecificDataUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;

public final class DefaultTsPayloadReaderFactory
implements TsPayloadReader.Factory {
    public static final int FLAG_ALLOW_NON_IDR_KEYFRAMES = 1;
    public static final int FLAG_IGNORE_AAC_STREAM = 2;
    public static final int FLAG_IGNORE_H264_STREAM = 4;
    public static final int FLAG_DETECT_ACCESS_UNITS = 8;
    public static final int FLAG_IGNORE_SPLICE_INFO_STREAM = 16;
    public static final int FLAG_OVERRIDE_CAPTION_DESCRIPTORS = 32;
    public static final int FLAG_ENABLE_HDMV_DTS_AUDIO_STREAMS = 64;
    private static final int DESCRIPTOR_TAG_CAPTION_SERVICE = 134;
    private final int flags;
    private final List<Format> closedCaptionFormats;

    public DefaultTsPayloadReaderFactory() {
        this(0);
    }

    public DefaultTsPayloadReaderFactory(int flags) {
        this(flags, (List<Format>)ImmutableList.of());
    }

    public DefaultTsPayloadReaderFactory(int flags, List<Format> closedCaptionFormats) {
        this.flags = flags;
        this.closedCaptionFormats = closedCaptionFormats;
    }

    @Override
    public SparseArray<TsPayloadReader> createInitialPayloadReaders() {
        return new SparseArray();
    }

    @Override
    @Nullable
    public TsPayloadReader createPayloadReader(int streamType, TsPayloadReader.EsInfo esInfo) {
        switch (streamType) {
            case 3: 
            case 4: {
                return new PesReader(new MpegAudioReader(esInfo.language));
            }
            case 15: {
                return this.isSet(2) ? null : new PesReader(new AdtsReader(false, esInfo.language));
            }
            case 17: {
                return this.isSet(2) ? null : new PesReader(new LatmReader(esInfo.language));
            }
            case 129: 
            case 135: {
                return new PesReader(new Ac3Reader(esInfo.language));
            }
            case 172: {
                return new PesReader(new Ac4Reader(esInfo.language));
            }
            case 130: {
                if (!this.isSet(64)) {
                    return null;
                }
            }
            case 138: {
                return new PesReader(new DtsReader(esInfo.language));
            }
            case 2: 
            case 128: {
                return new PesReader(new H262Reader(this.buildUserDataReader(esInfo)));
            }
            case 16: {
                return new PesReader(new H263Reader(this.buildUserDataReader(esInfo)));
            }
            case 27: {
                return this.isSet(4) ? null : new PesReader(new H264Reader(this.buildSeiReader(esInfo), this.isSet(1), this.isSet(8)));
            }
            case 36: {
                return new PesReader(new H265Reader(this.buildSeiReader(esInfo)));
            }
            case 134: {
                return this.isSet(16) ? null : new SectionReader(new PassthroughSectionPayloadReader("application/x-scte35"));
            }
            case 21: {
                return new PesReader(new Id3Reader());
            }
            case 89: {
                return new PesReader(new DvbSubtitleReader(esInfo.dvbSubtitleInfos));
            }
            case 257: {
                return new SectionReader(new PassthroughSectionPayloadReader("application/vnd.dvb.ait"));
            }
        }
        return null;
    }

    private SeiReader buildSeiReader(TsPayloadReader.EsInfo esInfo) {
        return new SeiReader(this.getClosedCaptionFormats(esInfo));
    }

    private UserDataReader buildUserDataReader(TsPayloadReader.EsInfo esInfo) {
        return new UserDataReader(this.getClosedCaptionFormats(esInfo));
    }

    private List<Format> getClosedCaptionFormats(TsPayloadReader.EsInfo esInfo) {
        if (this.isSet(32)) {
            return this.closedCaptionFormats;
        }
        ParsableByteArray scratchDescriptorData = new ParsableByteArray(esInfo.descriptorBytes);
        List<Format> closedCaptionFormats = this.closedCaptionFormats;
        while (scratchDescriptorData.bytesLeft() > 0) {
            int descriptorTag = scratchDescriptorData.readUnsignedByte();
            int descriptorLength = scratchDescriptorData.readUnsignedByte();
            int nextDescriptorPosition = scratchDescriptorData.getPosition() + descriptorLength;
            if (descriptorTag == 134) {
                closedCaptionFormats = new ArrayList<Format>();
                int numberOfServices = scratchDescriptorData.readUnsignedByte() & 0x1F;
                for (int i = 0; i < numberOfServices; ++i) {
                    int accessibilityChannel;
                    String mimeType;
                    boolean isDigital;
                    String language = scratchDescriptorData.readString(3);
                    int captionTypeByte = scratchDescriptorData.readUnsignedByte();
                    boolean bl = isDigital = (captionTypeByte & 0x80) != 0;
                    if (isDigital) {
                        mimeType = "application/cea-708";
                        accessibilityChannel = captionTypeByte & 0x3F;
                    } else {
                        mimeType = "application/cea-608";
                        accessibilityChannel = 1;
                    }
                    byte flags = (byte)scratchDescriptorData.readUnsignedByte();
                    scratchDescriptorData.skipBytes(1);
                    List initializationData = null;
                    if (isDigital) {
                        boolean isWideAspectRatio = (flags & 0x40) != 0;
                        initializationData = CodecSpecificDataUtil.buildCea708InitializationData((boolean)isWideAspectRatio);
                    }
                    closedCaptionFormats.add(new Format.Builder().setSampleMimeType(mimeType).setLanguage(language).setAccessibilityChannel(accessibilityChannel).setInitializationData(initializationData).build());
                }
            }
            scratchDescriptorData.setPosition(nextDescriptorPosition);
        }
        return closedCaptionFormats;
    }

    private boolean isSet(int flag) {
        return (this.flags & flag) != 0;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Flags {
    }
}

