/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.IndexSeekMap;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.CueEncoder;
import com.google.android.exoplayer2.text.SubtitleDecoder;
import com.google.android.exoplayer2.text.SubtitleDecoderException;
import com.google.android.exoplayer2.text.SubtitleInputBuffer;
import com.google.android.exoplayer2.text.SubtitleOutputBuffer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class SubtitleExtractor
implements Extractor {
    private static final int STATE_CREATED = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_EXTRACTING = 2;
    private static final int STATE_SEEKING = 3;
    private static final int STATE_FINISHED = 4;
    private static final int STATE_RELEASED = 5;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final SubtitleDecoder subtitleDecoder;
    private final CueEncoder cueEncoder;
    private final ParsableByteArray subtitleData;
    private final Format format;
    private final List<Long> timestamps;
    private final List<ParsableByteArray> samples;
    private @MonotonicNonNull ExtractorOutput extractorOutput;
    private @MonotonicNonNull TrackOutput trackOutput;
    private int bytesRead;
    private int state;
    private long seekTimeUs;

    public SubtitleExtractor(SubtitleDecoder subtitleDecoder, Format format) {
        this.subtitleDecoder = subtitleDecoder;
        this.cueEncoder = new CueEncoder();
        this.subtitleData = new ParsableByteArray();
        this.format = format.buildUpon().setSampleMimeType("text/x-exoplayer-cues").setCodecs(format.sampleMimeType).build();
        this.timestamps = new ArrayList<Long>();
        this.samples = new ArrayList<ParsableByteArray>();
        this.state = 0;
        this.seekTimeUs = -9223372036854775807L;
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        return true;
    }

    @Override
    public void init(ExtractorOutput output) {
        Assertions.checkState((this.state == 0 ? 1 : 0) != 0);
        this.extractorOutput = output;
        this.trackOutput = this.extractorOutput.track(0, 3);
        this.extractorOutput.endTracks();
        this.extractorOutput.seekMap(new IndexSeekMap(new long[]{0L}, new long[]{0L}, -9223372036854775807L));
        this.trackOutput.format(this.format);
        this.state = 1;
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        boolean inputFinished;
        Assertions.checkState((this.state != 0 && this.state != 5 ? 1 : 0) != 0);
        if (this.state == 1) {
            this.subtitleData.reset(input.getLength() != -1L ? Ints.checkedCast((long)input.getLength()) : 1024);
            this.bytesRead = 0;
            this.state = 2;
        }
        if (this.state == 2 && (inputFinished = this.readFromInput(input))) {
            this.decode();
            this.writeToOutput();
            this.state = 4;
        }
        if (this.state == 3 && (inputFinished = this.skipInput(input))) {
            this.writeToOutput();
            this.state = 4;
        }
        if (this.state == 4) {
            return -1;
        }
        return 0;
    }

    @Override
    public void seek(long position, long timeUs) {
        Assertions.checkState((this.state != 0 && this.state != 5 ? 1 : 0) != 0);
        this.seekTimeUs = timeUs;
        if (this.state == 2) {
            this.state = 1;
        }
        if (this.state == 4) {
            this.state = 3;
        }
    }

    @Override
    public void release() {
        if (this.state == 5) {
            return;
        }
        this.subtitleDecoder.release();
        this.state = 5;
    }

    private boolean skipInput(ExtractorInput input) throws IOException {
        return input.skip(input.getLength() != -1L ? Ints.checkedCast((long)input.getLength()) : 1024) == -1;
    }

    private boolean readFromInput(ExtractorInput input) throws IOException {
        long inputLength;
        int readResult;
        if (this.subtitleData.capacity() == this.bytesRead) {
            this.subtitleData.ensureCapacity(this.bytesRead + 1024);
        }
        if ((readResult = input.read(this.subtitleData.getData(), this.bytesRead, this.subtitleData.capacity() - this.bytesRead)) != -1) {
            this.bytesRead += readResult;
        }
        return (inputLength = input.getLength()) != -1L && (long)this.bytesRead == inputLength || readResult == -1;
    }

    private void decode() throws IOException {
        try {
            SubtitleInputBuffer inputBuffer = (SubtitleInputBuffer)((Object)this.subtitleDecoder.dequeueInputBuffer());
            while (inputBuffer == null) {
                Thread.sleep(5L);
                inputBuffer = (SubtitleInputBuffer)((Object)this.subtitleDecoder.dequeueInputBuffer());
            }
            inputBuffer.ensureSpaceForWrite(this.bytesRead);
            inputBuffer.data.put(this.subtitleData.getData(), 0, this.bytesRead);
            inputBuffer.data.limit(this.bytesRead);
            this.subtitleDecoder.queueInputBuffer((Object)inputBuffer);
            SubtitleOutputBuffer outputBuffer = (SubtitleOutputBuffer)this.subtitleDecoder.dequeueOutputBuffer();
            while (outputBuffer == null) {
                Thread.sleep(5L);
                outputBuffer = (SubtitleOutputBuffer)this.subtitleDecoder.dequeueOutputBuffer();
            }
            for (int i = 0; i < outputBuffer.getEventTimeCount(); ++i) {
                List<Cue> cues = outputBuffer.getCues(outputBuffer.getEventTime(i));
                byte[] cuesSample = this.cueEncoder.encode(cues);
                this.timestamps.add(outputBuffer.getEventTime(i));
                this.samples.add(new ParsableByteArray(cuesSample));
            }
            outputBuffer.release();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
        catch (SubtitleDecoderException e) {
            throw ParserException.createForMalformedContainer((String)"SubtitleDecoder failed.", (Throwable)((Object)e));
        }
    }

    private void writeToOutput() {
        int index;
        Assertions.checkStateNotNull((Object)this.trackOutput);
        Assertions.checkState((this.timestamps.size() == this.samples.size() ? 1 : 0) != 0);
        for (int i = index = this.seekTimeUs == -9223372036854775807L ? 0 : Util.binarySearchFloor(this.timestamps, (Comparable)Long.valueOf(this.seekTimeUs), (boolean)true, (boolean)true); i < this.samples.size(); ++i) {
            ParsableByteArray sample = this.samples.get(i);
            sample.setPosition(0);
            int size = sample.getData().length;
            this.trackOutput.sampleData(sample, size);
            this.trackOutput.sampleMetadata(this.timestamps.get(i), 1, size, 0, null);
        }
    }
}

