/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.icy;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataInputBuffer;
import com.google.android.exoplayer2.metadata.SimpleMetadataDecoder;
import com.google.android.exoplayer2.metadata.icy.IcyInfo;
import com.google.common.base.Ascii;
import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IcyDecoder
extends SimpleMetadataDecoder {
    private static final Pattern METADATA_ELEMENT = Pattern.compile("(.+?)='(.*?)';", 32);
    private static final String STREAM_KEY_NAME = "streamtitle";
    private static final String STREAM_KEY_URL = "streamurl";
    private final CharsetDecoder utf8Decoder = Charsets.UTF_8.newDecoder();
    private final CharsetDecoder iso88591Decoder = Charsets.ISO_8859_1.newDecoder();

    @Override
    protected Metadata decode(MetadataInputBuffer inputBuffer, ByteBuffer buffer) {
        String icyString = this.decodeToString(buffer);
        byte[] icyBytes = new byte[buffer.limit()];
        buffer.get(icyBytes);
        if (icyString == null) {
            return new Metadata(new Metadata.Entry[]{new IcyInfo(icyBytes, null, null)});
        }
        String name = null;
        String url = null;
        int index = 0;
        Matcher matcher = METADATA_ELEMENT.matcher(icyString);
        while (matcher.find(index)) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            if (key != null) {
                switch (Ascii.toLowerCase((String)key)) {
                    case "streamtitle": {
                        name = value;
                        break;
                    }
                    case "streamurl": {
                        url = value;
                        break;
                    }
                }
            }
            index = matcher.end();
        }
        return new Metadata(new Metadata.Entry[]{new IcyInfo(icyBytes, name, url)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String decodeToString(ByteBuffer data) {
        try {
            String string = this.utf8Decoder.decode(data).toString();
            return string;
        }
        catch (CharacterCodingException characterCodingException) {
        }
        finally {
            this.utf8Decoder.reset();
            data.rewind();
        }
        try {
            String string = this.iso88591Decoder.decode(data).toString();
            return string;
        }
        catch (CharacterCodingException e) {
            String string = null;
            return string;
        }
        finally {
            this.iso88591Decoder.reset();
            data.rewind();
        }
    }
}

