/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp4;

import android.util.Pair;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.Ac4Util;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.CeaUtil;
import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.GaplessInfoHolder;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.mp4.Atom;
import com.google.android.exoplayer2.extractor.mp4.AtomParsers;
import com.google.android.exoplayer2.extractor.mp4.DefaultSampleValues;
import com.google.android.exoplayer2.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer2.extractor.mp4.Sniffer;
import com.google.android.exoplayer2.extractor.mp4.Track;
import com.google.android.exoplayer2.extractor.mp4.TrackEncryptionBox;
import com.google.android.exoplayer2.extractor.mp4.TrackFragment;
import com.google.android.exoplayer2.extractor.mp4.TrackSampleTable;
import com.google.android.exoplayer2.metadata.emsg.EventMessage;
import com.google.android.exoplayer2.metadata.emsg.EventMessageEncoder;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Function;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class FragmentedMp4Extractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new FragmentedMp4Extractor()};
    public static final int FLAG_WORKAROUND_EVERY_VIDEO_FRAME_IS_SYNC_FRAME = 1;
    public static final int FLAG_WORKAROUND_IGNORE_TFDT_BOX = 2;
    public static final int FLAG_ENABLE_EMSG_TRACK = 4;
    public static final int FLAG_WORKAROUND_IGNORE_EDIT_LISTS = 16;
    private static final String TAG = "FragmentedMp4Extractor";
    private static final int SAMPLE_GROUP_TYPE_seig = 1936025959;
    private static final byte[] PIFF_SAMPLE_ENCRYPTION_BOX_EXTENDED_TYPE = new byte[]{-94, 57, 79, 82, 90, -101, 79, 20, -94, 68, 108, 66, 124, 100, -115, -12};
    private static final Format EMSG_FORMAT = new Format.Builder().setSampleMimeType("application/x-emsg").build();
    private static final int EXTRA_TRACKS_BASE_ID = 100;
    private static final int STATE_READING_ATOM_HEADER = 0;
    private static final int STATE_READING_ATOM_PAYLOAD = 1;
    private static final int STATE_READING_ENCRYPTION_DATA = 2;
    private static final int STATE_READING_SAMPLE_START = 3;
    private static final int STATE_READING_SAMPLE_CONTINUE = 4;
    private final int flags;
    @Nullable
    private final Track sideloadedTrack;
    private final List<Format> closedCaptionFormats;
    private final SparseArray<TrackBundle> trackBundles;
    private final ParsableByteArray nalStartCode;
    private final ParsableByteArray nalPrefix;
    private final ParsableByteArray nalBuffer;
    private final byte[] scratchBytes;
    private final ParsableByteArray scratch;
    @Nullable
    private final TimestampAdjuster timestampAdjuster;
    private final EventMessageEncoder eventMessageEncoder;
    private final ParsableByteArray atomHeader;
    private final ArrayDeque<Atom.ContainerAtom> containerAtoms;
    private final ArrayDeque<MetadataSampleInfo> pendingMetadataSampleInfos;
    @Nullable
    private final TrackOutput additionalEmsgTrackOutput;
    private int parserState;
    private int atomType;
    private long atomSize;
    private int atomHeaderBytesRead;
    @Nullable
    private ParsableByteArray atomData;
    private long endOfMdatPosition;
    private int pendingMetadataSampleBytes;
    private long pendingSeekTimeUs;
    private long durationUs;
    private long segmentIndexEarliestPresentationTimeUs;
    @Nullable
    private TrackBundle currentTrackBundle;
    private int sampleSize;
    private int sampleBytesWritten;
    private int sampleCurrentNalBytesRemaining;
    private boolean processSeiNalUnitPayload;
    private ExtractorOutput extractorOutput;
    private TrackOutput[] emsgTrackOutputs;
    private TrackOutput[] ceaTrackOutputs;
    private boolean haveOutputSeekMap;

    public FragmentedMp4Extractor() {
        this(0);
    }

    public FragmentedMp4Extractor(int flags) {
        this(flags, null);
    }

    public FragmentedMp4Extractor(int flags, @Nullable TimestampAdjuster timestampAdjuster) {
        this(flags, timestampAdjuster, null, Collections.emptyList());
    }

    public FragmentedMp4Extractor(int flags, @Nullable TimestampAdjuster timestampAdjuster, @Nullable Track sideloadedTrack) {
        this(flags, timestampAdjuster, sideloadedTrack, Collections.emptyList());
    }

    public FragmentedMp4Extractor(int flags, @Nullable TimestampAdjuster timestampAdjuster, @Nullable Track sideloadedTrack, List<Format> closedCaptionFormats) {
        this(flags, timestampAdjuster, sideloadedTrack, closedCaptionFormats, null);
    }

    public FragmentedMp4Extractor(int flags, @Nullable TimestampAdjuster timestampAdjuster, @Nullable Track sideloadedTrack, List<Format> closedCaptionFormats, @Nullable TrackOutput additionalEmsgTrackOutput) {
        this.flags = flags;
        this.timestampAdjuster = timestampAdjuster;
        this.sideloadedTrack = sideloadedTrack;
        this.closedCaptionFormats = Collections.unmodifiableList(closedCaptionFormats);
        this.additionalEmsgTrackOutput = additionalEmsgTrackOutput;
        this.eventMessageEncoder = new EventMessageEncoder();
        this.atomHeader = new ParsableByteArray(16);
        this.nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
        this.nalPrefix = new ParsableByteArray(5);
        this.nalBuffer = new ParsableByteArray();
        this.scratchBytes = new byte[16];
        this.scratch = new ParsableByteArray(this.scratchBytes);
        this.containerAtoms = new ArrayDeque();
        this.pendingMetadataSampleInfos = new ArrayDeque();
        this.trackBundles = new SparseArray();
        this.durationUs = -9223372036854775807L;
        this.pendingSeekTimeUs = -9223372036854775807L;
        this.segmentIndexEarliestPresentationTimeUs = -9223372036854775807L;
        this.extractorOutput = ExtractorOutput.PLACEHOLDER;
        this.emsgTrackOutputs = new TrackOutput[0];
        this.ceaTrackOutputs = new TrackOutput[0];
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        return Sniffer.sniffFragmented(input);
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
        this.enterReadingAtomHeaderState();
        this.initExtraTracks();
        if (this.sideloadedTrack != null) {
            TrackBundle bundle = new TrackBundle(output.track(0, this.sideloadedTrack.type), new TrackSampleTable(this.sideloadedTrack, new long[0], new int[0], 0, new long[0], new int[0], 0L), new DefaultSampleValues(0, 0, 0, 0));
            this.trackBundles.put(0, (Object)bundle);
            this.extractorOutput.endTracks();
        }
    }

    @Override
    public void seek(long position, long timeUs) {
        int trackCount = this.trackBundles.size();
        for (int i = 0; i < trackCount; ++i) {
            ((TrackBundle)this.trackBundles.valueAt(i)).resetFragmentInfo();
        }
        this.pendingMetadataSampleInfos.clear();
        this.pendingMetadataSampleBytes = 0;
        this.pendingSeekTimeUs = timeUs;
        this.containerAtoms.clear();
        this.enterReadingAtomHeaderState();
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        block5: while (true) {
            switch (this.parserState) {
                case 0: {
                    if (this.readAtomHeader(input)) continue block5;
                    return -1;
                }
                case 1: {
                    this.readAtomPayload(input);
                    continue block5;
                }
                case 2: {
                    this.readEncryptionData(input);
                    continue block5;
                }
            }
            if (this.readSample(input)) break;
        }
        return 0;
    }

    private void enterReadingAtomHeaderState() {
        this.parserState = 0;
        this.atomHeaderBytesRead = 0;
    }

    private boolean readAtomHeader(ExtractorInput input) throws IOException {
        if (this.atomHeaderBytesRead == 0) {
            if (!input.readFully(this.atomHeader.getData(), 0, 8, true)) {
                return false;
            }
            this.atomHeaderBytesRead = 8;
            this.atomHeader.setPosition(0);
            this.atomSize = this.atomHeader.readUnsignedInt();
            this.atomType = this.atomHeader.readInt();
        }
        if (this.atomSize == 1L) {
            int headerBytesRemaining = 8;
            input.readFully(this.atomHeader.getData(), 8, headerBytesRemaining);
            this.atomHeaderBytesRead += headerBytesRemaining;
            this.atomSize = this.atomHeader.readUnsignedLongToLong();
        } else if (this.atomSize == 0L) {
            long endPosition = input.getLength();
            if (endPosition == -1L && !this.containerAtoms.isEmpty()) {
                endPosition = this.containerAtoms.peek().endPosition;
            }
            if (endPosition != -1L) {
                this.atomSize = endPosition - input.getPosition() + (long)this.atomHeaderBytesRead;
            }
        }
        if (this.atomSize < (long)this.atomHeaderBytesRead) {
            throw ParserException.createForUnsupportedContainerFeature((String)"Atom size less than header length (unsupported).");
        }
        long atomPosition = input.getPosition() - (long)this.atomHeaderBytesRead;
        if (!(this.atomType != 0x6D6F6F66 && this.atomType != 1835295092 || this.haveOutputSeekMap)) {
            this.extractorOutput.seekMap(new SeekMap.Unseekable(this.durationUs, atomPosition));
            this.haveOutputSeekMap = true;
        }
        if (this.atomType == 0x6D6F6F66) {
            int trackCount = this.trackBundles.size();
            for (int i = 0; i < trackCount; ++i) {
                TrackFragment fragment = ((TrackBundle)this.trackBundles.valueAt((int)i)).fragment;
                fragment.atomPosition = atomPosition;
                fragment.auxiliaryDataPosition = atomPosition;
                fragment.dataPosition = atomPosition;
            }
        }
        if (this.atomType == 1835295092) {
            this.currentTrackBundle = null;
            this.endOfMdatPosition = atomPosition + this.atomSize;
            this.parserState = 2;
            return true;
        }
        if (FragmentedMp4Extractor.shouldParseContainerAtom(this.atomType)) {
            long endPosition = input.getPosition() + this.atomSize - 8L;
            this.containerAtoms.push(new Atom.ContainerAtom(this.atomType, endPosition));
            if (this.atomSize == (long)this.atomHeaderBytesRead) {
                this.processAtomEnded(endPosition);
            } else {
                this.enterReadingAtomHeaderState();
            }
        } else if (FragmentedMp4Extractor.shouldParseLeafAtom(this.atomType)) {
            if (this.atomHeaderBytesRead != 8) {
                throw ParserException.createForUnsupportedContainerFeature((String)"Leaf atom defines extended atom size (unsupported).");
            }
            if (this.atomSize > Integer.MAX_VALUE) {
                throw ParserException.createForUnsupportedContainerFeature((String)"Leaf atom with length > 2147483647 (unsupported).");
            }
            ParsableByteArray atomData = new ParsableByteArray((int)this.atomSize);
            System.arraycopy(this.atomHeader.getData(), 0, atomData.getData(), 0, 8);
            this.atomData = atomData;
            this.parserState = 1;
        } else {
            if (this.atomSize > Integer.MAX_VALUE) {
                throw ParserException.createForUnsupportedContainerFeature((String)"Skipping atom with length > 2147483647 (unsupported).");
            }
            this.atomData = null;
            this.parserState = 1;
        }
        return true;
    }

    private void readAtomPayload(ExtractorInput input) throws IOException {
        int atomPayloadSize = (int)this.atomSize - this.atomHeaderBytesRead;
        ParsableByteArray atomData = this.atomData;
        if (atomData != null) {
            input.readFully(atomData.getData(), 8, atomPayloadSize);
            this.onLeafAtomRead(new Atom.LeafAtom(this.atomType, atomData), input.getPosition());
        } else {
            input.skipFully(atomPayloadSize);
        }
        this.processAtomEnded(input.getPosition());
    }

    private void processAtomEnded(long atomEndPosition) throws ParserException {
        while (!this.containerAtoms.isEmpty() && this.containerAtoms.peek().endPosition == atomEndPosition) {
            this.onContainerAtomRead(this.containerAtoms.pop());
        }
        this.enterReadingAtomHeaderState();
    }

    private void onLeafAtomRead(Atom.LeafAtom leaf, long inputPosition) throws ParserException {
        if (!this.containerAtoms.isEmpty()) {
            this.containerAtoms.peek().add(leaf);
        } else if (leaf.type == 1936286840) {
            Pair<Long, ChunkIndex> result = FragmentedMp4Extractor.parseSidx(leaf.data, inputPosition);
            this.segmentIndexEarliestPresentationTimeUs = (Long)result.first;
            this.extractorOutput.seekMap((SeekMap)result.second);
            this.haveOutputSeekMap = true;
        } else if (leaf.type == 1701671783) {
            this.onEmsgLeafAtomRead(leaf.data);
        }
    }

    private void onContainerAtomRead(Atom.ContainerAtom container) throws ParserException {
        if (container.type == 1836019574) {
            this.onMoovContainerAtomRead(container);
        } else if (container.type == 0x6D6F6F66) {
            this.onMoofContainerAtomRead(container);
        } else if (!this.containerAtoms.isEmpty()) {
            this.containerAtoms.peek().add(container);
        }
    }

    private void onMoovContainerAtomRead(Atom.ContainerAtom moov) throws ParserException {
        Assertions.checkState((this.sideloadedTrack == null ? 1 : 0) != 0, (Object)"Unexpected moov box.");
        DrmInitData drmInitData = FragmentedMp4Extractor.getDrmInitDataFromAtoms(moov.leafChildren);
        Atom.ContainerAtom mvex = (Atom.ContainerAtom)Assertions.checkNotNull((Object)moov.getContainerAtomOfType(1836475768));
        SparseArray defaultSampleValuesArray = new SparseArray();
        long duration = -9223372036854775807L;
        int mvexChildrenSize = mvex.leafChildren.size();
        for (int i = 0; i < mvexChildrenSize; ++i) {
            Atom.LeafAtom atom = mvex.leafChildren.get(i);
            if (atom.type == 1953654136) {
                Pair<Integer, DefaultSampleValues> trexData = FragmentedMp4Extractor.parseTrex(atom.data);
                defaultSampleValuesArray.put(((Integer)trexData.first).intValue(), (Object)((DefaultSampleValues)trexData.second));
                continue;
            }
            if (atom.type != 1835362404) continue;
            duration = FragmentedMp4Extractor.parseMehd(atom.data);
        }
        List<TrackSampleTable> sampleTables = AtomParsers.parseTraks(moov, new GaplessInfoHolder(), duration, drmInitData, (this.flags & 0x10) != 0, false, (Function<Track, Track>)((Function)this::modifyTrack));
        int trackCount = sampleTables.size();
        if (this.trackBundles.size() == 0) {
            for (int i = 0; i < trackCount; ++i) {
                TrackSampleTable sampleTable = sampleTables.get(i);
                Track track = sampleTable.track;
                TrackBundle trackBundle = new TrackBundle(this.extractorOutput.track(i, track.type), sampleTable, this.getDefaultSampleValues((SparseArray<DefaultSampleValues>)defaultSampleValuesArray, track.id));
                this.trackBundles.put(track.id, (Object)trackBundle);
                this.durationUs = Math.max(this.durationUs, track.durationUs);
            }
            this.extractorOutput.endTracks();
        } else {
            Assertions.checkState((this.trackBundles.size() == trackCount ? 1 : 0) != 0);
            for (int i = 0; i < trackCount; ++i) {
                TrackSampleTable sampleTable = sampleTables.get(i);
                Track track = sampleTable.track;
                ((TrackBundle)this.trackBundles.get(track.id)).reset(sampleTable, this.getDefaultSampleValues((SparseArray<DefaultSampleValues>)defaultSampleValuesArray, track.id));
            }
        }
    }

    @Nullable
    protected Track modifyTrack(@Nullable Track track) {
        return track;
    }

    private DefaultSampleValues getDefaultSampleValues(SparseArray<DefaultSampleValues> defaultSampleValuesArray, int trackId) {
        if (defaultSampleValuesArray.size() == 1) {
            return (DefaultSampleValues)defaultSampleValuesArray.valueAt(0);
        }
        return (DefaultSampleValues)Assertions.checkNotNull((Object)((DefaultSampleValues)defaultSampleValuesArray.get(trackId)));
    }

    private void onMoofContainerAtomRead(Atom.ContainerAtom moof) throws ParserException {
        int i;
        int trackCount;
        FragmentedMp4Extractor.parseMoof(moof, this.trackBundles, this.sideloadedTrack != null, this.flags, this.scratchBytes);
        DrmInitData drmInitData = FragmentedMp4Extractor.getDrmInitDataFromAtoms(moof.leafChildren);
        if (drmInitData != null) {
            trackCount = this.trackBundles.size();
            for (i = 0; i < trackCount; ++i) {
                ((TrackBundle)this.trackBundles.valueAt(i)).updateDrmInitData(drmInitData);
            }
        }
        if (this.pendingSeekTimeUs != -9223372036854775807L) {
            trackCount = this.trackBundles.size();
            for (i = 0; i < trackCount; ++i) {
                ((TrackBundle)this.trackBundles.valueAt(i)).seek(this.pendingSeekTimeUs);
            }
            this.pendingSeekTimeUs = -9223372036854775807L;
        }
    }

    private void initExtraTracks() {
        int nextExtraTrackId = 100;
        this.emsgTrackOutputs = new TrackOutput[2];
        int emsgTrackOutputCount = 0;
        if (this.additionalEmsgTrackOutput != null) {
            this.emsgTrackOutputs[emsgTrackOutputCount++] = this.additionalEmsgTrackOutput;
        }
        if ((this.flags & 4) != 0) {
            this.emsgTrackOutputs[emsgTrackOutputCount++] = this.extractorOutput.track(nextExtraTrackId++, 5);
        }
        for (TrackOutput eventMessageTrackOutput : this.emsgTrackOutputs = (TrackOutput[])Util.nullSafeArrayCopy((Object[])this.emsgTrackOutputs, (int)emsgTrackOutputCount)) {
            eventMessageTrackOutput.format(EMSG_FORMAT);
        }
        this.ceaTrackOutputs = new TrackOutput[this.closedCaptionFormats.size()];
        for (int i = 0; i < this.ceaTrackOutputs.length; ++i) {
            TrackOutput output = this.extractorOutput.track(nextExtraTrackId++, 3);
            output.format(this.closedCaptionFormats.get(i));
            this.ceaTrackOutputs[i] = output;
        }
    }

    private void onEmsgLeafAtomRead(ParsableByteArray atom) {
        long id;
        long durationMs;
        String value;
        String schemeIdUri;
        if (this.emsgTrackOutputs.length == 0) {
            return;
        }
        atom.setPosition(8);
        int fullAtom = atom.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        long presentationTimeDeltaUs = -9223372036854775807L;
        long sampleTimeUs = -9223372036854775807L;
        switch (version) {
            case 0: {
                schemeIdUri = (String)Assertions.checkNotNull((Object)atom.readNullTerminatedString());
                value = (String)Assertions.checkNotNull((Object)atom.readNullTerminatedString());
                long timescale = atom.readUnsignedInt();
                presentationTimeDeltaUs = Util.scaleLargeTimestamp((long)atom.readUnsignedInt(), (long)1000000L, (long)timescale);
                if (this.segmentIndexEarliestPresentationTimeUs != -9223372036854775807L) {
                    sampleTimeUs = this.segmentIndexEarliestPresentationTimeUs + presentationTimeDeltaUs;
                }
                durationMs = Util.scaleLargeTimestamp((long)atom.readUnsignedInt(), (long)1000L, (long)timescale);
                id = atom.readUnsignedInt();
                break;
            }
            case 1: {
                long timescale = atom.readUnsignedInt();
                sampleTimeUs = Util.scaleLargeTimestamp((long)atom.readUnsignedLongToLong(), (long)1000000L, (long)timescale);
                durationMs = Util.scaleLargeTimestamp((long)atom.readUnsignedInt(), (long)1000L, (long)timescale);
                id = atom.readUnsignedInt();
                schemeIdUri = (String)Assertions.checkNotNull((Object)atom.readNullTerminatedString());
                value = (String)Assertions.checkNotNull((Object)atom.readNullTerminatedString());
                break;
            }
            default: {
                Log.w((String)TAG, (String)("Skipping unsupported emsg version: " + version));
                return;
            }
        }
        byte[] messageData = new byte[atom.bytesLeft()];
        atom.readBytes(messageData, 0, atom.bytesLeft());
        EventMessage eventMessage = new EventMessage(schemeIdUri, value, durationMs, id, messageData);
        ParsableByteArray encodedEventMessage = new ParsableByteArray(this.eventMessageEncoder.encode(eventMessage));
        int sampleSize = encodedEventMessage.bytesLeft();
        for (TrackOutput emsgTrackOutput : this.emsgTrackOutputs) {
            encodedEventMessage.setPosition(0);
            emsgTrackOutput.sampleData(encodedEventMessage, sampleSize);
        }
        if (sampleTimeUs == -9223372036854775807L) {
            this.pendingMetadataSampleInfos.addLast(new MetadataSampleInfo(presentationTimeDeltaUs, true, sampleSize));
            this.pendingMetadataSampleBytes += sampleSize;
        } else if (!this.pendingMetadataSampleInfos.isEmpty()) {
            this.pendingMetadataSampleInfos.addLast(new MetadataSampleInfo(sampleTimeUs, false, sampleSize));
            this.pendingMetadataSampleBytes += sampleSize;
        } else {
            if (this.timestampAdjuster != null) {
                sampleTimeUs = this.timestampAdjuster.adjustSampleTimestamp(sampleTimeUs);
            }
            for (TrackOutput emsgTrackOutput : this.emsgTrackOutputs) {
                emsgTrackOutput.sampleMetadata(sampleTimeUs, 1, sampleSize, 0, null);
            }
        }
    }

    private static Pair<Integer, DefaultSampleValues> parseTrex(ParsableByteArray trex) {
        trex.setPosition(12);
        int trackId = trex.readInt();
        int defaultSampleDescriptionIndex = trex.readInt() - 1;
        int defaultSampleDuration = trex.readInt();
        int defaultSampleSize = trex.readInt();
        int defaultSampleFlags = trex.readInt();
        return Pair.create((Object)trackId, (Object)new DefaultSampleValues(defaultSampleDescriptionIndex, defaultSampleDuration, defaultSampleSize, defaultSampleFlags));
    }

    private static long parseMehd(ParsableByteArray mehd) {
        mehd.setPosition(8);
        int fullAtom = mehd.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        return version == 0 ? mehd.readUnsignedInt() : mehd.readUnsignedLongToLong();
    }

    private static void parseMoof(Atom.ContainerAtom moof, SparseArray<TrackBundle> trackBundles, boolean haveSideloadedTrack, int flags, byte[] extendedTypeScratch) throws ParserException {
        int moofContainerChildrenSize = moof.containerChildren.size();
        for (int i = 0; i < moofContainerChildrenSize; ++i) {
            Atom.ContainerAtom child = moof.containerChildren.get(i);
            if (child.type != 1953653094) continue;
            FragmentedMp4Extractor.parseTraf(child, trackBundles, haveSideloadedTrack, flags, extendedTypeScratch);
        }
    }

    private static void parseTraf(Atom.ContainerAtom traf, SparseArray<TrackBundle> trackBundles, boolean haveSideloadedTrack, int flags, byte[] extendedTypeScratch) throws ParserException {
        Atom.LeafAtom senc;
        Atom.LeafAtom saio;
        Atom.LeafAtom tfhd = (Atom.LeafAtom)Assertions.checkNotNull((Object)traf.getLeafAtomOfType(1952868452));
        TrackBundle trackBundle = FragmentedMp4Extractor.parseTfhd(tfhd.data, trackBundles, haveSideloadedTrack);
        if (trackBundle == null) {
            return;
        }
        TrackFragment fragment = trackBundle.fragment;
        long fragmentDecodeTime = fragment.nextFragmentDecodeTime;
        boolean fragmentDecodeTimeIncludesMoov = fragment.nextFragmentDecodeTimeIncludesMoov;
        trackBundle.resetFragmentInfo();
        trackBundle.currentlyInFragment = true;
        Atom.LeafAtom tfdtAtom = traf.getLeafAtomOfType(0x74666474);
        if (tfdtAtom != null && (flags & 2) == 0) {
            fragment.nextFragmentDecodeTime = FragmentedMp4Extractor.parseTfdt(tfdtAtom.data);
            fragment.nextFragmentDecodeTimeIncludesMoov = true;
        } else {
            fragment.nextFragmentDecodeTime = fragmentDecodeTime;
            fragment.nextFragmentDecodeTimeIncludesMoov = fragmentDecodeTimeIncludesMoov;
        }
        FragmentedMp4Extractor.parseTruns(traf, trackBundle, flags);
        TrackEncryptionBox encryptionBox = trackBundle.moovSampleTable.track.getSampleDescriptionEncryptionBox(((DefaultSampleValues)Assertions.checkNotNull((Object)fragment.header)).sampleDescriptionIndex);
        Atom.LeafAtom saiz = traf.getLeafAtomOfType(1935763834);
        if (saiz != null) {
            FragmentedMp4Extractor.parseSaiz((TrackEncryptionBox)Assertions.checkNotNull((Object)encryptionBox), saiz.data, fragment);
        }
        if ((saio = traf.getLeafAtomOfType(1935763823)) != null) {
            FragmentedMp4Extractor.parseSaio(saio.data, fragment);
        }
        if ((senc = traf.getLeafAtomOfType(1936027235)) != null) {
            FragmentedMp4Extractor.parseSenc(senc.data, fragment);
        }
        FragmentedMp4Extractor.parseSampleGroups(traf, encryptionBox != null ? encryptionBox.schemeType : null, fragment);
        int leafChildrenSize = traf.leafChildren.size();
        for (int i = 0; i < leafChildrenSize; ++i) {
            Atom.LeafAtom atom = traf.leafChildren.get(i);
            if (atom.type != 1970628964) continue;
            FragmentedMp4Extractor.parseUuid(atom.data, fragment, extendedTypeScratch);
        }
    }

    private static void parseTruns(Atom.ContainerAtom traf, TrackBundle trackBundle, int flags) throws ParserException {
        int trunCount = 0;
        int totalSampleCount = 0;
        List<Atom.LeafAtom> leafChildren = traf.leafChildren;
        int leafChildrenSize = leafChildren.size();
        for (int i = 0; i < leafChildrenSize; ++i) {
            Atom.LeafAtom atom = leafChildren.get(i);
            if (atom.type != 1953658222) continue;
            ParsableByteArray trunData = atom.data;
            trunData.setPosition(12);
            int trunSampleCount = trunData.readUnsignedIntToInt();
            if (trunSampleCount <= 0) continue;
            totalSampleCount += trunSampleCount;
            ++trunCount;
        }
        trackBundle.currentTrackRunIndex = 0;
        trackBundle.currentSampleInTrackRun = 0;
        trackBundle.currentSampleIndex = 0;
        trackBundle.fragment.initTables(trunCount, totalSampleCount);
        int trunIndex = 0;
        int trunStartPosition = 0;
        for (int i = 0; i < leafChildrenSize; ++i) {
            Atom.LeafAtom trun = leafChildren.get(i);
            if (trun.type != 1953658222) continue;
            trunStartPosition = FragmentedMp4Extractor.parseTrun(trackBundle, trunIndex++, flags, trun.data, trunStartPosition);
        }
    }

    private static void parseSaiz(TrackEncryptionBox encryptionBox, ParsableByteArray saiz, TrackFragment out) throws ParserException {
        int vectorSize = encryptionBox.perSampleIvSize;
        saiz.setPosition(8);
        int fullAtom = saiz.readInt();
        int flags = Atom.parseFullAtomFlags(fullAtom);
        if ((flags & 1) == 1) {
            saiz.skipBytes(8);
        }
        int defaultSampleInfoSize = saiz.readUnsignedByte();
        int sampleCount = saiz.readUnsignedIntToInt();
        if (sampleCount > out.sampleCount) {
            throw ParserException.createForMalformedContainer((String)("Saiz sample count " + sampleCount + " is greater than fragment sample count" + out.sampleCount), null);
        }
        int totalSize = 0;
        if (defaultSampleInfoSize == 0) {
            boolean[] sampleHasSubsampleEncryptionTable = out.sampleHasSubsampleEncryptionTable;
            for (int i = 0; i < sampleCount; ++i) {
                int sampleInfoSize = saiz.readUnsignedByte();
                totalSize += sampleInfoSize;
                sampleHasSubsampleEncryptionTable[i] = sampleInfoSize > vectorSize;
            }
        } else {
            boolean subsampleEncryption = defaultSampleInfoSize > vectorSize;
            totalSize += defaultSampleInfoSize * sampleCount;
            Arrays.fill(out.sampleHasSubsampleEncryptionTable, 0, sampleCount, subsampleEncryption);
        }
        Arrays.fill(out.sampleHasSubsampleEncryptionTable, sampleCount, out.sampleCount, false);
        if (totalSize > 0) {
            out.initEncryptionData(totalSize);
        }
    }

    private static void parseSaio(ParsableByteArray saio, TrackFragment out) throws ParserException {
        int entryCount;
        saio.setPosition(8);
        int fullAtom = saio.readInt();
        int flags = Atom.parseFullAtomFlags(fullAtom);
        if ((flags & 1) == 1) {
            saio.skipBytes(8);
        }
        if ((entryCount = saio.readUnsignedIntToInt()) != 1) {
            throw ParserException.createForMalformedContainer((String)("Unexpected saio entry count: " + entryCount), null);
        }
        int version = Atom.parseFullAtomVersion(fullAtom);
        out.auxiliaryDataPosition = out.auxiliaryDataPosition + (version == 0 ? saio.readUnsignedInt() : saio.readUnsignedLongToLong());
    }

    @Nullable
    private static TrackBundle parseTfhd(ParsableByteArray tfhd, SparseArray<TrackBundle> trackBundles, boolean haveSideloadedTrack) {
        TrackBundle trackBundle;
        tfhd.setPosition(8);
        int fullAtom = tfhd.readInt();
        int atomFlags = Atom.parseFullAtomFlags(fullAtom);
        int trackId = tfhd.readInt();
        TrackBundle trackBundle2 = trackBundle = haveSideloadedTrack ? (TrackBundle)trackBundles.valueAt(0) : (TrackBundle)trackBundles.get(trackId);
        if (trackBundle == null) {
            return null;
        }
        if ((atomFlags & 1) != 0) {
            long baseDataPosition;
            trackBundle.fragment.dataPosition = baseDataPosition = tfhd.readUnsignedLongToLong();
            trackBundle.fragment.auxiliaryDataPosition = baseDataPosition;
        }
        DefaultSampleValues defaultSampleValues = trackBundle.defaultSampleValues;
        int defaultSampleDescriptionIndex = (atomFlags & 2) != 0 ? tfhd.readInt() - 1 : defaultSampleValues.sampleDescriptionIndex;
        int defaultSampleDuration = (atomFlags & 8) != 0 ? tfhd.readInt() : defaultSampleValues.duration;
        int defaultSampleSize = (atomFlags & 0x10) != 0 ? tfhd.readInt() : defaultSampleValues.size;
        int defaultSampleFlags = (atomFlags & 0x20) != 0 ? tfhd.readInt() : defaultSampleValues.flags;
        trackBundle.fragment.header = new DefaultSampleValues(defaultSampleDescriptionIndex, defaultSampleDuration, defaultSampleSize, defaultSampleFlags);
        return trackBundle;
    }

    private static long parseTfdt(ParsableByteArray tfdt) {
        tfdt.setPosition(8);
        int fullAtom = tfdt.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        return version == 1 ? tfdt.readUnsignedLongToLong() : tfdt.readUnsignedInt();
    }

    private static int parseTrun(TrackBundle trackBundle, int index, int flags, ParsableByteArray trun, int trackRunStart) throws ParserException {
        trun.setPosition(8);
        int fullAtom = trun.readInt();
        int atomFlags = Atom.parseFullAtomFlags(fullAtom);
        Track track = trackBundle.moovSampleTable.track;
        TrackFragment fragment = trackBundle.fragment;
        DefaultSampleValues defaultSampleValues = (DefaultSampleValues)Util.castNonNull((Object)fragment.header);
        fragment.trunLength[index] = trun.readUnsignedIntToInt();
        fragment.trunDataPosition[index] = fragment.dataPosition;
        if ((atomFlags & 1) != 0) {
            int n = index;
            fragment.trunDataPosition[n] = fragment.trunDataPosition[n] + (long)trun.readInt();
        }
        boolean firstSampleFlagsPresent = (atomFlags & 4) != 0;
        int firstSampleFlags = defaultSampleValues.flags;
        if (firstSampleFlagsPresent) {
            firstSampleFlags = trun.readInt();
        }
        boolean sampleDurationsPresent = (atomFlags & 0x100) != 0;
        boolean sampleSizesPresent = (atomFlags & 0x200) != 0;
        boolean sampleFlagsPresent = (atomFlags & 0x400) != 0;
        boolean sampleCompositionTimeOffsetsPresent = (atomFlags & 0x800) != 0;
        long edtsOffset = 0L;
        if (track.editListDurations != null && track.editListDurations.length == 1 && track.editListDurations[0] == 0L) {
            edtsOffset = ((long[])Util.castNonNull((Object)track.editListMediaTimes))[0];
        }
        int[] sampleSizeTable = fragment.sampleSizeTable;
        long[] samplePresentationTimesUs = fragment.samplePresentationTimesUs;
        boolean[] sampleIsSyncFrameTable = fragment.sampleIsSyncFrameTable;
        boolean workaroundEveryVideoFrameIsSyncFrame = track.type == 2 && (flags & 1) != 0;
        int trackRunEnd = trackRunStart + fragment.trunLength[index];
        long timescale = track.timescale;
        long cumulativeTime = fragment.nextFragmentDecodeTime;
        for (int i = trackRunStart; i < trackRunEnd; ++i) {
            int sampleDuration = FragmentedMp4Extractor.checkNonNegative(sampleDurationsPresent ? trun.readInt() : defaultSampleValues.duration);
            int sampleSize = FragmentedMp4Extractor.checkNonNegative(sampleSizesPresent ? trun.readInt() : defaultSampleValues.size);
            int sampleFlags = sampleFlagsPresent ? trun.readInt() : (i == 0 && firstSampleFlagsPresent ? firstSampleFlags : defaultSampleValues.flags);
            int sampleCompositionTimeOffset = 0;
            if (sampleCompositionTimeOffsetsPresent) {
                sampleCompositionTimeOffset = trun.readInt();
            }
            long samplePresentationTime = cumulativeTime + (long)sampleCompositionTimeOffset - edtsOffset;
            samplePresentationTimesUs[i] = Util.scaleLargeTimestamp((long)samplePresentationTime, (long)1000000L, (long)timescale);
            if (!fragment.nextFragmentDecodeTimeIncludesMoov) {
                int n = i;
                samplePresentationTimesUs[n] = samplePresentationTimesUs[n] + trackBundle.moovSampleTable.durationUs;
            }
            sampleSizeTable[i] = sampleSize;
            sampleIsSyncFrameTable[i] = (sampleFlags >> 16 & 1) == 0 && (!workaroundEveryVideoFrameIsSyncFrame || i == 0);
            cumulativeTime += (long)sampleDuration;
        }
        fragment.nextFragmentDecodeTime = cumulativeTime;
        return trackRunEnd;
    }

    private static int checkNonNegative(int value) throws ParserException {
        if (value < 0) {
            throw ParserException.createForMalformedContainer((String)("Unexpected negative value: " + value), null);
        }
        return value;
    }

    private static void parseUuid(ParsableByteArray uuid, TrackFragment out, byte[] extendedTypeScratch) throws ParserException {
        uuid.setPosition(8);
        uuid.readBytes(extendedTypeScratch, 0, 16);
        if (!Arrays.equals(extendedTypeScratch, PIFF_SAMPLE_ENCRYPTION_BOX_EXTENDED_TYPE)) {
            return;
        }
        FragmentedMp4Extractor.parseSenc(uuid, 16, out);
    }

    private static void parseSenc(ParsableByteArray senc, TrackFragment out) throws ParserException {
        FragmentedMp4Extractor.parseSenc(senc, 0, out);
    }

    private static void parseSenc(ParsableByteArray senc, int offset, TrackFragment out) throws ParserException {
        senc.setPosition(8 + offset);
        int fullAtom = senc.readInt();
        int flags = Atom.parseFullAtomFlags(fullAtom);
        if ((flags & 1) != 0) {
            throw ParserException.createForUnsupportedContainerFeature((String)"Overriding TrackEncryptionBox parameters is unsupported.");
        }
        boolean subsampleEncryption = (flags & 2) != 0;
        int sampleCount = senc.readUnsignedIntToInt();
        if (sampleCount == 0) {
            Arrays.fill(out.sampleHasSubsampleEncryptionTable, 0, out.sampleCount, false);
            return;
        }
        if (sampleCount != out.sampleCount) {
            throw ParserException.createForMalformedContainer((String)("Senc sample count " + sampleCount + " is different from fragment sample count" + out.sampleCount), null);
        }
        Arrays.fill(out.sampleHasSubsampleEncryptionTable, 0, sampleCount, subsampleEncryption);
        out.initEncryptionData(senc.bytesLeft());
        out.fillEncryptionData(senc);
    }

    private static void parseSampleGroups(Atom.ContainerAtom traf, @Nullable String schemeType, TrackFragment out) throws ParserException {
        boolean isProtected;
        ParsableByteArray sbgp = null;
        ParsableByteArray sgpd = null;
        for (int i = 0; i < traf.leafChildren.size(); ++i) {
            Atom.LeafAtom leafAtom = traf.leafChildren.get(i);
            ParsableByteArray leafAtomData = leafAtom.data;
            if (leafAtom.type == 1935828848) {
                leafAtomData.setPosition(12);
                if (leafAtomData.readInt() != 1936025959) continue;
                sbgp = leafAtomData;
                continue;
            }
            if (leafAtom.type != 1936158820) continue;
            leafAtomData.setPosition(12);
            if (leafAtomData.readInt() != 1936025959) continue;
            sgpd = leafAtomData;
        }
        if (sbgp == null || sgpd == null) {
            return;
        }
        sbgp.setPosition(8);
        int sbgpVersion = Atom.parseFullAtomVersion(sbgp.readInt());
        sbgp.skipBytes(4);
        if (sbgpVersion == 1) {
            sbgp.skipBytes(4);
        }
        if (sbgp.readInt() != 1) {
            throw ParserException.createForUnsupportedContainerFeature((String)"Entry count in sbgp != 1 (unsupported).");
        }
        sgpd.setPosition(8);
        int sgpdVersion = Atom.parseFullAtomVersion(sgpd.readInt());
        sgpd.skipBytes(4);
        if (sgpdVersion == 1) {
            if (sgpd.readUnsignedInt() == 0L) {
                throw ParserException.createForUnsupportedContainerFeature((String)"Variable length description in sgpd found (unsupported)");
            }
        } else if (sgpdVersion >= 2) {
            sgpd.skipBytes(4);
        }
        if (sgpd.readUnsignedInt() != 1L) {
            throw ParserException.createForUnsupportedContainerFeature((String)"Entry count in sgpd != 1 (unsupported).");
        }
        sgpd.skipBytes(1);
        int patternByte = sgpd.readUnsignedByte();
        int cryptByteBlock = (patternByte & 0xF0) >> 4;
        int skipByteBlock = patternByte & 0xF;
        boolean bl = isProtected = sgpd.readUnsignedByte() == 1;
        if (!isProtected) {
            return;
        }
        int perSampleIvSize = sgpd.readUnsignedByte();
        byte[] keyId = new byte[16];
        sgpd.readBytes(keyId, 0, keyId.length);
        byte[] constantIv = null;
        if (perSampleIvSize == 0) {
            int constantIvSize = sgpd.readUnsignedByte();
            constantIv = new byte[constantIvSize];
            sgpd.readBytes(constantIv, 0, constantIvSize);
        }
        out.definesEncryptionData = true;
        out.trackEncryptionBox = new TrackEncryptionBox(isProtected, schemeType, perSampleIvSize, keyId, cryptByteBlock, skipByteBlock, constantIv);
    }

    private static Pair<Long, ChunkIndex> parseSidx(ParsableByteArray atom, long inputPosition) throws ParserException {
        long earliestPresentationTime;
        atom.setPosition(8);
        int fullAtom = atom.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        atom.skipBytes(4);
        long timescale = atom.readUnsignedInt();
        long offset = inputPosition;
        if (version == 0) {
            earliestPresentationTime = atom.readUnsignedInt();
            offset += atom.readUnsignedInt();
        } else {
            earliestPresentationTime = atom.readUnsignedLongToLong();
            offset += atom.readUnsignedLongToLong();
        }
        long earliestPresentationTimeUs = Util.scaleLargeTimestamp((long)earliestPresentationTime, (long)1000000L, (long)timescale);
        atom.skipBytes(2);
        int referenceCount = atom.readUnsignedShort();
        int[] sizes = new int[referenceCount];
        long[] offsets = new long[referenceCount];
        long[] durationsUs = new long[referenceCount];
        long[] timesUs = new long[referenceCount];
        long time = earliestPresentationTime;
        long timeUs = earliestPresentationTimeUs;
        for (int i = 0; i < referenceCount; ++i) {
            int firstInt = atom.readInt();
            int type = Integer.MIN_VALUE & firstInt;
            if (type != 0) {
                throw ParserException.createForMalformedContainer((String)"Unhandled indirect reference", null);
            }
            long referenceDuration = atom.readUnsignedInt();
            sizes[i] = Integer.MAX_VALUE & firstInt;
            offsets[i] = offset;
            timesUs[i] = timeUs;
            timeUs = Util.scaleLargeTimestamp((long)(time += referenceDuration), (long)1000000L, (long)timescale);
            durationsUs[i] = timeUs - timesUs[i];
            atom.skipBytes(4);
            offset += (long)sizes[i];
        }
        return Pair.create((Object)earliestPresentationTimeUs, (Object)new ChunkIndex(sizes, offsets, durationsUs, timesUs));
    }

    private void readEncryptionData(ExtractorInput input) throws IOException {
        TrackBundle nextTrackBundle = null;
        long nextDataOffset = Long.MAX_VALUE;
        int trackBundlesSize = this.trackBundles.size();
        for (int i = 0; i < trackBundlesSize; ++i) {
            TrackFragment trackFragment = ((TrackBundle)this.trackBundles.valueAt((int)i)).fragment;
            if (!trackFragment.sampleEncryptionDataNeedsFill || trackFragment.auxiliaryDataPosition >= nextDataOffset) continue;
            nextDataOffset = trackFragment.auxiliaryDataPosition;
            nextTrackBundle = (TrackBundle)this.trackBundles.valueAt(i);
        }
        if (nextTrackBundle == null) {
            this.parserState = 3;
            return;
        }
        int bytesToSkip = (int)(nextDataOffset - input.getPosition());
        if (bytesToSkip < 0) {
            throw ParserException.createForMalformedContainer((String)"Offset to encryption data was negative.", null);
        }
        input.skipFully(bytesToSkip);
        nextTrackBundle.fragment.fillEncryptionData(input);
    }

    private boolean readSample(ExtractorInput input) throws IOException {
        TrackBundle trackBundle = this.currentTrackBundle;
        if (trackBundle == null) {
            trackBundle = FragmentedMp4Extractor.getNextTrackBundle(this.trackBundles);
            if (trackBundle == null) {
                int bytesToSkip = (int)(this.endOfMdatPosition - input.getPosition());
                if (bytesToSkip < 0) {
                    throw ParserException.createForMalformedContainer((String)"Offset to end of mdat was negative.", null);
                }
                input.skipFully(bytesToSkip);
                this.enterReadingAtomHeaderState();
                return false;
            }
            long nextDataPosition = trackBundle.getCurrentSampleOffset();
            int bytesToSkip = (int)(nextDataPosition - input.getPosition());
            if (bytesToSkip < 0) {
                Log.w((String)TAG, (String)"Ignoring negative offset to sample data.");
                bytesToSkip = 0;
            }
            input.skipFully(bytesToSkip);
            this.currentTrackBundle = trackBundle;
        }
        if (this.parserState == 3) {
            this.sampleSize = trackBundle.getCurrentSampleSize();
            if (trackBundle.currentSampleIndex < trackBundle.firstSampleToOutputIndex) {
                input.skipFully(this.sampleSize);
                trackBundle.skipSampleEncryptionData();
                if (!trackBundle.next()) {
                    this.currentTrackBundle = null;
                }
                this.parserState = 3;
                return true;
            }
            if (trackBundle.moovSampleTable.track.sampleTransformation == 1) {
                this.sampleSize -= 8;
                input.skipFully(8);
            }
            if ("audio/ac4".equals(trackBundle.moovSampleTable.track.format.sampleMimeType)) {
                this.sampleBytesWritten = trackBundle.outputSampleEncryptionData(this.sampleSize, 7);
                Ac4Util.getAc4SampleHeader(this.sampleSize, this.scratch);
                trackBundle.output.sampleData(this.scratch, 7);
                this.sampleBytesWritten += 7;
            } else {
                this.sampleBytesWritten = trackBundle.outputSampleEncryptionData(this.sampleSize, 0);
            }
            this.sampleSize += this.sampleBytesWritten;
            this.parserState = 4;
            this.sampleCurrentNalBytesRemaining = 0;
        }
        Track track = trackBundle.moovSampleTable.track;
        TrackOutput output = trackBundle.output;
        long sampleTimeUs = trackBundle.getCurrentSamplePresentationTimeUs();
        if (this.timestampAdjuster != null) {
            sampleTimeUs = this.timestampAdjuster.adjustSampleTimestamp(sampleTimeUs);
        }
        if (track.nalUnitLengthFieldLength != 0) {
            byte[] nalPrefixData = this.nalPrefix.getData();
            nalPrefixData[0] = 0;
            nalPrefixData[1] = 0;
            nalPrefixData[2] = 0;
            int nalUnitPrefixLength = track.nalUnitLengthFieldLength + 1;
            int nalUnitLengthFieldLengthDiff = 4 - track.nalUnitLengthFieldLength;
            while (this.sampleBytesWritten < this.sampleSize) {
                int writtenBytes;
                if (this.sampleCurrentNalBytesRemaining == 0) {
                    input.readFully(nalPrefixData, nalUnitLengthFieldLengthDiff, nalUnitPrefixLength);
                    this.nalPrefix.setPosition(0);
                    int nalLengthInt = this.nalPrefix.readInt();
                    if (nalLengthInt < 1) {
                        throw ParserException.createForMalformedContainer((String)"Invalid NAL length", null);
                    }
                    this.sampleCurrentNalBytesRemaining = nalLengthInt - 1;
                    this.nalStartCode.setPosition(0);
                    output.sampleData(this.nalStartCode, 4);
                    output.sampleData(this.nalPrefix, 1);
                    this.processSeiNalUnitPayload = this.ceaTrackOutputs.length > 0 && NalUnitUtil.isNalUnitSei(track.format.sampleMimeType, nalPrefixData[4]);
                    this.sampleBytesWritten += 5;
                    this.sampleSize += nalUnitLengthFieldLengthDiff;
                    continue;
                }
                if (this.processSeiNalUnitPayload) {
                    this.nalBuffer.reset(this.sampleCurrentNalBytesRemaining);
                    input.readFully(this.nalBuffer.getData(), 0, this.sampleCurrentNalBytesRemaining);
                    output.sampleData(this.nalBuffer, this.sampleCurrentNalBytesRemaining);
                    writtenBytes = this.sampleCurrentNalBytesRemaining;
                    int unescapedLength = NalUnitUtil.unescapeStream(this.nalBuffer.getData(), this.nalBuffer.limit());
                    this.nalBuffer.setPosition("video/hevc".equals(track.format.sampleMimeType) ? 1 : 0);
                    this.nalBuffer.setLimit(unescapedLength);
                    CeaUtil.consume(sampleTimeUs, this.nalBuffer, this.ceaTrackOutputs);
                } else {
                    writtenBytes = output.sampleData(input, this.sampleCurrentNalBytesRemaining, false);
                }
                this.sampleBytesWritten += writtenBytes;
                this.sampleCurrentNalBytesRemaining -= writtenBytes;
            }
        } else {
            while (this.sampleBytesWritten < this.sampleSize) {
                int writtenBytes = output.sampleData(input, this.sampleSize - this.sampleBytesWritten, false);
                this.sampleBytesWritten += writtenBytes;
            }
        }
        int sampleFlags = trackBundle.getCurrentSampleFlags();
        TrackOutput.CryptoData cryptoData = null;
        TrackEncryptionBox encryptionBox = trackBundle.getEncryptionBoxIfEncrypted();
        if (encryptionBox != null) {
            cryptoData = encryptionBox.cryptoData;
        }
        output.sampleMetadata(sampleTimeUs, sampleFlags, this.sampleSize, 0, cryptoData);
        this.outputPendingMetadataSamples(sampleTimeUs);
        if (!trackBundle.next()) {
            this.currentTrackBundle = null;
        }
        this.parserState = 3;
        return true;
    }

    private void outputPendingMetadataSamples(long sampleTimeUs) {
        while (!this.pendingMetadataSampleInfos.isEmpty()) {
            MetadataSampleInfo metadataSampleInfo = this.pendingMetadataSampleInfos.removeFirst();
            this.pendingMetadataSampleBytes -= metadataSampleInfo.size;
            long metadataSampleTimeUs = metadataSampleInfo.sampleTimeUs;
            if (metadataSampleInfo.sampleTimeIsRelative) {
                metadataSampleTimeUs += sampleTimeUs;
            }
            if (this.timestampAdjuster != null) {
                metadataSampleTimeUs = this.timestampAdjuster.adjustSampleTimestamp(metadataSampleTimeUs);
            }
            for (TrackOutput emsgTrackOutput : this.emsgTrackOutputs) {
                emsgTrackOutput.sampleMetadata(metadataSampleTimeUs, 1, metadataSampleInfo.size, this.pendingMetadataSampleBytes, null);
            }
        }
    }

    @Nullable
    private static TrackBundle getNextTrackBundle(SparseArray<TrackBundle> trackBundles) {
        TrackBundle nextTrackBundle = null;
        long nextSampleOffset = Long.MAX_VALUE;
        int trackBundlesSize = trackBundles.size();
        for (int i = 0; i < trackBundlesSize; ++i) {
            long sampleOffset;
            TrackBundle trackBundle = (TrackBundle)trackBundles.valueAt(i);
            if (!trackBundle.currentlyInFragment && trackBundle.currentSampleIndex == trackBundle.moovSampleTable.sampleCount || trackBundle.currentlyInFragment && trackBundle.currentTrackRunIndex == trackBundle.fragment.trunCount || (sampleOffset = trackBundle.getCurrentSampleOffset()) >= nextSampleOffset) continue;
            nextTrackBundle = trackBundle;
            nextSampleOffset = sampleOffset;
        }
        return nextTrackBundle;
    }

    @Nullable
    private static DrmInitData getDrmInitDataFromAtoms(List<Atom.LeafAtom> leafChildren) {
        ArrayList<DrmInitData.SchemeData> schemeDatas = null;
        int leafChildrenSize = leafChildren.size();
        for (int i = 0; i < leafChildrenSize; ++i) {
            byte[] psshData;
            UUID uuid;
            Atom.LeafAtom child = leafChildren.get(i);
            if (child.type != 1886614376) continue;
            if (schemeDatas == null) {
                schemeDatas = new ArrayList<DrmInitData.SchemeData>();
            }
            if ((uuid = PsshAtomUtil.parseUuid(psshData = child.data.getData())) == null) {
                Log.w((String)TAG, (String)"Skipped pssh atom (failed to extract uuid)");
                continue;
            }
            schemeDatas.add(new DrmInitData.SchemeData(uuid, "video/mp4", psshData));
        }
        return schemeDatas == null ? null : new DrmInitData(schemeDatas);
    }

    private static boolean shouldParseLeafAtom(int atom) {
        return atom == 1751411826 || atom == 1835296868 || atom == 1836476516 || atom == 1936286840 || atom == 1937011556 || atom == 0x73747473 || atom == 1668576371 || atom == 1937011555 || atom == 1937011578 || atom == 1937013298 || atom == 1937007471 || atom == 1668232756 || atom == 0x73747373 || atom == 0x74666474 || atom == 1952868452 || atom == 1953196132 || atom == 1953654136 || atom == 1953658222 || atom == 1886614376 || atom == 1935763834 || atom == 1935763823 || atom == 1936027235 || atom == 1970628964 || atom == 1935828848 || atom == 1936158820 || atom == 1701606260 || atom == 1835362404 || atom == 1701671783;
    }

    private static boolean shouldParseContainerAtom(int atom) {
        return atom == 1836019574 || atom == 1953653099 || atom == 1835297121 || atom == 1835626086 || atom == 1937007212 || atom == 0x6D6F6F66 || atom == 1953653094 || atom == 1836475768 || atom == 1701082227;
    }

    private static final class TrackBundle {
        private static final int SINGLE_SUBSAMPLE_ENCRYPTION_DATA_LENGTH = 8;
        public final TrackOutput output;
        public final TrackFragment fragment;
        public final ParsableByteArray scratch;
        public TrackSampleTable moovSampleTable;
        public DefaultSampleValues defaultSampleValues;
        public int currentSampleIndex;
        public int currentSampleInTrackRun;
        public int currentTrackRunIndex;
        public int firstSampleToOutputIndex;
        private final ParsableByteArray encryptionSignalByte;
        private final ParsableByteArray defaultInitializationVector;
        private boolean currentlyInFragment;

        public TrackBundle(TrackOutput output, TrackSampleTable moovSampleTable, DefaultSampleValues defaultSampleValues) {
            this.output = output;
            this.moovSampleTable = moovSampleTable;
            this.defaultSampleValues = defaultSampleValues;
            this.fragment = new TrackFragment();
            this.scratch = new ParsableByteArray();
            this.encryptionSignalByte = new ParsableByteArray(1);
            this.defaultInitializationVector = new ParsableByteArray();
            this.reset(moovSampleTable, defaultSampleValues);
        }

        public void reset(TrackSampleTable moovSampleTable, DefaultSampleValues defaultSampleValues) {
            this.moovSampleTable = moovSampleTable;
            this.defaultSampleValues = defaultSampleValues;
            this.output.format(moovSampleTable.track.format);
            this.resetFragmentInfo();
        }

        public void updateDrmInitData(DrmInitData drmInitData) {
            TrackEncryptionBox encryptionBox = this.moovSampleTable.track.getSampleDescriptionEncryptionBox(((DefaultSampleValues)Util.castNonNull((Object)this.fragment.header)).sampleDescriptionIndex);
            String schemeType = encryptionBox != null ? encryptionBox.schemeType : null;
            DrmInitData updatedDrmInitData = drmInitData.copyWithSchemeType(schemeType);
            Format format = this.moovSampleTable.track.format.buildUpon().setDrmInitData(updatedDrmInitData).build();
            this.output.format(format);
        }

        public void resetFragmentInfo() {
            this.fragment.reset();
            this.currentSampleIndex = 0;
            this.currentTrackRunIndex = 0;
            this.currentSampleInTrackRun = 0;
            this.firstSampleToOutputIndex = 0;
            this.currentlyInFragment = false;
        }

        public void seek(long timeUs) {
            for (int searchIndex = this.currentSampleIndex; searchIndex < this.fragment.sampleCount && this.fragment.getSamplePresentationTimeUs(searchIndex) < timeUs; ++searchIndex) {
                if (!this.fragment.sampleIsSyncFrameTable[searchIndex]) continue;
                this.firstSampleToOutputIndex = searchIndex;
            }
        }

        public long getCurrentSamplePresentationTimeUs() {
            return !this.currentlyInFragment ? this.moovSampleTable.timestampsUs[this.currentSampleIndex] : this.fragment.getSamplePresentationTimeUs(this.currentSampleIndex);
        }

        public long getCurrentSampleOffset() {
            return !this.currentlyInFragment ? this.moovSampleTable.offsets[this.currentSampleIndex] : this.fragment.trunDataPosition[this.currentTrackRunIndex];
        }

        public int getCurrentSampleSize() {
            return !this.currentlyInFragment ? this.moovSampleTable.sizes[this.currentSampleIndex] : this.fragment.sampleSizeTable[this.currentSampleIndex];
        }

        public int getCurrentSampleFlags() {
            int flags;
            int n = !this.currentlyInFragment ? this.moovSampleTable.flags[this.currentSampleIndex] : (flags = this.fragment.sampleIsSyncFrameTable[this.currentSampleIndex] ? 1 : 0);
            if (this.getEncryptionBoxIfEncrypted() != null) {
                flags |= 0x40000000;
            }
            return flags;
        }

        public boolean next() {
            ++this.currentSampleIndex;
            if (!this.currentlyInFragment) {
                return false;
            }
            ++this.currentSampleInTrackRun;
            if (this.currentSampleInTrackRun == this.fragment.trunLength[this.currentTrackRunIndex]) {
                ++this.currentTrackRunIndex;
                this.currentSampleInTrackRun = 0;
                return false;
            }
            return true;
        }

        public int outputSampleEncryptionData(int sampleSize, int clearHeaderSize) {
            int vectorSize;
            ParsableByteArray initializationVectorData;
            TrackEncryptionBox encryptionBox = this.getEncryptionBoxIfEncrypted();
            if (encryptionBox == null) {
                return 0;
            }
            if (encryptionBox.perSampleIvSize != 0) {
                initializationVectorData = this.fragment.sampleEncryptionData;
                vectorSize = encryptionBox.perSampleIvSize;
            } else {
                byte[] initVectorData = (byte[])Util.castNonNull((Object)encryptionBox.defaultInitializationVector);
                this.defaultInitializationVector.reset(initVectorData, initVectorData.length);
                initializationVectorData = this.defaultInitializationVector;
                vectorSize = initVectorData.length;
            }
            boolean haveSubsampleEncryptionTable = this.fragment.sampleHasSubsampleEncryptionTable(this.currentSampleIndex);
            boolean writeSubsampleEncryptionData = haveSubsampleEncryptionTable || clearHeaderSize != 0;
            this.encryptionSignalByte.getData()[0] = (byte)(vectorSize | (writeSubsampleEncryptionData ? 128 : 0));
            this.encryptionSignalByte.setPosition(0);
            this.output.sampleData(this.encryptionSignalByte, 1, 1);
            this.output.sampleData(initializationVectorData, vectorSize, 1);
            if (!writeSubsampleEncryptionData) {
                return 1 + vectorSize;
            }
            if (!haveSubsampleEncryptionTable) {
                this.scratch.reset(8);
                byte[] data = this.scratch.getData();
                data[0] = 0;
                data[1] = 1;
                data[2] = (byte)(clearHeaderSize >> 8 & 0xFF);
                data[3] = (byte)(clearHeaderSize & 0xFF);
                data[4] = (byte)(sampleSize >> 24 & 0xFF);
                data[5] = (byte)(sampleSize >> 16 & 0xFF);
                data[6] = (byte)(sampleSize >> 8 & 0xFF);
                data[7] = (byte)(sampleSize & 0xFF);
                this.output.sampleData(this.scratch, 8, 1);
                return 1 + vectorSize + 8;
            }
            ParsableByteArray subsampleEncryptionData = this.fragment.sampleEncryptionData;
            int subsampleCount = subsampleEncryptionData.readUnsignedShort();
            subsampleEncryptionData.skipBytes(-2);
            int subsampleDataLength = 2 + 6 * subsampleCount;
            if (clearHeaderSize != 0) {
                this.scratch.reset(subsampleDataLength);
                byte[] scratchData = this.scratch.getData();
                subsampleEncryptionData.readBytes(scratchData, 0, subsampleDataLength);
                int clearDataSize = (scratchData[2] & 0xFF) << 8 | scratchData[3] & 0xFF;
                int adjustedClearDataSize = clearDataSize + clearHeaderSize;
                scratchData[2] = (byte)(adjustedClearDataSize >> 8 & 0xFF);
                scratchData[3] = (byte)(adjustedClearDataSize & 0xFF);
                subsampleEncryptionData = this.scratch;
            }
            this.output.sampleData(subsampleEncryptionData, subsampleDataLength, 1);
            return 1 + vectorSize + subsampleDataLength;
        }

        public void skipSampleEncryptionData() {
            TrackEncryptionBox encryptionBox = this.getEncryptionBoxIfEncrypted();
            if (encryptionBox == null) {
                return;
            }
            ParsableByteArray sampleEncryptionData = this.fragment.sampleEncryptionData;
            if (encryptionBox.perSampleIvSize != 0) {
                sampleEncryptionData.skipBytes(encryptionBox.perSampleIvSize);
            }
            if (this.fragment.sampleHasSubsampleEncryptionTable(this.currentSampleIndex)) {
                sampleEncryptionData.skipBytes(6 * sampleEncryptionData.readUnsignedShort());
            }
        }

        @Nullable
        public TrackEncryptionBox getEncryptionBoxIfEncrypted() {
            if (!this.currentlyInFragment) {
                return null;
            }
            int sampleDescriptionIndex = ((DefaultSampleValues)Util.castNonNull((Object)this.fragment.header)).sampleDescriptionIndex;
            TrackEncryptionBox encryptionBox = this.fragment.trackEncryptionBox != null ? this.fragment.trackEncryptionBox : this.moovSampleTable.track.getSampleDescriptionEncryptionBox(sampleDescriptionIndex);
            return encryptionBox != null && encryptionBox.isEncrypted ? encryptionBox : null;
        }
    }

    private static final class MetadataSampleInfo {
        public final long sampleTimeUs;
        public final boolean sampleTimeIsRelative;
        public final int size;

        public MetadataSampleInfo(long sampleTimeUs, boolean sampleTimeIsRelative, int size) {
            this.sampleTimeUs = sampleTimeUs;
            this.sampleTimeIsRelative = sampleTimeIsRelative;
            this.size = size;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Flags {
    }
}

