/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.wav;

import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.WavUtil;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.wav.WavFormat;
import com.google.android.exoplayer2.extractor.wav.WavHeaderReader;
import com.google.android.exoplayer2.extractor.wav.WavSeekMap;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class WavExtractor
implements Extractor {
    private static final String TAG = "WavExtractor";
    private static final int TARGET_SAMPLES_PER_SECOND = 10;
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new WavExtractor()};
    private static final int STATE_READING_FILE_TYPE = 0;
    private static final int STATE_READING_RF64_SAMPLE_DATA_SIZE = 1;
    private static final int STATE_READING_FORMAT = 2;
    private static final int STATE_SKIPPING_TO_SAMPLE_DATA = 3;
    private static final int STATE_READING_SAMPLE_DATA = 4;
    private @MonotonicNonNull ExtractorOutput extractorOutput;
    private @MonotonicNonNull TrackOutput trackOutput;
    private int state = 0;
    private long rf64SampleDataSize = -1L;
    private @MonotonicNonNull OutputWriter outputWriter;
    private int dataStartPosition = -1;
    private long dataEndPosition = -1L;

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        return WavHeaderReader.checkFileType(input);
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
        this.trackOutput = output.track(0, 1);
        output.endTracks();
    }

    @Override
    public void seek(long position, long timeUs) {
        int n = this.state = position == 0L ? 0 : 4;
        if (this.outputWriter != null) {
            this.outputWriter.reset(timeUs);
        }
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        this.assertInitialized();
        switch (this.state) {
            case 0: {
                this.readFileType(input);
                return 0;
            }
            case 1: {
                this.readRf64SampleDataSize(input);
                return 0;
            }
            case 2: {
                this.readFormat(input);
                return 0;
            }
            case 3: {
                this.skipToSampleData(input);
                return 0;
            }
            case 4: {
                return this.readSampleData(input);
            }
        }
        throw new IllegalStateException();
    }

    @EnsuresNonNull(value={"extractorOutput", "trackOutput"})
    private void assertInitialized() {
        Assertions.checkStateNotNull((Object)this.trackOutput);
        Util.castNonNull((Object)this.extractorOutput);
    }

    private void readFileType(ExtractorInput input) throws IOException {
        Assertions.checkState((input.getPosition() == 0L ? 1 : 0) != 0);
        if (this.dataStartPosition != -1) {
            input.skipFully(this.dataStartPosition);
            this.state = 4;
            return;
        }
        if (!WavHeaderReader.checkFileType(input)) {
            throw ParserException.createForMalformedContainer((String)"Unsupported or unrecognized wav file type.", null);
        }
        input.skipFully((int)(input.getPeekPosition() - input.getPosition()));
        this.state = 1;
    }

    private void readRf64SampleDataSize(ExtractorInput input) throws IOException {
        this.rf64SampleDataSize = WavHeaderReader.readRf64SampleDataSize(input);
        this.state = 2;
    }

    @RequiresNonNull(value={"extractorOutput", "trackOutput"})
    private void readFormat(ExtractorInput input) throws IOException {
        WavFormat wavFormat = WavHeaderReader.readFormat(input);
        if (wavFormat.formatType == 17) {
            this.outputWriter = new ImaAdPcmOutputWriter(this.extractorOutput, this.trackOutput, wavFormat);
        } else if (wavFormat.formatType == 6) {
            this.outputWriter = new PassthroughOutputWriter(this.extractorOutput, this.trackOutput, wavFormat, "audio/g711-alaw", -1);
        } else if (wavFormat.formatType == 7) {
            this.outputWriter = new PassthroughOutputWriter(this.extractorOutput, this.trackOutput, wavFormat, "audio/g711-mlaw", -1);
        } else {
            int pcmEncoding = WavUtil.getPcmEncodingForType(wavFormat.formatType, wavFormat.bitsPerSample);
            if (pcmEncoding == 0) {
                int n = wavFormat.formatType;
                throw ParserException.createForUnsupportedContainerFeature((String)new StringBuilder(40).append("Unsupported WAV format type: ").append(n).toString());
            }
            this.outputWriter = new PassthroughOutputWriter(this.extractorOutput, this.trackOutput, wavFormat, "audio/raw", pcmEncoding);
        }
        this.state = 3;
    }

    private void skipToSampleData(ExtractorInput input) throws IOException {
        Pair<Long, Long> dataBounds = WavHeaderReader.skipToSampleData(input);
        this.dataStartPosition = ((Long)dataBounds.first).intValue();
        long dataSize = (Long)dataBounds.second;
        if (this.rf64SampleDataSize != -1L && dataSize == 0xFFFFFFFFL) {
            dataSize = this.rf64SampleDataSize;
        }
        this.dataEndPosition = (long)this.dataStartPosition + dataSize;
        long inputLength = input.getLength();
        if (inputLength != -1L && this.dataEndPosition > inputLength) {
            long l = this.dataEndPosition;
            Log.w((String)TAG, (String)new StringBuilder(69).append("Data exceeds input length: ").append(l).append(", ").append(inputLength).toString());
            this.dataEndPosition = inputLength;
        }
        ((OutputWriter)Assertions.checkNotNull((Object)this.outputWriter)).init(this.dataStartPosition, this.dataEndPosition);
        this.state = 4;
    }

    private int readSampleData(ExtractorInput input) throws IOException {
        Assertions.checkState((this.dataEndPosition != -1L ? 1 : 0) != 0);
        long bytesLeft = this.dataEndPosition - input.getPosition();
        return ((OutputWriter)Assertions.checkNotNull((Object)this.outputWriter)).sampleData(input, bytesLeft) ? -1 : 0;
    }

    private static final class ImaAdPcmOutputWriter
    implements OutputWriter {
        private static final int[] INDEX_TABLE = new int[]{-1, -1, -1, -1, 2, 4, 6, 8, -1, -1, -1, -1, 2, 4, 6, 8};
        private static final int[] STEP_TABLE = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
        private final ExtractorOutput extractorOutput;
        private final TrackOutput trackOutput;
        private final WavFormat wavFormat;
        private final int framesPerBlock;
        private final byte[] inputData;
        private final ParsableByteArray decodedData;
        private final int targetSampleSizeFrames;
        private final Format format;
        private int pendingInputBytes;
        private long startTimeUs;
        private int pendingOutputBytes;
        private long outputFrameCount;

        public ImaAdPcmOutputWriter(ExtractorOutput extractorOutput, TrackOutput trackOutput, WavFormat wavFormat) throws ParserException {
            this.extractorOutput = extractorOutput;
            this.trackOutput = trackOutput;
            this.wavFormat = wavFormat;
            this.targetSampleSizeFrames = Math.max(1, wavFormat.frameRateHz / 10);
            ParsableByteArray scratch = new ParsableByteArray(wavFormat.extraData);
            scratch.readLittleEndianUnsignedShort();
            this.framesPerBlock = scratch.readLittleEndianUnsignedShort();
            int numChannels = wavFormat.numChannels;
            int expectedFramesPerBlock = (wavFormat.blockSize - 4 * numChannels) * 8 / (wavFormat.bitsPerSample * numChannels) + 1;
            if (this.framesPerBlock != expectedFramesPerBlock) {
                int n = this.framesPerBlock;
                throw ParserException.createForMalformedContainer((String)new StringBuilder(56).append("Expected frames per block: ").append(expectedFramesPerBlock).append("; got: ").append(n).toString(), null);
            }
            int maxBlocksToDecode = Util.ceilDivide((int)this.targetSampleSizeFrames, (int)this.framesPerBlock);
            this.inputData = new byte[maxBlocksToDecode * wavFormat.blockSize];
            this.decodedData = new ParsableByteArray(maxBlocksToDecode * ImaAdPcmOutputWriter.numOutputFramesToBytes(this.framesPerBlock, numChannels));
            int constantBitrate = wavFormat.frameRateHz * wavFormat.blockSize * 8 / this.framesPerBlock;
            this.format = new Format.Builder().setSampleMimeType("audio/raw").setAverageBitrate(constantBitrate).setPeakBitrate(constantBitrate).setMaxInputSize(ImaAdPcmOutputWriter.numOutputFramesToBytes(this.targetSampleSizeFrames, numChannels)).setChannelCount(wavFormat.numChannels).setSampleRate(wavFormat.frameRateHz).setPcmEncoding(2).build();
        }

        @Override
        public void reset(long timeUs) {
            this.pendingInputBytes = 0;
            this.startTimeUs = timeUs;
            this.pendingOutputBytes = 0;
            this.outputFrameCount = 0L;
        }

        @Override
        public void init(int dataStartPosition, long dataEndPosition) {
            this.extractorOutput.seekMap(new WavSeekMap(this.wavFormat, this.framesPerBlock, dataStartPosition, dataEndPosition));
            this.trackOutput.format(this.format);
        }

        @Override
        public boolean sampleData(ExtractorInput input, long bytesLeft) throws IOException {
            int pendingOutputFrames;
            boolean endOfSampleData;
            int targetFramesRemaining = this.targetSampleSizeFrames - this.numOutputBytesToFrames(this.pendingOutputBytes);
            int blocksToDecode = Util.ceilDivide((int)targetFramesRemaining, (int)this.framesPerBlock);
            int targetReadBytes = blocksToDecode * this.wavFormat.blockSize;
            boolean bl = endOfSampleData = bytesLeft == 0L;
            while (!endOfSampleData && this.pendingInputBytes < targetReadBytes) {
                int bytesToRead = (int)Math.min((long)(targetReadBytes - this.pendingInputBytes), bytesLeft);
                int bytesAppended = input.read(this.inputData, this.pendingInputBytes, bytesToRead);
                if (bytesAppended == -1) {
                    endOfSampleData = true;
                    continue;
                }
                this.pendingInputBytes += bytesAppended;
            }
            int pendingBlockCount = this.pendingInputBytes / this.wavFormat.blockSize;
            if (pendingBlockCount > 0) {
                this.decode(this.inputData, pendingBlockCount, this.decodedData);
                this.pendingInputBytes -= pendingBlockCount * this.wavFormat.blockSize;
                int decodedDataSize = this.decodedData.limit();
                this.trackOutput.sampleData(this.decodedData, decodedDataSize);
                this.pendingOutputBytes += decodedDataSize;
                int pendingOutputFrames2 = this.numOutputBytesToFrames(this.pendingOutputBytes);
                if (pendingOutputFrames2 >= this.targetSampleSizeFrames) {
                    this.writeSampleMetadata(this.targetSampleSizeFrames);
                }
            }
            if (endOfSampleData && (pendingOutputFrames = this.numOutputBytesToFrames(this.pendingOutputBytes)) > 0) {
                this.writeSampleMetadata(pendingOutputFrames);
            }
            return endOfSampleData;
        }

        private void writeSampleMetadata(int sampleFrames) {
            long timeUs = this.startTimeUs + Util.scaleLargeTimestamp((long)this.outputFrameCount, (long)1000000L, (long)this.wavFormat.frameRateHz);
            int size = this.numOutputFramesToBytes(sampleFrames);
            int offset = this.pendingOutputBytes - size;
            this.trackOutput.sampleMetadata(timeUs, 1, size, offset, null);
            this.outputFrameCount += (long)sampleFrames;
            this.pendingOutputBytes -= size;
        }

        private void decode(byte[] input, int blockCount, ParsableByteArray output) {
            for (int blockIndex = 0; blockIndex < blockCount; ++blockIndex) {
                for (int channelIndex = 0; channelIndex < this.wavFormat.numChannels; ++channelIndex) {
                    this.decodeBlockForChannel(input, blockIndex, channelIndex, output.getData());
                }
            }
            int decodedDataSize = this.numOutputFramesToBytes(this.framesPerBlock * blockCount);
            output.setPosition(0);
            output.setLimit(decodedDataSize);
        }

        private void decodeBlockForChannel(byte[] input, int blockIndex, int channelIndex, byte[] output) {
            int blockSize = this.wavFormat.blockSize;
            int numChannels = this.wavFormat.numChannels;
            int blockStartIndex = blockIndex * blockSize;
            int headerStartIndex = blockStartIndex + channelIndex * 4;
            int dataStartIndex = headerStartIndex + numChannels * 4;
            int dataSizeBytes = blockSize / numChannels - 4;
            int predictedSample = (input[headerStartIndex + 1] & 0xFF) << 8 | input[headerStartIndex] & 0xFF;
            int stepIndex = Math.min(input[headerStartIndex + 2] & 0xFF, 88);
            int step = STEP_TABLE[stepIndex];
            int outputIndex = (blockIndex * this.framesPerBlock * numChannels + channelIndex) * 2;
            output[outputIndex] = (byte)(predictedSample & 0xFF);
            output[outputIndex + 1] = (byte)(predictedSample >> 8);
            for (int i = 0; i < dataSizeBytes * 2; ++i) {
                int dataSegmentIndex = i / 8;
                int dataSegmentOffset = i / 2 % 4;
                int dataIndex = dataStartIndex + dataSegmentIndex * numChannels * 4 + dataSegmentOffset;
                int originalSample = input[dataIndex] & 0xFF;
                originalSample = i % 2 == 0 ? (originalSample &= 0xF) : (originalSample >>= 4);
                int delta = originalSample & 7;
                int difference = (2 * delta + 1) * step >> 3;
                if ((originalSample & 8) != 0) {
                    difference = -difference;
                }
                predictedSample += difference;
                predictedSample = Util.constrainValue((int)predictedSample, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
                output[outputIndex += 2 * numChannels] = (byte)(predictedSample & 0xFF);
                output[outputIndex + 1] = (byte)(predictedSample >> 8);
                stepIndex += INDEX_TABLE[originalSample];
                stepIndex = Util.constrainValue((int)stepIndex, (int)0, (int)(STEP_TABLE.length - 1));
                step = STEP_TABLE[stepIndex];
            }
        }

        private int numOutputBytesToFrames(int bytes) {
            return bytes / (2 * this.wavFormat.numChannels);
        }

        private int numOutputFramesToBytes(int frames) {
            return ImaAdPcmOutputWriter.numOutputFramesToBytes(frames, this.wavFormat.numChannels);
        }

        private static int numOutputFramesToBytes(int frames, int numChannels) {
            return frames * 2 * numChannels;
        }
    }

    private static final class PassthroughOutputWriter
    implements OutputWriter {
        private final ExtractorOutput extractorOutput;
        private final TrackOutput trackOutput;
        private final WavFormat wavFormat;
        private final Format format;
        private final int targetSampleSizeBytes;
        private long startTimeUs;
        private int pendingOutputBytes;
        private long outputFrameCount;

        public PassthroughOutputWriter(ExtractorOutput extractorOutput, TrackOutput trackOutput, WavFormat wavFormat, String mimeType, int pcmEncoding) throws ParserException {
            this.extractorOutput = extractorOutput;
            this.trackOutput = trackOutput;
            this.wavFormat = wavFormat;
            int bytesPerFrame = wavFormat.numChannels * wavFormat.bitsPerSample / 8;
            if (wavFormat.blockSize != bytesPerFrame) {
                int n = wavFormat.blockSize;
                throw ParserException.createForMalformedContainer((String)new StringBuilder(50).append("Expected block size: ").append(bytesPerFrame).append("; got: ").append(n).toString(), null);
            }
            int constantBitrate = wavFormat.frameRateHz * bytesPerFrame * 8;
            this.targetSampleSizeBytes = Math.max(bytesPerFrame, wavFormat.frameRateHz * bytesPerFrame / 10);
            this.format = new Format.Builder().setSampleMimeType(mimeType).setAverageBitrate(constantBitrate).setPeakBitrate(constantBitrate).setMaxInputSize(this.targetSampleSizeBytes).setChannelCount(wavFormat.numChannels).setSampleRate(wavFormat.frameRateHz).setPcmEncoding(pcmEncoding).build();
        }

        @Override
        public void reset(long timeUs) {
            this.startTimeUs = timeUs;
            this.pendingOutputBytes = 0;
            this.outputFrameCount = 0L;
        }

        @Override
        public void init(int dataStartPosition, long dataEndPosition) {
            this.extractorOutput.seekMap(new WavSeekMap(this.wavFormat, 1, dataStartPosition, dataEndPosition));
            this.trackOutput.format(this.format);
        }

        @Override
        public boolean sampleData(ExtractorInput input, long bytesLeft) throws IOException {
            while (bytesLeft > 0L && this.pendingOutputBytes < this.targetSampleSizeBytes) {
                int bytesToRead = (int)Math.min((long)(this.targetSampleSizeBytes - this.pendingOutputBytes), bytesLeft);
                int bytesAppended = this.trackOutput.sampleData(input, bytesToRead, true);
                if (bytesAppended == -1) {
                    bytesLeft = 0L;
                    continue;
                }
                this.pendingOutputBytes += bytesAppended;
                bytesLeft -= (long)bytesAppended;
            }
            int bytesPerFrame = this.wavFormat.blockSize;
            int pendingFrames = this.pendingOutputBytes / bytesPerFrame;
            if (pendingFrames > 0) {
                long timeUs = this.startTimeUs + Util.scaleLargeTimestamp((long)this.outputFrameCount, (long)1000000L, (long)this.wavFormat.frameRateHz);
                int size = pendingFrames * bytesPerFrame;
                int offset = this.pendingOutputBytes - size;
                this.trackOutput.sampleMetadata(timeUs, 1, size, offset, null);
                this.outputFrameCount += (long)pendingFrames;
                this.pendingOutputBytes = offset;
            }
            return bytesLeft <= 0L;
        }
    }

    private static interface OutputWriter {
        public void reset(long var1);

        public void init(int var1, long var2) throws ParserException;

        public boolean sampleData(ExtractorInput var1, long var2) throws IOException;
    }
}

