/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.icy;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.util.List;
import java.util.Map;

public final class IcyHeaders
implements Metadata.Entry {
    public static final String REQUEST_HEADER_ENABLE_METADATA_NAME = "Icy-MetaData";
    public static final String REQUEST_HEADER_ENABLE_METADATA_VALUE = "1";
    private static final String TAG = "IcyHeaders";
    private static final String RESPONSE_HEADER_BITRATE = "icy-br";
    private static final String RESPONSE_HEADER_GENRE = "icy-genre";
    private static final String RESPONSE_HEADER_NAME = "icy-name";
    private static final String RESPONSE_HEADER_URL = "icy-url";
    private static final String RESPONSE_HEADER_PUB = "icy-pub";
    private static final String RESPONSE_HEADER_METADATA_INTERVAL = "icy-metaint";
    public final int bitrate;
    @Nullable
    public final String genre;
    @Nullable
    public final String name;
    @Nullable
    public final String url;
    public final boolean isPublic;
    public final int metadataInterval;
    public static final Parcelable.Creator<IcyHeaders> CREATOR = new Parcelable.Creator<IcyHeaders>(){

        public IcyHeaders createFromParcel(Parcel in) {
            return new IcyHeaders(in);
        }

        public IcyHeaders[] newArray(int size) {
            return new IcyHeaders[size];
        }
    };

    @Nullable
    public static IcyHeaders parse(Map<String, List<String>> responseHeaders) {
        boolean icyHeadersPresent = false;
        int bitrate = -1;
        String genre = null;
        String name = null;
        String url = null;
        boolean isPublic = false;
        int metadataInterval = -1;
        List<String> headers = responseHeaders.get(RESPONSE_HEADER_BITRATE);
        if (headers != null) {
            String bitrateHeader = headers.get(0);
            try {
                bitrate = Integer.parseInt(bitrateHeader) * 1000;
                if (bitrate > 0) {
                    icyHeadersPresent = true;
                } else {
                    String string = String.valueOf(bitrateHeader);
                    Log.w((String)TAG, (String)(string.length() != 0 ? "Invalid bitrate: ".concat(string) : new String("Invalid bitrate: ")));
                    bitrate = -1;
                }
            }
            catch (NumberFormatException e) {
                String string = String.valueOf(bitrateHeader);
                Log.w((String)TAG, (String)(string.length() != 0 ? "Invalid bitrate header: ".concat(string) : new String("Invalid bitrate header: ")));
            }
        }
        if ((headers = responseHeaders.get(RESPONSE_HEADER_GENRE)) != null) {
            genre = headers.get(0);
            icyHeadersPresent = true;
        }
        if ((headers = responseHeaders.get(RESPONSE_HEADER_NAME)) != null) {
            name = headers.get(0);
            icyHeadersPresent = true;
        }
        if ((headers = responseHeaders.get(RESPONSE_HEADER_URL)) != null) {
            url = headers.get(0);
            icyHeadersPresent = true;
        }
        if ((headers = responseHeaders.get(RESPONSE_HEADER_PUB)) != null) {
            isPublic = headers.get(0).equals(REQUEST_HEADER_ENABLE_METADATA_VALUE);
            icyHeadersPresent = true;
        }
        if ((headers = responseHeaders.get(RESPONSE_HEADER_METADATA_INTERVAL)) != null) {
            String metadataIntervalHeader = headers.get(0);
            try {
                metadataInterval = Integer.parseInt(metadataIntervalHeader);
                if (metadataInterval > 0) {
                    icyHeadersPresent = true;
                } else {
                    String string = String.valueOf(metadataIntervalHeader);
                    Log.w((String)TAG, (String)(string.length() != 0 ? "Invalid metadata interval: ".concat(string) : new String("Invalid metadata interval: ")));
                    metadataInterval = -1;
                }
            }
            catch (NumberFormatException e) {
                String string = String.valueOf(metadataIntervalHeader);
                Log.w((String)TAG, (String)(string.length() != 0 ? "Invalid metadata interval: ".concat(string) : new String("Invalid metadata interval: ")));
            }
        }
        return icyHeadersPresent ? new IcyHeaders(bitrate, genre, name, url, isPublic, metadataInterval) : null;
    }

    public IcyHeaders(int bitrate, @Nullable String genre, @Nullable String name, @Nullable String url, boolean isPublic, int metadataInterval) {
        Assertions.checkArgument((metadataInterval == -1 || metadataInterval > 0 ? 1 : 0) != 0);
        this.bitrate = bitrate;
        this.genre = genre;
        this.name = name;
        this.url = url;
        this.isPublic = isPublic;
        this.metadataInterval = metadataInterval;
    }

    IcyHeaders(Parcel in) {
        this.bitrate = in.readInt();
        this.genre = in.readString();
        this.name = in.readString();
        this.url = in.readString();
        this.isPublic = Util.readBoolean((Parcel)in);
        this.metadataInterval = in.readInt();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IcyHeaders other = (IcyHeaders)obj;
        return this.bitrate == other.bitrate && Util.areEqual((Object)this.genre, (Object)other.genre) && Util.areEqual((Object)this.name, (Object)other.name) && Util.areEqual((Object)this.url, (Object)other.url) && this.isPublic == other.isPublic && this.metadataInterval == other.metadataInterval;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.bitrate;
        result = 31 * result + (this.genre != null ? this.genre.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.isPublic ? 1 : 0);
        result = 31 * result + this.metadataInterval;
        return result;
    }

    public String toString() {
        String string = this.name;
        String string2 = this.genre;
        int n = this.bitrate;
        int n2 = this.metadataInterval;
        return new StringBuilder(80 + String.valueOf(string).length() + String.valueOf(string2).length()).append("IcyHeaders: name=\"").append(string).append("\", genre=\"").append(string2).append("\", bitrate=").append(n).append(", metadataInterval=").append(n2).toString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.bitrate);
        dest.writeString(this.genre);
        dest.writeString(this.name);
        dest.writeString(this.url);
        Util.writeBoolean((Parcel)dest, (boolean)this.isPublic);
        dest.writeInt(this.metadataInterval);
    }

    public int describeContents() {
        return 0;
    }
}

