/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.rawcc;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class RawCcExtractor
implements Extractor {
    private static final int SCRATCH_SIZE = 9;
    private static final int HEADER_SIZE = 8;
    private static final int HEADER_ID = 1380139777;
    private static final int TIMESTAMP_SIZE_V0 = 4;
    private static final int TIMESTAMP_SIZE_V1 = 8;
    private static final int STATE_READING_HEADER = 0;
    private static final int STATE_READING_TIMESTAMP_AND_COUNT = 1;
    private static final int STATE_READING_SAMPLES = 2;
    private final Format format;
    private final ParsableByteArray dataScratch;
    private @MonotonicNonNull TrackOutput trackOutput;
    private int parserState;
    private int version;
    private long timestampUs;
    private int remainingSampleCount;
    private int sampleBytesWritten;

    public RawCcExtractor(Format format) {
        this.format = format;
        this.dataScratch = new ParsableByteArray(9);
        this.parserState = 0;
    }

    @Override
    public void init(ExtractorOutput output) {
        output.seekMap(new SeekMap.Unseekable(-9223372036854775807L));
        this.trackOutput = output.track(0, 3);
        this.trackOutput.format(this.format);
        output.endTracks();
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        this.dataScratch.reset(8);
        input.peekFully(this.dataScratch.getData(), 0, 8);
        return this.dataScratch.readInt() == 1380139777;
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        Assertions.checkStateNotNull((Object)this.trackOutput);
        block5: while (true) {
            switch (this.parserState) {
                case 0: {
                    if (this.parseHeader(input)) {
                        this.parserState = 1;
                        continue block5;
                    }
                    return -1;
                }
                case 1: {
                    if (this.parseTimestampAndSampleCount(input)) {
                        this.parserState = 2;
                        continue block5;
                    }
                    this.parserState = 0;
                    return -1;
                }
                case 2: {
                    this.parseSamples(input);
                    this.parserState = 1;
                    return 0;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    @Override
    public void seek(long position, long timeUs) {
        this.parserState = 0;
    }

    @Override
    public void release() {
    }

    private boolean parseHeader(ExtractorInput input) throws IOException {
        this.dataScratch.reset(8);
        if (input.readFully(this.dataScratch.getData(), 0, 8, true)) {
            if (this.dataScratch.readInt() != 1380139777) {
                throw new IOException("Input not RawCC");
            }
            this.version = this.dataScratch.readUnsignedByte();
            return true;
        }
        return false;
    }

    private boolean parseTimestampAndSampleCount(ExtractorInput input) throws IOException {
        if (this.version == 0) {
            this.dataScratch.reset(5);
            if (!input.readFully(this.dataScratch.getData(), 0, 5, true)) {
                return false;
            }
            this.timestampUs = this.dataScratch.readUnsignedInt() * 1000L / 45L;
        } else if (this.version == 1) {
            this.dataScratch.reset(9);
            if (!input.readFully(this.dataScratch.getData(), 0, 9, true)) {
                return false;
            }
            this.timestampUs = this.dataScratch.readLong();
        } else {
            int n = this.version;
            throw ParserException.createForMalformedContainer((String)new StringBuilder(39).append("Unsupported version number: ").append(n).toString(), null);
        }
        this.remainingSampleCount = this.dataScratch.readUnsignedByte();
        this.sampleBytesWritten = 0;
        return true;
    }

    @RequiresNonNull(value={"trackOutput"})
    private void parseSamples(ExtractorInput input) throws IOException {
        while (this.remainingSampleCount > 0) {
            this.dataScratch.reset(3);
            input.readFully(this.dataScratch.getData(), 0, 3);
            this.trackOutput.sampleData(this.dataScratch, 3);
            this.sampleBytesWritten += 3;
            --this.remainingSampleCount;
        }
        if (this.sampleBytesWritten > 0) {
            this.trackOutput.sampleMetadata(this.timestampUs, 1, this.sampleBytesWritten, 0, null);
        }
    }
}

