/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.extractor.SeekPoint;
import com.google.android.exoplayer2.util.Assertions;

public interface SeekMap {
    public boolean isSeekable();

    public long getDurationUs();

    public SeekPoints getSeekPoints(long var1);

    public static final class SeekPoints {
        public final SeekPoint first;
        public final SeekPoint second;

        public SeekPoints(SeekPoint point) {
            this(point, point);
        }

        public SeekPoints(SeekPoint first, SeekPoint second) {
            this.first = (SeekPoint)Assertions.checkNotNull((Object)first);
            this.second = (SeekPoint)Assertions.checkNotNull((Object)second);
        }

        public String toString() {
            String string;
            String string2;
            String string3 = String.valueOf(this.first);
            if (this.first.equals(this.second)) {
                string2 = "";
            } else {
                string = String.valueOf(this.second);
                string2 = new StringBuilder(2 + String.valueOf(string).length()).append(", ").append(string).toString();
            }
            string = string2;
            return new StringBuilder(2 + String.valueOf(string3).length() + String.valueOf(string).length()).append("[").append(string3).append(string).append("]").toString();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SeekPoints other = (SeekPoints)obj;
            return this.first.equals(other.first) && this.second.equals(other.second);
        }

        public int hashCode() {
            return 31 * this.first.hashCode() + this.second.hashCode();
        }
    }

    public static class Unseekable
    implements SeekMap {
        private final long durationUs;
        private final SeekPoints startSeekPoints;

        public Unseekable(long durationUs) {
            this(durationUs, 0L);
        }

        public Unseekable(long durationUs, long startPosition) {
            this.durationUs = durationUs;
            this.startSeekPoints = new SeekPoints(startPosition == 0L ? SeekPoint.START : new SeekPoint(0L, startPosition));
        }

        @Override
        public boolean isSeekable() {
            return false;
        }

        @Override
        public long getDurationUs() {
            return this.durationUs;
        }

        @Override
        public SeekPoints getSeekPoints(long timeUs) {
            return this.startSeekPoints;
        }
    }
}

