/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.wav;

import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.WavUtil;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.wav.WavHeader;
import com.google.android.exoplayer2.extractor.wav.WavHeaderReader;
import com.google.android.exoplayer2.extractor.wav.WavSeekMap;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class WavExtractor
implements Extractor {
    private static final int TARGET_SAMPLES_PER_SECOND = 10;
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new WavExtractor()};
    private @MonotonicNonNull ExtractorOutput extractorOutput;
    private @MonotonicNonNull TrackOutput trackOutput;
    private @MonotonicNonNull OutputWriter outputWriter;
    private int dataStartPosition = -1;
    private long dataEndPosition = -1L;

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        return WavHeaderReader.peek(input) != null;
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
        this.trackOutput = output.track(0, 1);
        output.endTracks();
    }

    @Override
    public void seek(long position, long timeUs) {
        if (this.outputWriter != null) {
            this.outputWriter.reset(timeUs);
        }
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        this.assertInitialized();
        if (this.outputWriter == null) {
            WavHeader header = WavHeaderReader.peek(input);
            if (header == null) {
                throw new ParserException("Unsupported or unrecognized wav header.");
            }
            if (header.formatType == 17) {
                this.outputWriter = new ImaAdPcmOutputWriter(this.extractorOutput, this.trackOutput, header);
            } else if (header.formatType == 6) {
                this.outputWriter = new PassthroughOutputWriter(this.extractorOutput, this.trackOutput, header, "audio/g711-alaw", -1);
            } else if (header.formatType == 7) {
                this.outputWriter = new PassthroughOutputWriter(this.extractorOutput, this.trackOutput, header, "audio/g711-mlaw", -1);
            } else {
                int pcmEncoding = WavUtil.getPcmEncodingForType((int)header.formatType, (int)header.bitsPerSample);
                if (pcmEncoding == 0) {
                    int n = header.formatType;
                    throw new ParserException(new StringBuilder(40).append("Unsupported WAV format type: ").append(n).toString());
                }
                this.outputWriter = new PassthroughOutputWriter(this.extractorOutput, this.trackOutput, header, "audio/raw", pcmEncoding);
            }
        }
        if (this.dataStartPosition == -1) {
            Pair<Long, Long> dataBounds = WavHeaderReader.skipToData(input);
            this.dataStartPosition = ((Long)dataBounds.first).intValue();
            this.dataEndPosition = (Long)dataBounds.second;
            this.outputWriter.init(this.dataStartPosition, this.dataEndPosition);
        } else if (input.getPosition() == 0L) {
            input.skipFully(this.dataStartPosition);
        }
        Assertions.checkState((this.dataEndPosition != -1L ? 1 : 0) != 0);
        long bytesLeft = this.dataEndPosition - input.getPosition();
        return this.outputWriter.sampleData(input, bytesLeft) ? -1 : 0;
    }

    @EnsuresNonNull(value={"extractorOutput", "trackOutput"})
    private void assertInitialized() {
        Assertions.checkStateNotNull((Object)this.trackOutput);
        Util.castNonNull((Object)this.extractorOutput);
    }

    private static final class ImaAdPcmOutputWriter
    implements OutputWriter {
        private static final int[] INDEX_TABLE = new int[]{-1, -1, -1, -1, 2, 4, 6, 8, -1, -1, -1, -1, 2, 4, 6, 8};
        private static final int[] STEP_TABLE = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
        private final ExtractorOutput extractorOutput;
        private final TrackOutput trackOutput;
        private final WavHeader header;
        private final int framesPerBlock;
        private final byte[] inputData;
        private final ParsableByteArray decodedData;
        private final int targetSampleSizeFrames;
        private final Format format;
        private int pendingInputBytes;
        private long startTimeUs;
        private int pendingOutputBytes;
        private long outputFrameCount;

        public ImaAdPcmOutputWriter(ExtractorOutput extractorOutput, TrackOutput trackOutput, WavHeader header) throws ParserException {
            this.extractorOutput = extractorOutput;
            this.trackOutput = trackOutput;
            this.header = header;
            this.targetSampleSizeFrames = Math.max(1, header.frameRateHz / 10);
            ParsableByteArray scratch = new ParsableByteArray(header.extraData);
            scratch.readLittleEndianUnsignedShort();
            this.framesPerBlock = scratch.readLittleEndianUnsignedShort();
            int numChannels = header.numChannels;
            int expectedFramesPerBlock = (header.blockSize - 4 * numChannels) * 8 / (header.bitsPerSample * numChannels) + 1;
            if (this.framesPerBlock != expectedFramesPerBlock) {
                int n = this.framesPerBlock;
                throw new ParserException(new StringBuilder(56).append("Expected frames per block: ").append(expectedFramesPerBlock).append("; got: ").append(n).toString());
            }
            int maxBlocksToDecode = Util.ceilDivide((int)this.targetSampleSizeFrames, (int)this.framesPerBlock);
            this.inputData = new byte[maxBlocksToDecode * header.blockSize];
            this.decodedData = new ParsableByteArray(maxBlocksToDecode * ImaAdPcmOutputWriter.numOutputFramesToBytes(this.framesPerBlock, numChannels));
            int constantBitrate = header.frameRateHz * header.blockSize * 8 / this.framesPerBlock;
            this.format = new Format.Builder().setSampleMimeType("audio/raw").setAverageBitrate(constantBitrate).setPeakBitrate(constantBitrate).setMaxInputSize(ImaAdPcmOutputWriter.numOutputFramesToBytes(this.targetSampleSizeFrames, numChannels)).setChannelCount(header.numChannels).setSampleRate(header.frameRateHz).setPcmEncoding(2).build();
        }

        @Override
        public void reset(long timeUs) {
            this.pendingInputBytes = 0;
            this.startTimeUs = timeUs;
            this.pendingOutputBytes = 0;
            this.outputFrameCount = 0L;
        }

        @Override
        public void init(int dataStartPosition, long dataEndPosition) {
            this.extractorOutput.seekMap(new WavSeekMap(this.header, this.framesPerBlock, dataStartPosition, dataEndPosition));
            this.trackOutput.format(this.format);
        }

        @Override
        public boolean sampleData(ExtractorInput input, long bytesLeft) throws IOException {
            int pendingOutputFrames;
            boolean endOfSampleData;
            int targetFramesRemaining = this.targetSampleSizeFrames - this.numOutputBytesToFrames(this.pendingOutputBytes);
            int blocksToDecode = Util.ceilDivide((int)targetFramesRemaining, (int)this.framesPerBlock);
            int targetReadBytes = blocksToDecode * this.header.blockSize;
            boolean bl = endOfSampleData = bytesLeft == 0L;
            while (!endOfSampleData && this.pendingInputBytes < targetReadBytes) {
                int bytesToRead = (int)Math.min((long)(targetReadBytes - this.pendingInputBytes), bytesLeft);
                int bytesAppended = input.read(this.inputData, this.pendingInputBytes, bytesToRead);
                if (bytesAppended == -1) {
                    endOfSampleData = true;
                    continue;
                }
                this.pendingInputBytes += bytesAppended;
            }
            int pendingBlockCount = this.pendingInputBytes / this.header.blockSize;
            if (pendingBlockCount > 0) {
                this.decode(this.inputData, pendingBlockCount, this.decodedData);
                this.pendingInputBytes -= pendingBlockCount * this.header.blockSize;
                int decodedDataSize = this.decodedData.limit();
                this.trackOutput.sampleData(this.decodedData, decodedDataSize);
                this.pendingOutputBytes += decodedDataSize;
                int pendingOutputFrames2 = this.numOutputBytesToFrames(this.pendingOutputBytes);
                if (pendingOutputFrames2 >= this.targetSampleSizeFrames) {
                    this.writeSampleMetadata(this.targetSampleSizeFrames);
                }
            }
            if (endOfSampleData && (pendingOutputFrames = this.numOutputBytesToFrames(this.pendingOutputBytes)) > 0) {
                this.writeSampleMetadata(pendingOutputFrames);
            }
            return endOfSampleData;
        }

        private void writeSampleMetadata(int sampleFrames) {
            long timeUs = this.startTimeUs + Util.scaleLargeTimestamp((long)this.outputFrameCount, (long)1000000L, (long)this.header.frameRateHz);
            int size = this.numOutputFramesToBytes(sampleFrames);
            int offset = this.pendingOutputBytes - size;
            this.trackOutput.sampleMetadata(timeUs, 1, size, offset, null);
            this.outputFrameCount += (long)sampleFrames;
            this.pendingOutputBytes -= size;
        }

        private void decode(byte[] input, int blockCount, ParsableByteArray output) {
            for (int blockIndex = 0; blockIndex < blockCount; ++blockIndex) {
                for (int channelIndex = 0; channelIndex < this.header.numChannels; ++channelIndex) {
                    this.decodeBlockForChannel(input, blockIndex, channelIndex, output.getData());
                }
            }
            int decodedDataSize = this.numOutputFramesToBytes(this.framesPerBlock * blockCount);
            output.setPosition(0);
            output.setLimit(decodedDataSize);
        }

        private void decodeBlockForChannel(byte[] input, int blockIndex, int channelIndex, byte[] output) {
            int blockSize = this.header.blockSize;
            int numChannels = this.header.numChannels;
            int blockStartIndex = blockIndex * blockSize;
            int headerStartIndex = blockStartIndex + channelIndex * 4;
            int dataStartIndex = headerStartIndex + numChannels * 4;
            int dataSizeBytes = blockSize / numChannels - 4;
            int predictedSample = (input[headerStartIndex + 1] & 0xFF) << 8 | input[headerStartIndex] & 0xFF;
            int stepIndex = Math.min(input[headerStartIndex + 2] & 0xFF, 88);
            int step = STEP_TABLE[stepIndex];
            int outputIndex = (blockIndex * this.framesPerBlock * numChannels + channelIndex) * 2;
            output[outputIndex] = (byte)(predictedSample & 0xFF);
            output[outputIndex + 1] = (byte)(predictedSample >> 8);
            for (int i = 0; i < dataSizeBytes * 2; ++i) {
                int dataSegmentIndex = i / 8;
                int dataSegmentOffset = i / 2 % 4;
                int dataIndex = dataStartIndex + dataSegmentIndex * numChannels * 4 + dataSegmentOffset;
                int originalSample = input[dataIndex] & 0xFF;
                originalSample = i % 2 == 0 ? (originalSample &= 0xF) : (originalSample >>= 4);
                int delta = originalSample & 7;
                int difference = (2 * delta + 1) * step >> 3;
                if ((originalSample & 8) != 0) {
                    difference = -difference;
                }
                predictedSample += difference;
                predictedSample = Util.constrainValue((int)predictedSample, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
                output[outputIndex += 2 * numChannels] = (byte)(predictedSample & 0xFF);
                output[outputIndex + 1] = (byte)(predictedSample >> 8);
                stepIndex += INDEX_TABLE[originalSample];
                stepIndex = Util.constrainValue((int)stepIndex, (int)0, (int)(STEP_TABLE.length - 1));
                step = STEP_TABLE[stepIndex];
            }
        }

        private int numOutputBytesToFrames(int bytes) {
            return bytes / (2 * this.header.numChannels);
        }

        private int numOutputFramesToBytes(int frames) {
            return ImaAdPcmOutputWriter.numOutputFramesToBytes(frames, this.header.numChannels);
        }

        private static int numOutputFramesToBytes(int frames, int numChannels) {
            return frames * 2 * numChannels;
        }
    }

    private static final class PassthroughOutputWriter
    implements OutputWriter {
        private final ExtractorOutput extractorOutput;
        private final TrackOutput trackOutput;
        private final WavHeader header;
        private final Format format;
        private final int targetSampleSizeBytes;
        private long startTimeUs;
        private int pendingOutputBytes;
        private long outputFrameCount;

        public PassthroughOutputWriter(ExtractorOutput extractorOutput, TrackOutput trackOutput, WavHeader header, String mimeType, int pcmEncoding) throws ParserException {
            this.extractorOutput = extractorOutput;
            this.trackOutput = trackOutput;
            this.header = header;
            int bytesPerFrame = header.numChannels * header.bitsPerSample / 8;
            if (header.blockSize != bytesPerFrame) {
                int n = header.blockSize;
                throw new ParserException(new StringBuilder(50).append("Expected block size: ").append(bytesPerFrame).append("; got: ").append(n).toString());
            }
            int constantBitrate = header.frameRateHz * bytesPerFrame * 8;
            this.targetSampleSizeBytes = Math.max(bytesPerFrame, header.frameRateHz * bytesPerFrame / 10);
            this.format = new Format.Builder().setSampleMimeType(mimeType).setAverageBitrate(constantBitrate).setPeakBitrate(constantBitrate).setMaxInputSize(this.targetSampleSizeBytes).setChannelCount(header.numChannels).setSampleRate(header.frameRateHz).setPcmEncoding(pcmEncoding).build();
        }

        @Override
        public void reset(long timeUs) {
            this.startTimeUs = timeUs;
            this.pendingOutputBytes = 0;
            this.outputFrameCount = 0L;
        }

        @Override
        public void init(int dataStartPosition, long dataEndPosition) {
            this.extractorOutput.seekMap(new WavSeekMap(this.header, 1, dataStartPosition, dataEndPosition));
            this.trackOutput.format(this.format);
        }

        @Override
        public boolean sampleData(ExtractorInput input, long bytesLeft) throws IOException {
            while (bytesLeft > 0L && this.pendingOutputBytes < this.targetSampleSizeBytes) {
                int bytesToRead = (int)Math.min((long)(this.targetSampleSizeBytes - this.pendingOutputBytes), bytesLeft);
                int bytesAppended = this.trackOutput.sampleData(input, bytesToRead, true);
                if (bytesAppended == -1) {
                    bytesLeft = 0L;
                    continue;
                }
                this.pendingOutputBytes += bytesAppended;
                bytesLeft -= (long)bytesAppended;
            }
            int bytesPerFrame = this.header.blockSize;
            int pendingFrames = this.pendingOutputBytes / bytesPerFrame;
            if (pendingFrames > 0) {
                long timeUs = this.startTimeUs + Util.scaleLargeTimestamp((long)this.outputFrameCount, (long)1000000L, (long)this.header.frameRateHz);
                int size = pendingFrames * bytesPerFrame;
                int offset = this.pendingOutputBytes - size;
                this.trackOutput.sampleMetadata(timeUs, 1, size, offset, null);
                this.outputFrameCount += (long)pendingFrames;
                this.pendingOutputBytes = offset;
            }
            return bytesLeft <= 0L;
        }
    }

    private static interface OutputWriter {
        public void reset(long var1);

        public void init(int var1, long var2) throws ParserException;

        public boolean sampleData(ExtractorInput var1, long var2) throws IOException;
    }
}

