/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class Id3Reader
implements ElementaryStreamReader {
    private static final String TAG = "Id3Reader";
    private final ParsableByteArray id3Header = new ParsableByteArray(10);
    private @MonotonicNonNull TrackOutput output;
    private boolean writingSample;
    private long sampleTimeUs;
    private int sampleSize;
    private int sampleBytesRead;

    @Override
    public void seek() {
        this.writingSample = false;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        idGenerator.generateNewId();
        this.output = extractorOutput.track(idGenerator.getTrackId(), 5);
        this.output.format(new Format.Builder().setId(idGenerator.getFormatId()).setSampleMimeType("application/id3").build());
    }

    @Override
    public void packetStarted(long pesTimeUs, int flags) {
        if ((flags & 4) == 0) {
            return;
        }
        this.writingSample = true;
        this.sampleTimeUs = pesTimeUs;
        this.sampleSize = 0;
        this.sampleBytesRead = 0;
    }

    @Override
    public void consume(ParsableByteArray data) {
        Assertions.checkStateNotNull((Object)this.output);
        if (!this.writingSample) {
            return;
        }
        int bytesAvailable = data.bytesLeft();
        if (this.sampleBytesRead < 10) {
            int headerBytesAvailable = Math.min(bytesAvailable, 10 - this.sampleBytesRead);
            System.arraycopy(data.getData(), data.getPosition(), this.id3Header.getData(), this.sampleBytesRead, headerBytesAvailable);
            if (this.sampleBytesRead + headerBytesAvailable == 10) {
                this.id3Header.setPosition(0);
                if (73 != this.id3Header.readUnsignedByte() || 68 != this.id3Header.readUnsignedByte() || 51 != this.id3Header.readUnsignedByte()) {
                    Log.w((String)TAG, (String)"Discarding invalid ID3 tag");
                    this.writingSample = false;
                    return;
                }
                this.id3Header.skipBytes(3);
                this.sampleSize = 10 + this.id3Header.readSynchSafeInt();
            }
        }
        int bytesToWrite = Math.min(bytesAvailable, this.sampleSize - this.sampleBytesRead);
        this.output.sampleData(data, bytesToWrite);
        this.sampleBytesRead += bytesToWrite;
    }

    @Override
    public void packetFinished() {
        Assertions.checkStateNotNull((Object)this.output);
        if (!this.writingSample || this.sampleSize == 0 || this.sampleBytesRead != this.sampleSize) {
            return;
        }
        this.output.sampleMetadata(this.sampleTimeUs, 1, this.sampleSize, 0, null);
        this.writingSample = false;
    }
}

