/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.flac.PictureFrame;
import com.google.android.exoplayer2.metadata.flac.VorbisComment;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class FlacStreamMetadata {
    private static final String TAG = "FlacStreamMetadata";
    public static final int NOT_IN_LOOKUP_TABLE = -1;
    private static final String SEPARATOR = "=";
    public final int minBlockSizeSamples;
    public final int maxBlockSizeSamples;
    public final int minFrameSize;
    public final int maxFrameSize;
    public final int sampleRate;
    public final int sampleRateLookupKey;
    public final int channels;
    public final int bitsPerSample;
    public final int bitsPerSampleLookupKey;
    public final long totalSamples;
    @Nullable
    public final SeekTable seekTable;
    @Nullable
    private final Metadata metadata;

    public FlacStreamMetadata(byte[] data, int offset) {
        ParsableBitArray scratch = new ParsableBitArray(data);
        scratch.setPosition(offset * 8);
        this.minBlockSizeSamples = scratch.readBits(16);
        this.maxBlockSizeSamples = scratch.readBits(16);
        this.minFrameSize = scratch.readBits(24);
        this.maxFrameSize = scratch.readBits(24);
        this.sampleRate = scratch.readBits(20);
        this.sampleRateLookupKey = FlacStreamMetadata.getSampleRateLookupKey(this.sampleRate);
        this.channels = scratch.readBits(3) + 1;
        this.bitsPerSample = scratch.readBits(5) + 1;
        this.bitsPerSampleLookupKey = FlacStreamMetadata.getBitsPerSampleLookupKey(this.bitsPerSample);
        this.totalSamples = scratch.readBitsToLong(36);
        this.seekTable = null;
        this.metadata = null;
    }

    public FlacStreamMetadata(int minBlockSizeSamples, int maxBlockSizeSamples, int minFrameSize, int maxFrameSize, int sampleRate, int channels, int bitsPerSample, long totalSamples, ArrayList<String> vorbisComments, ArrayList<PictureFrame> pictureFrames) {
        this(minBlockSizeSamples, maxBlockSizeSamples, minFrameSize, maxFrameSize, sampleRate, channels, bitsPerSample, totalSamples, null, FlacStreamMetadata.buildMetadata(vorbisComments, pictureFrames));
    }

    private FlacStreamMetadata(int minBlockSizeSamples, int maxBlockSizeSamples, int minFrameSize, int maxFrameSize, int sampleRate, int channels, int bitsPerSample, long totalSamples, @Nullable SeekTable seekTable, @Nullable Metadata metadata) {
        this.minBlockSizeSamples = minBlockSizeSamples;
        this.maxBlockSizeSamples = maxBlockSizeSamples;
        this.minFrameSize = minFrameSize;
        this.maxFrameSize = maxFrameSize;
        this.sampleRate = sampleRate;
        this.sampleRateLookupKey = FlacStreamMetadata.getSampleRateLookupKey(sampleRate);
        this.channels = channels;
        this.bitsPerSample = bitsPerSample;
        this.bitsPerSampleLookupKey = FlacStreamMetadata.getBitsPerSampleLookupKey(bitsPerSample);
        this.totalSamples = totalSamples;
        this.seekTable = seekTable;
        this.metadata = metadata;
    }

    public int getMaxDecodedFrameSize() {
        return this.maxBlockSizeSamples * this.channels * (this.bitsPerSample / 8);
    }

    public int getDecodedBitrate() {
        return this.bitsPerSample * this.sampleRate * this.channels;
    }

    public long getDurationUs() {
        return this.totalSamples == 0L ? -9223372036854775807L : this.totalSamples * 1000000L / (long)this.sampleRate;
    }

    public long getSampleNumber(long timeUs) {
        long sampleNumber = timeUs * (long)this.sampleRate / 1000000L;
        return Util.constrainValue((long)sampleNumber, (long)0L, (long)(this.totalSamples - 1L));
    }

    public long getApproxBytesPerFrame() {
        long approxBytesPerFrame;
        if (this.maxFrameSize > 0) {
            approxBytesPerFrame = ((long)this.maxFrameSize + (long)this.minFrameSize) / 2L + 1L;
        } else {
            long blockSizeSamples = this.minBlockSizeSamples == this.maxBlockSizeSamples && this.minBlockSizeSamples > 0 ? (long)this.minBlockSizeSamples : 4096L;
            approxBytesPerFrame = blockSizeSamples * (long)this.channels * (long)this.bitsPerSample / 8L + 64L;
        }
        return approxBytesPerFrame;
    }

    public Format getFormat(byte[] streamMarkerAndInfoBlock, @Nullable Metadata id3Metadata) {
        streamMarkerAndInfoBlock[4] = -128;
        int maxInputSize = this.maxFrameSize > 0 ? this.maxFrameSize : -1;
        Metadata metadataWithId3 = this.getMetadataCopyWithAppendedEntriesFrom(id3Metadata);
        return new Format.Builder().setSampleMimeType("audio/flac").setMaxInputSize(maxInputSize).setChannelCount(this.channels).setSampleRate(this.sampleRate).setInitializationData(Collections.singletonList(streamMarkerAndInfoBlock)).setMetadata(metadataWithId3).build();
    }

    @Nullable
    public Metadata getMetadataCopyWithAppendedEntriesFrom(@Nullable Metadata other) {
        return this.metadata == null ? other : this.metadata.copyWithAppendedEntriesFrom(other);
    }

    public FlacStreamMetadata copyWithSeekTable(@Nullable SeekTable seekTable) {
        return new FlacStreamMetadata(this.minBlockSizeSamples, this.maxBlockSizeSamples, this.minFrameSize, this.maxFrameSize, this.sampleRate, this.channels, this.bitsPerSample, this.totalSamples, seekTable, this.metadata);
    }

    public FlacStreamMetadata copyWithVorbisComments(List<String> vorbisComments) {
        Metadata appendedMetadata = this.getMetadataCopyWithAppendedEntriesFrom(FlacStreamMetadata.buildMetadata(vorbisComments, Collections.emptyList()));
        return new FlacStreamMetadata(this.minBlockSizeSamples, this.maxBlockSizeSamples, this.minFrameSize, this.maxFrameSize, this.sampleRate, this.channels, this.bitsPerSample, this.totalSamples, this.seekTable, appendedMetadata);
    }

    public FlacStreamMetadata copyWithPictureFrames(List<PictureFrame> pictureFrames) {
        Metadata appendedMetadata = this.getMetadataCopyWithAppendedEntriesFrom(FlacStreamMetadata.buildMetadata(Collections.emptyList(), pictureFrames));
        return new FlacStreamMetadata(this.minBlockSizeSamples, this.maxBlockSizeSamples, this.minFrameSize, this.maxFrameSize, this.sampleRate, this.channels, this.bitsPerSample, this.totalSamples, this.seekTable, appendedMetadata);
    }

    private static int getSampleRateLookupKey(int sampleRate) {
        switch (sampleRate) {
            case 88200: {
                return 1;
            }
            case 176400: {
                return 2;
            }
            case 192000: {
                return 3;
            }
            case 8000: {
                return 4;
            }
            case 16000: {
                return 5;
            }
            case 22050: {
                return 6;
            }
            case 24000: {
                return 7;
            }
            case 32000: {
                return 8;
            }
            case 44100: {
                return 9;
            }
            case 48000: {
                return 10;
            }
            case 96000: {
                return 11;
            }
        }
        return -1;
    }

    private static int getBitsPerSampleLookupKey(int bitsPerSample) {
        switch (bitsPerSample) {
            case 8: {
                return 1;
            }
            case 12: {
                return 2;
            }
            case 16: {
                return 4;
            }
            case 20: {
                return 5;
            }
            case 24: {
                return 6;
            }
        }
        return -1;
    }

    @Nullable
    private static Metadata buildMetadata(List<String> vorbisComments, List<PictureFrame> pictureFrames) {
        if (vorbisComments.isEmpty() && pictureFrames.isEmpty()) {
            return null;
        }
        ArrayList<Object> metadataEntries = new ArrayList<Object>();
        for (int i = 0; i < vorbisComments.size(); ++i) {
            String vorbisComment = vorbisComments.get(i);
            String[] keyAndValue = Util.splitAtFirst((String)vorbisComment, (String)SEPARATOR);
            if (keyAndValue.length != 2) {
                Log.w((String)TAG, (String)("Failed to parse Vorbis comment: " + vorbisComment));
                continue;
            }
            VorbisComment entry = new VorbisComment(keyAndValue[0], keyAndValue[1]);
            metadataEntries.add(entry);
        }
        metadataEntries.addAll(pictureFrames);
        return metadataEntries.isEmpty() ? null : new Metadata(metadataEntries);
    }

    public static class SeekTable {
        public final long[] pointSampleNumbers;
        public final long[] pointOffsets;

        public SeekTable(long[] pointSampleNumbers, long[] pointOffsets) {
            this.pointSampleNumbers = pointSampleNumbers;
            this.pointOffsets = pointOffsets;
        }
    }
}

