/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.crypto;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.DataSink;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.crypto.AesFlushingCipher;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

@Deprecated
public final class AesCipherDataSink
implements DataSink {
    private final DataSink wrappedDataSink;
    private final byte[] secretKey;
    @Nullable
    private final byte[] scratch;
    @Nullable
    private AesFlushingCipher cipher;

    public AesCipherDataSink(byte[] secretKey, DataSink wrappedDataSink) {
        this(secretKey, wrappedDataSink, null);
    }

    public AesCipherDataSink(byte[] secretKey, DataSink wrappedDataSink, @Nullable byte[] scratch) {
        this.wrappedDataSink = wrappedDataSink;
        this.secretKey = secretKey;
        this.scratch = scratch;
    }

    @Override
    public void open(DataSpec dataSpec) throws IOException {
        this.wrappedDataSink.open(dataSpec);
        this.cipher = new AesFlushingCipher(1, this.secretKey, dataSpec.key, dataSpec.uriPositionOffset + dataSpec.position);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this.scratch == null) {
            ((AesFlushingCipher)Util.castNonNull((Object)this.cipher)).updateInPlace(buffer, offset, length);
            this.wrappedDataSink.write(buffer, offset, length);
        } else {
            int bytesToProcess;
            for (int bytesProcessed = 0; bytesProcessed < length; bytesProcessed += bytesToProcess) {
                bytesToProcess = Math.min(length - bytesProcessed, this.scratch.length);
                ((AesFlushingCipher)Util.castNonNull((Object)this.cipher)).update(buffer, offset + bytesProcessed, bytesToProcess, this.scratch, 0);
                this.wrappedDataSink.write(this.scratch, 0, bytesToProcess);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.cipher = null;
        this.wrappedDataSink.close();
    }
}

