/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import android.os.SystemClock;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.mkv.MatroskaExtractor;
import com.google.android.exoplayer2.extractor.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer2.extractor.rawcc.RawCcExtractor;
import com.google.android.exoplayer2.source.BehindLiveWindowException;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.chunk.ChunkExtractorWrapper;
import com.google.android.exoplayer2.source.chunk.ChunkHolder;
import com.google.android.exoplayer2.source.chunk.ChunkedTrackBlacklistUtil;
import com.google.android.exoplayer2.source.chunk.ContainerMediaChunk;
import com.google.android.exoplayer2.source.chunk.InitializationChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.chunk.SingleSampleMediaChunk;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.DashSegmentIndex;
import com.google.android.exoplayer2.source.dash.DashWrappingSegmentIndex;
import com.google.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.LoaderErrorThrower;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DefaultDashChunkSource
implements DashChunkSource {
    private final LoaderErrorThrower manifestLoaderErrorThrower;
    private final int[] adaptationSetIndices;
    private final TrackSelection trackSelection;
    private final int trackType;
    private final RepresentationHolder[] representationHolders;
    private final DataSource dataSource;
    private final long elapsedRealtimeOffsetMs;
    private final int maxSegmentsPerLoad;
    private DashManifest manifest;
    private int periodIndex;
    private IOException fatalError;
    private boolean missingLastSegment;

    public DefaultDashChunkSource(LoaderErrorThrower manifestLoaderErrorThrower, DashManifest manifest, int periodIndex, int[] adaptationSetIndices, TrackSelection trackSelection, int trackType, DataSource dataSource, long elapsedRealtimeOffsetMs, int maxSegmentsPerLoad, boolean enableEventMessageTrack, boolean enableCea608Track) {
        this.manifestLoaderErrorThrower = manifestLoaderErrorThrower;
        this.manifest = manifest;
        this.adaptationSetIndices = adaptationSetIndices;
        this.trackSelection = trackSelection;
        this.trackType = trackType;
        this.dataSource = dataSource;
        this.periodIndex = periodIndex;
        this.elapsedRealtimeOffsetMs = elapsedRealtimeOffsetMs;
        this.maxSegmentsPerLoad = maxSegmentsPerLoad;
        long periodDurationUs = manifest.getPeriodDurationUs(periodIndex);
        ArrayList<Representation> representations = this.getRepresentations();
        this.representationHolders = new RepresentationHolder[trackSelection.length()];
        for (int i = 0; i < this.representationHolders.length; ++i) {
            Representation representation = (Representation)representations.get(trackSelection.getIndexInTrackGroup(i));
            this.representationHolders[i] = new RepresentationHolder(periodDurationUs, representation, enableEventMessageTrack, enableCea608Track);
        }
    }

    @Override
    public void updateManifest(DashManifest newManifest, int newPeriodIndex) {
        try {
            this.manifest = newManifest;
            this.periodIndex = newPeriodIndex;
            long periodDurationUs = this.manifest.getPeriodDurationUs(this.periodIndex);
            ArrayList<Representation> representations = this.getRepresentations();
            for (int i = 0; i < this.representationHolders.length; ++i) {
                Representation representation = (Representation)representations.get(this.trackSelection.getIndexInTrackGroup(i));
                this.representationHolders[i].updateRepresentation(periodDurationUs, representation);
            }
        }
        catch (BehindLiveWindowException e) {
            this.fatalError = e;
        }
    }

    public void maybeThrowError() throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
        this.manifestLoaderErrorThrower.maybeThrowError();
    }

    public int getPreferredQueueSize(long playbackPositionUs, List<? extends MediaChunk> queue) {
        if (this.fatalError != null || this.trackSelection.length() < 2) {
            return queue.size();
        }
        return this.trackSelection.evaluateQueueSize(playbackPositionUs, queue);
    }

    public final void getNextChunk(MediaChunk previous, long playbackPositionUs, ChunkHolder out) {
        int segmentNum;
        int lastAvailableSegmentNum;
        if (this.fatalError != null) {
            return;
        }
        long bufferedDurationUs = previous != null ? previous.endTimeUs - playbackPositionUs : 0L;
        this.trackSelection.updateSelectedTrack(bufferedDurationUs);
        RepresentationHolder representationHolder = this.representationHolders[this.trackSelection.getSelectedIndex()];
        if (representationHolder.extractorWrapper != null) {
            Representation selectedRepresentation = representationHolder.representation;
            RangedUri pendingInitializationUri = null;
            RangedUri pendingIndexUri = null;
            if (representationHolder.extractorWrapper.getSampleFormats() == null) {
                pendingInitializationUri = selectedRepresentation.getInitializationUri();
            }
            if (representationHolder.segmentIndex == null) {
                pendingIndexUri = selectedRepresentation.getIndexUri();
            }
            if (pendingInitializationUri != null || pendingIndexUri != null) {
                out.chunk = DefaultDashChunkSource.newInitializationChunk(representationHolder, this.dataSource, this.trackSelection.getSelectedFormat(), this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), pendingInitializationUri, pendingIndexUri);
                return;
            }
        }
        long nowUs = this.getNowUnixTimeUs();
        int availableSegmentCount = representationHolder.getSegmentCount();
        if (availableSegmentCount == 0) {
            out.endOfStream = !this.manifest.dynamic || this.periodIndex < this.manifest.getPeriodCount() - 1;
            return;
        }
        int firstAvailableSegmentNum = representationHolder.getFirstSegmentNum();
        if (availableSegmentCount == -1) {
            long liveEdgeTimeUs = nowUs - this.manifest.availabilityStartTime * 1000L;
            long periodStartUs = this.manifest.getPeriod((int)this.periodIndex).startMs * 1000L;
            long liveEdgeTimeInPeriodUs = liveEdgeTimeUs - periodStartUs;
            if (this.manifest.timeShiftBufferDepth != -9223372036854775807L) {
                long bufferDepthUs = this.manifest.timeShiftBufferDepth * 1000L;
                firstAvailableSegmentNum = Math.max(firstAvailableSegmentNum, representationHolder.getSegmentNum(liveEdgeTimeInPeriodUs - bufferDepthUs));
            }
            lastAvailableSegmentNum = representationHolder.getSegmentNum(liveEdgeTimeInPeriodUs) - 1;
        } else {
            lastAvailableSegmentNum = firstAvailableSegmentNum + availableSegmentCount - 1;
        }
        if (previous == null) {
            segmentNum = Util.constrainValue((int)representationHolder.getSegmentNum(playbackPositionUs), (int)firstAvailableSegmentNum, (int)lastAvailableSegmentNum);
        } else {
            segmentNum = previous.getNextChunkIndex();
            if (segmentNum < firstAvailableSegmentNum) {
                this.fatalError = new BehindLiveWindowException();
                return;
            }
        }
        if (segmentNum > lastAvailableSegmentNum || this.missingLastSegment && segmentNum >= lastAvailableSegmentNum) {
            out.endOfStream = !this.manifest.dynamic || this.periodIndex < this.manifest.getPeriodCount() - 1;
            return;
        }
        int maxSegmentCount = Math.min(this.maxSegmentsPerLoad, lastAvailableSegmentNum - segmentNum + 1);
        out.chunk = DefaultDashChunkSource.newMediaChunk(representationHolder, this.dataSource, this.trackType, this.trackSelection.getSelectedFormat(), this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), segmentNum, maxSegmentCount);
    }

    public void onChunkLoadCompleted(Chunk chunk) {
        if (chunk instanceof InitializationChunk) {
            SeekMap seekMap;
            InitializationChunk initializationChunk = (InitializationChunk)chunk;
            RepresentationHolder representationHolder = this.representationHolders[this.trackSelection.indexOf(initializationChunk.trackFormat)];
            if (representationHolder.segmentIndex == null && (seekMap = representationHolder.extractorWrapper.getSeekMap()) != null) {
                representationHolder.segmentIndex = new DashWrappingSegmentIndex((ChunkIndex)seekMap);
            }
        }
    }

    public boolean onChunkLoadError(Chunk chunk, boolean cancelable, Exception e) {
        RepresentationHolder representationHolder;
        int segmentCount;
        if (!cancelable) {
            return false;
        }
        if (!this.manifest.dynamic && chunk instanceof MediaChunk && e instanceof HttpDataSource.InvalidResponseCodeException && ((HttpDataSource.InvalidResponseCodeException)e).responseCode == 404 && (segmentCount = (representationHolder = this.representationHolders[this.trackSelection.indexOf(chunk.trackFormat)]).getSegmentCount()) != -1 && segmentCount != 0) {
            int lastAvailableSegmentNum = representationHolder.getFirstSegmentNum() + segmentCount - 1;
            if (((MediaChunk)chunk).getNextChunkIndex() > lastAvailableSegmentNum) {
                this.missingLastSegment = true;
                return true;
            }
        }
        return ChunkedTrackBlacklistUtil.maybeBlacklistTrack((TrackSelection)this.trackSelection, (int)this.trackSelection.indexOf(chunk.trackFormat), (Exception)e);
    }

    private ArrayList<Representation> getRepresentations() {
        List<AdaptationSet> manifestAdapationSets = this.manifest.getPeriod((int)this.periodIndex).adaptationSets;
        ArrayList<Representation> representations = new ArrayList<Representation>();
        for (int adaptationSetIndex : this.adaptationSetIndices) {
            representations.addAll(manifestAdapationSets.get((int)adaptationSetIndex).representations);
        }
        return representations;
    }

    private long getNowUnixTimeUs() {
        if (this.elapsedRealtimeOffsetMs != 0L) {
            return (SystemClock.elapsedRealtime() + this.elapsedRealtimeOffsetMs) * 1000L;
        }
        return System.currentTimeMillis() * 1000L;
    }

    private static Chunk newInitializationChunk(RepresentationHolder representationHolder, DataSource dataSource, Format trackFormat, int trackSelectionReason, Object trackSelectionData, RangedUri initializationUri, RangedUri indexUri) {
        RangedUri requestUri;
        String baseUrl = representationHolder.representation.baseUrl;
        if (initializationUri != null) {
            requestUri = initializationUri.attemptMerge(indexUri, baseUrl);
            if (requestUri == null) {
                requestUri = initializationUri;
            }
        } else {
            requestUri = indexUri;
        }
        DataSpec dataSpec = new DataSpec(requestUri.resolveUri(baseUrl), requestUri.start, requestUri.length, representationHolder.representation.getCacheKey());
        return new InitializationChunk(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, representationHolder.extractorWrapper);
    }

    private static Chunk newMediaChunk(RepresentationHolder representationHolder, DataSource dataSource, int trackType, Format trackFormat, int trackSelectionReason, Object trackSelectionData, int firstSegmentNum, int maxSegmentCount) {
        RangedUri nextSegmentUri;
        RangedUri mergedSegmentUri;
        Representation representation = representationHolder.representation;
        long startTimeUs = representationHolder.getSegmentStartTimeUs(firstSegmentNum);
        RangedUri segmentUri = representationHolder.getSegmentUrl(firstSegmentNum);
        String baseUrl = representation.baseUrl;
        if (representationHolder.extractorWrapper == null) {
            long endTimeUs = representationHolder.getSegmentEndTimeUs(firstSegmentNum);
            DataSpec dataSpec = new DataSpec(segmentUri.resolveUri(baseUrl), segmentUri.start, segmentUri.length, representation.getCacheKey());
            return new SingleSampleMediaChunk(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, firstSegmentNum, trackType, trackFormat);
        }
        int segmentCount = 1;
        for (int i = 1; i < maxSegmentCount && (mergedSegmentUri = segmentUri.attemptMerge(nextSegmentUri = representationHolder.getSegmentUrl(firstSegmentNum + i), baseUrl)) != null; ++i) {
            segmentUri = mergedSegmentUri;
            ++segmentCount;
        }
        long endTimeUs = representationHolder.getSegmentEndTimeUs(firstSegmentNum + segmentCount - 1);
        DataSpec dataSpec = new DataSpec(segmentUri.resolveUri(baseUrl), segmentUri.start, segmentUri.length, representation.getCacheKey());
        long sampleOffsetUs = -representation.presentationTimeOffsetUs;
        return new ContainerMediaChunk(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, firstSegmentNum, segmentCount, sampleOffsetUs, representationHolder.extractorWrapper);
    }

    protected static final class RepresentationHolder {
        public final ChunkExtractorWrapper extractorWrapper;
        public Representation representation;
        public DashSegmentIndex segmentIndex;
        private long periodDurationUs;
        private int segmentNumShift;

        public RepresentationHolder(long periodDurationUs, Representation representation, boolean enableEventMessageTrack, boolean enableCea608Track) {
            this.periodDurationUs = periodDurationUs;
            this.representation = representation;
            String containerMimeType = representation.format.containerMimeType;
            if (RepresentationHolder.mimeTypeIsRawText(containerMimeType)) {
                this.extractorWrapper = null;
            } else {
                RawCcExtractor extractor;
                if ("application/x-rawcc".equals(containerMimeType)) {
                    extractor = new RawCcExtractor(representation.format);
                } else if (RepresentationHolder.mimeTypeIsWebm(containerMimeType)) {
                    extractor = new MatroskaExtractor(1);
                } else {
                    int flags = 0;
                    if (enableEventMessageTrack) {
                        flags |= 4;
                    }
                    if (enableCea608Track) {
                        flags |= 8;
                    }
                    extractor = new FragmentedMp4Extractor(flags);
                }
                this.extractorWrapper = new ChunkExtractorWrapper((Extractor)extractor, representation.format);
            }
            this.segmentIndex = representation.getIndex();
        }

        public void updateRepresentation(long newPeriodDurationUs, Representation newRepresentation) throws BehindLiveWindowException {
            int newIndexFirstSegmentNum;
            long newIndexStartTimeUs;
            DashSegmentIndex oldIndex = this.representation.getIndex();
            DashSegmentIndex newIndex = newRepresentation.getIndex();
            this.periodDurationUs = newPeriodDurationUs;
            this.representation = newRepresentation;
            if (oldIndex == null) {
                return;
            }
            this.segmentIndex = newIndex;
            if (!oldIndex.isExplicit()) {
                return;
            }
            int oldIndexSegmentCount = oldIndex.getSegmentCount(this.periodDurationUs);
            if (oldIndexSegmentCount == 0) {
                return;
            }
            int oldIndexLastSegmentNum = oldIndex.getFirstSegmentNum() + oldIndexSegmentCount - 1;
            long oldIndexEndTimeUs = oldIndex.getTimeUs(oldIndexLastSegmentNum) + oldIndex.getDurationUs(oldIndexLastSegmentNum, this.periodDurationUs);
            if (oldIndexEndTimeUs == (newIndexStartTimeUs = newIndex.getTimeUs(newIndexFirstSegmentNum = newIndex.getFirstSegmentNum()))) {
                this.segmentNumShift += oldIndexLastSegmentNum + 1 - newIndexFirstSegmentNum;
            } else {
                if (oldIndexEndTimeUs < newIndexStartTimeUs) {
                    throw new BehindLiveWindowException();
                }
                this.segmentNumShift += oldIndex.getSegmentNum(newIndexStartTimeUs, this.periodDurationUs) - newIndexFirstSegmentNum;
            }
        }

        public int getFirstSegmentNum() {
            return this.segmentIndex.getFirstSegmentNum() + this.segmentNumShift;
        }

        public int getSegmentCount() {
            return this.segmentIndex.getSegmentCount(this.periodDurationUs);
        }

        public long getSegmentStartTimeUs(int segmentNum) {
            return this.segmentIndex.getTimeUs(segmentNum - this.segmentNumShift);
        }

        public long getSegmentEndTimeUs(int segmentNum) {
            return this.getSegmentStartTimeUs(segmentNum) + this.segmentIndex.getDurationUs(segmentNum - this.segmentNumShift, this.periodDurationUs);
        }

        public int getSegmentNum(long positionUs) {
            return this.segmentIndex.getSegmentNum(positionUs, this.periodDurationUs) + this.segmentNumShift;
        }

        public RangedUri getSegmentUrl(int segmentNum) {
            return this.segmentIndex.getSegmentUrl(segmentNum - this.segmentNumShift);
        }

        private static boolean mimeTypeIsWebm(String mimeType) {
            return mimeType.startsWith("video/webm") || mimeType.startsWith("audio/webm") || mimeType.startsWith("application/webm");
        }

        private static boolean mimeTypeIsRawText(String mimeType) {
            return MimeTypes.isText((String)mimeType) || "application/ttml+xml".equals(mimeType);
        }
    }

    public static final class Factory
    implements DashChunkSource.Factory {
        private final DataSource.Factory dataSourceFactory;
        private final int maxSegmentsPerLoad;

        public Factory(DataSource.Factory dataSourceFactory) {
            this(dataSourceFactory, 1);
        }

        public Factory(DataSource.Factory dataSourceFactory, int maxSegmentsPerLoad) {
            this.dataSourceFactory = dataSourceFactory;
            this.maxSegmentsPerLoad = maxSegmentsPerLoad;
        }

        @Override
        public DashChunkSource createDashChunkSource(LoaderErrorThrower manifestLoaderErrorThrower, DashManifest manifest, int periodIndex, int[] adaptationSetIndices, TrackSelection trackSelection, int trackType, long elapsedRealtimeOffsetMs, boolean enableEventMessageTrack, boolean enableCea608Track) {
            DataSource dataSource = this.dataSourceFactory.createDataSource();
            return new DefaultDashChunkSource(manifestLoaderErrorThrower, manifest, periodIndex, adaptationSetIndices, trackSelection, trackType, dataSource, elapsedRealtimeOffsetMs, this.maxSegmentsPerLoad, enableEventMessageTrack, enableCea608Track);
        }
    }
}

