/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.AdaptiveMediaSourceEventListener;
import com.google.android.exoplayer2.source.CompositeSequenceableLoader;
import com.google.android.exoplayer2.source.EmptySampleStream;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.chunk.ChunkSampleStream;
import com.google.android.exoplayer2.source.chunk.ChunkSource;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.source.dash.manifest.SchemeValuePair;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.LoaderErrorThrower;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

final class DashMediaPeriod
implements MediaPeriod,
SequenceableLoader.Callback<ChunkSampleStream<DashChunkSource>> {
    final int id;
    private final DashChunkSource.Factory chunkSourceFactory;
    private final int minLoadableRetryCount;
    private final AdaptiveMediaSourceEventListener.EventDispatcher eventDispatcher;
    private final long elapsedRealtimeOffset;
    private final LoaderErrorThrower manifestLoaderErrorThrower;
    private final Allocator allocator;
    private final TrackGroupArray trackGroups;
    private final EmbeddedTrackInfo[] embeddedTrackInfos;
    private MediaPeriod.Callback callback;
    private ChunkSampleStream<DashChunkSource>[] sampleStreams;
    private CompositeSequenceableLoader sequenceableLoader;
    private DashManifest manifest;
    private int periodIndex;
    private List<AdaptationSet> adaptationSets;

    public DashMediaPeriod(int id, DashManifest manifest, int periodIndex, DashChunkSource.Factory chunkSourceFactory, int minLoadableRetryCount, AdaptiveMediaSourceEventListener.EventDispatcher eventDispatcher, long elapsedRealtimeOffset, LoaderErrorThrower manifestLoaderErrorThrower, Allocator allocator) {
        this.id = id;
        this.manifest = manifest;
        this.periodIndex = periodIndex;
        this.chunkSourceFactory = chunkSourceFactory;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.eventDispatcher = eventDispatcher;
        this.elapsedRealtimeOffset = elapsedRealtimeOffset;
        this.manifestLoaderErrorThrower = manifestLoaderErrorThrower;
        this.allocator = allocator;
        this.sampleStreams = DashMediaPeriod.newSampleStreamArray(0);
        this.sequenceableLoader = new CompositeSequenceableLoader(this.sampleStreams);
        this.adaptationSets = manifest.getPeriod((int)periodIndex).adaptationSets;
        Pair<TrackGroupArray, EmbeddedTrackInfo[]> result = DashMediaPeriod.buildTrackGroups(this.adaptationSets);
        this.trackGroups = (TrackGroupArray)result.first;
        this.embeddedTrackInfos = (EmbeddedTrackInfo[])result.second;
    }

    public void updateManifest(DashManifest manifest, int periodIndex) {
        this.manifest = manifest;
        this.periodIndex = periodIndex;
        this.adaptationSets = manifest.getPeriod((int)periodIndex).adaptationSets;
        if (this.sampleStreams != null) {
            for (ChunkSampleStream<DashChunkSource> sampleStream : this.sampleStreams) {
                ((DashChunkSource)sampleStream.getChunkSource()).updateManifest(manifest, periodIndex);
            }
            this.callback.onContinueLoadingRequested((SequenceableLoader)this);
        }
    }

    public void release() {
        for (ChunkSampleStream<DashChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.release();
        }
    }

    public void prepare(MediaPeriod.Callback callback) {
        this.callback = callback;
        callback.onPrepared((MediaPeriod)this);
    }

    public void maybeThrowPrepareError() throws IOException {
        this.manifestLoaderErrorThrower.maybeThrowError();
    }

    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    public long selectTracks(TrackSelection[] selections, boolean[] mayRetainStreamFlags, SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        int i;
        int adaptationSetCount = this.adaptationSets.size();
        HashMap<Integer, Object> primarySampleStreams = new HashMap<Integer, Object>();
        for (i = 0; i < selections.length; ++i) {
            int trackGroupIndex;
            if (streams[i] instanceof ChunkSampleStream) {
                ChunkSampleStream stream = (ChunkSampleStream)streams[i];
                if (selections[i] == null || !mayRetainStreamFlags[i]) {
                    stream.release();
                    streams[i] = null;
                } else {
                    int adaptationSetIndex = this.trackGroups.indexOf(selections[i].getTrackGroup());
                    primarySampleStreams.put(adaptationSetIndex, stream);
                }
            }
            if (streams[i] != null || selections[i] == null || (trackGroupIndex = this.trackGroups.indexOf(selections[i].getTrackGroup())) >= adaptationSetCount) continue;
            ChunkSampleStream<DashChunkSource> stream = this.buildSampleStream(trackGroupIndex, selections[i], positionUs);
            primarySampleStreams.put(trackGroupIndex, stream);
            streams[i] = stream;
            streamResetFlags[i] = true;
        }
        for (i = 0; i < selections.length; ++i) {
            boolean mayRetainStream;
            int trackGroupIndex;
            if (!(!(streams[i] instanceof ChunkSampleStream.EmbeddedSampleStream) && !(streams[i] instanceof EmptySampleStream) || selections[i] != null && mayRetainStreamFlags[i])) {
                DashMediaPeriod.releaseIfEmbeddedSampleStream(streams[i]);
                streams[i] = null;
            }
            if (selections[i] == null || (trackGroupIndex = this.trackGroups.indexOf(selections[i].getTrackGroup())) < adaptationSetCount) continue;
            int embeddedTrackIndex = trackGroupIndex - adaptationSetCount;
            EmbeddedTrackInfo embeddedTrackInfo = this.embeddedTrackInfos[embeddedTrackIndex];
            int adaptationSetIndex = embeddedTrackInfo.adaptationSetIndex;
            ChunkSampleStream primaryStream = (ChunkSampleStream)primarySampleStreams.get(adaptationSetIndex);
            SampleStream stream = streams[i];
            boolean bl = primaryStream == null ? stream instanceof EmptySampleStream : (mayRetainStream = stream instanceof ChunkSampleStream.EmbeddedSampleStream && ((ChunkSampleStream.EmbeddedSampleStream)stream).parent == primaryStream);
            if (mayRetainStream) continue;
            DashMediaPeriod.releaseIfEmbeddedSampleStream(stream);
            streams[i] = primaryStream == null ? new EmptySampleStream() : primaryStream.selectEmbeddedTrack(positionUs, embeddedTrackInfo.trackType);
            streamResetFlags[i] = true;
        }
        this.sampleStreams = DashMediaPeriod.newSampleStreamArray(primarySampleStreams.size());
        primarySampleStreams.values().toArray(this.sampleStreams);
        this.sequenceableLoader = new CompositeSequenceableLoader(this.sampleStreams);
        return positionUs;
    }

    public void discardBuffer(long positionUs) {
        for (ChunkSampleStream<DashChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.discardUnselectedEmbeddedTracksTo(positionUs);
        }
    }

    public boolean continueLoading(long positionUs) {
        return this.sequenceableLoader.continueLoading(positionUs);
    }

    public long getNextLoadPositionUs() {
        return this.sequenceableLoader.getNextLoadPositionUs();
    }

    public long readDiscontinuity() {
        return -9223372036854775807L;
    }

    public long getBufferedPositionUs() {
        long bufferedPositionUs = Long.MAX_VALUE;
        for (ChunkSampleStream<DashChunkSource> sampleStream : this.sampleStreams) {
            long rendererBufferedPositionUs = sampleStream.getBufferedPositionUs();
            if (rendererBufferedPositionUs == Long.MIN_VALUE) continue;
            bufferedPositionUs = Math.min(bufferedPositionUs, rendererBufferedPositionUs);
        }
        return bufferedPositionUs == Long.MAX_VALUE ? Long.MIN_VALUE : bufferedPositionUs;
    }

    public long seekToUs(long positionUs) {
        for (ChunkSampleStream<DashChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.seekToUs(positionUs);
        }
        return positionUs;
    }

    public void onContinueLoadingRequested(ChunkSampleStream<DashChunkSource> sampleStream) {
        this.callback.onContinueLoadingRequested((SequenceableLoader)this);
    }

    private static Pair<TrackGroupArray, EmbeddedTrackInfo[]> buildTrackGroups(List<AdaptationSet> adaptationSets) {
        int adaptationSetCount = adaptationSets.size();
        int embeddedTrackCount = DashMediaPeriod.getEmbeddedTrackCount(adaptationSets);
        TrackGroup[] trackGroupArray = new TrackGroup[adaptationSetCount + embeddedTrackCount];
        EmbeddedTrackInfo[] embeddedTrackInfos = new EmbeddedTrackInfo[embeddedTrackCount];
        int embeddedTrackIndex = 0;
        for (int i = 0; i < adaptationSetCount; ++i) {
            AdaptationSet adaptationSet = adaptationSets.get(i);
            List<Representation> representations = adaptationSet.representations;
            Format[] formats = new Format[representations.size()];
            for (int j = 0; j < formats.length; ++j) {
                formats[j] = representations.get((int)j).format;
            }
            trackGroupArray[i] = new TrackGroup(formats);
            if (DashMediaPeriod.hasEventMessageTrack(adaptationSet)) {
                Format format = Format.createSampleFormat((String)(adaptationSet.id + ":emsg"), (String)"application/x-emsg", null, (int)-1, null);
                trackGroupArray[adaptationSetCount + embeddedTrackIndex] = new TrackGroup(new Format[]{format});
                embeddedTrackInfos[embeddedTrackIndex++] = new EmbeddedTrackInfo(i, 4);
            }
            if (!DashMediaPeriod.hasCea608Track(adaptationSet)) continue;
            Format format = Format.createTextSampleFormat((String)(adaptationSet.id + ":cea608"), (String)"application/cea-608", null, (int)-1, (int)0, null, null);
            trackGroupArray[adaptationSetCount + embeddedTrackIndex] = new TrackGroup(new Format[]{format});
            embeddedTrackInfos[embeddedTrackIndex++] = new EmbeddedTrackInfo(i, 3);
        }
        return Pair.create((Object)new TrackGroupArray(trackGroupArray), (Object)embeddedTrackInfos);
    }

    private ChunkSampleStream<DashChunkSource> buildSampleStream(int adaptationSetIndex, TrackSelection selection, long positionUs) {
        boolean enableCea608Track;
        AdaptationSet adaptationSet = this.adaptationSets.get(adaptationSetIndex);
        int embeddedTrackCount = 0;
        int[] embeddedTrackTypes = new int[2];
        boolean enableEventMessageTrack = DashMediaPeriod.hasEventMessageTrack(adaptationSet);
        if (enableEventMessageTrack) {
            embeddedTrackTypes[embeddedTrackCount++] = 4;
        }
        if (enableCea608Track = DashMediaPeriod.hasCea608Track(adaptationSet)) {
            embeddedTrackTypes[embeddedTrackCount++] = 3;
        }
        if (embeddedTrackCount < embeddedTrackTypes.length) {
            embeddedTrackTypes = Arrays.copyOf(embeddedTrackTypes, embeddedTrackCount);
        }
        DashChunkSource chunkSource = this.chunkSourceFactory.createDashChunkSource(this.manifestLoaderErrorThrower, this.manifest, this.periodIndex, adaptationSetIndex, selection, this.elapsedRealtimeOffset, enableEventMessageTrack, enableCea608Track);
        ChunkSampleStream stream = new ChunkSampleStream(adaptationSet.type, embeddedTrackTypes, (ChunkSource)chunkSource, (SequenceableLoader.Callback)this, this.allocator, positionUs, this.minLoadableRetryCount, this.eventDispatcher);
        return stream;
    }

    private static int getEmbeddedTrackCount(List<AdaptationSet> adaptationSets) {
        int embeddedTrackCount = 0;
        for (int i = 0; i < adaptationSets.size(); ++i) {
            AdaptationSet adaptationSet = adaptationSets.get(i);
            if (DashMediaPeriod.hasEventMessageTrack(adaptationSet)) {
                ++embeddedTrackCount;
            }
            if (!DashMediaPeriod.hasCea608Track(adaptationSet)) continue;
            ++embeddedTrackCount;
        }
        return embeddedTrackCount;
    }

    private static boolean hasEventMessageTrack(AdaptationSet adaptationSet) {
        List<Representation> representations = adaptationSet.representations;
        for (int i = 0; i < representations.size(); ++i) {
            Representation representation = representations.get(i);
            if (representation.inbandEventStreams.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCea608Track(AdaptationSet adaptationSet) {
        List<SchemeValuePair> descriptors = adaptationSet.accessibilityDescriptors;
        for (int i = 0; i < descriptors.size(); ++i) {
            SchemeValuePair descriptor = descriptors.get(i);
            if (!"urn:scte:dash:cc:cea-608:2015".equals(descriptor.schemeIdUri)) continue;
            return true;
        }
        return false;
    }

    private static ChunkSampleStream<DashChunkSource>[] newSampleStreamArray(int length) {
        return new ChunkSampleStream[length];
    }

    private static void releaseIfEmbeddedSampleStream(SampleStream sampleStream) {
        if (sampleStream instanceof ChunkSampleStream.EmbeddedSampleStream) {
            ((ChunkSampleStream.EmbeddedSampleStream)sampleStream).release();
        }
    }

    private static final class EmbeddedTrackInfo {
        public final int adaptationSetIndex;
        public final int trackType;

        public EmbeddedTrackInfo(int adaptationSetIndex, int trackType) {
            this.adaptationSetIndex = adaptationSetIndex;
            this.trackType = trackType;
        }
    }
}

